CREATE TABLE "platform_users" (
  "ID" int default NULL,
  "username" varchar(60) NOT NULL,
  PRIMARY KEY ("username")
);

INSERT INTO "platform_users" ("username") VALUES ('Admin');

CREATE TABLE "platform_groups" (
  "ID" int default NULL,
  "groupname" varchar(60) NOT NULL,
  PRIMARY KEY ("groupname")
);

CREATE TABLE "col_files_folders" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) default NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "parent" int default NULL,
  "name" varchar(255) default NULL,
  "description" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_files_types" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_files_files" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "assigneduser" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "folder" int NOT NULL,
  "type" int default NULL,
  "deleted" smallint default '0',
  "title" varchar(255) default NULL,
  "filenum" varchar(255) default NULL,
  "status" smallint default '0',
  "keywords" varchar(255) default NULL,
  "description" text default NULL,
  "versioncount" int default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("assigneduser") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("folder") REFERENCES "col_files_folders" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("type") REFERENCES "col_files_types" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_files_items" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "file" int NOT NULL,
  "filename" varchar(255) default NULL,
  "version" varchar(255) default NULL,
  "mimetype" varchar(255) default NULL,
  "size" int default '0',
  "comment" text default NULL,
  "binfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("file") REFERENCES "col_files_files" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_files_journal" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "file" int NOT NULL,
  "date" int default '0',
  "subject" varchar(255) default NULL,
  "text" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("file") REFERENCES "col_files_files" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_files_shortcuts" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) NOT NULL,
  "creationdate" int default '0',
  "file" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("file") REFERENCES "col_files_files" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_forums_columns" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_forums_forums" (
  "ID" serial NOT NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) default NULL,
  "assigneduser" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "column" int default NULL,
  "name" varchar(255) default NULL,
  "description" text default NULL,
  "lastentry" int default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("assigneduser") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("column") REFERENCES "col_forums_columns" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_forums_topics" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "forum" int NOT NULL,
  "title" varchar(255) default NULL,
  "lastentry" int default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("forum") REFERENCES "col_forums_forums" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_forums_entries" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "topic" int NOT NULL,
  "flag" smallint default '0',
  "text" text default NULL,
  "attachname" varchar(255) default NULL,
  "attachbinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("topic") REFERENCES "col_forums_topics" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_forums_notify" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) NOT NULL,
  "forum" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("forum") REFERENCES "col_forums_forums" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_forums_view" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) NOT NULL,
  "forum" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("forum") REFERENCES "col_forums_forums" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_messages_folders" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) default NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "parent" int default NULL,
  "name" varchar(255) default NULL,
  "description" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_messages_accounts" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) NOT NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "activity" smallint default '0',
  "default" smallint default '0',
  "name" varchar(255) default NULL,
  "email" varchar(255) default NULL,
  "server" varchar(255) default NULL,
  "port" smallint default '0',
  "protocol" varchar(255) default NULL,
  "username" varchar(255) default NULL,
  "password" varchar(255) default NULL,
  "movetoprimary" smallint default '0',
  "moveto" int default NULL,
  "description" text default NULL,
  "leavemsg" smallint default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("moveto") REFERENCES "col_messages_folders" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_messages_messages" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) default NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "account" int default NULL,
  "primaryfolder" smallint default '0',
  "folder" int default NULL,
  "flag" smallint default '0',
  "date" int default '0',
  "subject" varchar(255) default NULL,
  "sender" varchar(255) default NULL,
  "sender_name" varchar(255) default NULL,
  "to" varchar(255) default NULL,
  "to_name" varchar(255) default NULL,
  "cc" varchar(255) default NULL,
  "bcc" varchar(255) default NULL,
  "reply_to" varchar(255) default NULL,
  "count_to" int default '0',
  "contenttype" varchar(255) default NULL,
  "binfile" varchar(32) default NULL,
  "keywords" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("account") REFERENCES "col_messages_accounts" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("folder") REFERENCES "col_messages_folders" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_messages_msglog" (
  "ID" serial NOT NULL,
  "account" int NOT NULL,
  "uid" int default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("account") REFERENCES "col_messages_accounts" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_messages_templates" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) default NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "default" smallint default '0',
  "name" varchar(255) default NULL,
  "text" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_news_channels" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) NOT NULL,
  "creationdate" int default '0',
  "activity" smallint default '0',
  "type" smallint default '0',
  "title" varchar(255) default NULL,
  "newsfeed" varchar(255) default NULL,
  "link" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "col_news_newsitems" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) NOT NULL,
  "creationdate" int default '0',
  "channel" int default NULL,
  "title" varchar(255) default NULL,
  "pubdate" int default '0',
  "link" varchar(255) default NULL,
  "description" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("channel") REFERENCES "col_news_channels" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_contacts_companies" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60)  default NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  "director" varchar(255) default NULL,
  "traderegister" varchar(255) default NULL,
  "taxcode" varchar(255) default NULL,
  "address" varchar(255) default NULL,
  "postalcode" varchar(255) default NULL,
  "city" varchar(255) default NULL,
  "region" varchar(255) default NULL,
  "country" varchar(255) default NULL,
  "phone" varchar(255) default NULL,
  "phone2" varchar(255) default NULL,
  "fax" varchar(255) default NULL,
  "fax2" varchar(255) default NULL,
  "email" varchar(255) default NULL,
  "website" varchar(255) default NULL,
  "description" text default NULL,
  "extdatabinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_customers_customers" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "assigneduser" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  "customernum" varchar(255) default NULL,
  "status" smallint default '0',
  "risk" smallint default '0',
  "dispatch" smallint default '0',
  "payment" smallint default '0',
  "prefcontact" smallint default '0',
  "contact" int default NULL,
  "description" text default NULL,
  "usebilling" smallint default '0',
  "billingaddr" varchar(255) default NULL,
  "billingpc" varchar(255) default NULL,
  "billingcity" varchar(255) default NULL,
  "billingcountry" varchar(255) default NULL,
  "useshipping" smallint default '0',
  "shippingaddr" varchar(255) default NULL,
  "shippingpc" varchar(255) default NULL,
  "shippingcity" varchar(255) default NULL,
  "shippingcountry" varchar(255) default NULL,
  "bank" varchar(255) default NULL,
  "bankid" varchar(255) default NULL,
  "account" varchar(255) default NULL,
  "cctype" smallint default '0',
  "ccnum" varchar(255) default NULL,
  "ccvalid" varchar(5) default NULL,
  "ccauth" varchar(3) default NULL,
  "extdatabinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("assigneduser") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("contact") REFERENCES "org_contacts_companies" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_billing_deliveries" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "deliverynum" varchar(255) default NULL,
  "customer" int default NULL,
  "date" int default '0',
  "status" smallint default '0',
  "discount" double precision default '0',
  "netamount" double precision default '0',
  "tax" double precision default '0',
  "itemsbinfile" varchar(32) default NULL,
  "extdatabinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("customer") REFERENCES "crm_customers_customers" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_billing_invoices" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "invoicenum" varchar(255) default NULL,
  "customer" int default NULL,
  "date" int default '0',
  "duedate" int default '0',
  "status" smallint default '0',
  "amountpayable" double precision default '0',
  "payment" double precision default '0',
  "extdatabinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("customer") REFERENCES "crm_customers_customers" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_billing_invoices_deliveries" (
  "ID" serial NOT NULL,
  "invoice" int NOT NULL,
  "delivery" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("invoice") REFERENCES "crm_billing_invoices" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("delivery") REFERENCES "crm_billing_deliveries" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_billing_offers" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "quotationnum" varchar(255) default NULL,
  "customer" int default NULL,
  "date" int default '0',
  "duedate" int default '0',
  "status" smallint default '0',
  "discount" double precision default '0',
  "netamount" double precision default '0',
  "tax" double precision default '0',
  "margin" double precision default '0',
  "itemsbinfile" varchar(32) default NULL,
  "extdatabinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("customer") REFERENCES "crm_customers_customers" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_billing_orders" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "ordernum" varchar(255) default NULL,
  "customer" int default NULL,
  "date" int default '0',
  "duedate" int default '0',
  "status" smallint default '0',
  "discount" double precision default '0',
  "netamount" double precision default '0',
  "tax" double precision default '0',
  "margin" double precision default '0',
  "itemsbinfile" varchar(32) default NULL,
  "extdatabinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("customer") REFERENCES "crm_customers_customers" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_billing_payments" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "invoice" int NOT NULL,
  "date" int default '0',
  "account" varchar(255) default NULL,
  "reference" varchar(255) default NULL,
  "amount" double precision default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("invoice") REFERENCES "crm_billing_invoices" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_billing_templates" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "type" smallint default '0',
  "name" varchar(255) default NULL,
  "inputbinfile" varchar(32) default NULL,
  "outputbinfile" varchar(32) default NULL,
  "pdfbinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_billing_printouts" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "type" smallint default '0',
  "transaction" int NOT NULL,
  "transactionnum" varchar(255) default NULL,
  "template" int default NULL,
  "maildate" int default '0',
  "databinfile" varchar(32) default NULL,
  "pdfbinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("template") REFERENCES "crm_billing_templates" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_billing_requests" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "requestnum" varchar(255) default NULL,
  "customer" int default NULL,
  "date" int default '0',
  "status" smallint default '0',
  "itemsbinfile" varchar(32) default NULL,
  "extdatabinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("customer") REFERENCES "crm_customers_customers" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_campaigns_campaigns" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "assigneduser" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "title" varchar(255) default NULL,
  "datefrom" int default '0',
  "dateto" int default '0',
  "status" smallint default '0',
  "media" smallint default '0',
  "replyrate" smallint default '0',
  "projectedeffort" double precision default '0',
  "budget" double precision default '0',
  "description" text default NULL,
  "extdatabinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("assigneduser") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_campaigns_addressees" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "campaign" int NOT NULL,
  "customer" int NOT NULL,
  "flag" smallint default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("campaign") REFERENCES "crm_campaigns_campaigns" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("customer") REFERENCES "crm_customers_customers" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);


CREATE TABLE "crm_campaigns_journal" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "campaign" int NOT NULL,
  "date" int default '0',
  "subject" varchar(255) default NULL,
  "text" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("campaign") REFERENCES "crm_campaigns_campaigns" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_campaigns_files" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "campaign" int NOT NULL,
  "file" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("campaign") REFERENCES "crm_campaigns_campaigns" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("file") REFERENCES "col_files_files" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_tasks_tasks" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) default NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) default NULL,
  "assigneduser" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "parent" int default NULL,
  "title" varchar(255) default NULL,
  "duedate" int default '0',
  "status" smallint default '0',
  "progress" smallint default '0',
  "priority" smallint default '0',
  "projectedeffort" double precision default '0',
  "actualeffort" double precision default '0',
  "budget" double precision default '0',
  "costs" double precision default '0',
  "description" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("assigneduser") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_campaigns_tasks" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "campaign" int NOT NULL,
  "task" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("campaign") REFERENCES "crm_campaigns_campaigns" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("task") REFERENCES "org_tasks_tasks" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_cases_categories" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_cases_cases" (
  "ID" serial NOT NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) default NULL,
  "assigneduser" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "title" varchar(255) default NULL,
  "casenum" varchar(255) default NULL,
  "customer" int default NULL,
  "status" smallint default '0',
  "priority" smallint default '0',
  "category" int default NULL,
  "projectedeffort" double precision default '0',
  "budget" double precision default '0',
  "materialcosts" double precision default '0',
  "message" int default NULL,
  "databinfile" varchar(32) default NULL,
  "itemsbinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("assigneduser") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("customer") REFERENCES "crm_customers_customers" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("category") REFERENCES "crm_cases_categories" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("message") REFERENCES "col_messages_messages" ("ID")
);

CREATE TABLE "crm_cases_files" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "case" int NOT NULL,
  "file" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("case") REFERENCES "crm_cases_cases" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("file") REFERENCES "col_files_files" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_cases_journal" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "case" int NOT NULL,
  "date" int default '0',
  "subject" varchar(255) default NULL,
  "text" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("case") REFERENCES "crm_cases_cases" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_cases_tasks" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "case" int NOT NULL,
  "task" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("case") REFERENCES "crm_cases_cases" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("task") REFERENCES "org_tasks_tasks" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_contracts_classes" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "default" smallint default '0',
  "name" varchar(255) default NULL,
  "description" text default NULL,
  "inputbinfile" varchar(32) default NULL,
  "outputbinfile" varchar(32) default NULL,
  "pdfbinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_contracts_contracts" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "assigneduser" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "title" varchar(255) default NULL,
  "contractnum" varchar(255) default NULL,
  "customer" int default NULL,
  "class" int NOT NULL,
  "usedatefrom" smallint default '0',
  "datefrom" int default '0',
  "usedateto" smallint default '0',
  "dateto" int default '0',
  "usedatecancel" smallint default '0',
  "datecancel" int default '0',
  "status" smallint default '0',
  "databinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("assigneduser") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("customer") REFERENCES "crm_customers_customers" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("class") REFERENCES "crm_contracts_classes" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_contracts_files" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "contract" int NOT NULL,
  "file" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("contract") REFERENCES "crm_contracts_contracts" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("file") REFERENCES "col_files_files" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_contracts_journal" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "contract" int NOT NULL,
  "date" int default '0',
  "subject" varchar(255) default NULL,
  "text" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("contract") REFERENCES "crm_contracts_contracts" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_customers_groups" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_customers_customers_groups" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "customer" int NOT NULL,
  "group" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("customer") REFERENCES "crm_customers_customers" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("group") REFERENCES "crm_customers_groups" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_customers_files" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "customer" int NOT NULL,
  "file" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("customer") REFERENCES "crm_customers_customers" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("file") REFERENCES "col_files_files" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_contacts_people" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) default NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  "lastname" varchar(255) default NULL,
  "firstname" varchar(255) default NULL,
  "title" varchar(255) default NULL,
  "company" varchar(255) default NULL,
  "position" varchar(255) default NULL,
  "workgroup" varchar(255) default NULL,
  "address" varchar(255) default NULL,
  "postalcode" varchar(255) default NULL,
  "city" varchar(255) default NULL,
  "region" varchar(255) default NULL,
  "country" varchar(255) default NULL,
  "phone" varchar(255) default NULL,
  "phone2" varchar(255) default NULL,
  "cell" varchar(255) default NULL,
  "fax" varchar(255) default NULL,
  "fax2" varchar(255) default NULL,
  "pager" varchar(255) default NULL,
  "iptel" varchar(255) default NULL,
  "email" varchar(255) default NULL,
  "description" text default NULL,
  "picbinfile" varchar(32) default NULL,
  "extdatabinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_customers_journal" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "customer" int NOT NULL,
  "date" int default '0',
  "label" smallint default '0',
  "contact" int default NULL,
  "subject" varchar(255) default NULL,
  "text" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("customer") REFERENCES "crm_customers_customers" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("contact") REFERENCES "org_contacts_people" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_opportunities_opportunities" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "assigneduser" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "title" varchar(255) default NULL,
  "customer" int default NULL,
  "status" smallint default '0',
  "probability" smallint default '0',
  "closedate" int default '0',
  "priority" smallint default '0',
  "forecast" smallint default '0',
  "worstcase" double precision default '0',
  "mostlikely" double precision default '0',
  "upside" double precision default '0',
  "description" text default NULL,
  "message" int default NULL,
  "extdatabinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("assigneduser") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("customer") REFERENCES "crm_customers_customers" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("message") REFERENCES "col_messages_messages" ("ID")
);

CREATE TABLE "crm_opportunities_files" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "opportunity" int NOT NULL,
  "file" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("opportunity") REFERENCES "crm_opportunities_opportunities" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("file") REFERENCES "col_files_files" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "crm_opportunities_journal" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "opportunity" int NOT NULL,
  "date" int default '0',
  "subject" varchar(255) default NULL,
  "text" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("opportunity") REFERENCES "crm_opportunities_opportunities" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_archive_locations" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_archive_rooms" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "location" int NOT NULL,
  "name" varchar(255) default NULL,
  "roomnum" varchar(255) default NULL,
  "description" text default NULL,
  "lastinsert" int default '0',
  "mapbinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("location") REFERENCES "erp_archive_locations" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_archive_shelfs" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "room" int NOT NULL,
  "name" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("room") REFERENCES "erp_archive_rooms" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_archive_types" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_archive_elements" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "shelf" int NOT NULL,
  "name" varchar(255) default NULL,
  "elementid" varchar(255) default NULL,
  "type" int default NULL,
  "description" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("shelf") REFERENCES "erp_archive_shelfs" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("type") REFERENCES "erp_archive_types" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_categories" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "number" smallint default '0',
  "name" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_storages" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "assigneduser" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "default" smallint default '0',
  "name" varchar(255) default NULL,
  "description" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("assigneduser") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_items" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "storage" int NOT NULL,
  "useserials" smallint default '0',
  "evalmethod" smallint default '0',
  "periode" smallint default '0',
  "name" varchar(255) default NULL,
  "manufacturer" varchar(255) default NULL,
  "itemnum" varchar(255) default NULL,
  "location" varchar(255) default NULL,
  "quantity" smallint default '0',
  "barcode" varchar(255) default NULL,
  "price" double precision default '0',
  "taxrate" smallint default '0',
  "minstock" int default '0',
  "weight" double precision default '0',
  "dimx" double precision default '0',
  "dimy" double precision default '0',
  "dimz" double precision default '0',
  "description" text default NULL,
  "extdatabinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("storage") REFERENCES "erp_stockcalc_storages" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_productions" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "item" int NOT NULL,
  "date" int default '0',
  "productionid" varchar(255) default NULL,
  "output" int default '0',
  "target" int default '0',
  "materialcosts" double precision default '0',
  "manufactcosts" double precision default '0',
  "itemsbinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("item") REFERENCES "erp_stockcalc_items" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_depletions" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "item" int NOT NULL,
  "date" int default '0',
  "delivery" int default NULL,
  "production" int default NULL,
  "purpose" varchar(255) default NULL,
  "amount" int default '0',
  "price" double precision default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("item") REFERENCES "erp_stockcalc_items" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("delivery") REFERENCES "crm_billing_deliveries" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("production") REFERENCES "erp_stockcalc_productions" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_depletions_serials" (
  "ID" serial NOT NULL,
  "depletion" int NOT NULL,
  "serial" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("depletion") REFERENCES "erp_stockcalc_depletions" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_devices" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "item" int NOT NULL,
  "serial" varchar(255) default NULL,
  "location" varchar(255) default NULL,
  "reference" varchar(255) default NULL,
  "comment" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("item") REFERENCES "erp_stockcalc_items" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_files" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "item" int NOT NULL,
  "file" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("item") REFERENCES "erp_stockcalc_items" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("file") REFERENCES "col_files_files" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_items_categories" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "item" int NOT NULL,
  "category" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("item") REFERENCES "erp_stockcalc_items" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("category") REFERENCES "erp_stockcalc_categories" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_suppliers_suppliers" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "assigneduser" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  "vendornum" varchar(255) default NULL,
  "status" smallint default '0',
  "customernum" varchar(255) default NULL,
  "dispatch" smallint default '0',
  "payment" smallint default '0',
  "prefcontact" smallint default '0',
  "bank" varchar(255) default NULL,
  "bankid" varchar(255) default NULL,
  "account" varchar(255) default NULL,
  "contact" int default NULL,
  "description" text default NULL,
  "lastupload" int default '0',
  "pricelistbinfile" varchar(32) default NULL,
  "extdatabinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("assigneduser") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("contact") REFERENCES "org_contacts_companies" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_orders" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "item" int NOT NULL,
  "flag" smallint default '0',
  "date" int default '0',
  "orderid" varchar(255) default NULL,
  "supplier" int default NULL,
  "amount" int default '0',
  "delivered" int default '0',
  "price" double precision default '0',
  "etd" int default '0',
  "td" int default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("item") REFERENCES "erp_stockcalc_items" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("supplier") REFERENCES "erp_suppliers_suppliers" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_incoming" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "item" int NOT NULL,
  "date" int default '0',
  "order" int default NULL,
  "production" int default NULL,
  "amount" int default '0',
  "price" double precision default '0',
  "periode" smallint default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("item") REFERENCES "erp_stockcalc_items" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("order") REFERENCES "erp_stockcalc_orders" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("production") REFERENCES "erp_stockcalc_productions" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_incoming_serials" (
  "ID" serial NOT NULL,
  "incoming" int NOT NULL,
  "serial" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("incoming") REFERENCES "erp_stockcalc_incoming" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_templates" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  "inputbinfile" varchar(32) default NULL,
  "outputbinfile" varchar(32) default NULL,
  "pdfbinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_printouts" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "orderid" varchar(255) default NULL,
  "template" int default NULL,
  "maildate" int default '0',
  "databinfile" varchar(32) default NULL,
  "pdfbinfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("template") REFERENCES "erp_stockcalc_templates" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_stockcalc_suppliers" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "item" int NOT NULL,
  "supplier" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("item") REFERENCES "erp_stockcalc_items" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("supplier") REFERENCES "erp_suppliers_suppliers" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_suppliers_categories" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "supplier" int NOT NULL,
  "category" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("supplier") REFERENCES "erp_suppliers_suppliers" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("category") REFERENCES "erp_stockcalc_categories" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_suppliers_files" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "supplier" int NOT NULL,
  "file" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("supplier") REFERENCES "erp_suppliers_suppliers" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("file") REFERENCES "col_files_files" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_suppliers_invoices" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "supplier" int NOT NULL,
  "flag" smallint default '0',
  "invoicenum" varchar(255) default NULL,
  "billingdate" int default '0',
  "duedate" int default '0',
  "netamount" double precision default '0',
  "totalamount" double precision default '0',
  "payment" double precision default '0',
  "comment" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("supplier") REFERENCES "erp_suppliers_suppliers" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "erp_suppliers_journal" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "supplier" int NOT NULL,
  "date" int default '0',
  "label" smallint default '0',
  "contact" int default NULL,
  "subject" varchar(255) default NULL,
  "text" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("supplier") REFERENCES "erp_suppliers_suppliers" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("contact") REFERENCES "org_contacts_people" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_calendar_events" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) default NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "title" varchar(255) default NULL,
  "location" varchar(255) default NULL,
  "datefrom" int default '0',
  "dateto" int default '0',
  "repeat" smallint default '0',
  "interval" int default '0',
  "usedaterepeat" smallint default '0',
  "daterepeat" int default '0',
  "label" smallint default '0',
  "display" smallint default '0',
  "description" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_calendar_invitations" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) NOT NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "event" int NOT NULL,
  "flag" smallint default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("event") REFERENCES "org_calendar_events" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_contacts_people_companies" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "person" int NOT NULL,
  "company" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("person") REFERENCES "org_contacts_people" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("company") REFERENCES "org_contacts_companies" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_followup_categories" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_followup_reminders" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) default NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) default NULL,
  "assigneduser" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "category" int default NULL,
  "title" varchar(255) default NULL,
  "duedate" int default '0',
  "status" smallint default '0',
  "priority" smallint default '0',
  "description" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("assigneduser") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("category") REFERENCES "org_followup_categories" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_followup_associates" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) default NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "reminder" int NOT NULL,
  "entity" varchar(60) default NULL,
  "index" int default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("reminder") REFERENCES "org_followup_reminders" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_links_columns" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) NOT NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_links_links" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) NOT NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "column" int default NULL,
  "title" varchar(255) default NULL,
  "url" varchar(255) default NULL,
  "description" text default NULL,
  "numviews" int default '0',
  "lastview" int default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("column") REFERENCES "org_links_columns" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_notes_categories" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_notes_notes" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) default NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) default NULL,
  "assigneduser" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "category" int default NULL,
  "title" varchar(255) default NULL,
  "text" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("assigneduser") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("category") REFERENCES "org_notes_categories" ("ID") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "org_tasks_records" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "task" int NOT NULL,
  "text" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("task") REFERENCES "org_tasks_tasks" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "platform_accesskeys" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "name" varchar(255) default NULL,
  "key" varchar(32) default NULL,
  "description" text default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "platform_boarditems" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "text" varchar(255) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "platform_charts" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "activity" smallint default '0',
  "timeoriented" smallint default '0',
  "name" varchar(255) default NULL,
  "binfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "platform_exporttemplates" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "activity" smallint default '0',
  "entity" varchar(60) default NULL,
  "name" varchar(255) default NULL,
  "binfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "platform_monitor" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) default NULL,
  "ownergroup" varchar(60) default NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "UMI" varchar(60) default NULL,
  "entity" varchar(60) default NULL,
  "index" int default '0',
  "url" varchar(255) default NULL,
  "name" varchar(255) default NULL,
  "action" smallint default '0',
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("ownergroup") REFERENCES "platform_groups" ("groupname") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "platform_services" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "activity" smallint default '0',
  "name" varchar(255) default NULL,
  "event" smallint default '0',
  "entity" varchar(60) default NULL,
  "schedule" int default '0',
  "interval" int default '0',
  "binfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "platform_services_accesskeys" (
  "ID" serial NOT NULL,
  "creator" varchar(60) default NULL,
  "creationdate" int default '0',
  "service" int NOT NULL,
  "accesskey" int NOT NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("creator") REFERENCES "platform_users" ("username") ON DELETE SET NULL ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("service") REFERENCES "platform_services" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE,
  FOREIGN KEY ("accesskey") REFERENCES "platform_accesskeys" ("ID") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);

CREATE TABLE "platform_settings" (
  "ID" serial NOT NULL,
  "owneruser" varchar(60) NOT NULL,
  "creationdate" int default '0',
  "lastmodified" int default '0',
  "UMI" varchar(60) default NULL,
  "binfile" varchar(32) default NULL,
  PRIMARY KEY ("ID"),
  FOREIGN KEY ("owneruser") REFERENCES "platform_users" ("username") ON DELETE CASCADE ON UPDATE CASCADE DEFERRABLE
);