=begin

  Copyright (c) 2009 Infosoft Global Private Limited
 
=end
#Helps in saving the files on server Contains methods to check whether server is ready for save or not, generate a unique filename
class Fusioncharts::Exporter::SaveHelper
   require "digest"
   #Checks whether the server is ready for download
  def self.check_server_save_status(folder_to_save,filename,overwrite,intelligent_file_naming)
    err_codes=""
    # check whether directory exists
    #raise error and halt execution if directory does not exists
    count=0
    if(!FileTest.exists?(folder_to_save))
      err_code="E508,"
      err_codes+=err_code
      return err_codes
    end
    # check if directory is writable or not
    is_dir_writable = File.writable?( folder_to_save ) 
      if(!is_dir_writable)
        err_code="E403,"
        err_codes+=err_code
        return err_codes # folder is not writable - access forbidden
      end
    #build filepath
    complete_file_path = folder_to_save + '/' + filename 
    
    # check whether file exists
    if ( FileTest.exists?(complete_file_path )) 
      err_code= "W509,"
      #print "WARNING:"+"509\n"
      err_codes+=err_code

      #if overwrite is on return with ready flag 
      if ( overwrite ) 
          # add notice while trying to overwrite
          err_code= "W510,"
          err_codes+=(count==0 ? err_code:","+err_code)
          # see whether the existing file is writable
          # if not halt raising error message
          if(!File.writable?( complete_file_path ) ) 
              err_code= "E511,"
              err_codes+=err_code
              return err_codes
          end
          
      else 
        # File already exists, file overwrite is false , check IntelligentFileNaming
        if(!intelligent_file_naming)
              err_code= "E512,"
              err_codes+=err_code
              return err_codes
        end
      end
    end	
      # return with ready flag / error code
      return err_codes
    end    
  # Generates Unique filename with suffix either a TIMESTAMP  or RANDOM number
  def self.generate_unique_filename(complete_file_path_without_ext,extension) 
    #print "Generating unique id..."
       md5_str=""
       until !FileTest.exists?(complete_file_path_without_ext+md5_str+"."+extension)
          md5 = Digest::MD5.new
          now = Time.now
          md5 << now.to_s
          md5 << String(now.usec)
          md5 << String(rand(0))
          md5 << String($$)
          #md5 << constant
          md5.hexdigest
          if(Fusioncharts::Exporter::Properties.FILESUFFIXFORMAT=="TIMESTAMP")
            md5_str = md5.to_s + "_" + Time.now.strftime("%m%d%Y%S").to_s 
          else 
            md5_str = md5.to_s + "_" + Array.new(9){rand 10}.join 
          end
      end
      #print "Generated"
      return complete_file_path_without_ext+md5_str + "." + extension
    end
    # Builds the query string starting with & for meta values
    def self.build_meta_query_string(meta,fileNameWithPath)
       meta_values="&fileName="+fileNameWithPath
        meta_values+= "&width=" +meta ["width"]
        meta_values+= "&height=" +meta ["height"]
        meta_values+= "&DOMId=" +meta ["DOMId"]
        return meta_values
    end
end