<%@ include file="../Includes/DBConn.jsp"%>

<%@ page import="java.sql.Statement"%>
<%@ page import="java.sql.ResultSet"%>
<%@ page import="java.sql.Date"%>
<HTML>
	<HEAD>
		<TITLE>FusionCharts - Database + JavaScript Example</TITLE>
	
		<%
			/*
			In this example, we show a combination of database + JavaScript (dataURL method)
			rendering using FusionCharts.
			
			The entire app (page) can be summarized as under. This app shows the break-down
			of factory wise output generated. In a pie chart, we first show the sum of quantity
			generated by each factory. These pie slices, when clicked would show detailed date-wise
			output of that factory. The detailed data would be dynamically pulled by the column
			chart from another JSP page. There are no page refreshes required. Everything
			is done on one single page.
			
			The XML data for the pie chart is fully created in JSP at run-time. JSP interacts
			with the database and creates the XML for this.
			Now, for the column chart (date-wise output report), each time we need the data
			we dynamically submit request to the server with the appropriate factoryId. The server
			responds with an XML document, which we accept and update chart at client side.
			*/
			%>
			<SCRIPT LANGUAGE="Javascript" SRC="../../FusionCharts/FusionCharts.js">
				//You need to include the above JS file, if you intend to embed the chart using JavaScript.
				//Embedding using JavaScripts avoids the "Click to Activate..." issue in Internet Explorer
				//When you make your own charts, make sure that the path to this JS file is correct. Else, you would get JavaScript errors.
			</SCRIPT>
		
			<SCRIPT LANGUAGE="JavaScript">
				
				/** 
				 * updateChart method is invoked when the user clicks on a pie slice.
				 * In this method, we get the index of the factory after which we request for XML data
				 * for that that factory from FactoryData.asp, and finally
				 * update the Column Chart.
				 *	@param	factoryIndex	Sequential Index of the factory.
				*/		
				function updateChart(factoryIndex){		
					//DataURL for the chart
					var strURL = "FactoryData.jsp?factoryId=" + factoryIndex;
					
					//Sometimes, the above URL and XML data gets cached by the browser.
					//If you want your charts to get new XML data on each request,
					//you can add the following line:
					//strURL = strURL + "&currTime=" + getTimeForURL();
					//getTimeForURL method is defined below and needs to be included
					//This basically adds a ever-changing parameter which bluffs
					//the browser and forces it to re-load the XML data every time.
								
					//URLEncode it - NECESSARY.
					strURL = escape(strURL);
					
					//Get reference to chart object using Dom ID "FactoryDetailed"
					var chartObj = getChartFromId("FactoryDetailed");			
					//Send request for XML
					chartObj.setDataURL(strURL);
				}
				/**
				 * getTimeForURL method returns the current time 
				 * in a URL friendly format, so that it can be appended to
				 * dataURL for effective non-caching.
				*/
				function getTimeForURL(){
					var dt = new Date();
					var strOutput = "";
					strOutput = dt.getHours() + "_" + dt.getMinutes() + "_" + dt.getSeconds() + "_" + dt.getMilliseconds();
					return strOutput;
				}
			</SCRIPT>
			<style type="text/css">
				<!--
				body {
					font-family: Arial, Helvetica, sans-serif;
					font-size: 12px;
				}
				.text{
					font-family: Arial, Helvetica, sans-serif;
					font-size: 12px;
				}
				-->
			</style>
		</HEAD>
		<BODY>
			<CENTER>
			<h2>FusionCharts Database + JavaScript (dataURL method) Example</h2>
			<h4>Inter-connected charts - Click on any pie slice to see detailed
			chart below.</h4>
			<p>The charts in this page have been dynamically generated using
			data contained in a database.</p>
			<%		
					//Database Objects - Initialization
					Statement st1=null,st2=null;
					ResultSet rs1=null,rs2=null;
					
					String strQuery="";
				
					//strXML will be used to store the entire XML document generated
					String strXML="";
				
					//Generate the chart element
					strXML = "<chart caption='Factory Output report' subCaption='By Quantity' pieSliceDepth='30' showBorder='1' formatNumberScale='0' numberSuffix=' Units' >";	
					
					//Iterate through each factory
					strQuery = "select * from Factory_Master";
					st1=oConn.createStatement();
					rs1=st1.executeQuery(strQuery);
					
					String factoryId=null;
					String factoryName=null;
					String totalOutput="";
					
					while(rs1.next()) {
						factoryId=rs1.getString("FactoryId");
						factoryName=rs1.getString("FactoryName");
						//Now create second recordset to get details for this factory
						strQuery = "select sum(Quantity) as TotOutput from Factory_Output where FactoryId=" + factoryId;
						st2=oConn.createStatement();
						rs2 = st2.executeQuery(strQuery);
						if(rs2.next()){
							totalOutput=rs2.getString("TotOutput");
						}
						//Generate <set label='..' value='..'/>		
						strXML += "<set label='" + factoryName + "' value='" +totalOutput+ "' link='javaScript:updateChart("+factoryId + ")'/>";
						//close the resultset,statement
						//enclose them in try catch block
						try {
							if(null!=rs2){
								rs2.close();
								rs2=null;
							}
						}catch(java.sql.SQLException e){
						 	System.out.println("Could not close the resultset");
						}
						try{
							if(null!=st2) {
								st2.close();
								st2=null;
							}
						}catch(java.sql.SQLException e){
						 	System.out.println("Could not close the statement");
						}
					}
					//Finally, close <chart> element
					strXML += "</chart>";
					//close the resultset,statement,connection
					//enclose them in try catch block
					try {
						if(null!=rs1){
							rs1.close();
							rs1=null;
						}
					}catch(java.sql.SQLException e){
						 System.out.println("Could not close the resultset");
					}	
					try {
						if(null!=st1) {
							st1.close();
							st1=null;
						}
				    }catch(java.sql.SQLException e){
					 	 System.out.println("Could not close the statement");
					}
					try {
						if(null!=oConn) {
						    oConn.close();
						    oConn=null;
						}
				    }catch(java.sql.SQLException e){
					 	 System.out.println("Could not close the connection");
					}
			
				//Create the chart - Pie 3D Chart with data from strXML
%> 
			<jsp:include page="../Includes/FusionChartsRenderer.jsp" flush="true"> 
							<jsp:param name="chartSWF" value="../../FusionCharts/Pie3D.swf" /> 
							<jsp:param name="strURL" value="" /> 
							<jsp:param name="strXML" value="<%=strXML%>" /> 
							<jsp:param name="chartId" value="FactorySum" /> 
							<jsp:param name="chartWidth" value="500" /> 
							<jsp:param name="chartHeight" value="250" /> 
							<jsp:param name="debugMode" value="false" /> 	
							<jsp:param name="registerWithJS" value="false" /> 							
						</jsp:include>
			<BR>
			<%
				//Column 2D Chart with changed "No data to display" message
				//We initialize the chart with <chart></chart>
%>
						<jsp:include page="../Includes/FusionChartsRenderer.jsp" flush="true"> 
								<jsp:param name="chartSWF" value="../../FusionCharts/Column2D.swf?ChartNoDataText=Please select a factory from pie chart above to view detailed data." /> 
								<jsp:param name="strURL" value="" /> 
								<jsp:param name="strXML" value="<chart></chart>" /> 
								<jsp:param name="chartId" value="FactoryDetailed" /> 
								<jsp:param name="chartWidth" value="600" /> 
								<jsp:param name="chartHeight" value="250" /> 
								<jsp:param name="debugMode" value="false" /> 	
								<jsp:param name="registerWithJS" value="true" /> 								
							</jsp:include> 
			<BR>
			<BR>
			<a href='../NoChart.html' target="_blank">Unable to see the charts above?</a><BR>
			<H5><a href='../default.htm'>&laquo; Back to list of examples</a></h5>
		</CENTER>
	</BODY>
</HTML>