<?php

$OLT_LOAD_SMARTY = true;

require_once('loader.php');
require_once('inc/Request.class.php');
require_once('inc/Auth.php');
require_once('stats.php');


$mode = Request::getString(RM_GETPOST, 'mode', 'main');


function show_template($name)
{
	global $tpl;
	$tpl->display('base.tpl', "{$name}.tpl");
	exit(0);
}

function date_time_picker()
{
	global $tpl;
	if (Request::is_set(RM_GET, 'day'))
	{
		$time = mktime(0, 0, 0, Request::getInt(RM_GET, 'month'), Request::getInt(RM_GET, 'day'), Request::getInt(RM_GET, 'year'));
		$date = date("Y-m-d", $time);
	}
	else 
	{
		$date = date("Y-m-d");
	}
	
	list($year, $month, $day) = split('[/.-]', $date);
	$tpl->assign('dpick_year', $year);
	$tpl->assign('dpick_month', $month);
	$tpl->assign('dpick_day', $day);
	
	$monthes[1] = "January";
	$monthes[2] = "February";
	$monthes[3] = "March";
	$monthes[4] = "April";
	$monthes[5] = "May";
	$monthes[6] = "June";
	$monthes[7] = "July";
	$monthes[8] = "August";
	$monthes[9] = "September";
	$monthes[10] = "October";
	$monthes[11] = "November";
	$monthes[12] = "December";
	
	for ($i = 1; $i < 31; $i++) $days[$i] = $i;
	$cur_year = intval(date("Y"));
	for ($i = $cur_year; $i > $cur_year-5; $i--) $years[$i] = $i;
	
	$tpl->assign('dpick_year_vals', $years);
	$tpl->assign('dpick_month_vals', $monthes);
	$tpl->assign('dpick_day_vals', $days);
	
	return $date;
	
}

function buttons_list()
{
	$result = array();
	if ($handle = opendir(dirname(__FILE__) . '/buttons'))
	{
		while (false !== ($file = readdir($handle))) 
		{
			if(is_dir($file)) continue;
			if (preg_match('/(.*)\.png$/i', $file, $match))
				$result[] = $match[1];
		}
		closedir($handle);
		return $result;
	}
	else 
	{
		echo "Error opendir `/buttons` failed";
		exit;
	} 
}

function update_setting($name, $value)
{
	global $db, $conf_db_pref;
	
	$settings = load_settings();
	$value = addslashes($value);
	if (isset($settings[$name]))
	{
		$sql = "UPDATE {$conf_db_pref}settings SET value='$value' WHERE name='$name'";
	}
	else 
	{
		$sql = "INSERT INTO {$conf_db_pref}settings (name, value) VALUES ('$name', '$value')";
	}
	if (!$db->query($sql)) 
		die($db->getMessage() . ". SQL: " . $sql);
}

function load_settings()
{
	global $db, $conf_db_pref;
	$sql = "SELECT name, value FROM {$conf_db_pref}settings ORDER BY name";
	$result = $db->queryRows($sql);
	if ($result === false) 
		die($db->getMessage() . ". SQL: " . $sql);
	$settings = array();
	foreach ($result as $row) 
	{
		$settings[$row['name']]	= $row['value'];
	}
	return $settings;
}

function process_leave_stats()
{
	global $db, $conf_db_pref;
	$settings = load_settings();
	if (!isset($settings['leave'])) return ;
	$days = intval($settings['leave']);
	if ($days <= 0) return ;
	$now = time() - (($days+1) * 60 * 60 * 24);
	$date = date("Y-m-d", $now);
	$sql = "DELETE FROM {$conf_db_pref}hits WHERE hitdate < '$date'";
	if (!$db->query($sql)) 
		echo "Failed to delete statistic - " . $db->getMessage() . ". SQL: " . $sql;
}

//--------------------------------------------------------------------------------
if ($mode == 'auth')
{
	$user = Request::getString(RM_POST, 'login', '');
	$pass = Request::getString(RM_POST, 'pass', '');
	if (!Auth::login($user, $pass))
	{
		$tpl->assign('errors', array('Wrong login or password'));
		show_template('login');
	}
	$mode = 'main';	
}
else 
{
	if (!Auth::present())
	{
		$tpl->display('base.tpl', 'login.tpl');
		exit(0);
	}
}

//--------------------------------------------------------------------------------
if ($mode == 'logout') 
{
	Auth::logout();
	show_template('login');
}



$tpl->assign('logged_in', true);
process_leave_stats();



//--------------------------------------------------------------------------------
if ($mode == 'searches') 
{
	$date = date_time_picker();
	
	$stats = get_detailed_stats($date);
	
	$tpl->assign('date', $date);
	$tpl->assign('stats', $stats);
	
	show_template('searches');
}

//--------------------------------------------------------------------------------
if ($mode == 'settings') 
{
	
	if (Request::is_set(RM_POST, 'leave'))
	{
		$leave = Request::getInt(RM_POST, 'leave', 60);
		if ($leave < 0) $leave = 0;
		update_setting('leave', $leave);
	}
	
	$settings = load_settings();
	$tpl->assign('settings', $settings);
	
	show_template('settings');
}

//--------------------------------------------------------------------------------
if ($mode == 'queries') 
{
	$engine_id = Request::getInt(RM_GET, 's');
	$date = Request::getString(RM_GET, 'd');
	$page_id = Request::getInt(RM_GET, 'p');
	
	$stats = get_query_stats($engine_id, $page_id, $date);
	
	$tpl->assign('enigne', $se_ru_names[$engine_id]);
	$tpl->assign('date', $date);
	$tpl->assign('stats', $stats);
	
	show_template('queries');
}

//--------------------------------------------------------------------------------
if ($mode == 'getcode') 
{
	$base_url = "http://" . $_SERVER['SERVER_NAME'];
	$base_url .= dirname($_SERVER['REQUEST_URI']);
	$base_url .= "/hit.php";
	
	$buttons = buttons_list();	
	$sel_button = $buttons[0];
	$tpl->assign('buttons', $buttons);
	$tpl->assign('sel_button', $buttons[0]);
	
	$code1 = "
<!-- site 1x1 counter -->
<script type=\"text/javascript\"><!--
var olt_rnd_gen = Math.random()*10000;
document.write('<img src=\"{$base_url}?sih=1&r='+
escape(document.referrer)+((typeof(screen)=='undefined')?'&m=null':
'&m='+screen.width+'*'+screen.height+'*'+(screen.colorDepth?
screen.colorDepth:screen.pixelDepth))+'&p='+escape(document.URL)+
'&g='+olt_rnd_gen+
'\" width=1 height=1 alt=\"\">')//-->
</script>
<!-- /site 1x1 counter -->
";
	
	
	$code2 = "
<!-- site big counter -->
<a title=\"Free soft for webmasters\" href=\"http://soft-seo.com/\">
<script type=\"text/javascript\"><!--
document.write('<img src=\"{$base_url}?bih=1&skin={$sel_button}&p='+escape(document.URL)+
'&g='+olt_rnd_gen+
'\" width=88 height=31 alt=\"\">')//-->
</script>
</a>
<!-- /site big counter -->
";
	
	$tpl->assign('code1', $code1);
	$tpl->assign('code2', $code2);
	
	
	show_template('getcode');
}

//--------------------------------------------------------------------------------
if ($mode == 'main') 
{
	
	$date = date_time_picker();
	$stats = get_common_stats($date);
	
	$tpl->assign('date', $date);
	$tpl->assign('stats', $stats);
	
	show_template('common');
}


?>
