package com.softviewtech.jbillboard;

import javax.swing.UIManager;
import java.awt.*;

import javax.swing.*;

/**
 * Title:        JBillboard
 * Description:  The builder for billboard applets.
 * Copyright:    Copyright (c) 2002
 * Company:      SoftView Technology
 * @author J.Y. Weng
 * @version 1.0
 */

public class jbillboard {
    boolean packFrame = false;

    /**Construct the application*/
    public jbillboard() {
        // show the cover
        FrmCover frmCover=new FrmCover();
        if (packFrame) {
            frmCover.pack();
        }
        else {
            frmCover.validate();
        }
        //Center the window
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frmCover.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frmCover.setLocation((screenSize.width - frameSize.width) / 2,
                                    (screenSize.height - frameSize.height) / 2);
        frmCover.setVisible(true);
        frmCover.showCover();


        // start the program
        Frame1 frame = new Frame1();

        //Validate frames that have preset sizes
        //Pack frames that have useful preferred size info, e.g. from their layout
        if (packFrame) {
            frame.pack();
        }
        else {
            frame.validate();
        }
        //Center the window
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }

        frame.setLocation(frmCover.getLocation());

        frame.setVisible(true);
        frmCover.setVisible(false);
        frmCover.dispose();

        frame.showDlgInputSN();
        frmCover=null;

    }
    /**Main method*/
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch(Exception e) {
            e.printStackTrace();
        }
        new jbillboard();
    }
}