/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dx.dataset;

import com.borland.dx.dataset.Res;
import com.borland.dx.dataset.VariantException;
import com.borland.jb.util.ExceptionChain;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class Variant
implements Serializable,
Cloneable {
    static int bugCount;
    private static long timeZoneOffset;
    private static boolean offsetsKnown;
    private static byte[] zeroByteArray;
    private static ByteArrayInputStream zeroBinary;
    private static BigDecimal zeroBIGDECIMAL;
    private static String zeroString;
    private transient Object objectVal;
    private Timestamp timestampVal;
    private Time timeVal;
    private Date dateVal;
    private BigDecimal bigDecimalVal;
    private byte[] byteArrayVal;
    private String stringVal;
    private double doubleVal;
    private float floatVal;
    private long longVal;
    private int intVal;
    private boolean booleanVal;
    private int type;
    private int setType;
    public static final int MaxTypes = 18;
    private static final int SET_AS_OBJECT = -3;
    private static final int SET_AS_INPUTSTREAM = -2;
    public static final Variant nullVariant;
    public static final String UnknownType_S = "UNKNOWN";
    public static final String ObjectType_S = "OBJECT";
    public static final String StringType_S = "STRING";
    public static final String ByteArrayType_S = "BYTE_ARRAY";
    public static final String TimestampType_S = "TIMESTAMP";
    public static final String TimeType_S = "TIME";
    public static final String DateType_S = "DATE";
    public static final String BinaryStreamType_S = "BINARY_STREAM";
    public static final String InputStreamType_S = "INPUTSTREAM";
    public static final String BooleanType_S = "BOOLEAN";
    public static final String BigDecimalType_S = "BIGDECIMAL";
    public static final String DoubleType_S = "DOUBLE";
    public static final String FloatType_S = "FLOAT";
    public static final String LongType_S = "LONG";
    public static final String IntType_S = "INT";
    public static final String ShortType_S = "SHORT";
    public static final String ByteType_S = "BYTE";
    public static final String UnassignedNull_S = "UNASSIGNED_NULL";
    public static final String AssignedNull_S = "ASSIGNED_NULL";
    public static final int BYTE_ARRAY = 18;
    public static final int OBJECT = 17;
    public static final int STRING = 16;
    public static final int TIMESTAMP = 15;
    public static final int TIME = 14;
    public static final int DATE = 13;
    public static final int INPUTSTREAM = 12;
    public static final int BINARY_STREAM = 12;
    public static final int BOOLEAN = 11;
    public static final int BIGDECIMAL = 10;
    public static final int DOUBLE = 7;
    public static final int FLOAT = 6;
    public static final int LONG = 5;
    public static final int INT = 4;
    public static final int SHORT = 3;
    public static final int BYTE = 2;
    public static final int NULL_TYPES = 1;
    public static final int ASSIGNED_NULL = 1;
    public static final int UNASSIGNED_NULL = 0;
    private static final long serialVersionUID = 200L;

    static {
        nullVariant = new Variant(0);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.objectVal = objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.objectVal instanceof Serializable) {
            objectOutputStream.writeObject(this.objectVal);
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    public Object clone() {
        Variant variant = new Variant(this.setType);
        variant.setVariant(this);
        return variant;
    }

    public void subtract(Variant variant, Variant variant2) {
        if (variant.isNull() && this.isNull()) {
            variant2.setVariant(this);
        } else {
            switch (this.type) {
                case 2: 
                case 3: 
                case 4: {
                    variant2.setInt(this.intVal - variant.getAsInt());
                    break;
                }
                case 5: {
                    variant2.setLong(this.longVal - variant.getAsLong());
                    break;
                }
                case 6: {
                    variant2.setFloat(this.floatVal - variant.getAsFloat());
                    break;
                }
                case 7: {
                    variant2.setDouble(this.doubleVal - variant.getAsDouble());
                    break;
                }
                case 10: {
                    variant2.setBigDecimal(this.getBigDecimal().subtract(variant.getAsBigDecimal()));
                    break;
                }
                case 0: 
                case 1: {
                    variant2.setVariant(variant);
                    break;
                }
            }
        }
    }

    public void add(Variant variant, Variant variant2) {
        if (variant.isNull() && this.isNull()) {
            variant2.setVariant(this);
        } else {
            switch (this.type) {
                case 2: {
                    variant2.setByte((byte)(this.intVal + variant.getAsInt()));
                    break;
                }
                case 3: {
                    variant2.setShort((short)(this.intVal + variant.getAsInt()));
                    break;
                }
                case 4: {
                    variant2.setInt(this.intVal + variant.getAsInt());
                    break;
                }
                case 5: {
                    variant2.setLong(this.longVal + variant.getAsLong());
                    break;
                }
                case 13: {
                    variant2.setDate(this.dateVal.getTime() + variant.getDate().getTime());
                }
                case 14: {
                    variant2.setTime(this.timeVal.getTime() + variant.getTime().getTime());
                }
                case 6: {
                    variant2.setFloat(this.floatVal + variant.getAsFloat());
                    break;
                }
                case 7: {
                    variant2.setDouble(this.doubleVal + variant.getAsDouble());
                    break;
                }
                case 10: {
                    variant2.setBigDecimal(this.getBigDecimal().add(variant.getAsBigDecimal()));
                    break;
                }
                case 0: 
                case 1: {
                    variant2.setVariant(variant);
                    break;
                }
            }
        }
    }

    public int compareTo(Variant variant) {
        if (this.isNull()) {
            return variant.isNull() ? 0 : -1;
        }
        if (variant.isNull()) {
            return 1;
        }
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                int n2 = variant.getAsInt();
                if (this.intVal < n2) {
                    return -1;
                }
                if (this.intVal > n2) {
                    return 1;
                }
                return 0;
            }
            case 5: {
                return this.a(this.longVal, variant.getAsLong());
            }
            case 6: {
                return this.a(this.floatVal, variant.getAsFloat());
            }
            case 7: {
                return this.a(this.doubleVal, variant.getAsDouble());
            }
            case 10: {
                return this.getBigDecimal().compareTo(variant.getAsBigDecimal());
            }
            case 13: {
                return this.a(this.dateVal.getTime(), variant.getDate().getTime());
            }
            case 14: {
                return this.a(this.timeVal.getTime(), variant.getTime().getTime());
            }
            case 15: {
                return this.a(this.timestampVal, variant.getTimestamp());
            }
            case 11: {
                return this.a(this.booleanVal, variant.getBoolean());
            }
            case 16: {
                return this.stringVal.compareTo(variant.getString());
            }
        }
        return 0;
    }

    private final int a(boolean bl, boolean bl2) {
        if (bl == bl2) {
            return 0;
        }
        if (bl) {
            return 1;
        }
        return -1;
    }

    private final int a(Timestamp timestamp, Timestamp timestamp2) {
        int n2 = this.a(((java.util.Date)timestamp).getTime(), ((java.util.Date)timestamp2).getTime());
        if (n2 == 0) {
            return timestamp.getNanos() - timestamp2.getNanos();
        }
        return n2;
    }

    private final int a(float f2, float f3) {
        if (f2 < f3) {
            return -1;
        }
        if (f2 > f3) {
            return 1;
        }
        return 0;
    }

    private final int a(double d2, double d3) {
        if (d2 < d3) {
            return -1;
        }
        if (d2 > d3) {
            return 1;
        }
        return 0;
    }

    private final int a(long l2, long l3) {
        if (l2 < l3) {
            return -1;
        }
        if (l2 > l3) {
            return 1;
        }
        return 0;
    }

    private boolean a(InputStream inputStream, InputStream inputStream2) {
        if (inputStream == inputStream2) {
            return true;
        }
        if (inputStream == null || inputStream2 == null) {
            return false;
        }
        if (!inputStream.markSupported() || !inputStream2.markSupported()) {
            return false;
        }
        try {
            inputStream.reset();
            inputStream2.reset();
            int n2 = 0;
            while (n2 != -1) {
                int n3;
                n2 = inputStream.read();
                if (n2 == (n3 = inputStream2.read())) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private boolean a(char[] cArray, char[] cArray2) {
        int n2 = cArray.length;
        if (n2 != cArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (cArray[i2] == cArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Variant variant) {
        if (this.type != variant.type) {
            if (this.type <= 1 || variant.type <= 1) {
                return false;
            }
            this.a(variant.type, this.type, true);
        }
        switch (this.type) {
            case 0: 
            case 1: {
                return variant.type == this.type;
            }
            case 2: 
            case 3: 
            case 4: {
                return this.intVal == variant.intVal;
            }
            case 11: {
                return this.booleanVal == variant.booleanVal;
            }
            case 6: {
                return this.floatVal == variant.floatVal;
            }
            case 7: {
                return this.doubleVal == variant.doubleVal;
            }
            case 15: {
                if (this.timestampVal.getNanos() != variant.getTimestamp().getNanos()) {
                    return false;
                }
                return ((java.util.Date)this.timestampVal).getTime() == ((java.util.Date)variant.getTimestamp()).getTime();
            }
            case 13: 
            case 14: {
                return this.getAsLong() == variant.getAsLong();
            }
            case 5: {
                return this.longVal == variant.longVal;
            }
            case 10: {
                if (this.getBigDecimal() == variant.getBigDecimal()) {
                    return true;
                }
                return this.bigDecimalVal.compareTo(variant.bigDecimalVal) == 0;
            }
            case 16: {
                if (this.stringVal == variant.stringVal) {
                    return true;
                }
                return this.stringVal.equals(variant.stringVal);
            }
            case 18: {
                if (this.intVal == -2) {
                    this.getByteArray();
                }
                variant.getByteArray();
                return this.a(variant);
            }
            case 12: {
                if (this.intVal >= 0 && this.intVal == variant.intVal) {
                    return this.a(variant);
                }
                return this.a(this.getInputStream(), variant.getInputStream());
            }
            case 17: {
                if (this.intVal >= 0 && this.intVal == variant.intVal) {
                    return this.a(variant);
                }
                if (this.intVal != -3 && variant.intVal != -3) {
                    return this.a(this.getInputStream(), variant.getInputStream());
                }
                if (this.getObject() == variant.getObject()) {
                    return true;
                }
                return this.getObject().equals(variant.getObject());
            }
        }
        return false;
    }

    private final boolean a(Variant variant) {
        if (this.intVal == variant.intVal) {
            int n2;
            if (this.byteArrayVal == variant.byteArrayVal) {
                return true;
            }
            for (n2 = 0; n2 < this.intVal && this.byteArrayVal[n2] == variant.byteArrayVal[n2]; ++n2) {
            }
            return n2 == this.intVal;
        }
        return false;
    }

    public boolean equalsInstance(Variant variant) {
        if (this.type == variant.type) {
            switch (this.type) {
                case 12: {
                    if (this.intVal != -2 || variant.intVal != -2) break;
                    return this.getInputStream() == variant.getInputStream();
                }
                case 17: {
                    if (this.intVal != -3 || variant.intVal != -3) break;
                    return this.getObject() == variant.getObject();
                }
            }
        }
        return this.equals(variant);
    }

    public final String toString() {
        switch (this.type) {
            case 0: 
            case 1: {
                return "";
            }
            case 2: 
            case 3: 
            case 4: {
                return Integer.toString(this.intVal, 10);
            }
            case 6: {
                return Float.toString(this.floatVal);
            }
            case 7: {
                return Double.toString(this.doubleVal);
            }
            case 5: {
                return Long.toString(this.longVal, 10);
            }
            case 10: {
                if (this.booleanVal) {
                    return this.stringVal;
                }
                if (this.bigDecimalVal == null) {
                    return "";
                }
                return this.bigDecimalVal.toString();
            }
            case 11: {
                return this.booleanVal ? "true" : "false";
            }
            case 16: {
                if (this.stringVal == null) {
                    return "";
                }
                return this.stringVal;
            }
            case 13: {
                return this.dateVal.toString();
            }
            case 14: {
                return this.timeVal.toString();
            }
            case 15: {
                return this.timestampVal.toString();
            }
            case 18: {
                if (this.byteArrayVal == null) {
                    return "";
                }
                return new String(this.byteArrayVal, 0, this.intVal);
            }
            case 17: {
                this.getObject();
                if (this.objectVal == null) {
                    return "";
                }
                return this.objectVal.toString();
            }
            case 12: {
                this.getInputStream();
                if (this.objectVal == null) {
                    return "";
                }
                return this.objectVal.toString();
            }
        }
        return "";
    }

    public void setAsObject(Object object, int n2) {
        switch (n2) {
            case 1: {
                this.setAssignedNull();
                break;
            }
            case 0: {
                this.setUnassignedNull();
                break;
            }
            case 4: {
                this.setInt((Integer)object);
                break;
            }
            case 2: {
                this.setByte((Byte)object);
                break;
            }
            case 3: {
                this.setShort((Short)object);
                break;
            }
            case 6: {
                this.setFloat(((Float)object).floatValue());
                break;
            }
            case 7: {
                this.setDouble((Double)object);
                break;
            }
            case 5: {
                this.setLong((Long)object);
                break;
            }
            case 10: {
                this.setBigDecimal((BigDecimal)object);
                break;
            }
            case 11: {
                this.setBoolean((Boolean)object);
                break;
            }
            case 16: {
                this.setString((String)object);
                break;
            }
            case 13: {
                this.setDate((Date)object);
                break;
            }
            case 14: {
                this.setTime((Time)object);
                break;
            }
            case 15: {
                this.setTimestamp((Timestamp)object);
                break;
            }
            case 18: {
                this.setByteArray((byte[])object, ((byte[])object).length);
                break;
            }
            case 17: {
                this.setObject(object);
                break;
            }
            case 12: {
                this.setInputStream((InputStream)object);
                break;
            }
        }
    }

    public Object getAsObject() {
        switch (this.type) {
            case 0: 
            case 1: {
                return null;
            }
            case 4: {
                return new Integer(this.intVal);
            }
            case 2: {
                return new Byte((byte)this.intVal);
            }
            case 3: {
                return new Short((short)this.intVal);
            }
            case 6: {
                return new Float(this.floatVal);
            }
            case 7: {
                return new Double(this.doubleVal);
            }
            case 5: {
                return new Long(this.longVal);
            }
            case 10: {
                if (this.booleanVal) {
                    return new BigDecimal(this.stringVal);
                }
                if (this.bigDecimalVal == null) {
                    return new BigDecimal("0");
                }
                return this.bigDecimalVal;
            }
            case 11: {
                return new Boolean(this.booleanVal);
            }
            case 16: {
                if (this.stringVal == null) {
                    return "";
                }
                return this.stringVal;
            }
            case 13: {
                return new Date(this.dateVal.getTime());
            }
            case 14: {
                return new Time(this.timeVal.getTime());
            }
            case 15: {
                return new Timestamp(((java.util.Date)this.timestampVal).getTime());
            }
            case 18: {
                if (this.byteArrayVal == null) {
                    return null;
                }
                return this.byteArrayVal;
            }
            case 17: {
                this.getObject();
                if (this.objectVal == null) {
                    return null;
                }
                return this.objectVal;
            }
            case 12: {
                this.getInputStream();
                if (this.objectVal == null) {
                    return null;
                }
                return this.objectVal;
            }
        }
        return null;
    }

    public final int getStoreType() {
        switch (this.type) {
            default: {
                if (this.objectVal != null || this.byteArrayVal == null) break;
                return 18;
            }
            case 18: {
                if (this.byteArrayVal != null || this.objectVal == null || this.intVal != -2) break;
                return 12;
            }
        }
        return this.type;
    }

    public final int getSetType() {
        return this.setType;
    }

    public final int getType() {
        return this.type;
    }

    public final boolean isNull() {
        return this.type <= 1;
    }

    public final boolean isUnassignedNull() {
        return this.type == 0;
    }

    public final boolean isAssignedNull() {
        return this.type == 1;
    }

    public final void setUnassignedNull() {
        this.type = 0;
    }

    public final void setAssignedNull() {
        this.type = 1;
    }

    public final void setNull(int n2) {
        this.type = n2 == 0 ? 0 : 1;
    }

    public final void setAsDate(Variant variant) {
        switch (variant.type) {
            case 13: {
                this.setDate(variant.getDate());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                this.setDate(variant.getAsLong());
                return;
            }
            case 0: {
                this.setUnassignedNull();
                return;
            }
            case 1: {
                this.setAssignedNull();
                return;
            }
        }
        this.a(this.type, 13, false);
    }

    public final void setAsTimestamp(Variant variant) {
        switch (variant.type) {
            case 15: {
                this.setTimestamp(variant.getTimestamp());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                this.setTimestamp(variant.getAsLong(), 0);
                return;
            }
            case 0: {
                this.setUnassignedNull();
                return;
            }
            case 1: {
                this.setAssignedNull();
                return;
            }
        }
        this.a(this.type, 15, false);
    }

    public final void setAsTime(Variant variant) {
        switch (variant.type) {
            case 14: {
                this.setTime(variant.getTime());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                this.setTime(variant.getAsLong());
                return;
            }
            case 0: {
                this.setUnassignedNull();
                return;
            }
            case 1: {
                this.setAssignedNull();
                return;
            }
        }
        this.a(this.type, 14, false);
    }

    public final boolean getAsBoolean() {
        switch (this.type) {
            case 11: {
                return this.booleanVal;
            }
            case 16: {
                return Boolean.valueOf(this.stringVal);
            }
            case 2: 
            case 3: 
            case 4: {
                return this.intVal != 0;
            }
            case 5: {
                return this.longVal != (long)0;
            }
            case 6: {
                return this.floatVal != 0.0f;
            }
            case 7: {
                return this.doubleVal != 0.0;
            }
            case 10: {
                return this.bigDecimalVal.doubleValue() != 0.0;
            }
            case 13: 
            case 14: 
            case 15: {
                return this.getAsLong() != (long)0;
            }
        }
        return false;
    }

    public final BigDecimal getAsBigDecimal() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return new BigDecimal((double)this.intVal);
            }
            case 5: {
                return BigDecimal.valueOf(this.longVal, 0);
            }
            case 6: {
                return new BigDecimal(this.floatVal);
            }
            case 7: {
                return new BigDecimal(this.doubleVal);
            }
            case 10: {
                return this.getBigDecimal();
            }
            case 13: 
            case 14: 
            case 15: {
                return BigDecimal.valueOf(this.getAsLong());
            }
            case 0: 
            case 1: {
                return new BigDecimal(0.0);
            }
        }
        this.a(this.type, 10, true);
        return null;
    }

    public final float getAsFloat() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return this.intVal;
            }
            case 5: {
                return this.longVal;
            }
            case 6: {
                return this.floatVal;
            }
            case 7: {
                return (float)this.doubleVal;
            }
            case 10: {
                return this.getBigDecimal().floatValue();
            }
            case 13: 
            case 14: 
            case 15: {
                return this.getAsLong();
            }
            case 0: 
            case 1: {
                return 0.0f;
            }
        }
        this.a(this.type, 6, true);
        return 0.0f;
    }

    public final double getAsDouble() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return this.intVal;
            }
            case 5: {
                return this.longVal;
            }
            case 6: {
                return this.floatVal;
            }
            case 7: {
                return this.doubleVal;
            }
            case 10: {
                return this.getBigDecimal().doubleValue();
            }
            case 13: 
            case 14: 
            case 15: {
                return this.getAsLong();
            }
            case 0: 
            case 1: {
                return 0.0;
            }
        }
        this.a(this.type, 7, true);
        return 0.0;
    }

    public final long getAsLong() {
        switch (this.type) {
            case 11: {
                return this.booleanVal ? 1 : 0;
            }
            case 2: 
            case 3: 
            case 4: {
                return this.intVal;
            }
            case 5: {
                return this.longVal;
            }
            case 6: {
                return (long)this.floatVal;
            }
            case 7: {
                return (long)this.doubleVal;
            }
            case 10: {
                return this.getBigDecimal().longValue();
            }
            case 15: {
                return ((java.util.Date)this.timestampVal).getTime();
            }
            case 14: {
                return this.timeVal.getTime();
            }
            case 13: {
                return this.dateVal.getTime();
            }
            case 0: 
            case 1: {
                return 0L;
            }
        }
        this.a(this.type, 5, true);
        return 0L;
    }

    public final int getAsInt() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return this.intVal;
            }
            case 11: {
                return this.booleanVal ? 1 : 0;
            }
            case 13: 
            case 14: 
            case 15: {
                return (int)this.getAsLong();
            }
            case 5: {
                return (int)this.longVal;
            }
            case 6: {
                return (int)this.floatVal;
            }
            case 7: {
                return (int)this.doubleVal;
            }
            case 10: {
                return this.getBigDecimal().intValue();
            }
            case 0: 
            case 1: {
                return 0;
            }
        }
        this.a(this.type, 4, true);
        return 0;
    }

    public final short getAsShort() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return (short)this.intVal;
            }
            case 11: {
                return (short)(this.booleanVal ? 1 : 0);
            }
            case 13: 
            case 14: 
            case 15: {
                return (short)this.getAsLong();
            }
            case 5: {
                return (short)this.longVal;
            }
            case 6: {
                return (short)this.floatVal;
            }
            case 7: {
                return (short)this.doubleVal;
            }
            case 10: {
                return (short)this.getBigDecimal().intValue();
            }
            case 0: 
            case 1: {
                return 0;
            }
        }
        this.a(this.type, 3, true);
        return 0;
    }

    public final Object getObject() {
        if (this.type != 17 && this.type != 18 && this.type != 12) {
            this.a(this.type, 17, true);
        }
        if (this.intVal != -3 && (this.intVal == -2 && this.objectVal != null || this.byteArrayVal != null)) {
            try {
                InputStream inputStream = this.getInputStream();
                try {
                    inputStream.reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.setObject(new ObjectInputStream(inputStream).readObject());
            }
            catch (Exception exception) {
                VariantException.fire(ExceptionChain.getOriginalMessage(exception));
            }
        }
        return this.objectVal;
    }

    public final boolean isSetAsObject() {
        return this.intVal == -3;
    }

    public final void setObject(byte[] byArray, int n2) {
        this.setByteArray(byArray, n2);
        this.type = 17;
    }

    public final void setObject(Object object) {
        if (this.setType != 17 && this.setType != 0) {
            this.a(this.setType, 17, false);
        }
        this.type = 17;
        this.intVal = -3;
        this.objectVal = object;
    }

    private final void a(int n2) {
        VariantException.fire(Res.a.format(131, new String[]{Variant.typeName(n2)}));
    }

    public final void setFromString(int n2, String string) {
        if (this.setType != n2 && this.setType != 0) {
            this.a(this.setType, n2, false);
        }
        if (string == null) {
            this.type = 16;
        }
        switch (n2) {
            case 2: {
                this.setByte(Byte.parseByte(string));
                break;
            }
            case 3: {
                this.setShort(Short.parseShort(string));
                break;
            }
            case 4: {
                this.setInt(Integer.parseInt(string));
                break;
            }
            case 5: {
                this.setLong(Long.parseLong(string));
                break;
            }
            case 6: {
                this.setFloat(Float.valueOf(string).floatValue());
                break;
            }
            case 7: {
                this.setDouble(Double.valueOf(string));
                break;
            }
            case 10: {
                this.setBigDecimal(new BigDecimal(string));
                break;
            }
            case 11: {
                this.setBoolean(Boolean.valueOf(this.stringVal));
                break;
            }
            case 15: {
                this.type = 15;
                this.timestampVal = Timestamp.valueOf(string);
                break;
            }
            case 13: {
                this.type = 13;
                this.dateVal = Date.valueOf(string);
                break;
            }
            case 14: {
                this.type = 14;
                this.timeVal = Time.valueOf(string);
                break;
            }
            case 16: {
                this.setString(string);
                break;
            }
            default: {
                this.a(this.type);
            }
        }
    }

    public final void setAsVariant(Variant variant) {
        switch (this.setType) {
            case 16: {
                this.setString(variant.toString());
                break;
            }
            case 2: {
                this.setByte((byte)variant.getAsInt());
                break;
            }
            case 3: {
                this.setShort((short)variant.getAsInt());
                break;
            }
            case 4: {
                this.setInt(variant.getAsInt());
                break;
            }
            case 11: {
                this.setBoolean(variant.getAsBoolean());
                break;
            }
            case 15: {
                this.setAsTimestamp(variant);
                break;
            }
            case 13: {
                this.setAsDate(variant);
                break;
            }
            case 14: {
                this.setAsTime(variant);
                break;
            }
            case 5: {
                this.setLong(variant.getAsLong());
                break;
            }
            case 6: {
                this.setFloat(variant.getAsFloat());
                break;
            }
            case 7: {
                this.setDouble(variant.getAsDouble());
                break;
            }
            case 10: {
                this.setBigDecimal(variant.getAsBigDecimal());
                break;
            }
            case 1: {
                this.setAssignedNull();
                break;
            }
            case 17: {
                this.setObject(variant.getAsObject());
                break;
            }
            default: {
                if (this.setType == 0 || this.setType == variant.type || variant.isNull()) {
                    this.setVariant(variant);
                    break;
                }
                this.a(this.setType);
            }
        }
    }

    public final void setVariant(Variant variant) {
        switch (variant.type) {
            case 16: {
                this.setString(variant.stringVal);
                break;
            }
            case 2: {
                this.setByte((byte)variant.intVal);
                break;
            }
            case 3: {
                this.setShort((short)variant.intVal);
                break;
            }
            case 4: {
                this.setInt(variant.intVal);
                break;
            }
            case 11: {
                this.setBoolean(variant.booleanVal);
                break;
            }
            case 15: {
                this.setTimestamp(variant.getTimestamp());
                break;
            }
            case 13: {
                this.setDate(variant.getDate());
                break;
            }
            case 14: {
                this.setTime(variant.getTime());
                break;
            }
            case 5: {
                this.setLong(variant.longVal);
                break;
            }
            case 6: {
                this.setFloat(variant.floatVal);
                break;
            }
            case 7: {
                this.setDouble(variant.doubleVal);
                break;
            }
            case 10: {
                this.setBigDecimal(variant.bigDecimalVal);
                break;
            }
            case 12: {
                if (this.setType == 0 || this.setType == variant.type) {
                    this.b(variant);
                    break;
                }
                this.setInputStream(variant.getInputStream());
                break;
            }
            case 18: {
                if (this.setType == 0 || this.setType == variant.type) {
                    this.b(variant);
                    break;
                }
                byte[] byArray = variant.getByteArray();
                this.setByteArray(byArray, variant.intVal);
                break;
            }
            case 17: {
                if (this.setType == 0 || this.setType == variant.type) {
                    this.b(variant);
                    break;
                }
                this.setObject(variant.getObject());
                break;
            }
            case 0: 
            case 1: {
                if (this.setType != variant.type && this.setType != 0) {
                    this.a(variant.type, this.setType, false);
                }
                this.type = variant.type;
                break;
            }
            default: {
                this.a(variant.type);
                break;
            }
        }
    }

    private final void b(Variant variant) {
        this.type = variant.type;
        this.intVal = variant.intVal;
        this.byteArrayVal = variant.byteArrayVal;
        this.objectVal = variant.objectVal;
    }

    public final void setInputStream(InputStream inputStream) {
        if (this.setType != 12 && this.setType != 18 && this.setType != 17 && this.setType != 0) {
            this.a(this.setType, 12, false);
        }
        this.type = inputStream == null ? 1 : (this.setType != 0 ? this.setType : 12);
        this.intVal = -2;
        this.byteArrayVal = null;
        this.objectVal = inputStream;
    }

    public final void setBinaryStream(InputStream inputStream) {
        this.setInputStream(inputStream);
    }

    public final void setArrayLength(int n2) {
        this.intVal = n2;
    }

    public final void setByteArray(byte[] byArray, int n2) {
        if (this.setType != 18 && this.setType != 12 && this.setType != 17 && this.setType != 0) {
            this.a(this.setType, 18, false);
        }
        this.byteArrayVal = byArray;
        this.type = byArray == null ? 1 : (this.setType != 0 ? this.setType : 18);
        this.objectVal = null;
        this.intVal = n2;
    }

    public final void setTimestamp(long l2) {
        if (this.setType != 15 && this.setType != 0) {
            this.a(this.setType, 15, false);
        }
        this.type = 15;
        if (this.timestampVal == null) {
            this.timestampVal = new Timestamp(System.currentTimeMillis());
        }
        ((java.util.Date)this.timestampVal).setTime(l2 / (long)1000 * (long)1000);
        int n2 = (int)(l2 % (long)1000 * (long)1000000);
        if (n2 < 0) {
            n2 = 1000000000 + n2;
            ((java.util.Date)this.timestampVal).setTime((l2 / (long)1000 - (long)1) * (long)1000);
        }
        this.timestampVal.setNanos(n2);
    }

    public final void setTimestamp(long l2, int n2) {
        if (this.setType != 15 && this.setType != 0) {
            this.a(this.setType, 15, false);
        }
        this.type = 15;
        if (this.timestampVal == null) {
            this.timestampVal = new Timestamp(System.currentTimeMillis());
        }
        ((java.util.Date)this.timestampVal).setTime(l2);
        this.timestampVal.setNanos(n2);
    }

    public final void setTime(long l2) {
        if (this.setType != 14 && this.setType != 0) {
            this.a(this.setType, 14, false);
        }
        this.type = 14;
        if (this.timeVal == null) {
            this.timeVal = new Time(System.currentTimeMillis());
        }
        this.timeVal.setTime(l2);
    }

    public final void setDate(long l2) {
        if (this.setType != 13 && this.setType != 0) {
            this.a(this.setType, 13, false);
        }
        this.type = 13;
        if (this.dateVal == null) {
            this.dateVal = new Date(System.currentTimeMillis());
        }
        this.dateVal.setTime(l2);
    }

    public final void setTimestamp(Timestamp timestamp) {
        if (this.setType != 15 && this.setType != 0) {
            this.a(this.setType, 15, false);
        }
        if (timestamp == null) {
            this.type = 1;
            this.timestampVal = null;
        } else {
            this.type = 15;
            if (this.timestampVal == null) {
                this.timestampVal = new Timestamp(System.currentTimeMillis());
            }
            ((java.util.Date)this.timestampVal).setTime(((java.util.Date)timestamp).getTime());
            this.timestampVal.setNanos(timestamp.getNanos());
        }
    }

    public final void setTime(Time time) {
        if (this.setType != 14 && this.setType != 0) {
            this.a(this.setType, 14, false);
        }
        if (time == null) {
            this.type = 1;
            this.timeVal = null;
        } else {
            this.type = 14;
            if (this.timeVal == null) {
                this.timeVal = new Time(time.getTime());
            } else {
                this.timeVal.setTime(time.getTime());
            }
        }
    }

    public final void setDate(Date date) {
        if (this.setType != 13 && this.setType != 0) {
            this.a(this.setType, 13, false);
        }
        if (date == null) {
            this.type = 1;
            this.dateVal = null;
        } else {
            this.type = 13;
            if (this.dateVal == null) {
                this.dateVal = new Date(date.getTime());
            } else {
                this.dateVal.setTime(date.getTime());
            }
        }
    }

    public final void setBigDecimal(BigDecimal bigDecimal) {
        if (this.setType != 10 && this.setType != 0) {
            this.a(this.setType, 10, false);
        }
        this.type = bigDecimal == null ? 1 : 10;
        this.bigDecimalVal = bigDecimal;
        this.booleanVal = false;
    }

    public final void setString(String string) {
        if (this.setType != 16 && this.setType != 0) {
            this.a(this.setType, 16, false);
        }
        this.type = string == null ? 1 : 16;
        this.stringVal = string;
    }

    public final void setFloat(float f2) {
        if (this.setType != 0 && this.setType != 6) {
            this.a(this.setType, 6, false);
        }
        this.type = 6;
        this.floatVal = f2;
    }

    public final void setDouble(double d2) {
        if (this.setType != 0 && this.setType != 7) {
            this.a(this.setType, 7, false);
        }
        this.type = 7;
        this.doubleVal = d2;
    }

    public final void setBoolean(boolean bl) {
        if (this.setType != 0 && this.setType != 11) {
            this.a(this.setType, 11, false);
        }
        this.type = 11;
        this.booleanVal = bl;
    }

    public final void setLong(long l2) {
        if (this.setType != 0 && (this.setType < 2 || this.setType > 5)) {
            this.a(this.setType, 5, false);
        }
        this.type = 5;
        this.longVal = l2;
    }

    public final void setByte(byte by) {
        if (this.setType != 0 && this.setType < 2 || this.setType > 5) {
            this.a(this.setType, 2, false);
        }
        this.type = 2;
        this.intVal = by;
    }

    public final void setShort(short s2) {
        if (this.setType != 0 && this.setType != 3) {
            this.a(this.setType, 3, false);
        }
        this.type = 3;
        this.intVal = s2;
    }

    public final void setInt(int n2) {
        if (this.setType != 0 && this.setType != 4) {
            this.a(this.setType, 4, false);
        }
        this.type = 4;
        this.intVal = n2;
    }

    public final InputStream getInputStream() {
        if (this.type != 12 && this.type != 17 && this.type != 18) {
            this.a(this.type, 12, true);
        }
        if (this.intVal != -2 && this.objectVal == null && this.byteArrayVal != null) {
            this.setInputStream(new ByteArrayInputStream(this.byteArrayVal, 0, this.intVal));
            this.byteArrayVal = null;
        }
        return (InputStream)this.objectVal;
    }

    public final InputStream getBinaryStream() {
        return this.getInputStream();
    }

    public final int getArrayLength() {
        return this.intVal;
    }

    public final byte[] getByteArray() {
        if (this.type != 18 && this.type != 12 && this.type != 17) {
            this.a(this.type, 18, true);
        }
        if (this.byteArrayVal == null && this.intVal == -2) {
            InputStream inputStream = (InputStream)this.objectVal;
            try {
                this.intVal = inputStream.available();
                this.byteArrayVal = new byte[this.intVal];
                inputStream.read(this.byteArrayVal);
                this.setByteArray(this.byteArrayVal, this.intVal);
            }
            catch (IOException iOException) {
                byte[] byArray = null;
                return byArray;
            }
            this.objectVal = null;
        }
        return this.byteArrayVal;
    }

    public final Timestamp getTimestamp() {
        if (this.type != 15) {
            this.a(this.type, 15, true);
        }
        return this.timestampVal;
    }

    public final Time getTime() {
        if (this.type != 14) {
            this.a(this.type, 14, true);
        }
        return this.timeVal;
    }

    public final Date getDate() {
        if (this.type != 13) {
            this.a(this.type, 13, true);
        }
        return this.dateVal;
    }

    public final BigDecimal getBigDecimal() {
        if (this.type != 10) {
            this.a(this.type, 10, true);
        }
        if (this.booleanVal) {
            this.bigDecimalVal = new BigDecimal(this.stringVal);
            this.booleanVal = false;
        }
        return this.bigDecimalVal;
    }

    public final String getString() {
        if (this.type != 16) {
            this.a(this.type, 16, true);
        }
        return this.stringVal;
    }

    public final float getFloat() {
        if (this.type != 6) {
            this.a(this.type, 6, true);
        }
        return this.floatVal;
    }

    public final double getDouble() {
        if (this.type != 7) {
            this.a(this.type, 7, true);
        }
        return this.doubleVal;
    }

    public final boolean getBoolean() {
        if (this.type != 11) {
            this.a(this.type, 11, true);
        }
        return this.booleanVal;
    }

    public final long getLong() {
        if (this.type != 5) {
            this.a(this.type, 5, true);
        }
        return this.longVal;
    }

    public final byte getByte() {
        if (this.type != 2) {
            this.a(this.type, 2, true);
        }
        return (byte)this.intVal;
    }

    public final short getShort() {
        if (this.type != 2 && this.type != 3) {
            this.a(this.type, 3, true);
        }
        return (short)this.intVal;
    }

    public final int getInt() {
        if (this.type != 4) {
            this.a(this.type, 4, true);
        }
        return this.intVal;
    }

    private void a(int n2, int n3, boolean bl) {
        if (n2 <= 1 && this.a(n2, n3)) {
            return;
        }
        int n4 = bl ? 130 : 129;
        VariantException.fire(Res.a.format(n4, new String[]{Variant.typeName(n2), Variant.typeName(n3)}));
    }

    private boolean a(int n2, int n3) {
        if (zeroString == null) {
            zeroString = "";
            zeroBIGDECIMAL = new BigDecimal(0.0);
            zeroByteArray = new byte[0];
            zeroBinary = new ByteArrayInputStream(zeroByteArray);
        }
        switch (n3) {
            case 2: 
            case 3: 
            case 4: {
                this.intVal = 0;
                break;
            }
            case 15: {
                this.setTimestamp(0L, 0);
                break;
            }
            case 14: {
                this.setTime(0L);
                break;
            }
            case 13: {
                this.setDate(0L);
                break;
            }
            case 5: {
                this.longVal = 0L;
                break;
            }
            case 11: {
                this.booleanVal = false;
                break;
            }
            case 6: {
                this.floatVal = 0.0f;
                break;
            }
            case 7: {
                this.doubleVal = 0.0;
                break;
            }
            case 16: {
                this.stringVal = zeroString;
                break;
            }
            case 10: {
                this.bigDecimalVal = zeroBIGDECIMAL;
                this.booleanVal = false;
                break;
            }
            case 12: 
            case 17: {
                this.intVal = 0;
                this.objectVal = zeroBinary;
                break;
            }
            case 18: {
                this.byteArrayVal = zeroByteArray;
                break;
            }
            default: {
                return false;
            }
        }
        this.type = n2;
        return true;
    }

    public final Object getDisplayValue() {
        switch (this.type) {
            case 0: 
            case 1: {
                return "";
            }
            case 17: {
                return this.getObject();
            }
            case 12: {
                return this.getInputStream();
            }
        }
        return this.toString();
    }

    public static long getTimeZoneOffset() {
        if (!offsetsKnown) {
            Date date = new Date(70, 0, 1);
            timeZoneOffset = date.getTime();
            offsetsKnown = true;
        }
        return timeZoneOffset;
    }

    public static int typeId(String string) {
        for (int i2 = 2; i2 <= 18; ++i2) {
            if (!string.equals(Variant.typeName(i2))) continue;
            return i2;
        }
        return 0;
    }

    public static int typeOf(String string) {
        if (string.equals(StringType_S)) {
            return 16;
        }
        if (string.equals(DateType_S)) {
            return 13;
        }
        if (string.equals(TimeType_S)) {
            return 14;
        }
        if (string.equals(TimestampType_S)) {
            return 15;
        }
        if (string.equals(IntType_S)) {
            return 4;
        }
        if (string.equals(BigDecimalType_S)) {
            return 10;
        }
        if (string.equals(AssignedNull_S)) {
            return 1;
        }
        if (string.equals(UnassignedNull_S)) {
            return 0;
        }
        if (string.equals(ByteType_S)) {
            return 2;
        }
        if (string.equals(ShortType_S)) {
            return 3;
        }
        if (string.equals(LongType_S)) {
            return 5;
        }
        if (string.equals(DoubleType_S)) {
            return 7;
        }
        if (string.equals(FloatType_S)) {
            return 6;
        }
        if (string.equals(BooleanType_S)) {
            return 11;
        }
        if (string.equals(BinaryStreamType_S)) {
            return 12;
        }
        if (string.equals(InputStreamType_S)) {
            return 12;
        }
        if (string.equals(ByteArrayType_S)) {
            return 18;
        }
        if (string.equals(ObjectType_S)) {
            return 17;
        }
        VariantException.fire(Res.a.format(132, new String[]{string}));
        return 0;
    }

    public static String typeName(int n2) {
        switch (n2) {
            case 1: {
                return AssignedNull_S;
            }
            case 0: {
                return UnassignedNull_S;
            }
            case 2: {
                return ByteType_S;
            }
            case 3: {
                return ShortType_S;
            }
            case 4: {
                return IntType_S;
            }
            case 5: {
                return LongType_S;
            }
            case 6: {
                return FloatType_S;
            }
            case 7: {
                return DoubleType_S;
            }
            case 10: {
                return BigDecimalType_S;
            }
            case 11: {
                return BooleanType_S;
            }
            case 12: {
                return InputStreamType_S;
            }
            case 13: {
                return DateType_S;
            }
            case 14: {
                return TimeType_S;
            }
            case 15: {
                return TimestampType_S;
            }
            case 16: {
                return StringType_S;
            }
            case 18: {
                return ByteArrayType_S;
            }
            case 17: {
                return ObjectType_S;
            }
        }
        return UnknownType_S;
    }

    public Variant() {
    }

    public Variant(int n2) {
        this.setType = n2;
    }
}

