/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing.plaf.basic;

import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.TableRowHeader;
import com.borland.dbswing.plaf.JdbTableRowHeaderUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.TableModel;

public class BasicJdbTableRowHeaderUI
extends JdbTableRowHeaderUI {
    TableRowHeader header;
    JTable table;
    TableModel model;
    CellRendererPane rendererPane;
    MouseInputListener mouseInputListener;
    Rectangle cellRect = new Rectangle();
    int lastResizingMark = 0;
    boolean ignoreSingleRowPaint = false;

    public void installUI(JComponent c2) {
        this.header = (TableRowHeader)c2;
        this.table = this.header.getTable();
        this.model = this.header.getModel();
        this.rendererPane = new CellRendererPane();
        this.header.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public void uninstallUI(JComponent c2) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.header.remove(this.rendererPane);
        this.header = null;
        this.table = null;
        this.model = null;
        this.rendererPane = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    public void repaintRows(int firstRow, int lastRow) {
        int singleCellHeight = DBUtilities.is1pt3() ? this.table.getRowHeight() : this.table.getRowHeight() + this.table.getRowMargin();
        this.ignoreSingleRowPaint = true;
        this.header.repaint(0L, 0, firstRow * singleCellHeight, this.header.getWidth(), (lastRow - firstRow + 1) * singleCellHeight);
    }

    public void paint(Graphics g2, JComponent c2) {
        if (this.table == null) {
            return;
        }
        Rectangle clipBounds = g2.getClipBounds();
        int singleCellHeight = DBUtilities.is1pt3() ? this.table.getRowHeight() : this.table.getRowHeight() + this.table.getRowMargin();
        int firstRow = clipBounds.y / singleCellHeight;
        int lastRow = (clipBounds.y + clipBounds.height) / singleCellHeight;
        lastRow = Math.min(lastRow, this.table.getRowCount() - 1);
        this.cellRect.height = singleCellHeight;
        this.cellRect.width = c2.getWidth();
        this.cellRect.y = clipBounds.y - clipBounds.y % singleCellHeight;
        for (int rowNo = firstRow; rowNo <= lastRow; ++rowNo) {
            Component actualPainter = this.header.getCellRenderer().getTableCellRendererComponent(this.table, this.header, false, false, rowNo, 0);
            this.rendererPane.add(actualPainter);
            this.rendererPane.paintComponent(g2, actualPainter, this.header, this.cellRect.x, this.cellRect.y, this.cellRect.width, this.cellRect.height, false);
            this.cellRect.y += this.cellRect.height;
            if (rowNo != firstRow) continue;
            if (!this.ignoreSingleRowPaint) {
                this.lastResizingMark = this.cellRect.y;
            }
            this.ignoreSingleRowPaint = false;
        }
    }

    public Dimension getPreferredSize(JComponent c2) {
        int height = 0;
        int width = 0;
        if (this.table != null) {
            height = this.table.getSize().height;
            width = this.header.getCellRenderer().getTableCellRendererComponent((JTable)this.table, (Object)this.header, (boolean)false, (boolean)false, (int)this.model.getRowCount(), (int)1).getPreferredSize().width;
        }
        return new Dimension(width, height);
    }

    public Dimension getMinimumSize(JComponent c2) {
        int height = 0;
        int width = 0;
        if (this.table != null) {
            height = this.table.getSize().height;
            width = this.header.getCellRenderer().getTableCellRendererComponent((JTable)this.table, (Object)this.header, (boolean)false, (boolean)false, (int)this.model.getRowCount(), (int)2).getMinimumSize().width;
        }
        return new Dimension(width, height);
    }

    public Dimension getMaximumSize(JComponent c2) {
        int height = 0;
        int width = 0;
        if (this.table != null) {
            height = this.table.getSize().height;
            width = this.header.getCellRenderer().getTableCellRendererComponent((JTable)this.table, (Object)this.header, (boolean)false, (boolean)false, (int)this.model.getRowCount(), (int)3).getMaximumSize().width;
        }
        return new Dimension(width, height);
    }

    public static ComponentUI createUI(JComponent c2) {
        return new BasicJdbTableRowHeaderUI();
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private int mouseStartY;
        private Rectangle triggerRect = new Rectangle();
        private int newRowHeight = 21;

        public void mouseClicked(MouseEvent e2) {
        }

        public void mousePressed(MouseEvent e2) {
            if (!BasicJdbTableRowHeaderUI.this.header.isHeightResizable()) {
                return;
            }
            Point point = e2.getPoint();
            this.mouseStartY = this.isWithinTriggerRect(point) ? point.y : 32768;
        }

        public void mouseMoved(MouseEvent e2) {
            if (this.isWithinTriggerRect(e2.getPoint())) {
                Cursor resizeCursor = Cursor.getPredefinedCursor(9);
                if (BasicJdbTableRowHeaderUI.this.header.getCursor() != resizeCursor) {
                    BasicJdbTableRowHeaderUI.this.header.setCursor(resizeCursor);
                }
            } else {
                Cursor defaultCursor = Cursor.getPredefinedCursor(0);
                if (BasicJdbTableRowHeaderUI.this.header.getCursor() != defaultCursor) {
                    BasicJdbTableRowHeaderUI.this.header.setCursor(defaultCursor);
                }
            }
        }

        public void mouseDragged(MouseEvent e2) {
            if (this.mouseStartY != 32768) {
                int pendingHeight = BasicJdbTableRowHeaderUI.this.table.getRowHeight() + e2.getY() - this.mouseStartY;
                if (pendingHeight > 0) {
                    this.newRowHeight = pendingHeight;
                    if (BasicJdbTableRowHeaderUI.this.header.isResizeTableWhileSizing()) {
                        Rectangle newViewRect = ((JViewport)BasicJdbTableRowHeaderUI.this.header.getParent()).getViewRect();
                        newViewRect.y = DBUtilities.is1pt3() ? newViewRect.y / BasicJdbTableRowHeaderUI.this.table.getRowHeight() * this.newRowHeight : newViewRect.y / (BasicJdbTableRowHeaderUI.this.table.getRowHeight() + BasicJdbTableRowHeaderUI.this.table.getRowMargin()) * (this.newRowHeight + BasicJdbTableRowHeaderUI.this.table.getRowMargin());
                        BasicJdbTableRowHeaderUI.this.table.setRowHeight(this.newRowHeight);
                        BasicJdbTableRowHeaderUI.this.table.scrollRectToVisible(newViewRect);
                        this.mouseStartY = newViewRect.y + this.newRowHeight + BasicJdbTableRowHeaderUI.this.table.getRowMargin();
                        BasicJdbTableRowHeaderUI.this.header.repaint();
                    }
                    Cursor resizeCursor = Cursor.getPredefinedCursor(9);
                    if (BasicJdbTableRowHeaderUI.this.header.getCursor() != resizeCursor) {
                        BasicJdbTableRowHeaderUI.this.header.setCursor(resizeCursor);
                    }
                } else {
                    Cursor defaultCursor = Cursor.getPredefinedCursor(0);
                    if (BasicJdbTableRowHeaderUI.this.header.getCursor() != defaultCursor) {
                        BasicJdbTableRowHeaderUI.this.header.setCursor(defaultCursor);
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent e2) {
            if (!BasicJdbTableRowHeaderUI.this.header.isHeightResizable()) {
                return;
            }
            if (this.mouseStartY != 32768) {
                int pendingHeight = BasicJdbTableRowHeaderUI.this.table.getRowHeight() + e2.getY() - this.mouseStartY;
                if (pendingHeight > 0) {
                    this.newRowHeight = pendingHeight;
                    Rectangle newViewRect = ((JViewport)BasicJdbTableRowHeaderUI.this.header.getParent()).getViewRect();
                    newViewRect.y = DBUtilities.is1pt3() ? newViewRect.y / BasicJdbTableRowHeaderUI.this.table.getRowHeight() * this.newRowHeight : newViewRect.y / (BasicJdbTableRowHeaderUI.this.table.getRowHeight() + BasicJdbTableRowHeaderUI.this.table.getRowMargin()) * (this.newRowHeight + BasicJdbTableRowHeaderUI.this.table.getRowMargin());
                    BasicJdbTableRowHeaderUI.this.table.setRowHeight(this.newRowHeight);
                    BasicJdbTableRowHeaderUI.this.table.scrollRectToVisible(newViewRect);
                    BasicJdbTableRowHeaderUI.this.header.repaint();
                    BasicJdbTableRowHeaderUI.this.table.repaint();
                }
                Cursor defaultCursor = Cursor.getPredefinedCursor(0);
                if (BasicJdbTableRowHeaderUI.this.header.getCursor() != defaultCursor) {
                    BasicJdbTableRowHeaderUI.this.header.setCursor(defaultCursor);
                }
            }
        }

        public void mouseEntered(MouseEvent e2) {
        }

        public void mouseExited(MouseEvent e2) {
        }

        private boolean isWithinTriggerRect(Point p2) {
            if (DBUtilities.is1pt3()) {
                int singleCellHeight = BasicJdbTableRowHeaderUI.this.table.getRowHeight();
            } else {
                int singleCellHeight = BasicJdbTableRowHeaderUI.this.table.getRowHeight() + BasicJdbTableRowHeaderUI.this.table.getRowMargin();
            }
            this.triggerRect.width = BasicJdbTableRowHeaderUI.this.header.getWidth();
            this.triggerRect.y = BasicJdbTableRowHeaderUI.this.lastResizingMark - 3;
            this.triggerRect.height = 6;
            return this.triggerRect.contains(p2);
        }
    }
}

