/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.CustomColumnsDescriptor;
import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBRuntimeSupport;
import com.borland.dbswing.DBTableModel;
import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.JdbComboBox;
import com.borland.dbswing.LRUCache;
import com.borland.dbswing.Res;
import com.borland.dbswing.TableFastStringRenderer;
import com.borland.dbswing.TableHeaderRenderer;
import com.borland.dbswing.TableImageEditor;
import com.borland.dbswing.TableImageReadOnlyEditor;
import com.borland.dbswing.TableMaskCellEditor;
import com.borland.dbswing.TableRowHeader;
import com.borland.dbswing.TextIcon;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnPaintListener;
import com.borland.dx.dataset.CustomPaintSite;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.SortDescriptor;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.ValidationException;
import com.borland.dx.dataset.Variant;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JdbTable
extends JTable
implements NavigationListener,
AccessListener,
MouseListener,
KeyListener,
DataChangeListener,
PropertyChangeListener,
ActionListener,
DataSetAware,
Serializable {
    private DataSet dataSet;
    private boolean addNotifyCalled;
    private TableRowHeader rowHeader;
    private boolean rowHeaderVisible = true;
    private boolean columnHeaderVisible = true;
    private boolean smartColumnWidths = true;
    private int[] hiddenColumns;
    private DBTableModel dbTableModel;
    private boolean ignoreNavigation;
    private boolean autoSelection = true;
    private boolean rebindColumnProperties;
    private boolean popupEnabled = true;
    private boolean enableSort = true;
    private Variant variantValue = new Variant();
    private boolean editable = true;
    private LRUCache imageCache;
    private Color focusedCellForeground;
    private Color focusedCellBackground;
    private CustomColumnsDescriptor customColumnDescriptor;
    private boolean applyCustomColumns;
    private ActionEvent tabEvent;
    private DataSet oldDataSet;
    private DataSet pendingDataSet;
    private boolean dataSetEventsEnabled = true;

    public JdbTable() {
        super(new AbstractTableModel(){

            public int getColumnCount() {
                return 1;
            }

            public int getRowCount() {
                return 1;
            }

            public String getColumnName(int col) {
                return "A";
            }

            public Object getValueAt(int row, int col) {
                return "";
            }
        });
    }

    public JdbTable(TableModel dm) {
        super(dm);
    }

    public JdbTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public JdbTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public JdbTable(int numColumns, int numRows) {
        super(numColumns, numRows);
    }

    public JdbTable(Vector data, Vector columnNames) {
        super(data, columnNames);
    }

    public JdbTable(Object[][] data, Object[] columnNames) {
        super(data, columnNames);
    }

    public void updateUI() {
        super.updateUI();
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 1));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(65, 2));
        ActionListener tabAction = this.getActionForKeyStroke(KeyStroke.getKeyStroke(9, 0));
        this.registerKeyboardAction(tabAction, KeyStroke.getKeyStroke(10, 0), 0);
        ActionListener reverseTabAction = this.getActionForKeyStroke(KeyStroke.getKeyStroke(9, 1));
        this.registerKeyboardAction(reverseTabAction, KeyStroke.getKeyStroke(10, 1), 0);
        this.registerKeyboardAction(new InsertRowAction(), KeyStroke.getKeyStroke(155, 2), 0);
        this.registerKeyboardAction(new AppendRowAction(), KeyStroke.getKeyStroke(40, 0), 0);
        this.registerKeyboardAction(new DeleteRowAction(), KeyStroke.getKeyStroke(127, 2), 0);
        ActionListener beginEditAction = this.getActionForKeyStroke(KeyStroke.getKeyStroke(113, 0));
        this.registerKeyboardAction(beginEditAction, KeyStroke.getKeyStroke(10, 2), 0);
        this.addKeyListener(this);
    }

    public void setDataSet(DataSet dataSet) {
        this.pendingDataSet = dataSet;
        if (this.addNotifyCalled) {
            this.bindDataSet();
        } else {
            this.dataSet = dataSet;
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setHiddenColumns(int[] hiddenColumns) {
        this.hiddenColumns = hiddenColumns;
        this.updateColumnModel();
    }

    public int[] getHiddenColumns() {
        return this.hiddenColumns;
    }

    public void setCustomizedColumns(TableColumn[] customColumns) {
        int[] columnOrder = new int[customColumns.length];
        for (int colNo = 0; colNo < customColumns.length; ++colNo) {
            columnOrder[colNo] = colNo;
        }
        this.setCustomColumns(new CustomColumnsDescriptor(columnOrder, customColumns));
    }

    public TableColumn[] getCustomizedColumns() {
        if (this.getCustomColumns() != null) {
            return this.getCustomColumns().getTableColumns();
        }
        return null;
    }

    public void setCustomColumns(CustomColumnsDescriptor customColumnDescriptor) {
        this.customColumnDescriptor = customColumnDescriptor;
        this.applyCustomColumns = true;
        this.updateColumnModel();
    }

    public CustomColumnsDescriptor getCustomColumns() {
        return this.customColumnDescriptor;
    }

    public void ensureRowIsVisible(int row) {
        this.scrollRectToVisible(this.getCellRect(row, 0, false));
    }

    public void setRowHeader(TableRowHeader rowHeader) {
        if (this.rowHeader != null) {
            this.rowHeader.setModel(null);
            this.rowHeader.setCellRenderer(null);
        }
        this.rowHeader = rowHeader;
        this.setRowHeaderVisible(rowHeader != null);
    }

    public TableRowHeader getRowHeader() {
        return this.rowHeader;
    }

    public void setRowHeaderVisible(boolean rowHeaderVisible) {
        Container parent;
        Container viewport;
        this.rowHeaderVisible = rowHeaderVisible;
        if (this.isDisplayable() && (viewport = this.getParent()) instanceof JViewport && (parent = viewport.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)parent;
            if (viewport != null && ((JViewport)viewport).getView() == this) {
                if (rowHeaderVisible) {
                    if (this.rowHeader == null) {
                        this.rowHeader = new TableRowHeader(this);
                    }
                    scrollPane.setRowHeaderView(this.rowHeader);
                } else {
                    scrollPane.setRowHeaderView(null);
                }
            }
        }
        this.firePropertyChange("rowHeaderVisible", !rowHeaderVisible, rowHeaderVisible);
    }

    public boolean isRowHeaderVisible() {
        return this.rowHeaderVisible;
    }

    public void setColumnHeaderVisible(boolean columnHeaderVisible) {
        Container parent;
        Container viewport;
        this.columnHeaderVisible = columnHeaderVisible;
        if (this.isDisplayable() && (viewport = this.getParent()) instanceof JViewport && (parent = viewport.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)parent;
            if (viewport != null && ((JViewport)viewport).getView() == this) {
                if (columnHeaderVisible) {
                    scrollPane.setColumnHeaderView(this.getTableHeader());
                } else {
                    scrollPane.setColumnHeaderView(null);
                }
            }
        }
        this.firePropertyChange("columnHeaderVisible", !columnHeaderVisible, columnHeaderVisible);
    }

    public boolean isColumnHeaderVisible() {
        return this.columnHeaderVisible;
    }

    public void setSmartColumnWidths(boolean smartColumnWidths) {
        this.smartColumnWidths = smartColumnWidths;
    }

    public boolean isSmartColumnWidths() {
        return this.smartColumnWidths;
    }

    public void setAutoSelection(boolean autoSelection) {
        this.autoSelection = autoSelection;
    }

    public boolean isAutoSelection() {
        return this.autoSelection;
    }

    public void setPopupMenuEnabled(boolean popupEnabled) {
        this.popupEnabled = popupEnabled;
    }

    public boolean isPopupMenuEnabled() {
        return this.popupEnabled;
    }

    public void setColumnSortEnabled(boolean enableSort) {
        this.enableSort = enableSort;
    }

    public boolean isColumnSortEnabled() {
        return this.enableSort;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    protected void configureEnclosingScrollPane() {
        Container parent;
        Container viewport = this.getParent();
        if (viewport instanceof JViewport && (parent = viewport.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)parent;
            if (viewport != null && ((JViewport)viewport).getView() == this) {
                if (this.columnHeaderVisible) {
                    scrollPane.setColumnHeaderView(this.getTableHeader());
                    this.getTableHeader().revalidate();
                    this.getTableHeader().repaint();
                } else {
                    scrollPane.setColumnHeaderView(null);
                }
                Border border = scrollPane.getBorder();
                if (border == null || border instanceof UIResource) {
                    scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
                }
                if (this.rowHeaderVisible) {
                    if (this.rowHeader == null) {
                        this.rowHeader = new TableRowHeader(this);
                    }
                    scrollPane.setRowHeaderView(this.rowHeader);
                    this.rowHeader.revalidate();
                    this.rowHeader.repaint();
                } else {
                    scrollPane.setRowHeaderView(null);
                }
                scrollPane.revalidate();
                scrollPane.repaint();
            }
        }
    }

    public void createDefaultColumnsFromModel() {
        block46: {
            TableColumn newColumn;
            DataSet newDataSet = null;
            boolean keepExistingColumnModel = true;
            if (this.getModel() instanceof DBTableModel) {
                this.dbTableModel = (DBTableModel)this.getModel();
                newDataSet = this.dbTableModel.getDataSet();
            } else {
                this.dbTableModel = null;
            }
            if (newDataSet != this.oldDataSet) {
                keepExistingColumnModel = false;
            }
            if (this.oldDataSet != null) {
                this.oldDataSet.removeNavigationListener(this);
                this.oldDataSet.removeAccessListener(this);
                this.oldDataSet.removeDataChangeListener(this);
            }
            this.removeMouseListener(this);
            if (DBRuntimeSupport.getInstance().containsComponent(this)) {
                DBRuntimeSupport.getInstance().removeComponent(this);
            }
            if (newDataSet != null) {
                newDataSet.addNavigationListener(this);
                newDataSet.addAccessListener(this);
                newDataSet.addDataChangeListener(this);
                this.addMouseListener(this);
                this.dataSet = newDataSet;
                DBRuntimeSupport.getInstance().addComponent(this, this);
            }
            if (this.oldDataSet == null && !(this.getModel() instanceof DBTableModel)) {
                keepExistingColumnModel = false;
            }
            this.dataSet = newDataSet;
            this.oldDataSet = newDataSet;
            boolean[] hiddenColumnMap = new boolean[this.getModel().getColumnCount()];
            TableColumn[] customizedColumnMap = new TableColumn[hiddenColumnMap.length];
            if (this.hiddenColumns != null) {
                for (int columnIndex = 0; columnIndex < this.hiddenColumns.length; ++columnIndex) {
                    if (this.hiddenColumns[columnIndex] >= hiddenColumnMap.length) continue;
                    hiddenColumnMap[this.hiddenColumns[columnIndex]] = true;
                }
            }
            TableColumn[] customColumns = new TableColumn[]{};
            if (this.customColumnDescriptor != null && customizedColumnMap.length > 0 && (customColumns = this.customColumnDescriptor.getTableColumns()) != null) {
                for (int columnIndex = 0; columnIndex < customColumns.length; ++columnIndex) {
                    if (customColumns[columnIndex].getModelIndex() >= customizedColumnMap.length) continue;
                    customizedColumnMap[customColumns[columnIndex].getModelIndex()] = customColumns[columnIndex];
                }
            }
            this.columnModel.removeColumnModelListener(this);
            Hashtable<Object, TableColumn> oldIdentifiers = null;
            if (keepExistingColumnModel && this.getModel().getColumnCount() > 0) {
                TableColumnModel columnModel = this.getColumnModel();
                int oldColumnModelSize = columnModel.getColumnCount();
                oldIdentifiers = new Hashtable<Object, TableColumn>();
                for (int columnNo = 0; columnNo < oldColumnModelSize; ++columnNo) {
                    TableColumn existingColumn = columnModel.getColumn(columnNo);
                    if (existingColumn.getIdentifier() == null) continue;
                    oldIdentifiers.put(existingColumn.getIdentifier(), existingColumn);
                }
            }
            Hashtable<Object, TableColumn> newTableColumns = new Hashtable<Object, TableColumn>();
            int newModelIndex = 0;
            TableColumn[] newModelOrder = this.hiddenColumns == null || hiddenColumnMap.length < this.hiddenColumns.length ? new TableColumn[hiddenColumnMap.length] : new TableColumn[hiddenColumnMap.length - this.hiddenColumns.length];
            for (int modelIndex = 0; modelIndex < hiddenColumnMap.length; ++modelIndex) {
                TableColumn column;
                if (hiddenColumnMap[modelIndex]) continue;
                newColumn = new TableColumn(modelIndex);
                if (this.dbTableModel != null) {
                    TableColumn existingColumn;
                    Column dataSetColumn = this.dbTableModel.getColumn(modelIndex);
                    this.bindDataSetColumnProperties(newColumn, dataSetColumn);
                    if (keepExistingColumnModel && oldIdentifiers != null && (existingColumn = (TableColumn)oldIdentifiers.get(dataSetColumn.getColumnName())) != null) {
                        this.inheritCustomColumnProperties(newColumn, existingColumn);
                    }
                } else {
                    TableColumn existingColumn;
                    newColumn.setHeaderValue(this.getModel().getColumnName(modelIndex));
                    newColumn.setIdentifier(newColumn.getHeaderValue());
                    if (this.smartColumnWidths) {
                        int width = this.getMaxCaptionWidth(newColumn.getHeaderValue(), null);
                        if (width > newColumn.getPreferredWidth()) {
                            newColumn.setPreferredWidth(width);
                        }
                        newColumn.setWidth(newColumn.getPreferredWidth());
                    }
                    if (keepExistingColumnModel && oldIdentifiers != null && (existingColumn = (TableColumn)oldIdentifiers.get(newColumn.getIdentifier())) != null) {
                        this.inheritCustomColumnProperties(newColumn, existingColumn);
                        newColumn.setIdentifier(existingColumn.getIdentifier());
                    }
                }
                if (this.applyCustomColumns && (column = customizedColumnMap[modelIndex]) != null) {
                    this.inheritCustomColumnProperties(newColumn, column);
                }
                if (newColumn.getHeaderValue() instanceof String[] || newColumn.getHeaderValue() instanceof String && ((String)newColumn.getHeaderValue()).indexOf("\n") != -1) {
                    newColumn.setHeaderRenderer(new TableHeaderRenderer());
                } else {
                    DefaultTableCellRenderer label = new DefaultTableCellRenderer(){

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            JTableHeader header;
                            if (table != null && (header = table.getTableHeader()) != null) {
                                this.setForeground(header.getForeground());
                                this.setBackground(header.getBackground());
                                this.setFont(header.getFont());
                            }
                            this.setText(value == null ? "" : value.toString());
                            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                            return this;
                        }
                    };
                    label.setHorizontalAlignment(0);
                    newColumn.setHeaderRenderer(label);
                }
                JComponent headerRenderer = null;
                if (newColumn.getHeaderRenderer() instanceof JComponent) {
                    headerRenderer = (JComponent)((Object)newColumn.getHeaderRenderer());
                } else if (DBUtilities.is1pt3() && headerRenderer == null && this.getTableHeader() != null && this.getTableHeader().getDefaultRenderer() instanceof JComponent) {
                    headerRenderer = (JComponent)((Object)this.getTableHeader().getDefaultRenderer());
                }
                if (headerRenderer != null) {
                    if (newColumn.getHeaderValue() instanceof String[]) {
                        headerRenderer.setToolTipText(this.getConcatenatedString((String[])newColumn.getHeaderValue()));
                    } else {
                        headerRenderer.setToolTipText(newColumn.getHeaderValue().toString().replace('\n', ' '));
                    }
                }
                newModelOrder[newModelIndex++] = newColumn;
                newTableColumns.put(newColumn.getIdentifier(), newColumn);
            }
            this.applyCustomColumns = false;
            TableColumnModel newColumnModel = this.createDefaultColumnModel();
            newColumnModel.setColumnMargin(this.getColumnModel().getColumnMargin());
            newColumnModel.getSelectionModel().setSelectionMode(0);
            if (keepExistingColumnModel && oldIdentifiers != null && this.getModel().getColumnCount() > 0) {
                TableColumnModel oldColumnModel = this.getColumnModel();
                int oldColumnModelSize = oldColumnModel.getColumnCount();
                for (int columnNo = 0; columnNo < oldColumnModelSize; ++columnNo) {
                    TableColumn oldColumn = oldColumnModel.getColumn(columnNo);
                    newColumn = (TableColumn)newTableColumns.remove(oldColumn.getIdentifier());
                    if (newColumn == null) continue;
                    newColumnModel.addColumn(newColumn);
                }
            }
            if (newTableColumns.size() > 0) {
                int newColumnModelSize = newModelOrder.length;
                boolean skipMove = newColumnModelSize == newTableColumns.size();
                for (int columnNo = 0; columnNo < newColumnModelSize; ++columnNo) {
                    newColumn = (TableColumn)newTableColumns.remove(newModelOrder[columnNo].getIdentifier());
                    if (newColumn == null) continue;
                    newColumnModel.addColumn(newColumn);
                    if (skipMove || columnNo >= newColumnModel.getColumnCount()) continue;
                    newColumnModel.moveColumn(newColumnModel.getColumnCount() - 1, columnNo);
                }
            }
            int[] columnPositions = null;
            if (this.customColumnDescriptor != null && (columnPositions = this.customColumnDescriptor.getColumnPositions()) != null && this.getModel().getColumnCount() > 0) {
                int columnNo;
                int index;
                int[] unsortedColumnPositions = new int[columnPositions.length];
                System.arraycopy(columnPositions, 0, unsortedColumnPositions, 0, columnPositions.length);
                int[] sortedColumnPositions = new int[columnPositions.length];
                int[] modelMap = new int[customColumns.length];
                for (index = 0; index < customColumns.length; ++index) {
                    modelMap[index] = customColumns[index].getModelIndex();
                }
                for (index = 0; index < unsortedColumnPositions.length; ++index) {
                    int minPos = unsortedColumnPositions[index];
                    int minIndex = index;
                    for (columnNo = unsortedColumnPositions.length - 1; columnNo > index; --columnNo) {
                        int columnPos = unsortedColumnPositions[columnNo];
                        if (columnPos > minPos) continue;
                        minPos = columnPos;
                        minIndex = columnNo;
                    }
                    sortedColumnPositions[index] = minPos;
                    if (hiddenColumnMap[customColumns[minIndex].getModelIndex()]) {
                        sortedColumnPositions[index] = -1;
                    }
                    int swapInt = unsortedColumnPositions[minIndex];
                    unsortedColumnPositions[minIndex] = unsortedColumnPositions[index];
                    unsortedColumnPositions[index] = swapInt;
                    swapInt = modelMap[minIndex];
                    modelMap[minIndex] = modelMap[index];
                    modelMap[index] = swapInt;
                }
                block9: for (columnNo = sortedColumnPositions.length - 1; columnNo >= 0 && sortedColumnPositions[columnNo] >= 0; --columnNo) {
                    if (sortedColumnPositions[columnNo] >= newColumnModel.getColumnCount()) {
                        sortedColumnPositions[columnNo] = newColumnModel.getColumnCount() - 1;
                    }
                    for (int column = 0; column < newColumnModel.getColumnCount(); ++column) {
                        if (newColumnModel.getColumn(column).getModelIndex() != modelMap[columnNo]) continue;
                        newColumnModel.moveColumn(column, sortedColumnPositions[columnNo]);
                        continue block9;
                    }
                }
            }
            this.columnModel.addColumnModelListener(this);
            this.setColumnModel(newColumnModel);
            this.configureEnclosingScrollPane();
            if (this.autoSelection && !this.rebindColumnProperties && (this.addNotifyCalled || !keepExistingColumnModel)) {
                this.ignoreNavigation = true;
                if (this.getColumnCount() > 0) {
                    this.setColumnSelectionInterval(0, 0);
                }
                if (this.getRowCount() > 0) {
                    this.setRowSelectionInterval(0, 0);
                }
                this.ignoreNavigation = false;
                Rectangle rect = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn(), true);
                this.scrollRectToVisible(rect);
            }
            if (this.getSelectedRow() == -1 && this.getSelectedColumn() != -1) {
                this.ignoreNavigation = true;
                if (this.getRowCount() > 0) {
                    this.setRowSelectionInterval(0, 0);
                }
                this.ignoreNavigation = false;
            }
            if (this.getSelectedRow() == -1 || this.getSelectedColumn() != -1 || this.getColumnCount() <= 0) break block46;
            this.setColumnSelectionInterval(0, 0);
        }
    }

    private void bindDataSetColumnProperties(TableColumn tableColumn, Column dataSetColumn) {
        tableColumn.setHeaderValue(dataSetColumn.getCaption());
        tableColumn.setIdentifier(dataSetColumn.getColumnName());
        tableColumn.setPreferredWidth(this.getDefaultTableColumnWidth(dataSetColumn));
        tableColumn.setWidth(tableColumn.getPreferredWidth());
        if (dataSetColumn.getItemEditor() != null && dataSetColumn.getItemEditor() instanceof TableCellEditor) {
            tableColumn.setCellEditor((TableCellEditor)dataSetColumn.getItemEditor());
        } else {
            tableColumn.setCellEditor(this.getDefaultCellEditor(dataSetColumn));
        }
        if (dataSetColumn.getItemPainter() != null && dataSetColumn.getItemPainter() instanceof TableCellRenderer) {
            tableColumn.setCellRenderer((TableCellRenderer)dataSetColumn.getItemPainter());
        } else {
            tableColumn.setCellRenderer(this.getDefaultCellRenderer(dataSetColumn));
        }
    }

    private void inheritCustomColumnProperties(TableColumn targetColumn, TableColumn sourceColumn) {
        if (sourceColumn.getHeaderValue() != null && !this.rebindColumnProperties) {
            targetColumn.setHeaderValue(sourceColumn.getHeaderValue());
            targetColumn.setPreferredWidth(this.getMaxCaptionWidth(targetColumn.getHeaderValue(), null));
            targetColumn.setWidth(targetColumn.getPreferredWidth());
        }
        if (this.dataSet == null && sourceColumn.getIdentifier() != null) {
            targetColumn.setIdentifier(sourceColumn.getIdentifier());
        }
        if (sourceColumn.getPreferredWidth() != 75) {
            targetColumn.setPreferredWidth(sourceColumn.getPreferredWidth());
            targetColumn.setWidth(sourceColumn.getWidth());
        }
        if (sourceColumn.getMinWidth() != 15 && !this.rebindColumnProperties) {
            targetColumn.setMinWidth(sourceColumn.getMinWidth());
        }
        if (sourceColumn.getMaxWidth() != Integer.MAX_VALUE && !this.rebindColumnProperties) {
            targetColumn.setMaxWidth(sourceColumn.getMaxWidth());
        }
        if (!sourceColumn.getResizable()) {
            targetColumn.setResizable(false);
        }
        if (sourceColumn.getCellEditor() != null) {
            targetColumn.setCellEditor(sourceColumn.getCellEditor());
        }
        if (sourceColumn.getCellRenderer() != null) {
            targetColumn.setCellRenderer(sourceColumn.getCellRenderer());
        }
        if (sourceColumn.getHeaderRenderer() != null) {
            targetColumn.setHeaderRenderer(sourceColumn.getHeaderRenderer());
        }
    }

    public boolean isCellEditable(int row, int column) {
        return this.editable && super.isCellEditable(row, column);
    }

    protected TableCellRenderer getDefaultCellRenderer(Column dataSetColumn) {
        int type = dataSetColumn.getDataType();
        if (type > 1 && type < 17 && type != 11) {
            if (type == 12) {
                return new TableImageRenderer(null);
            }
            TableFastStringRenderer renderer = new TableFastStringRenderer();
            if (dataSetColumn.getForeground() != null) {
                renderer.setDefaultForeground(dataSetColumn.getForeground());
            }
            if (dataSetColumn.getBackground() != null) {
                renderer.setDefaultBackground(dataSetColumn.getBackground());
            }
            if (dataSetColumn.getFont() != null) {
                renderer.setDefaultFont(dataSetColumn.getFont());
            }
            renderer.setDefaultAlignment(dataSetColumn.getAlignment());
            return renderer;
        }
        TableCellRenderer renderer = this.getDefaultRenderer(DBTableModel.getJavaClass(dataSetColumn.getDataType()));
        if (renderer instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer cellRenderer = (DefaultTableCellRenderer)renderer;
            if (dataSetColumn.getForeground() != null) {
                cellRenderer.setForeground(dataSetColumn.getForeground());
            }
            if (dataSetColumn.getBackground() != null) {
                cellRenderer.setBackground(dataSetColumn.getBackground());
            }
            if (dataSetColumn.getFont() != null) {
                cellRenderer.setFont(dataSetColumn.getFont());
            }
            cellRenderer.setHorizontalAlignment(DBUtilities.convertJBCLToSwingAlignment(dataSetColumn.getAlignment(), true));
            cellRenderer.setVerticalAlignment(DBUtilities.convertJBCLToSwingAlignment(dataSetColumn.getAlignment(), false));
            return cellRenderer;
        }
        return renderer;
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Variant variantCopy;
        Column dataSetColumn;
        ColumnPaintListener columnPaintListener;
        Object value;
        block16: {
            value = null;
            columnPaintListener = null;
            dataSetColumn = null;
            variantCopy = null;
            if (this.dbTableModel != null) {
                try {
                    dataSetColumn = this.dbTableModel.getColumn(this.convertColumnIndexToModel(column));
                    this.dataSet.getDisplayVariant(dataSetColumn.getOrdinal(), row, this.variantValue);
                    if (renderer instanceof TableFastStringRenderer) {
                        value = dataSetColumn.format(this.variantValue);
                        variantCopy = (Variant)this.variantValue.clone();
                        columnPaintListener = dataSetColumn.getColumnPaintListener();
                        break block16;
                    }
                    if (dataSetColumn.getDataType() == 12 && renderer instanceof TableImageRenderer) {
                        InputStream inputStream = this.variantValue.getInputStream();
                        inputStream.reset();
                        if (DBUtilities.isBMPFile(inputStream) || DBUtilities.isGIForJPGFile(inputStream)) {
                            if (this.imageCache == null) {
                                this.imageCache = new LRUCache();
                            }
                            if ((value = this.imageCache.get(inputStream)) == null) {
                                Image bmpImage;
                                byte[] bytes;
                                value = DBUtilities.isGIForJPGFile(inputStream) ? ((bytes = DBUtilities.getByteArrayFromStream(inputStream)) == null ? new TextIcon(Res.bundle.getString(22)) : new ImageIcon(bytes)) : ((bmpImage = DBUtilities.makeBMPImage(inputStream)) != null ? new ImageIcon(bmpImage) : new TextIcon(Res.bundle.getString(22)));
                                if (value != null) {
                                    this.imageCache.put(inputStream, value);
                                }
                            }
                        } else {
                            value = this.variantValue.isNull() ? new TextIcon(" ") : new TextIcon(Res.bundle.getString(22));
                        }
                        break block16;
                    }
                    value = this.getValueAt(row, column);
                }
                catch (Exception e2) {
                    DBExceptionHandler.handleException(this.dataSet, this, e2);
                }
            } else {
                value = this.getValueAt(row, column);
            }
        }
        boolean rowIsAnchor = this.selectionModel.getAnchorSelectionIndex() == row;
        boolean colIsAnchor = this.columnModel.getSelectionModel().getAnchorSelectionIndex() == column;
        boolean hasFocus = rowIsAnchor && colIsAnchor && this.hasFocus();
        boolean isSelected = hasFocus || this.isCellSelected(row, column);
        Component component = renderer.getTableCellRendererComponent(this, value, isSelected, hasFocus, row, column);
        if (this.dbTableModel != null && columnPaintListener != null && component instanceof CustomPaintSite) {
            Color foreground = component.getForeground();
            Color background = component.getBackground();
            columnPaintListener.painting(this.dataSet, dataSetColumn, row, this.variantValue, (CustomPaintSite)((Object)component));
            if (variantCopy != null && !variantCopy.equals(this.variantValue) && component instanceof TableFastStringRenderer) {
                try {
                    ((TableFastStringRenderer)component).setValue(dataSetColumn.format(this.variantValue));
                }
                catch (Exception e3) {
                    DBExceptionHandler.handleException(this.dataSet, this, e3);
                }
            }
            if (isSelected) {
                component.setForeground(foreground);
                component.setBackground(background);
            }
        }
        return component;
    }

    public void keyPressed(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
    }

    public void keyTyped(KeyEvent e2) {
        if (e2.getKeyChar() == '\u001b') {
            e2.consume();
            if (this.isEditing()) {
                this.removeEditor();
            }
        }
    }

    protected TableCellEditor getDefaultCellEditor(Column dataSetColumn) {
        Component editorComponent;
        int type = dataSetColumn.getDataType();
        if (type > 1 && type < 17 && type != 11) {
            if (type == 12) {
                return new TableImageEditor();
            }
            if (dataSetColumn.getPickList() != null) {
                JdbComboBox comboBox = new JdbComboBox();
                comboBox.setDataSet(this.dataSet);
                comboBox.setColumnName(dataSetColumn.getColumnName());
                return new DBTableCellEditorWrapper(new DefaultCellEditor(comboBox));
            }
            TableMaskCellEditor editor = new TableMaskCellEditor();
            editor.setFormatter(dataSetColumn.getFormatter());
            if (dataSetColumn.getDataType() == 16 && dataSetColumn.getPrecision() != -1) {
                editor.setMaxLength(dataSetColumn.getPrecision());
            }
            editor.setDefaultForeground(dataSetColumn.getForeground() == null ? this.getForeground() : dataSetColumn.getForeground());
            editor.setDefaultBackground(dataSetColumn.getBackground() == null ? this.getBackground() : dataSetColumn.getBackground());
            editor.setDefaultFont(dataSetColumn.getFont() == null ? this.getFont() : dataSetColumn.getFont());
            editor.setDefaultAlignment(dataSetColumn.getAlignment());
            editor.setEditMasker(dataSetColumn.getEditMasker());
            editor.setVariantType(dataSetColumn.getDataType());
            return editor;
        }
        TableCellEditor editor = this.getDefaultEditor(DBTableModel.getJavaClass(dataSetColumn.getDataType()));
        if (editor instanceof DefaultCellEditor && (editorComponent = ((DefaultCellEditor)editor).getComponent()) != null) {
            JComponent cellEditor;
            if (editorComponent instanceof JComponent) {
                cellEditor = (JComponent)editorComponent;
                if (dataSetColumn.getForeground() != null) {
                    cellEditor.setForeground(dataSetColumn.getForeground());
                }
                if (dataSetColumn.getBackground() != null) {
                    cellEditor.setBackground(dataSetColumn.getBackground());
                }
                if (dataSetColumn.getFont() != null) {
                    cellEditor.setFont(dataSetColumn.getFont());
                }
            }
            if (editorComponent instanceof JTextField) {
                cellEditor = (JTextField)editorComponent;
                ((JTextField)cellEditor).setHorizontalAlignment(DBUtilities.convertJBCLToSwingAlignment(dataSetColumn.getAlignment(), true));
            }
            if (editorComponent instanceof JCheckBox) {
                ((DefaultCellEditor)editor).setClickCountToStart(2);
            }
        }
        return new DBTableCellEditorWrapper(editor);
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Column dataSetColumn;
        ColumnPaintListener columnPaintListener;
        Object value;
        block20: {
            value = null;
            columnPaintListener = null;
            dataSetColumn = null;
            if (this.dbTableModel != null) {
                try {
                    dataSetColumn = this.dbTableModel.getColumn(this.convertColumnIndexToModel(column));
                    this.dataSet.getDisplayVariant(dataSetColumn.getOrdinal(), row, this.variantValue);
                    if (editor instanceof TableMaskCellEditor) {
                        if (dataSetColumn.getEditMask() == null && dataSetColumn.getFormatter().getFormatObj() instanceof DateFormat) {
                            String oldPattern = dataSetColumn.getFormatter().getPattern();
                            String widePattern = null;
                            int yearMaskIndex = -1;
                            yearMaskIndex = DBUtilities.yearMaskPos(oldPattern);
                            if (yearMaskIndex != -1) {
                                int yearMaskCount = 1;
                                int patternLength = oldPattern.length();
                                while (yearMaskIndex + yearMaskCount < patternLength && oldPattern.charAt(yearMaskIndex + yearMaskCount) == 'y') {
                                    ++yearMaskCount;
                                }
                                if (yearMaskCount < 4) {
                                    widePattern = String.valueOf(new StringBuffer(String.valueOf(oldPattern.substring(0, yearMaskIndex))).append("yyyy").append(yearMaskIndex + yearMaskCount < patternLength ? oldPattern.substring(yearMaskIndex + yearMaskCount) : ""));
                                }
                            }
                            if (widePattern != null) {
                                dataSetColumn.getFormatter().setPattern(widePattern);
                            }
                            value = dataSetColumn.format(this.variantValue);
                            if (widePattern != null) {
                                dataSetColumn.getFormatter().setPattern(oldPattern);
                            }
                        } else {
                            value = this.variantValue.getAsObject();
                        }
                        columnPaintListener = dataSetColumn.getColumnPaintListener();
                        break block20;
                    }
                    if (dataSetColumn.getDataType() == 12 && (editor instanceof TableImageEditor || editor instanceof TableImageReadOnlyEditor)) {
                        InputStream inputStream = this.variantValue.getInputStream();
                        inputStream.reset();
                        if (DBUtilities.isBMPFile(inputStream) || DBUtilities.isGIForJPGFile(inputStream)) {
                            if (this.imageCache == null) {
                                this.imageCache = new LRUCache();
                            }
                            if ((value = this.imageCache.get(inputStream)) == null) {
                                Image bmpImage;
                                byte[] bytes;
                                value = DBUtilities.isGIForJPGFile(inputStream) ? ((bytes = DBUtilities.getByteArrayFromStream(inputStream)) == null ? new TextIcon(Res.bundle.getString(22)) : new ImageIcon(bytes)) : ((bmpImage = DBUtilities.makeBMPImage(inputStream)) != null ? new ImageIcon(bmpImage) : new TextIcon(Res.bundle.getString(22)));
                                if (value != null) {
                                    this.imageCache.put(inputStream, value);
                                }
                            }
                        } else {
                            value = new TextIcon(Res.bundle.getString(22));
                        }
                        break block20;
                    }
                    value = this.getValueAt(row, column);
                }
                catch (Exception e2) {
                    DBExceptionHandler.handleException(this.dataSet, this, e2);
                }
            } else {
                value = this.getValueAt(row, column);
            }
        }
        boolean isSelected = this.isCellSelected(row, column);
        Component comp = editor.getTableCellEditorComponent(this, value, isSelected, row, column);
        if (comp instanceof JComponent) {
            ((JComponent)comp).setNextFocusableComponent(this);
        }
        if (columnPaintListener != null && comp instanceof CustomPaintSite) {
            columnPaintListener.editing(this.dataSet, dataSetColumn, (CustomPaintSite)((Object)comp));
        }
        return comp;
    }

    protected int getStringWidth(String string, Font font) {
        int width;
        Graphics g2;
        int emWidth = 9;
        if (font == null) {
            font = this.getFont();
        }
        if (font == null || (g2 = this.getGraphics()) == null) {
            width = emWidth * string.length();
        } else {
            FontMetrics fontMetrics = g2.getFontMetrics(font);
            width = fontMetrics.stringWidth(string);
            g2.dispose();
        }
        return width;
    }

    protected int getMaxCaptionWidth(Object columnHeaderValue, Font font) {
        int maxWidth = 0;
        if (columnHeaderValue instanceof String[]) {
            String[] strings = (String[])columnHeaderValue;
            for (int x2 = 0; x2 < strings.length; ++x2) {
                int width = this.getStringWidth(String.valueOf(strings[x2]).concat("  "), font);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
        } else if (columnHeaderValue != null) {
            int width;
            int offset = 0;
            String caption = columnHeaderValue.toString();
            while ((offset = caption.indexOf(10)) != -1) {
                width = this.getStringWidth(String.valueOf(caption.substring(0, offset + 1)).concat("  "), font);
                if (width > maxWidth) {
                    maxWidth = width;
                }
                caption = caption.substring(offset + 1);
            }
            width = this.getStringWidth(String.valueOf(caption).concat("  "), font);
            if (width > maxWidth) {
                maxWidth = width;
            }
        }
        return maxWidth;
    }

    protected int getDefaultTableColumnWidth(Column dataSetColumn) {
        int dataWidth;
        int emWidth = this.getStringWidth("M", dataSetColumn.getFont());
        if (dataSetColumn.getWidth() != 15 || !this.smartColumnWidths) {
            return dataSetColumn.getWidth() * emWidth;
        }
        if (dataSetColumn.getDataType() == 16 && dataSetColumn.getPrecision() != -1) {
            return Math.min(dataSetColumn.getPrecision() * 3 / 4, 40) * emWidth;
        }
        int captionWidth = this.getMaxCaptionWidth(dataSetColumn.getCaption(), dataSetColumn.getFont());
        if (captionWidth > (dataWidth = 10 * emWidth)) {
            return captionWidth;
        }
        if (dataWidth > 75) {
            return dataWidth;
        }
        return 75;
    }

    protected boolean isCellValid(TableCellEditor cellEditor) {
        if (this.dataSet == null) {
            return true;
        }
        if (cellEditor instanceof TableMaskCellEditor && !((TableMaskCellEditor)cellEditor).isValidValue() || !this.dbTableModel.isValidValue(cellEditor.getCellEditorValue(), this.getEditingRow(), this.getEditingColumn())) {
            DBExceptionHandler.handleException(this.dataSet, this, new ValidationException(1011, Res.bundle.getString(21), this.dbTableModel.getColumn(this.convertColumnIndexToModel(this.getEditingColumn()))));
            return false;
        }
        return true;
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.getColumnModel()){

            public boolean isFocusTraversable() {
                return false;
            }

            public boolean isRequestFocusEnabled() {
                return false;
            }
        };
    }

    protected TableModel createDefaultDataModel() {
        return new DBTableModel();
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JMenu sortMenu = new JMenu(Res.bundle.getString(20));
        if (this.dataSet.isEditing()) {
            sortMenu.setEnabled(false);
        }
        JCheckBoxMenuItem checkItem = new JCheckBoxMenuItem(Res.bundle.getString(19));
        checkItem.addActionListener(this);
        checkItem.setActionCommand("nosort");
        SortDescriptor sortDescriptor = this.dataSet.getSort();
        String columnSortKey = "";
        if (sortDescriptor == null) {
            checkItem.setState(true);
        } else {
            String[] sortKeys = sortDescriptor.getKeys();
            if (sortKeys != null && sortKeys.length > 0) {
                columnSortKey = sortKeys[0];
            }
        }
        sortMenu.add(checkItem);
        int maxCols = this.getColumnModel().getColumnCount();
        for (int colNo = 0; colNo < maxCols; ++colNo) {
            Column dataSetColumn = ((DBTableModel)this.getModel()).getColumn(this.convertColumnIndexToModel(colNo));
            if (dataSetColumn == null || !this.dataSet.isSortable(dataSetColumn)) continue;
            TableColumn column = this.getColumnModel().getColumn(colNo);
            checkItem = column.getHeaderValue() instanceof String[] ? new JCheckBoxMenuItem(this.getConcatenatedString((String[])column.getHeaderValue())) : new JCheckBoxMenuItem(column.getHeaderValue().toString().replace('\n', ' '));
            checkItem.addActionListener(this);
            String columnName = this.getColumnModel().getColumn(colNo).getIdentifier().toString();
            checkItem.setActionCommand(columnName);
            if (columnSortKey.equals(columnName)) {
                checkItem.setState(true);
            } else {
                checkItem.setState(false);
            }
            sortMenu.add(checkItem);
        }
        menu.add(sortMenu);
        menu.addSeparator();
        boolean readOnly = false;
        if (this.dataSet instanceof StorageDataSet) {
            readOnly = ((StorageDataSet)this.dataSet).isReadOnly();
        }
        JMenuItem menuItem = new JMenuItem(Res.bundle.getString(11));
        menuItem.setEnabled(this.dataSet.isEditing());
        menuItem.addActionListener(this);
        menuItem.setActionCommand("post");
        menu.add(menuItem);
        menuItem = new JMenuItem(Res.bundle.getString(12));
        menuItem.setEnabled(this.dataSet.isEditing());
        menuItem.addActionListener(this);
        menuItem.setActionCommand("cancel");
        menu.add(menuItem);
        menuItem = new JMenuItem(Res.bundle.getString(9));
        menuItem.setEnabled(this.dataSet.isEnableInsert() && this.isEditable() && !this.dataSet.isEditingNewRow() && this.dataSet.isEditable() && !readOnly);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("insert");
        menu.add(menuItem);
        menuItem = new JMenuItem(Res.bundle.getString(10));
        try {
            menuItem.setEnabled(this.dataSet.isEnableDelete() && this.isEditable() && !this.dataSet.isEmpty() && this.dataSet.isEditable() && !readOnly);
            menuItem.addActionListener(this);
            menuItem.setActionCommand("delete");
            menu.add(menuItem);
        }
        catch (DataSetException e2) {
            DBExceptionHandler.handleException(this.dataSet, this, e2);
        }
        return menu;
    }

    private String getConcatenatedString(String[] strings) {
        StringBuffer caption = new StringBuffer();
        for (int i2 = 0; i2 < strings.length; ++i2) {
            caption.append(strings[i2]).append(" ");
        }
        caption.deleteCharAt(caption.length() - 1);
        return caption.toString();
    }

    public void setEditableFocusedCellForeground(Color focusedCellForeground) {
        this.focusedCellForeground = focusedCellForeground;
    }

    public Color getEditableFocusedCellForeground() {
        return this.focusedCellForeground;
    }

    public void setEditableFocusedCellBackground(Color focusedCellBackground) {
        this.focusedCellBackground = focusedCellBackground;
    }

    public Color getEditableFocusedCellBackground() {
        return this.focusedCellBackground;
    }

    protected void initializeLocalVars() {
        this.setOpaque(true);
        this.createDefaultRenderers();
        this.createDefaultEditors();
        this.setTableHeader(this.createDefaultTableHeader());
        this.setShowGrid(true);
        this.setAutoResizeMode(0);
        this.setRowHeight(21);
        this.setRowMargin(1);
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(0);
        this.setCellEditor(null);
        this.setEditingColumn(-1);
        this.setEditingRow(-1);
        this.setPreferredScrollableViewportSize(new Dimension(450, 400));
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setAutoscrolls(true);
        this.addPropertyChangeListener(this);
    }

    public boolean isCellSelected(int row, int column) {
        return this.isRowSelected(row) && this.isColumnSelected(column);
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (this.getTableHeader() != null) {
            this.getTableHeader().removeMouseListener(this);
        }
        if (tableHeader != null) {
            tableHeader.addMouseListener(this);
        }
        super.setTableHeader(tableHeader);
    }

    public void propertyChange(PropertyChangeEvent e2) {
        if (e2.getPropertyName().equals("columnModel")) {
            Object columnModel = e2.getOldValue();
            if (columnModel != null) {
                ((TableColumnModel)columnModel).getSelectionModel().removeListSelectionListener(this);
            }
            if ((columnModel = e2.getNewValue()) != null) {
                ((TableColumnModel)columnModel).getSelectionModel().addListSelectionListener(this);
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.pendingDataSet != null) {
                this.bindDataSet();
            } else if (this.getModel() != null) {
                this.createDefaultColumnsFromModel();
            }
        }
    }

    private void bindDataSet() {
        int rowNo;
        if (this.dbTableModel == null) {
            this.dbTableModel = new DBTableModel();
        }
        if (this.pendingDataSet != null) {
            try {
                this.pendingDataSet.open();
            }
            catch (DataSetException ex) {
                DBExceptionHandler.handleException(this.pendingDataSet, this, ex);
                this.dbTableModel.setDataSet(null);
                this.setModel(this.dbTableModel);
                return;
            }
        }
        this.dbTableModel.setDataSet(this.pendingDataSet);
        if (this.getModel() != this.dbTableModel) {
            this.setModel(this.dbTableModel);
        }
        if (this.pendingDataSet != null && (rowNo = this.pendingDataSet.getRow()) > 0) {
            this.setRowSelectionInterval(rowNo, rowNo);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeHeaders();
    }

    private void removeHeaders() {
        Container parent;
        Container viewport;
        if (this.isDisplayable() && (viewport = this.getParent()) instanceof JViewport && (parent = viewport.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)parent;
            if (scrollPane.getColumnHeader().getView() instanceof JTableHeader) {
                scrollPane.setColumnHeaderView(null);
            }
            if (scrollPane.getRowHeader().getView() instanceof TableRowHeader) {
                scrollPane.setRowHeaderView(null);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setRowHeaderVisible(visible);
        this.setColumnHeaderVisible(visible);
    }

    private void updateColumnModel() {
        if (this.addNotifyCalled) {
            this.createDefaultColumnsFromModel();
        }
    }

    public void valueChanged(ListSelectionEvent e2) {
        super.valueChanged(e2);
        if (e2.getSource() == this.getColumnModel().getSelectionModel()) {
            int tableColumn = this.getSelectedColumn();
            if (!e2.getValueIsAdjusting() && this.dataSet != null && tableColumn > -1 && tableColumn < this.getColumnModel().getColumnCount()) {
                int modelColumn = this.convertColumnIndexToModel(tableColumn);
                TableModel tableModel = this.getModel();
                if (modelColumn >= 0 && modelColumn < tableModel.getColumnCount() && this.dataSet != null && tableModel instanceof DBTableModel) {
                    Column column = ((DBTableModel)tableModel).getColumn(modelColumn);
                    this.dataSet.setLastColumnVisited(column.getColumnName());
                }
            }
        } else if (!this.ignoreNavigation && !e2.getValueIsAdjusting() && this.dataSet != null && this.dataSet.isOpen() && this.getSelectedRow() != this.dataSet.getRow()) {
            int selectedRow = this.getSelectedRow();
            if (this.dataSet.isEditing()) {
                try {
                    this.dataSet.post();
                }
                catch (DataSetException ex) {
                    this.ignoreNavigation = true;
                    this.setRowSelectionInterval(this.dataSet.getRow(), this.dataSet.getRow());
                    this.ignoreNavigation = false;
                    DBExceptionHandler.handleException(this.dataSet, ex);
                    return;
                }
            }
            if (this.dataSet.getRow() != selectedRow) {
                this.ignoreNavigation = true;
                try {
                    block13: {
                        try {
                            this.dataSet.goToRow(selectedRow);
                            if (selectedRow <= 0) break block13;
                            this.setRowSelectionInterval(selectedRow, selectedRow);
                        }
                        catch (DataSetException ex) {
                            this.setRowSelectionInterval(this.dataSet.getRow(), this.dataSet.getRow());
                            DBExceptionHandler.handleException(this.dataSet, ex);
                            Object var7_10 = null;
                            this.ignoreNavigation = false;
                        }
                    }
                    Object var7_9 = null;
                    this.ignoreNavigation = false;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    this.ignoreNavigation = false;
                    throw throwable;
                }
            }
        }
    }

    public void tableChanged(TableModelEvent e2) {
        super.tableChanged(e2);
        if (e2.getType() == 1 || e2.getType() == -1) {
            this.ignoreNavigation = true;
            if (this.getRowCount() > e2.getLastRow()) {
                this.setRowSelectionInterval(e2.getLastRow(), e2.getLastRow());
            }
            this.ignoreNavigation = false;
        }
    }

    public void navigated(NavigationEvent e2) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        int row = this.dataSet.getRow();
        if (!this.ignoreNavigation) {
            this.ignoreNavigation = true;
            if (this.getRowCount() > row) {
                this.setRowSelectionInterval(row, row);
            }
            Rectangle rect = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn(), true);
            this.scrollRectToVisible(rect);
            this.repaint();
            this.ignoreNavigation = false;
        }
        if (this.getRowHeader() != null) {
            this.getRowHeader().revalidate();
            this.getRowHeader().repaint();
        }
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 1) {
            if (event.getReason() == 2) {
                this.dataSetEventsEnabled = true;
            }
            if (this.autoSelection && !this.rebindColumnProperties) {
                int rowNo = this.dataSet.getRow();
                if (rowNo > 0) {
                    this.setRowSelectionInterval(rowNo, rowNo);
                } else if (this.getRowCount() > 0) {
                    this.setRowSelectionInterval(0, 0);
                }
                if (this.getColumnCount() > 0) {
                    this.setColumnSelectionInterval(0, 0);
                }
            }
            if (this.rebindColumnProperties) {
                this.createDefaultColumnsFromModel();
                this.rebindColumnProperties = false;
            }
            this.repaint();
            if (this.getRowHeader() != null) {
                this.getRowHeader().revalidate();
                this.getRowHeader().repaint();
            }
        } else {
            if (event.getReason() == 9) {
                this.rebindColumnProperties = true;
            }
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
            }
        }
    }

    public void dataChanged(DataChangeEvent e2) {
        if (this.dataSetEventsEnabled && this.isEditing()) {
            int editingRow = this.getEditingRow();
            int affectedRow = e2.getRowAffected();
            if (affectedRow == editingRow && e2.getID() == 2) {
                this.removeEditor();
            }
        }
    }

    public void postRow(DataChangeEvent e2) throws Exception {
        if (this.cellEditor instanceof TableMaskCellEditor) {
            if (!((TableMaskCellEditor)this.cellEditor).isValidValue()) {
                throw new ValidationException(1011, Res.bundle.getString(21), this.dbTableModel.getColumn(this.convertColumnIndexToModel(this.getEditingColumn())));
            }
            this.cellEditor.stopCellEditing();
        }
    }

    public void mouseClicked(MouseEvent e2) {
        int tableColumn;
        if (e2.getSource() == this.getTableHeader() && this.enableSort && (tableColumn = this.getTableHeader().columnAtPoint(e2.getPoint())) != -1) {
            int modelColumn = this.convertColumnIndexToModel(tableColumn);
            TableModel tableModel = this.getModel();
            if (modelColumn >= 0 && modelColumn < tableModel.getColumnCount() && this.dataSet != null && tableModel instanceof DBTableModel) {
                Frame frame = DBUtilities.getFrame(this);
                try {
                    Column column = ((DBTableModel)tableModel).getColumn(modelColumn);
                    if (this.dataSet.isSortable(column) && !this.isEditing() && !this.dataSet.isEditing()) {
                        boolean resetAutoSelection = this.autoSelection;
                        this.autoSelection = false;
                        frame.setCursor(Cursor.getPredefinedCursor(3));
                        this.dataSet.toggleViewOrder(column.getColumnName());
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                        this.autoSelection = resetAutoSelection;
                    }
                }
                catch (Exception x2) {
                    DBExceptionHandler.handleException(this.dataSet, this, x2);
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    public void mousePressed(MouseEvent e2) {
        if (e2.getSource() == this && e2.isPopupTrigger() && this.getModel() instanceof DBTableModel && this.popupEnabled && !this.isEditing()) {
            this.createPopupMenu().show(this, e2.getX(), e2.getY());
        }
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mouseReleased(MouseEvent e2) {
        if (e2.getSource() == this && e2.isPopupTrigger() && this.getModel() instanceof DBTableModel && this.popupEnabled && !this.isEditing()) {
            this.createPopupMenu().show(this, e2.getX(), e2.getY());
        }
    }

    public void actionPerformed(ActionEvent e2) {
        JMenuItem menuItem = (JMenuItem)e2.getSource();
        String action = menuItem.getActionCommand();
        try {
            if (action.equals("post")) {
                this.dataSet.post();
            } else if (action.equals("cancel")) {
                this.dataSet.cancel();
            } else if (action.equals("insert")) {
                if (this.isEditable()) {
                    this.dataSet.insertRow(true);
                }
            } else if (action.equals("delete")) {
                if (this.isEditable()) {
                    this.dataSet.deleteRow();
                }
            } else if (action.equals("nosort")) {
                this.dataSet.setSort(null);
            } else {
                boolean resetAutoSelection = this.autoSelection;
                this.autoSelection = false;
                this.dataSet.toggleViewOrder(action);
                this.autoSelection = resetAutoSelection;
            }
        }
        catch (DataSetException ex) {
            DBExceptionHandler.handleException(this.dataSet, this, ex);
        }
    }

    private class InsertRowAction
    extends AbstractAction {
        private InsertRowAction() {
            super("insert-row");
        }

        public void actionPerformed(ActionEvent e2) {
            if (JdbTable.this.isEditable() && JdbTable.this.dataSet != null && JdbTable.this.dataSet.isEnableInsert() && !JdbTable.this.dataSet.isEditingNewRow() && JdbTable.this.dataSet.isEditable()) {
                boolean readOnly = false;
                if (JdbTable.this.dataSet instanceof StorageDataSet) {
                    readOnly = ((StorageDataSet)JdbTable.this.dataSet).isReadOnly();
                }
                if (!readOnly) {
                    try {
                        JdbTable.this.dataSet.insertRow(true);
                    }
                    catch (DataSetException ex) {
                        DBExceptionHandler.handleException(JdbTable.this.dataSet, JdbTable.this, ex);
                    }
                }
            }
        }
    }

    public class DBTableCellEditorWrapper
    implements TableCellEditor {
        TableCellEditor tableCellEditor;
        Component editorComponent;
        JTable table;
        int lastRow = -1;
        int row;
        int column;

        public DBTableCellEditorWrapper(TableCellEditor tableCellEditor) {
            this.tableCellEditor = tableCellEditor;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.tableCellEditor != null) {
                this.editorComponent = this.tableCellEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                this.table = table;
                this.row = row;
                this.column = column;
                return this.editorComponent;
            }
            return null;
        }

        public Object getCellEditorValue() {
            if (this.tableCellEditor != null) {
                return this.tableCellEditor.getCellEditorValue();
            }
            return null;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                Point point = ((MouseEvent)anEvent).getPoint();
                if (((MouseEvent)anEvent).getClickCount() > 1) {
                    return this.tableCellEditor.isCellEditable(anEvent);
                }
            } else if ((anEvent == null || anEvent instanceof KeyEvent) && this.tableCellEditor.isCellEditable(anEvent)) {
                SwingUtilities.invokeLater(new Runnable(this){
                    final /* synthetic */ DBTableCellEditorWrapper this$0;

                    public void run() {
                        this.this$0.editorComponent.requestFocus();
                    }
                    {
                        this.this$0 = this$0;
                    }
                });
                return true;
            }
            return false;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return this.tableCellEditor.shouldSelectCell(anEvent);
        }

        public boolean stopCellEditing() {
            if (!JdbTable.this.isCellValid(this.tableCellEditor) || !this.tableCellEditor.stopCellEditing()) {
                return false;
            }
            if (this.lastRow != -1 && this.lastRow != this.row && JdbTable.this.dataSet != null) {
                try {
                    JdbTable.this.dataSet.goToRow(this.row);
                    this.lastRow = this.row;
                }
                catch (DataSetException ex) {
                    DBExceptionHandler.handleException(JdbTable.this.dataSet, ex);
                    boolean bl = false;
                    return bl;
                }
            }
            return true;
        }

        public void cancelCellEditing() {
            this.tableCellEditor.cancelCellEditing();
        }

        public void addCellEditorListener(CellEditorListener l2) {
            this.tableCellEditor.addCellEditorListener(l2);
        }

        public void removeCellEditorListener(CellEditorListener l2) {
            this.tableCellEditor.removeCellEditorListener(l2);
        }
    }

    class TableImageRenderer
    extends DefaultTableCellRenderer {
        TableImageRenderer(JdbTable this$0) {
        }

        public void TableImageRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object value) {
            this.setIcon((Icon)value);
        }
    }

    class StartEditAction
    extends AbstractAction {
        private EventObject eventObject = new EventObject(this);

        private StartEditAction() {
            super("start-edit");
        }

        public void actionPerformed(ActionEvent e2) {
            if (!JdbTable.this.isEditing()) {
                JdbTable.this.editCellAt(JdbTable.this.getSelectedRow(), JdbTable.this.getSelectedColumn(), this.eventObject);
            }
        }
    }

    private class DeleteRowAction
    extends AbstractAction {
        private DeleteRowAction() {
            super("delete-row");
        }

        public void actionPerformed(ActionEvent e2) {
            if (JdbTable.this.isEditable() && JdbTable.this.dataSet != null && JdbTable.this.dataSet.isEnableDelete() && JdbTable.this.dataSet.isEditable()) {
                boolean readOnly = false;
                if (JdbTable.this.dataSet instanceof StorageDataSet) {
                    readOnly = ((StorageDataSet)JdbTable.this.dataSet).isReadOnly();
                }
                if (!readOnly) {
                    try {
                        if (!JdbTable.this.dataSet.isEmpty()) {
                            JdbTable.this.dataSet.deleteRow();
                        }
                    }
                    catch (DataSetException ex) {
                        DBExceptionHandler.handleException(JdbTable.this.dataSet, JdbTable.this, ex);
                    }
                }
            }
        }
    }

    private class AppendRowAction
    extends AbstractAction {
        private AppendRowAction() {
            super("append-row");
        }

        public void actionPerformed(ActionEvent e2) {
            if (JdbTable.this.isEditable() && JdbTable.this.dataSet != null && JdbTable.this.dataSet.isEnableInsert() && !JdbTable.this.dataSet.isEditingNewRow() && JdbTable.this.dataSet.isEditable()) {
                boolean readOnly = false;
                if (JdbTable.this.dataSet instanceof StorageDataSet) {
                    readOnly = ((StorageDataSet)JdbTable.this.dataSet).isReadOnly();
                }
                if (!readOnly) {
                    try {
                        if (JdbTable.this.dataSet.atLast()) {
                            JdbTable.this.dataSet.insertRow(false);
                        } else {
                            JdbTable.this.dataSet.next();
                        }
                    }
                    catch (DataSetException ex) {
                        DBExceptionHandler.handleException(JdbTable.this.dataSet, JdbTable.this, ex);
                    }
                }
            }
        }
    }
}

