function attrElem(pObj, pName, pValue) {
  var Attr = document.createAttribute(pName);
  Attr.nodeValue = pValue;
  pObj.setAttributeNode(Attr);
}

function attrElemById(pId, pName, pValue) {
  attrElem(elementById(pId), pName, pValue);
}

function chgBgClr(pObj, pColor) {
  pObj.style.backgroundColor = pColor;
}

function chgBgTxtClr(pObj, pBgColor, pTxtColor) {
  with (pObj.style) {
    backgroundColor = pBgColor;
    color = pTxtColor;
  }
}

function chgBrdClr(pObj, pColor) {
  pObj.style.borderColor = pColor;
}

function chgClass(pObj, pClass) {
  pObj.className = pClass;
}

function childElem(pObj, pName, pRecurse) {
  if (pObj.hasChildNodes())
    for (var I = 0; I < pObj.childNodes.length; I++)
      if (pObj.childNodes[I].nodeName == pName)
        return pObj.childNodes[I];
      else if (pRecurse) {
        var Elem = childElem(pObj.childNodes[I], pName, pRecurse);
        if (Elem != null)
          return Elem;
      }
  return null;
}

function childElemById(pId, pName, pRecurse) {
  return childElem(elementById(pId), pName, pRecurse);
}

function childrenElem(pObj, pName) {
  var Children = new Array();
  if (!pObj.hasChildNodes())
    return Children;
  if (pName == '')
    return pObj.childNodes;
  for (var I = 0; I < pObj.childNodes.length; I++)
    if (pObj.childNodes[I].nodeName == pName)
      Children.push(pObj.childNodes[I]);
  return Children;
}

function childrenElemById(pId, pName) {
  return childrenElem(elementById(pId), pName);
}

function displayElem(pObj, pDisplay) {
  if (pObj)
    with (pObj.style)
      try {
        display = pDisplay;
      } catch (Err) {
        display = 'block';
      }
}

function displayElemById(pId, pDisplay) {
  displayElem(elementById(pId), pDisplay);
}

function doHttpRequest(pUrl, pFunc, pParam, pRawPostData) {
  var HttpReq = false;

  if (window.XMLHttpRequest)
    HttpReq = new XMLHttpRequest();
  else if (window.ActiveXObject) {
    try {
      HttpReq = new ActiveXObject('Msxml2.XMLHTTP');
    } catch (Err) {
      try {
        HttpReq = new ActiveXObject('Microsoft.XMLHTTP');
      } catch (Err) {}
    }
  }

  if (HttpReq) {
    if (pFunc != '')
      HttpReq.onreadystatechange = function() {
        if (HttpReq.readyState == 4 && HttpReq.status == 200)
          eval(pFunc + '(HttpReq.responseText, pParam);');
      }
    if (pRawPostData == '') {
      HttpReq.open('GET', pUrl, true);
      HttpReq.send(null);
    } else {
      HttpReq.open('POST', pUrl, true);
      HttpReq.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
      HttpReq.send(pRawPostData);
    }
  }
}

function elementById(pId) {
  pId = 'id_' + pId;
  with (document)
    return getElementById ? getElementById(pId) : all[pId];
}

function frameByName(pName) {
  return window.frames['ifr_' + pName];
}

function formByName(pName) {
  return document.forms['frm_' + pName];
}

function getAllOptSelValues(pObj) {
  var List = new Array();
  if (typeof(pObj.length) == 'number') {
    for (var I = 0; I < pObj.length; I++)
      if (pObj[I].checked)
        List.push(pObj[I].value);
  } else if (pObj.checked)
    List.push(pObj.value);
  return List;
}

function getAllSelectSelValues(pObj) {
  var List = new Array();
  pObj = pObj.options;
  for (var I = 0; I < pObj.length; I++)
    if (pObj[I].selected)
      List.push(pObj[I].value);
  return List;
}

function getElemBody() {
  with (document)
    return getElementsByTagName ? getElementsByTagName('body')[0] : body;
}

function getHtml(pId) {
  var Elem = elementById(pId);
  return Elem == null ? '' : Elem.innerHTML;
}

function getOptSelValue(pObj) {
  if (typeof(pObj.length) == 'number') {
    for (var I = 0; I < pObj.length; I++)
      if (pObj[I].checked)
        return pObj[I].value;
  } else if (pObj.checked)
    return pObj.value;
  return '';
}

function getPageHeight() {
  return Math.max(getWindowHeight(), getElemBody().scrollHeight);
}

function getPageWidth() {
  return getElemBody().scrollWidth;
}

function getSelectSelValue(pObj) {
  with (pObj) {
    if (selectedIndex == -1)
      return '';
    return options[selectedIndex].value;
  }
}

function getWindowHeight() {
  return typeof(window.innerHeight) == 'number' ? window.innerHeight : getElemBody().clientHeight;
}

function getWindowScrollLeft() {
  return typeof(window.pageXOffset) == 'number' ? window.pageXOffset : getElemBody().scrollLeft;
}

function getWindowScrollTop() {
  return typeof(window.pageYOffset) == 'number' ? window.pageYOffset : getElemBody().scrollTop;
}

function getWindowWidth() {
  return typeof(window.innerWidth) == 'number' ? window.innerWidth : getElemBody().clientWidth;
}

function go(pUrl) {
  window.location.href = pUrl;
}

function goBlank(pUrl) {
  window.open(pUrl, '_blank');
}

function goSelect(pObj) {
  var S = getSelectSelValue(pObj);
  pObj.selectedIndex = 0;
  if (S != '')
    go(S);
}

function htmlcode(pValue) {
  return pValue.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/\s\s/g, '&nbsp; ');
}

function imageByName(pName) {
  return document.images['img_' + pName];
}

function insertText(pObj, pTextLeft, pTextRight) {
  pObj.focus();
  if (typeof(document.selection) != 'undefined') {
    var Range = document.selection.createRange();
    var S = Range.text;
    Range.text = pTextLeft + S + pTextRight;
    Range = document.selection.createRange();
    if (S.length == 0)
      Range.move('character', - pTextRight.length);
    else
      Range.moveStart('character', pTextLeft.length + S.length + pTextRight.length);      
    Range.select();
  } else if (typeof(pObj.selectionStart) != 'undefined') {
    var Start = pObj.selectionStart;
    var End = pObj.selectionEnd;
    var S = pObj.value.substring(Start, End);
    pObj.value = pObj.value.substr(0, Start) + pTextLeft + S + pTextRight + pObj.value.substr(End);
    pObj.selectionStart = pObj.selectionEnd = S.length == 0 ? Start + pTextLeft.length : Start + pTextLeft.length + S.length + pTextRight.length;
  }
}

function newElem(pName) {
  return document.createElement(pName);
}

function popupWindow(pUrl, pHeight, pWidth) {
  window.open(pUrl, 'popup', 'dependent=no,height=' + pHeight + ',left=' + Math.round((screen.availWidth - pWidth) / 2) + ',resizable=yes,width=' + pWidth + ',top=' + Math.round((screen.availHeight - pHeight) / 2)).focus();
}

function resetElemConfirm(pMsg, pObj) {
  if (!confirm(pMsg))
    with (pObj)
      if (type == 'text')
        value = defaultValue;
      else
        for (var I = 0; I < options.length; I++)
          options[I].selected = options[I].defaultSelected;
}

function selFloat(pObj, pCountDec, pNeg) {
  with (pObj) {
    var J = -1;
    try {
      var I = parseFloat(eval(value.replace(/,/, '.')));
      if (!isNaN(I) && (pNeg || I >= 0))
        J = I;
    } catch (Err) {}
    var B = J == -1;
    value = B ? defaultValue : J;
    if (pCountDec != -1) {
      var I = Math.pow(10, pCountDec);
      value = Math.round(value * I) / I;
    }
    return B;
  }
}

function selNum(pObj, pMaxLength, pNeg) {
  with (pObj) {
    var J = -1;
    try {
      var I = parseInt(eval(value.replace(/,/, '.')));
      if (!isNaN(I) && (pNeg || I >= 0))
        J = I;
    } catch (Err) {}
    var B = J == -1;
    value = B ? defaultValue : J;
    value = value.substr(0, pMaxLength);
    return B;
  }
}

function selUpperCase(pObj) {
  with (pObj)
    value = value.toUpperCase();
}

function setAllOptSelValues(pObj, pList) {
  for (var I = 0; I < pList.length; I++)
    if (pList[I] != '')
      if (typeof(pObj.length) == 'number') {
        for (var J = 0; J < pObj.length; J++)
          if (pObj[J].value == pList[I])
            pObj[J].checked = true;
      } else if (pObj.value == pList[I])
        pObj.checked = true;
}

function setHtml(pValue, pId) {
  var Elem = elementById(pId);
  if (Elem != null)
    Elem.innerHTML = pValue;
}

function stopEventPropagation(pEvent) {
  if (!pEvent)
    var pEvent = window.event;
  pEvent.cancelBubble = true;
  if (pEvent.stopPropagation)
    pEvent.stopPropagation();
}