/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.ktab.KeyTab;

public class Config {
    private static Config singleton = null;
    private Hashtable stanzaTable;
    private static boolean DEBUG = Krb5.DEBUG;
    private static final int BASE16_0 = 1;
    private static final int BASE16_1 = 16;
    private static final int BASE16_2 = 256;
    private static final int BASE16_3 = 4096;
    private String defaultRealm;

    private static native String getWindowsDirectory();

    public static synchronized Config getInstance() throws KrbException {
        if (singleton == null) {
            singleton = new Config();
        }
        return singleton;
    }

    public static synchronized void refresh() throws KrbException {
        singleton = new Config();
        KeyTab.refresh();
    }

    private Config() throws KrbException {
        String string = AccessController.doPrivileged(new GetPropertyAction("java.security.krb5.kdc"));
        this.defaultRealm = AccessController.doPrivileged(new GetPropertyAction("java.security.krb5.realm"));
        if (string == null && this.defaultRealm != null || this.defaultRealm == null && string != null) {
            throw new KrbException("System property java.security.krb5.kdc and java.security.krb5.realm both must be set or neither must be set.");
        }
        if (string != null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("default_realm", this.defaultRealm);
            string = string.replace(':', ' ');
            hashtable.put("kdc", string);
            this.stanzaTable = new Hashtable();
            this.stanzaTable.put("libdefaults", hashtable);
        } else {
            try {
                Vector vector = this.loadConfigFile();
                this.stanzaTable = this.parseStanzaTable(vector);
            }
            catch (IOException iOException) {
                KrbException krbException = new KrbException("Could not load configuration file " + iOException.getMessage());
                krbException.initCause(iOException);
                throw krbException;
            }
        }
    }

    public int getDefaultIntValue(String string) {
        String string2 = null;
        int n = Integer.MIN_VALUE;
        string2 = this.getDefault(string);
        if (string2 != null) {
            try {
                n = this.parseIntValue(string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (DEBUG) {
                    System.out.println("Exception in getting value of " + string + " " + numberFormatException.getMessage());
                    System.out.println("Setting " + string + " to minimum value");
                }
                n = Integer.MIN_VALUE;
            }
        }
        return n;
    }

    public int getDefaultIntValue(String string, String string2) {
        String string3 = null;
        int n = Integer.MIN_VALUE;
        string3 = this.getDefault(string, string2);
        if (string3 != null) {
            try {
                n = this.parseIntValue(string3);
            }
            catch (NumberFormatException numberFormatException) {
                if (DEBUG) {
                    System.out.println("Exception in getting value of " + string + " in section " + string2 + " " + numberFormatException.getMessage());
                    System.out.println("Setting " + string + " to minimum value");
                }
                n = Integer.MIN_VALUE;
            }
        }
        return n;
    }

    public String getDefault(String string) {
        if (this.stanzaTable == null) {
            return null;
        }
        return this.getDefault(string, this.stanzaTable);
    }

    private String getDefault(String string, Hashtable hashtable) {
        String string2 = null;
        if (this.stanzaTable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Object v = hashtable.get(string3);
                if (v instanceof Hashtable) {
                    string2 = this.getDefault(string, (Hashtable)v);
                    if (string2 == null) continue;
                    return string2;
                }
                if (!string3.equalsIgnoreCase(string)) continue;
                if (v instanceof String) {
                    return (String)hashtable.get(string3);
                }
                if (!(v instanceof Vector)) continue;
                string2 = "";
                int n = ((Vector)v).size();
                for (int i = 0; i < n; ++i) {
                    string2 = i == n - 1 ? string2 + (String)((Vector)v).elementAt(i) : string2 + (String)((Vector)v).elementAt(i) + " ";
                }
                return string2;
            }
        }
        return string2;
    }

    public String getDefault(String string, String string2) {
        String string3 = null;
        if (string.equalsIgnoreCase("kdc") && !string2.equalsIgnoreCase("libdefaults") && AccessController.doPrivileged(new GetPropertyAction("java.security.krb5.kdc")) != null) {
            string3 = this.getDefault("kdc", "libdefaults");
            return string3;
        }
        if (this.stanzaTable != null) {
            Enumeration enumeration = this.stanzaTable.keys();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable;
                Object v;
                String string4 = (String)enumeration.nextElement();
                Hashtable hashtable2 = (Hashtable)this.stanzaTable.get(string4);
                if (string4.equalsIgnoreCase(string2)) {
                    if (!hashtable2.containsKey(string)) continue;
                    return (String)hashtable2.get(string);
                }
                if (!hashtable2.containsKey(string2) || !((v = hashtable2.get(string2)) instanceof Hashtable) || !(hashtable = (Hashtable)v).containsKey(string)) continue;
                Object v2 = hashtable.get(string);
                if (v2 instanceof Vector) {
                    string3 = "";
                    int n = ((Vector)v2).size();
                    for (int i = 0; i < n; ++i) {
                        string3 = i == n - 1 ? string3 + (String)((Vector)v2).elementAt(i) : string3 + (String)((Vector)v2).elementAt(i) + " ";
                    }
                    continue;
                }
                string3 = (String)v2;
            }
        }
        return string3;
    }

    public boolean getDefaultBooleanValue(String string) {
        String string2 = null;
        string2 = this.stanzaTable == null ? null : this.getDefault(string, this.stanzaTable);
        return string2 != null && string2.equalsIgnoreCase("true");
    }

    public boolean getDefaultBooleanValue(String string, String string2) {
        String string3 = this.getDefault(string, string2);
        return string3 != null && string3.equalsIgnoreCase("true");
    }

    private int parseIntValue(String string) throws NumberFormatException {
        int n = 0;
        if (string.startsWith("+")) {
            String string2 = string.substring(1);
            return Integer.parseInt(string2);
        }
        if (string.startsWith("0x")) {
            String string3 = string.substring(2);
            char[] cArray = string3.toCharArray();
            if (cArray.length > 8) {
                throw new NumberFormatException();
            }
            block18: for (int i = 0; i < cArray.length; ++i) {
                int n2 = cArray.length - i - 1;
                switch (cArray[i]) {
                    case '0': {
                        n += 0;
                        continue block18;
                    }
                    case '1': {
                        n += 1 * this.getBase(n2);
                        continue block18;
                    }
                    case '2': {
                        n += 2 * this.getBase(n2);
                        continue block18;
                    }
                    case '3': {
                        n += 3 * this.getBase(n2);
                        continue block18;
                    }
                    case '4': {
                        n += 4 * this.getBase(n2);
                        continue block18;
                    }
                    case '5': {
                        n += 5 * this.getBase(n2);
                        continue block18;
                    }
                    case '6': {
                        n += 6 * this.getBase(n2);
                        continue block18;
                    }
                    case '7': {
                        n += 7 * this.getBase(n2);
                        continue block18;
                    }
                    case '8': {
                        n += 8 * this.getBase(n2);
                        continue block18;
                    }
                    case '9': {
                        n += 9 * this.getBase(n2);
                        continue block18;
                    }
                    case 'A': 
                    case 'a': {
                        n += 10 * this.getBase(n2);
                        continue block18;
                    }
                    case 'B': 
                    case 'b': {
                        n += 11 * this.getBase(n2);
                        continue block18;
                    }
                    case 'C': 
                    case 'c': {
                        n += 12 * this.getBase(n2);
                        continue block18;
                    }
                    case 'D': 
                    case 'd': {
                        n += 13 * this.getBase(n2);
                        continue block18;
                    }
                    case 'E': 
                    case 'e': {
                        n += 14 * this.getBase(n2);
                        continue block18;
                    }
                    case 'F': 
                    case 'f': {
                        n += 15 * this.getBase(n2);
                        continue block18;
                    }
                    default: {
                        throw new NumberFormatException("Invalid numerical format");
                    }
                }
            }
            if (n < 0) {
                throw new NumberFormatException("Data overflow.");
            }
        } else {
            n = Integer.parseInt(string);
        }
        return n;
    }

    private int getBase(int n) {
        int n2 = 16;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 16;
                break;
            }
            case 2: {
                n2 = 256;
                break;
            }
            case 3: {
                n2 = 4096;
                break;
            }
            default: {
                for (int i = 1; i < n; ++i) {
                    n2 *= 16;
                }
            }
        }
        return n2;
    }

    private String find(String string, String string2) {
        String string3;
        if (this.stanzaTable != null && (string3 = (String)((Hashtable)this.stanzaTable.get(string)).get(string2)) != null) {
            return string3;
        }
        return "";
    }

    private Vector loadConfigFile() throws IOException {
        try {
            final String string = this.getFileName();
            if (!string.equals("")) {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new FileInputStream(string);
                    }
                })));
                Vector<String> vector = new Vector<String>();
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.startsWith("#")) continue;
                    vector.addElement(string2.trim());
                }
                bufferedReader.close();
                return vector;
            }
            return null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private Hashtable parseStanzaTable(Vector vector) throws KrbException {
        if (vector == null) {
            throw new KrbException("I/O error while reading configuration file.");
        }
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        block0: for (int i = 0; i < vector.size(); ++i) {
            String string = ((String)vector.elementAt(i)).trim();
            if (string.equalsIgnoreCase("[realms]")) {
                for (int j = i + 1; j < vector.size() + 1; ++j) {
                    if (j != vector.size() && !((String)vector.elementAt(j)).startsWith("[")) continue;
                    Hashtable hashtable2 = new Hashtable();
                    hashtable2 = this.parseRealmField(vector, i + 1, j);
                    hashtable.put("realms", hashtable2);
                    i = j - 1;
                    continue block0;
                }
                continue;
            }
            if (string.equalsIgnoreCase("[capaths]")) {
                for (int j = i + 1; j < vector.size() + 1; ++j) {
                    if (j != vector.size() && !((String)vector.elementAt(j)).startsWith("[")) continue;
                    Hashtable hashtable3 = new Hashtable();
                    hashtable3 = this.parseRealmField(vector, i + 1, j);
                    hashtable.put("capaths", hashtable3);
                    i = j - 1;
                    continue block0;
                }
                continue;
            }
            if (!string.startsWith("[") || !string.endsWith("]")) continue;
            String string2 = string.substring(1, string.length() - 1);
            for (int j = i + 1; j < vector.size() + 1; ++j) {
                if (j != vector.size() && !((String)vector.elementAt(j)).startsWith("[")) continue;
                Hashtable hashtable4 = this.parseField(vector, i + 1, j);
                hashtable.put(string2, hashtable4);
                i = j - 1;
                continue block0;
            }
        }
        return hashtable;
    }

    private String getFileName() {
        String string = AccessController.doPrivileged(new GetPropertyAction("java.security.krb5.conf"));
        if (string != null) {
            Boolean bl = (Boolean)AccessController.doPrivileged(new FileExistsAction(string));
            if (bl.booleanValue()) {
                return string;
            }
        } else {
            string = AccessController.doPrivileged(new GetPropertyAction("java.home")) + File.separator + "lib" + File.separator + "security" + File.separator + "krb5.conf";
            Boolean bl = (Boolean)AccessController.doPrivileged(new FileExistsAction(string));
            if (bl.booleanValue()) {
                return string;
            }
            String string2 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string2.startsWith("Windows")) {
                try {
                    Credentials.ensureLoaded();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = Credentials.alreadyLoaded ? ((string = Config.getWindowsDirectory()) == null ? "c:\\winnt\\krb5.ini" : (string.endsWith("\\") ? string + "krb5.ini" : string + "\\krb5.ini")) : "c:\\winnt\\krb5.ini";
            } else if (string2.startsWith("SunOS")) {
                string = "/etc/krb5/krb5.conf";
            } else if (string2.startsWith("Linux")) {
                string = "/etc/krb5.conf";
            }
        }
        if (DEBUG) {
            System.out.println("Config name: " + string);
        }
        return string;
    }

    private Hashtable parseField(Vector vector, int n, int n2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        block0: for (int i = n; i < n2; ++i) {
            String string = (String)vector.elementAt(i);
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) != '=') continue;
                String string2 = string.substring(0, j).trim();
                String string3 = string.substring(j + 1).trim();
                hashtable.put(string2, string3);
                continue block0;
            }
        }
        return hashtable;
    }

    private Hashtable parseRealmField(Vector vector, int n, int n2) {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        block0: for (int i = n; i < n2; ++i) {
            int n3;
            String string = ((String)vector.elementAt(i)).trim();
            if (!string.endsWith("{")) continue;
            String string2 = "";
            for (n3 = 0; n3 < string.length(); ++n3) {
                if (string.charAt(n3) != '=') continue;
                string2 = string.substring(0, n3).trim();
                break;
            }
            for (n3 = i + 1; n3 < n2; ++n3) {
                boolean bl = false;
                string = ((String)vector.elementAt(n3)).trim();
                for (int j = 0; j < string.length(); ++j) {
                    if (string.charAt(j) != '}') continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                Hashtable hashtable2 = this.parseRealmFieldEx(vector, i + 1, n3);
                hashtable.put(string2, hashtable2);
                i = n3;
                bl = false;
                continue block0;
            }
        }
        return hashtable;
    }

    private Hashtable parseRealmFieldEx(Vector vector, int n, int n2) {
        Hashtable hashtable = new Hashtable();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        String string = "";
        block0: for (int i = n; i < n2; ++i) {
            string = (String)vector.elementAt(i);
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) != '=') continue;
                String string2 = string.substring(0, j - 1).trim();
                if (!this.exists(string2, vector2)) {
                    vector2.addElement(string2);
                    vector3 = new Vector<String>();
                } else {
                    vector3 = (Vector<String>)hashtable.get(string2);
                }
                vector3.addElement(string.substring(j + 1).trim());
                hashtable.put(string2, vector3);
                continue block0;
            }
        }
        return hashtable;
    }

    private boolean exists(String string, Vector vector) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            if (!((String)vector.elementAt(i)).equals(string)) continue;
            bl = true;
        }
        return bl;
    }

    public void listTable() {
        this.listTable(this.stanzaTable);
    }

    private void listTable(Hashtable hashtable) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (this.stanzaTable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = hashtable.get(string);
                if (hashtable == this.stanzaTable) {
                    System.out.println("[" + string + "]");
                }
                if (v instanceof Hashtable) {
                    if (hashtable != this.stanzaTable) {
                        System.out.println("\t" + string + " = {");
                    }
                    this.listTable((Hashtable)v);
                    if (hashtable == this.stanzaTable) continue;
                    System.out.println("\t}");
                    continue;
                }
                if (v instanceof String) {
                    System.out.println("\t" + string + " = " + (String)hashtable.get(string));
                    continue;
                }
                if (!(v instanceof Vector)) continue;
                vector = (Vector)v;
                for (int i = 0; i < vector.size(); ++i) {
                    System.out.println("\t" + string + " = " + (String)vector.elementAt(i));
                }
            }
        } else {
            System.out.println("Configuration file not found.");
        }
    }

    public int[] defaultEtype(String string) {
        int n;
        int[] nArray;
        String string2 = this.getDefault(string, "libdefaults");
        String string3 = " ";
        if (string2 == null) {
            if (DEBUG) {
                System.out.println("Using builtin default etypes for " + string);
            }
            nArray = EType.getBuiltInDefaults();
        } else {
            int n2;
            for (n = 0; n < string2.length(); ++n) {
                if (!string2.substring(n, n + 1).equals(",")) continue;
                string3 = ",";
                break;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            n = stringTokenizer.countTokens();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
            for (n2 = 0; n2 < n; ++n2) {
                int n3 = this.getType(stringTokenizer.nextToken());
                if (n3 == -1 || !EType.isSupported(n3)) continue;
                arrayList.add(new Integer(n3));
            }
            if (arrayList.size() == 0) {
                if (DEBUG) {
                    System.out.println("no supported default etypes for " + string);
                }
                return null;
            }
            nArray = new int[arrayList.size()];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = (Integer)arrayList.get(n2);
            }
        }
        if (DEBUG) {
            System.out.print("default etypes for " + string + ":");
            for (n = 0; n < nArray.length; ++n) {
                System.out.print(" " + nArray[n]);
            }
            System.out.println(".");
        }
        return nArray;
    }

    public int getType(String string) {
        int n = -1;
        if (string == null) {
            return n;
        }
        if (string.startsWith("d") || string.startsWith("D")) {
            if (string.equalsIgnoreCase("des-cbc-crc")) {
                n = 1;
            } else if (string.equalsIgnoreCase("des-cbc-md5")) {
                n = 3;
            } else if (string.equalsIgnoreCase("des-mac")) {
                n = 4;
            } else if (string.equalsIgnoreCase("des-mac-k")) {
                n = 5;
            } else if (string.equalsIgnoreCase("des-cbc-md4")) {
                n = 2;
            } else if (string.equalsIgnoreCase("des3-cbc-sha1") || string.equalsIgnoreCase("des3-hmac-sha1") || string.equalsIgnoreCase("des3-cbc-sha1-kd") || string.equalsIgnoreCase("des3-cbc-hmac-sha1-kd")) {
                n = 16;
            }
        } else if (string.startsWith("a") || string.startsWith("A")) {
            if (string.equalsIgnoreCase("aes128-cts") || string.equalsIgnoreCase("aes128-cts-hmac-sha1-96")) {
                n = 17;
            } else if (string.equalsIgnoreCase("aes256-cts") || string.equalsIgnoreCase("aes256-cts-hmac-sha1-96")) {
                n = 18;
            } else if (string.equalsIgnoreCase("arcfour-hmac") || string.equalsIgnoreCase("arcfour-hmac-md5")) {
                n = 23;
            }
        } else if (string.equalsIgnoreCase("rc4-hmac")) {
            n = 23;
        } else if (string.equalsIgnoreCase("CRC32")) {
            n = 1;
        } else if (string.startsWith("r") || string.startsWith("R")) {
            if (string.equalsIgnoreCase("rsa-md5")) {
                n = 7;
            } else if (string.equalsIgnoreCase("rsa-md5-des")) {
                n = 8;
            }
        } else if (string.equalsIgnoreCase("hmac-sha1-des3-kd")) {
            n = 12;
        } else if (string.equalsIgnoreCase("hmac-sha1-96-aes128")) {
            n = 15;
        } else if (string.equalsIgnoreCase("hmac-sha1-96-aes256")) {
            n = 16;
        } else if (string.equalsIgnoreCase("hmac-md5-rc4") || string.equalsIgnoreCase("hmac-md5-arcfour") || string.equalsIgnoreCase("hmac-md5-enc")) {
            n = -138;
        } else if (string.equalsIgnoreCase("NULL")) {
            n = 0;
        }
        return n;
    }

    public void resetDefaultRealm(String string) {
        this.defaultRealm = string;
        if (DEBUG) {
            System.out.println(">>> Config reset default kdc " + this.defaultRealm);
        }
    }

    public String getDefaultRealm() {
        return this.getDefault("default_realm", "libdefaults");
    }

    public String getKDCList(String string) {
        String string2;
        if (string == null) {
            string = this.getDefaultRealm();
        }
        if ((string2 = this.getDefault("kdc", string)) == null) {
            return null;
        }
        return string2;
    }

    static class FileExistsAction
    implements PrivilegedAction {
        private String fileName;

        public FileExistsAction(String string) {
            this.fileName = string;
        }

        public Object run() {
            return new Boolean(new File(this.fileName).exists());
        }
    }
}

