/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.Rectangle;
import sun.java2d.pipe.RegionClipSpanIterator;
import sun.java2d.pipe.RegionIterator;
import sun.java2d.pipe.RegionSpanIterator;
import sun.java2d.pipe.SpanIterator;

public class Region {
    public static final int INIT_SIZE = 50;
    public static final int GROW_SIZE = 50;
    int lox;
    int loy;
    int hix;
    int hiy;
    int endIndex;
    int[] bands;

    private static native void initIDs();

    public static int dimAdd(int n, int n2) {
        if (n2 <= 0) {
            return n;
        }
        if ((n2 += n) < n) {
            return Integer.MAX_VALUE;
        }
        return n2;
    }

    private Region(int n, int n2, int n3, int n4) {
        this.lox = n;
        this.loy = n2;
        this.hix = n3;
        this.hiy = n4;
    }

    public static Region getInstance(Rectangle rectangle) {
        return Region.getInstanceXYWH(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static Region getInstanceXYWH(int n, int n2, int n3, int n4) {
        return Region.getInstanceXYXY(n, n2, Region.dimAdd(n, n3), Region.dimAdd(n2, n4));
    }

    public static Region getInstance(int[] nArray) {
        return new Region(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static Region getInstanceXYXY(int n, int n2, int n3, int n4) {
        return new Region(n, n2, n3, n4);
    }

    public void setOutputArea(Rectangle rectangle) {
        this.setOutputAreaXYWH(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setOutputAreaXYWH(int n, int n2, int n3, int n4) {
        this.setOutputAreaXYXY(n, n2, Region.dimAdd(n, n3), Region.dimAdd(n2, n4));
    }

    public void setOutputArea(int[] nArray) {
        this.lox = nArray[0];
        this.loy = nArray[1];
        this.hix = nArray[2];
        this.hiy = nArray[3];
    }

    public void setOutputAreaXYXY(int n, int n2, int n3, int n4) {
        this.lox = n;
        this.loy = n2;
        this.hix = n3;
        this.hiy = n4;
    }

    public void appendSpans(SpanIterator spanIterator) {
        int[] nArray = new int[6];
        while (spanIterator.nextSpan(nArray)) {
            this.appendSpan(nArray);
        }
        this.endRow(nArray);
        this.calcBBox();
    }

    public Region getIntersection(Rectangle rectangle) {
        return this.getIntersectionXYWH(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Region getIntersectionXYWH(int n, int n2, int n3, int n4) {
        return this.getIntersectionXYXY(n, n2, Region.dimAdd(n, n3), Region.dimAdd(n2, n4));
    }

    public Region getIntersectionXYXY(int n, int n2, int n3, int n4) {
        if (this.isInsideXYXY(n, n2, n3, n4)) {
            return this;
        }
        Region region = new Region(n < this.lox ? this.lox : n, n2 < this.loy ? this.loy : n2, n3 > this.hix ? this.hix : n3, n4 > this.hiy ? this.hiy : n4);
        if (this.bands != null) {
            region.appendSpans(this.getSpanIterator());
        }
        return region;
    }

    public Region getIntersection(Region region) {
        if (this.isInsideQuickCheck(region)) {
            return this;
        }
        if (region.isInsideQuickCheck(this)) {
            return region;
        }
        Region region2 = new Region(region.lox < this.lox ? this.lox : region.lox, region.loy < this.loy ? this.loy : region.loy, region.hix > this.hix ? this.hix : region.hix, region.hiy > this.hiy ? this.hiy : region.hiy);
        SpanIterator spanIterator = null;
        if (this.bands != null) {
            spanIterator = this.getSpanIterator();
        }
        if (region.bands != null) {
            SpanIterator spanIterator2 = spanIterator = spanIterator == null ? region.getSpanIterator() : region.filter(spanIterator);
        }
        if (spanIterator != null) {
            region2.appendSpans(spanIterator);
        }
        return region2;
    }

    public Region getBoundsIntersection(Rectangle rectangle) {
        return this.getBoundsIntersectionXYWH(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Region getBoundsIntersectionXYWH(int n, int n2, int n3, int n4) {
        return this.getBoundsIntersectionXYXY(n, n2, Region.dimAdd(n, n3), Region.dimAdd(n2, n4));
    }

    public Region getBoundsIntersectionXYXY(int n, int n2, int n3, int n4) {
        if (this.bands == null && this.lox >= n && this.loy >= n2 && this.hix <= n3 && this.hiy <= n4) {
            return this;
        }
        return new Region(n < this.lox ? this.lox : n, n2 < this.loy ? this.loy : n2, n3 > this.hix ? this.hix : n3, n4 > this.hiy ? this.hiy : n4);
    }

    public Region getBoundsIntersection(Region region) {
        if (this.encompasses(region)) {
            return region;
        }
        if (region.encompasses(this)) {
            return this;
        }
        return new Region(region.lox < this.lox ? this.lox : region.lox, region.loy < this.loy ? this.loy : region.loy, region.hix > this.hix ? this.hix : region.hix, region.hiy > this.hiy ? this.hiy : region.hiy);
    }

    private void appendSpan(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = nArray[0];
        if (n4 < this.lox) {
            n4 = this.lox;
        }
        if ((n3 = nArray[1]) < this.loy) {
            n3 = this.loy;
        }
        if ((n2 = nArray[2]) > this.hix) {
            n2 = this.hix;
        }
        if ((n = nArray[3]) > this.hiy) {
            n = this.hiy;
        }
        if (n2 <= n4 || n <= n3) {
            return;
        }
        int n5 = nArray[4];
        if (this.endIndex == 0 || n3 >= this.bands[n5 + 1]) {
            if (this.bands == null) {
                this.bands = new int[50];
            } else {
                this.needSpace(5);
                this.endRow(nArray);
                n5 = nArray[4];
            }
            this.bands[this.endIndex++] = n3;
            this.bands[this.endIndex++] = n;
            this.bands[this.endIndex++] = 0;
        } else if (n3 == this.bands[n5] && n == this.bands[n5 + 1] && n4 >= this.bands[this.endIndex - 1]) {
            if (n4 == this.bands[this.endIndex - 1]) {
                this.bands[this.endIndex - 1] = n2;
                return;
            }
            this.needSpace(2);
        } else {
            throw new InternalError("bad span");
        }
        this.bands[this.endIndex++] = n4;
        this.bands[this.endIndex++] = n2;
        int n6 = n5 + 2;
        this.bands[n6] = this.bands[n6] + 1;
    }

    private void needSpace(int n) {
        if (this.endIndex + n >= this.bands.length) {
            int[] nArray = new int[this.bands.length + 50];
            System.arraycopy(this.bands, 0, nArray, 0, this.endIndex);
            this.bands = nArray;
        }
    }

    private void endRow(int[] nArray) {
        int[] nArray2;
        int n = nArray[4];
        int n2 = nArray[5];
        if (n > n2 && (nArray2 = this.bands)[n2 + 1] == nArray2[n] && nArray2[n2 + 2] == nArray2[n + 2]) {
            int n3 = nArray2[n + 2] * 2;
            n += 3;
            n2 += 3;
            while (n3 > 0 && nArray2[n++] == nArray2[n2++]) {
                --n3;
            }
            if (n3 == 0) {
                nArray2[nArray[5] + 1] = nArray2[n2 + 1];
                this.endIndex = n2;
                return;
            }
        }
        nArray[5] = nArray[4];
        nArray[4] = this.endIndex;
    }

    private void calcBBox() {
        int[] nArray = this.bands;
        if (this.endIndex <= 5) {
            if (this.endIndex == 0) {
                this.hiy = 0;
                this.hix = 0;
                this.loy = 0;
                this.lox = 0;
            } else {
                this.loy = nArray[0];
                this.hiy = nArray[1];
                this.lox = nArray[3];
                this.hix = nArray[4];
                this.endIndex = 0;
            }
            this.bands = null;
            return;
        }
        int n = this.hix;
        int n2 = this.lox;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.endIndex) {
            n3 = n4;
            int n5 = nArray[n4 + 2];
            if (n > nArray[n4 += 3]) {
                n = nArray[n4];
            }
            if (n2 >= nArray[(n4 += n5 * 2) - 1]) continue;
            n2 = nArray[n4 - 1];
        }
        this.lox = n;
        this.loy = nArray[0];
        this.hix = n2;
        this.hiy = nArray[n3 + 1];
    }

    public final int getLoX() {
        return this.lox;
    }

    public final int getLoY() {
        return this.loy;
    }

    public final int getHiX() {
        return this.hix;
    }

    public final int getHiY() {
        return this.hiy;
    }

    public final int getWidth() {
        if (this.hix < this.lox) {
            return 0;
        }
        int n = this.hix - this.lox;
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    public final int getHeight() {
        if (this.hiy < this.loy) {
            return 0;
        }
        int n = this.hiy - this.loy;
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.hix <= this.lox || this.hiy <= this.loy;
    }

    public boolean isRectangular() {
        return this.bands == null;
    }

    public boolean isInsideXYWH(int n, int n2, int n3, int n4) {
        return this.isInsideXYXY(n, n2, Region.dimAdd(n, n3), Region.dimAdd(n2, n4));
    }

    public boolean isInsideXYXY(int n, int n2, int n3, int n4) {
        return this.lox >= n && this.loy >= n2 && this.hix <= n3 && this.hiy <= n4;
    }

    public boolean isInsideQuickCheck(Region region) {
        return region.bands == null && region.lox <= this.lox && region.loy <= this.loy && region.hix >= this.hix && region.hiy >= this.hiy;
    }

    public boolean intersectsQuickCheckXYXY(int n, int n2, int n3, int n4) {
        return n3 > this.lox && n < this.hix && n4 > this.loy && n2 < this.hiy;
    }

    public boolean encompasses(Region region) {
        return this.bands == null && this.lox <= region.lox && this.loy <= region.loy && this.hix >= region.hix && this.hiy >= region.hiy;
    }

    public boolean encompassesXYWH(int n, int n2, int n3, int n4) {
        return this.encompassesXYXY(n, n2, Region.dimAdd(n, n3), Region.dimAdd(n2, n4));
    }

    public boolean encompassesXYXY(int n, int n2, int n3, int n4) {
        return this.bands == null && this.lox <= n && this.loy <= n2 && this.hix >= n3 && this.hiy >= n4;
    }

    public void getBounds(int[] nArray) {
        nArray[0] = this.lox;
        nArray[1] = this.loy;
        nArray[2] = this.hix;
        nArray[3] = this.hiy;
    }

    public void clipBoxToBounds(int[] nArray) {
        if (nArray[0] < this.lox) {
            nArray[0] = this.lox;
        }
        if (nArray[1] < this.loy) {
            nArray[1] = this.loy;
        }
        if (nArray[2] > this.hix) {
            nArray[2] = this.hix;
        }
        if (nArray[3] > this.hiy) {
            nArray[3] = this.hiy;
        }
    }

    public RegionIterator getIterator() {
        return new RegionIterator(this);
    }

    public SpanIterator getSpanIterator() {
        return new RegionSpanIterator(this);
    }

    public SpanIterator getSpanIterator(int[] nArray) {
        SpanIterator spanIterator = this.getSpanIterator();
        spanIterator.intersectClipBox(nArray[0], nArray[1], nArray[2], nArray[3]);
        return spanIterator;
    }

    public SpanIterator filter(SpanIterator spanIterator) {
        if (this.bands == null) {
            spanIterator.intersectClipBox(this.lox, this.loy, this.hix, this.hiy);
        } else {
            spanIterator = new RegionClipSpanIterator(this, spanIterator);
        }
        return spanIterator;
    }

    static {
        Region.initIDs();
    }
}

