/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import sun.font.GlyphList;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.DrawGlyphList;
import sun.java2d.loops.DrawGlyphListAA;
import sun.java2d.loops.DrawLine;
import sun.java2d.loops.DrawPath;
import sun.java2d.loops.DrawPolygons;
import sun.java2d.loops.DrawRect;
import sun.java2d.loops.FillPath;
import sun.java2d.loops.FillRect;
import sun.java2d.loops.FillSpans;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.GraphicsPrimitiveProxy;
import sun.java2d.loops.PixelWriter;
import sun.java2d.loops.SolidPixelWriter;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.XORComposite;
import sun.java2d.loops.XorPixelWriter;
import sun.java2d.pipe.Region;

public final class GeneralRenderer {
    static final int OUTCODE_TOP = 1;
    static final int OUTCODE_BOTTOM = 2;
    static final int OUTCODE_LEFT = 4;
    static final int OUTCODE_RIGHT = 8;

    public static void register() {
        Class<GeneralRenderer> clazz = GeneralRenderer.class;
        GraphicsPrimitive[] graphicsPrimitiveArray = new GraphicsPrimitive[]{new GraphicsPrimitiveProxy(clazz, "SetFillRectANY", FillRect.methodSignature, FillRect.primTypeID, SurfaceType.AnyColor, CompositeType.SrcNoEa, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "SetFillPathANY", FillPath.methodSignature, FillPath.primTypeID, SurfaceType.AnyColor, CompositeType.SrcNoEa, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "SetFillSpansANY", FillSpans.methodSignature, FillSpans.primTypeID, SurfaceType.AnyColor, CompositeType.SrcNoEa, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "SetDrawLineANY", DrawLine.methodSignature, DrawLine.primTypeID, SurfaceType.AnyColor, CompositeType.SrcNoEa, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "SetDrawPolygonsANY", DrawPolygons.methodSignature, DrawPolygons.primTypeID, SurfaceType.AnyColor, CompositeType.SrcNoEa, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "SetDrawPathANY", DrawPath.methodSignature, DrawPath.primTypeID, SurfaceType.AnyColor, CompositeType.SrcNoEa, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "SetDrawRectANY", DrawRect.methodSignature, DrawRect.primTypeID, SurfaceType.AnyColor, CompositeType.SrcNoEa, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorFillRectANY", FillRect.methodSignature, FillRect.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorFillPathANY", FillPath.methodSignature, FillPath.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorFillSpansANY", FillSpans.methodSignature, FillSpans.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorDrawLineANY", DrawLine.methodSignature, DrawLine.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorDrawPolygonsANY", DrawPolygons.methodSignature, DrawPolygons.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorDrawPathANY", DrawPath.methodSignature, DrawPath.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorDrawRectANY", DrawRect.methodSignature, DrawRect.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorDrawGlyphListANY", DrawGlyphList.methodSignature, DrawGlyphList.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorDrawGlyphListAAANY", DrawGlyphListAA.methodSignature, DrawGlyphListAA.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any)};
        GraphicsPrimitiveMgr.register(graphicsPrimitiveArray);
    }

    static void doDrawPoly(SurfaceData surfaceData, PixelWriter pixelWriter, int[] nArray, int[] nArray2, int n, int n2, Region region, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        int[] nArray3 = null;
        int n7 = n6 = nArray[n] + n3;
        int n8 = n5 = nArray2[n] + n4;
        while (--n2 > 0) {
            int n9 = nArray[++n] + n3;
            int n10 = nArray2[n] + n4;
            nArray3 = GeneralRenderer.doDrawLine(surfaceData, pixelWriter, nArray3, region, n6, n5, n9, n10);
            n6 = n9;
            n5 = n10;
        }
        if (bl && (n6 != n7 || n5 != n8)) {
            nArray3 = GeneralRenderer.doDrawLine(surfaceData, pixelWriter, nArray3, region, n6, n5, n7, n8);
        }
    }

    static void doSetRect(SurfaceData surfaceData, PixelWriter pixelWriter, int n, int n2, int n3, int n4) {
        WritableRaster writableRaster = (WritableRaster)surfaceData.getRaster(n, n2, n3 - n, n4 - n2);
        pixelWriter.setRaster(writableRaster);
        while (n2 < n4) {
            for (int i = n; i < n3; ++i) {
                pixelWriter.writePixel(i, n2);
            }
            ++n2;
        }
    }

    static int[] doDrawLine(SurfaceData surfaceData, PixelWriter pixelWriter, int[] nArray, Region region, int n, int n2, int n3, int n4) {
        if (nArray == null) {
            nArray = new int[8];
        }
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
        nArray[3] = n4;
        if (!GeneralRenderer.adjustLine(nArray, region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY())) {
            return nArray;
        }
        int n5 = nArray[0];
        int n6 = nArray[1];
        int n7 = nArray[2];
        int n8 = nArray[3];
        WritableRaster writableRaster = (WritableRaster)surfaceData.getRaster(Math.min(n5, n7), Math.min(n6, n8), Math.abs(n5 - n7) + 1, Math.abs(n6 - n8) + 1);
        pixelWriter.setRaster(writableRaster);
        if (n5 == n7) {
            if (n6 > n8) {
                do {
                    pixelWriter.writePixel(n5, n6);
                } while (--n6 >= n8);
            } else {
                do {
                    pixelWriter.writePixel(n5, n6);
                } while (++n6 <= n8);
            }
        } else if (n6 == n8) {
            if (n5 > n7) {
                do {
                    pixelWriter.writePixel(n5, n6);
                } while (--n5 >= n7);
            } else {
                do {
                    pixelWriter.writePixel(n5, n6);
                } while (++n5 <= n7);
            }
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            boolean bl;
            int n15 = nArray[4];
            int n16 = nArray[5];
            int n17 = nArray[6];
            int n18 = nArray[7];
            if (n17 >= n18) {
                bl = true;
                n14 = n18 * 2;
                n13 = n17 * 2;
                n12 = n15 < 0 ? -1 : 1;
                n11 = n16 < 0 ? -1 : 1;
                n17 = -n17;
                n10 = n7 - n5;
            } else {
                bl = false;
                n14 = n17 * 2;
                n13 = n18 * 2;
                n12 = n16 < 0 ? -1 : 1;
                n11 = n15 < 0 ? -1 : 1;
                n18 = -n18;
                n10 = n8 - n6;
            }
            int n19 = -(n13 / 2);
            if (n6 != n2) {
                n9 = n6 - n2;
                if (n9 < 0) {
                    n9 = -n9;
                }
                n19 += n9 * n17 * 2;
            }
            if (n5 != n) {
                n9 = n5 - n;
                if (n9 < 0) {
                    n9 = -n9;
                }
                n19 += n9 * n18 * 2;
            }
            if (n10 < 0) {
                n10 = -n10;
            }
            if (bl) {
                do {
                    pixelWriter.writePixel(n5, n6);
                    n5 += n12;
                    if ((n19 += n14) < 0) continue;
                    n6 += n11;
                    n19 -= n13;
                } while (--n10 >= 0);
            } else {
                do {
                    pixelWriter.writePixel(n5, n6);
                    n6 += n12;
                    if ((n19 += n14) < 0) continue;
                    n5 += n11;
                    n19 -= n13;
                } while (--n10 >= 0);
            }
        }
        return nArray;
    }

    public static void doDrawRect(PixelWriter pixelWriter, SunGraphics2D sunGraphics2D, SurfaceData surfaceData, int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0) {
            return;
        }
        int n5 = Region.dimAdd(Region.dimAdd(n, n3), 1);
        int n6 = Region.dimAdd(Region.dimAdd(n2, n4), 1);
        Region region = sunGraphics2D.getCompClip().getBoundsIntersectionXYXY(n, n2, n5, n6);
        if (region.isEmpty()) {
            return;
        }
        int n7 = region.getLoX();
        int n8 = region.getLoY();
        int n9 = region.getHiX();
        int n10 = region.getHiY();
        if (n3 < 2 || n4 < 2) {
            GeneralRenderer.doSetRect(surfaceData, pixelWriter, n7, n8, n9, n10);
            return;
        }
        if (n8 == n2) {
            GeneralRenderer.doSetRect(surfaceData, pixelWriter, n7, n8, n9, n8 + 1);
        }
        if (n7 == n) {
            GeneralRenderer.doSetRect(surfaceData, pixelWriter, n7, n8 + 1, n7 + 1, n10 - 1);
        }
        if (n9 == n5) {
            GeneralRenderer.doSetRect(surfaceData, pixelWriter, n9 - 1, n8 + 1, n9, n10 - 1);
        }
        if (n10 == n6) {
            GeneralRenderer.doSetRect(surfaceData, pixelWriter, n7, n10 - 1, n9, n10);
        }
    }

    static void doDrawGlyphList(SurfaceData surfaceData, PixelWriter pixelWriter, GlyphList glyphList, Region region) {
        int[] nArray = glyphList.getBounds();
        region.clipBoxToBounds(nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        WritableRaster writableRaster = (WritableRaster)surfaceData.getRaster(n, n2, n3 - n, n4 - n2);
        pixelWriter.setRaster(writableRaster);
        int n5 = glyphList.getNumGlyphs();
        for (int i = 0; i < n5; ++i) {
            glyphList.setGlyphIndex(i);
            int[] nArray2 = glyphList.getMetrics();
            int n6 = nArray2[0];
            int n7 = nArray2[1];
            int n8 = nArray2[2];
            int n9 = n6 + n8;
            int n10 = n7 + nArray2[3];
            int n11 = 0;
            if (n6 < n) {
                n11 = n - n6;
                n6 = n;
            }
            if (n7 < n2) {
                n11 += (n2 - n7) * n8;
                n7 = n2;
            }
            if (n9 > n3) {
                n9 = n3;
            }
            if (n10 > n4) {
                n10 = n4;
            }
            if (n9 <= n6 || n10 <= n7) continue;
            byte[] byArray = glyphList.getGrayBits();
            n8 -= n9 - n6;
            for (int j = n7; j < n10; ++j) {
                for (int k = n6; k < n9; ++k) {
                    if (byArray[n11++] >= 0) continue;
                    pixelWriter.writePixel(k, j);
                }
                n11 += n8;
            }
        }
    }

    static int outcode(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2 < n4 ? 1 : (n2 > n6 ? 2 : 0);
        if (n < n3) {
            n7 |= 4;
        } else if (n > n5) {
            n7 |= 8;
        }
        return n7;
    }

    public static boolean adjustLine(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = n3 - 1;
        int n6 = n4 - 1;
        int n7 = nArray[0];
        int n8 = nArray[1];
        int n9 = nArray[2];
        int n10 = nArray[3];
        if (n5 < n || n6 < n2) {
            return false;
        }
        if (n7 == n9) {
            if (n7 < n || n7 > n5) {
                return false;
            }
            if (n8 > n10) {
                int n11 = n8;
                n8 = n10;
                n10 = n11;
            }
            if (n8 < n2) {
                n8 = n2;
            }
            if (n10 > n6) {
                n10 = n6;
            }
            if (n8 > n10) {
                return false;
            }
            nArray[1] = n8;
            nArray[3] = n10;
        } else if (n8 == n10) {
            if (n8 < n2 || n8 > n6) {
                return false;
            }
            if (n7 > n9) {
                int n12 = n7;
                n7 = n9;
                n9 = n12;
            }
            if (n7 < n) {
                n7 = n;
            }
            if (n9 > n5) {
                n9 = n5;
            }
            if (n7 > n9) {
                return false;
            }
            nArray[0] = n7;
            nArray[2] = n9;
        } else {
            int n13 = n9 - n7;
            int n14 = n10 - n8;
            int n15 = n13 < 0 ? -n13 : n13;
            int n16 = n14 < 0 ? -n14 : n14;
            boolean bl = n15 >= n16;
            int n17 = GeneralRenderer.outcode(n7, n8, n, n2, n5, n6);
            int n18 = GeneralRenderer.outcode(n9, n10, n, n2, n5, n6);
            while ((n17 | n18) != 0) {
                int n19;
                int n20;
                if ((n17 & n18) != 0) {
                    return false;
                }
                if (n17 != 0) {
                    if (0 != (n17 & 3)) {
                        n8 = 0 != (n17 & 1) ? n2 : n6;
                        n20 = n8 - nArray[1];
                        if (n20 < 0) {
                            n20 = -n20;
                        }
                        n19 = 2 * n20 * n15 + n16;
                        if (bl) {
                            n19 += n16 - n15 - 1;
                        }
                        n19 /= 2 * n16;
                        if (n13 < 0) {
                            n19 = -n19;
                        }
                        n7 = nArray[0] + n19;
                    } else if (0 != (n17 & 0xC)) {
                        n7 = 0 != (n17 & 4) ? n : n5;
                        n19 = n7 - nArray[0];
                        if (n19 < 0) {
                            n19 = -n19;
                        }
                        n20 = 2 * n19 * n16 + n15;
                        if (!bl) {
                            n20 += n15 - n16 - 1;
                        }
                        n20 /= 2 * n15;
                        if (n14 < 0) {
                            n20 = -n20;
                        }
                        n8 = nArray[1] + n20;
                    }
                    n17 = GeneralRenderer.outcode(n7, n8, n, n2, n5, n6);
                    continue;
                }
                if (0 != (n18 & 3)) {
                    n10 = 0 != (n18 & 1) ? n2 : n6;
                    n20 = n10 - nArray[3];
                    if (n20 < 0) {
                        n20 = -n20;
                    }
                    n19 = 2 * n20 * n15 + n16;
                    n19 = bl ? (n19 += n16 - n15) : --n19;
                    n19 /= 2 * n16;
                    if (n13 > 0) {
                        n19 = -n19;
                    }
                    n9 = nArray[2] + n19;
                } else if (0 != (n18 & 0xC)) {
                    n9 = 0 != (n18 & 4) ? n : n5;
                    n19 = n9 - nArray[2];
                    if (n19 < 0) {
                        n19 = -n19;
                    }
                    n20 = 2 * n19 * n16 + n15;
                    n20 = bl ? --n20 : (n20 += n15 - n16);
                    n20 /= 2 * n15;
                    if (n14 > 0) {
                        n20 = -n20;
                    }
                    n10 = nArray[3] + n20;
                }
                n18 = GeneralRenderer.outcode(n9, n10, n, n2, n5, n6);
            }
            nArray[0] = n7;
            nArray[1] = n8;
            nArray[2] = n9;
            nArray[3] = n10;
            nArray[4] = n13;
            nArray[5] = n14;
            nArray[6] = n15;
            nArray[7] = n16;
        }
        return true;
    }

    static PixelWriter createSolidPixelWriter(SunGraphics2D sunGraphics2D, SurfaceData surfaceData) {
        ColorModel colorModel = surfaceData.getColorModel();
        Object object = colorModel.getDataElements(sunGraphics2D.eargb, null);
        return new SolidPixelWriter(object);
    }

    static PixelWriter createXorPixelWriter(SunGraphics2D sunGraphics2D, SurfaceData surfaceData) {
        ColorModel colorModel = surfaceData.getColorModel();
        Object object = colorModel.getDataElements(sunGraphics2D.eargb, null);
        XORComposite xORComposite = (XORComposite)sunGraphics2D.getComposite();
        int n = xORComposite.getXorColor().getRGB();
        Object object2 = colorModel.getDataElements(n, null);
        switch (colorModel.getTransferType()) {
            case 0: {
                return new XorPixelWriter.ByteData(object, object2);
            }
            case 1: 
            case 2: {
                return new XorPixelWriter.ShortData(object, object2);
            }
            case 3: {
                return new XorPixelWriter.IntData(object, object2);
            }
            case 4: {
                return new XorPixelWriter.FloatData(object, object2);
            }
            case 5: {
                return new XorPixelWriter.DoubleData(object, object2);
            }
        }
        throw new InternalError("Unsupported XOR pixel type");
    }
}

