/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.bind.DatatypeConverterImpl;
import com.sun.xml.internal.bind.v2.runtime.output.Encoded;
import com.sun.xml.internal.messaging.saaj.packaging.mime.util.OutputUtil;
import com.sun.xml.internal.org.jvnet.staxex.Base64Data;
import com.sun.xml.internal.org.jvnet.staxex.NamespaceContextEx;
import com.sun.xml.internal.org.jvnet.staxex.XMLStreamReaderEx;
import com.sun.xml.internal.org.jvnet.staxex.XMLStreamWriterEx;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.MimeCodec;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import com.sun.xml.internal.ws.encoding.StreamSOAPCodec;
import com.sun.xml.internal.ws.message.MimeAttachmentSet;
import com.sun.xml.internal.ws.message.stream.StreamAttachment;
import com.sun.xml.internal.ws.util.ByteArrayDataSource;
import com.sun.xml.internal.ws.util.xml.XMLStreamReaderFilter;
import com.sun.xml.internal.ws.util.xml.XMLStreamWriterFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;

public class MtomCodec
extends MimeCodec {
    public static final String XOP_XML_MIME_TYPE = "application/xop+xml";
    private final com.sun.xml.internal.ws.api.pipe.StreamSOAPCodec codec;
    private String boundary;
    private final String soapXopContentType;
    private String messageContentType;
    private final MTOMFeature mtomFeature;
    private final List<ByteArrayBuffer> mtomAttachmentStream = new ArrayList<ByteArrayBuffer>();
    private static final byte[] XOP_PREF = MtomCodec.encode("<Include xmlns=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:");
    private static final byte[] XOP_SUFF = MtomCodec.encode("\"/>");
    private static final String XOP_LOCALNAME = "Include";
    private static final String XOP_NAMESPACEURI = "http://www.w3.org/2004/08/xop/include";
    private static final Charset UTF8 = Charset.forName("UTF-8");

    MtomCodec(SOAPVersion sOAPVersion, com.sun.xml.internal.ws.api.pipe.StreamSOAPCodec streamSOAPCodec, WebServiceFeature webServiceFeature) {
        super(sOAPVersion);
        this.codec = streamSOAPCodec;
        this.createConteTypeHeader();
        this.soapXopContentType = "application/xop+xml;charset=utf-8;type=\"" + sOAPVersion.contentType + "\"";
        this.mtomFeature = webServiceFeature == null ? new MTOMFeature() : (MTOMFeature)webServiceFeature;
    }

    private void createConteTypeHeader() {
        this.boundary = "uuid:" + UUID.randomUUID().toString();
        String string = "boundary=\"" + this.boundary + "\"";
        this.messageContentType = "multipart/related;type=\"application/xop+xml\";" + string + ";start-info=\"" + this.version.contentType + "\"";
    }

    public ContentType getStaticContentType(Packet packet) {
        return this.getContentType(packet);
    }

    private ContentType getContentType(Packet packet) {
        switch (this.version) {
            case SOAP_11: {
                return new ContentTypeImpl(this.messageContentType, packet.soapAction == null ? "" : packet.soapAction, null);
            }
            case SOAP_12: {
                if (packet.soapAction != null) {
                    this.messageContentType = this.messageContentType + ";action=\"" + packet.soapAction + "\"";
                }
                return new ContentTypeImpl(this.messageContentType, null, null);
            }
        }
        return null;
    }

    public ContentType encode(Packet packet, OutputStream outputStream) throws IOException {
        this.mtomAttachmentStream.clear();
        ContentType contentType = this.getContentType(packet);
        if (packet.getMessage() != null) {
            try {
                OutputUtil.writeln("--" + this.boundary, outputStream);
                OutputUtil.writeln("Content-Type: " + this.soapXopContentType, outputStream);
                OutputUtil.writeln("Content-Transfer-Encoding: binary", outputStream);
                OutputUtil.writeln(outputStream);
                MtomStreamWriter mtomStreamWriter = new MtomStreamWriter(XMLStreamWriterFactory.create(outputStream), outputStream);
                packet.getMessage().writeTo(mtomStreamWriter);
                XMLStreamWriterFactory.recycle(mtomStreamWriter);
                OutputUtil.writeln(outputStream);
                for (ByteArrayBuffer byteArrayBuffer : this.mtomAttachmentStream) {
                    byteArrayBuffer.write(outputStream);
                }
                this.writeAttachments(packet.getMessage().getAttachments(), outputStream);
                OutputUtil.writeAsAscii("--" + this.boundary, outputStream);
                OutputUtil.writeAsAscii("--", outputStream);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
        }
        this.createConteTypeHeader();
        return contentType;
    }

    private void writeMimeHeaders(String string, String string2, OutputStream outputStream) throws IOException {
        OutputUtil.writeln("Content-Type: " + string, outputStream);
        String string3 = string2;
        if (string3 != null && string3.length() > 0 && string3.charAt(0) != '<') {
            string3 = '<' + string3 + '>';
        }
        OutputUtil.writeln("Content-Id: " + string3, outputStream);
        OutputUtil.writeln("Content-Transfer-Encoding: binary", outputStream);
        OutputUtil.writeln(outputStream);
    }

    private void writeAttachments(AttachmentSet attachmentSet, OutputStream outputStream) throws IOException {
        for (Attachment attachment : attachmentSet) {
            OutputUtil.writeln("--" + this.boundary, outputStream);
            this.writeMimeHeaders(attachment.getContentType(), attachment.getContentId(), outputStream);
            attachment.writeTo(outputStream);
            OutputUtil.writeln(outputStream);
        }
    }

    public ContentType encode(Packet packet, WritableByteChannel writableByteChannel) {
        throw new UnsupportedOperationException();
    }

    public MtomCodec copy() {
        return new MtomCodec(this.version, (com.sun.xml.internal.ws.api.pipe.StreamSOAPCodec)this.codec.copy(), this.mtomFeature);
    }

    private String encodeCid() {
        String string = "example.jaxws.sun.com";
        String string2 = UUID.randomUUID() + "@";
        return string2 + string;
    }

    protected void decode(MimeMultipartParser mimeMultipartParser, Packet packet) throws IOException {
        MtomXMLStreamReaderEx mtomXMLStreamReaderEx = new MtomXMLStreamReaderEx(mimeMultipartParser, XMLStreamReaderFactory.create(null, mimeMultipartParser.getRootPart().asInputStream(), true));
        if (this.codec instanceof StreamSOAPCodec) {
            packet.setMessage(((StreamSOAPCodec)this.codec).decode(mtomXMLStreamReaderEx, new MimeAttachmentSet(mimeMultipartParser)));
        } else {
            packet.setMessage(this.codec.decode(mtomXMLStreamReaderEx));
        }
    }

    private static byte[] encode(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException);
        }
    }

    private class ByteArrayBuffer {
        final String contentId;
        private DataHandler dh;

        ByteArrayBuffer(DataHandler dataHandler) {
            this.dh = dataHandler;
            this.contentId = MtomCodec.this.encodeCid();
        }

        void write(OutputStream outputStream) throws IOException {
            OutputUtil.writeln("--" + MtomCodec.this.boundary, outputStream);
            MtomCodec.this.writeMimeHeaders(this.dh.getContentType(), this.contentId, outputStream);
            this.dh.writeTo(outputStream);
            OutputUtil.writeln(outputStream);
        }
    }

    private class MtomStreamWriter
    extends XMLStreamWriterFilter
    implements XMLStreamWriterEx {
        private final OutputStream out;
        private final Encoded encoded;

        public MtomStreamWriter(XMLStreamWriter xMLStreamWriter, OutputStream outputStream) {
            super(xMLStreamWriter);
            this.encoded = new Encoded();
            this.out = outputStream;
        }

        public void writeBinary(byte[] byArray, int n, int n2, String string) throws XMLStreamException {
            if (MtomCodec.this.mtomFeature.getThreshold() > n2) {
                this.writeCharacters(DatatypeConverterImpl._printBase64Binary(byArray, n, n2));
                return;
            }
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(new DataHandler(new ByteArrayDataSource(byArray, n, n2, string)));
            this.writeBinary(byteArrayBuffer);
        }

        public void writeBinary(DataHandler dataHandler) throws XMLStreamException {
            Base64Data base64Data = new Base64Data();
            base64Data.set(dataHandler);
            this.writeBinary(new ByteArrayBuffer(base64Data.getDataHandler()));
        }

        public OutputStream writeBinary(String string) throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        public void writePCDATA(CharSequence charSequence) throws XMLStreamException {
            if (charSequence == null) {
                return;
            }
            if (charSequence instanceof Base64Data) {
                Base64Data base64Data = (Base64Data)charSequence;
                this.writeBinary(base64Data.getDataHandler());
                return;
            }
            this.writeCharacters(((Object)charSequence).toString());
        }

        private void writeBinary(ByteArrayBuffer byteArrayBuffer) {
            try {
                MtomCodec.this.mtomAttachmentStream.add(byteArrayBuffer);
                this.writer.writeCharacters("");
                this.writer.flush();
                this.out.write(XOP_PREF);
                this.encoded.set(byteArrayBuffer.contentId);
                this.out.write(this.encoded.buf, 0, this.encoded.len);
                this.out.write(XOP_SUFF);
            }
            catch (IOException iOException) {
                throw new WebServiceException(iOException);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
        }

        public NamespaceContextEx getNamespaceContext() {
            NamespaceContext namespaceContext = this.writer.getNamespaceContext();
            return new MtomNamespaceContextEx(namespaceContext);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MtomNamespaceContextEx
        implements NamespaceContextEx {
            private NamespaceContext nsContext;

            public MtomNamespaceContextEx(NamespaceContext namespaceContext) {
                this.nsContext = namespaceContext;
            }

            @Override
            public Iterator<NamespaceContextEx.Binding> iterator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getNamespaceURI(String string) {
                return this.nsContext.getNamespaceURI(string);
            }

            @Override
            public String getPrefix(String string) {
                return this.nsContext.getPrefix(string);
            }

            @Override
            public Iterator getPrefixes(String string) {
                return this.nsContext.getPrefixes(string);
            }
        }
    }

    private static class MtomXMLStreamReaderEx
    extends XMLStreamReaderFilter
    implements XMLStreamReaderEx {
        private final MimeMultipartParser mimeMP;
        private boolean xopReferencePresent = false;
        private Base64Data base64AttData;
        private int textLength;
        private int textStart;
        private char[] base64EncodedText;

        public MtomXMLStreamReaderEx(MimeMultipartParser mimeMultipartParser, XMLStreamReader xMLStreamReader) {
            super(xMLStreamReader);
            this.mimeMP = mimeMultipartParser;
        }

        public CharSequence getPCDATA() throws XMLStreamException {
            if (this.xopReferencePresent) {
                return this.base64AttData;
            }
            return this.reader.getText();
        }

        public NamespaceContextEx getNamespaceContext() {
            NamespaceContext namespaceContext = this.reader.getNamespaceContext();
            return new MtomNamespaceContextEx(namespaceContext);
        }

        public String getElementTextTrim() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        public int getTextLength() {
            if (this.xopReferencePresent) {
                return this.textLength;
            }
            return this.reader.getTextLength();
        }

        public int getTextStart() {
            if (this.xopReferencePresent) {
                return 0;
            }
            return this.reader.getTextStart();
        }

        public int getEventType() {
            if (this.xopReferencePresent) {
                return 4;
            }
            return super.getEventType();
        }

        public int next() throws XMLStreamException {
            int n = this.reader.next();
            if (n == 1 && this.reader.getLocalName().equals(MtomCodec.XOP_LOCALNAME) && this.reader.getNamespaceURI().equals(MtomCodec.XOP_NAMESPACEURI)) {
                String string = this.reader.getAttributeValue(null, "href");
                try {
                    StreamAttachment streamAttachment = this.getAttachment(string);
                    if (streamAttachment != null) {
                        this.base64AttData = streamAttachment.asBase64Data();
                        this.textLength = this.base64AttData.getDataLen();
                    }
                    this.textStart = 0;
                    this.xopReferencePresent = true;
                }
                catch (IOException iOException) {
                    throw new WebServiceException(iOException);
                }
                try {
                    this.reader.next();
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new WebServiceException(xMLStreamException);
                }
                return 4;
            }
            if (this.xopReferencePresent) {
                this.xopReferencePresent = false;
                this.textStart = 0;
                this.textLength = 0;
                this.base64EncodedText = null;
            }
            return n;
        }

        private String decodeCid(String string) {
            try {
                string = URLDecoder.decode(string, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return string;
            }
            return string;
        }

        private boolean needToDecode(String string) {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2++);
                switch (c) {
                    case '%': {
                        return true;
                    }
                }
            }
            return false;
        }

        private StreamAttachment getAttachment(String string) throws IOException {
            StreamAttachment streamAttachment;
            if (string.startsWith("cid:")) {
                string = string.substring(4, string.length());
            }
            if ((streamAttachment = this.mimeMP.getAttachmentPart(string)) == null && this.needToDecode(string)) {
                string = this.decodeCid(string);
                return this.mimeMP.getAttachmentPart(string);
            }
            return streamAttachment;
        }

        public char[] getTextCharacters() {
            if (this.xopReferencePresent) {
                char[] cArray = new char[this.base64AttData.length()];
                this.base64AttData.writeTo(cArray, 0);
                this.textLength = cArray.length;
                return cArray;
            }
            return this.reader.getTextCharacters();
        }

        public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
            if (this.xopReferencePresent) {
                int n4 = this.reader.getEventType();
                if (n4 != 4) {
                    throw new XMLStreamException("Invalid state: Expected CHARACTERS found :");
                }
                if (cArray == null) {
                    throw new NullPointerException("target char array can't be null");
                }
                if (n2 < 0 || n3 < 0 || n < 0 || n2 >= cArray.length || n2 + n3 > cArray.length) {
                    throw new IndexOutOfBoundsException();
                }
                if (this.base64EncodedText != null) {
                    this.base64EncodedText = new char[this.base64AttData.length()];
                    this.base64AttData.writeTo(this.base64EncodedText, 0);
                    this.textLength = this.base64EncodedText.length;
                    this.textStart = 0;
                }
                if (this.textStart + n > this.textLength) {
                    throw new IndexOutOfBoundsException();
                }
                int n5 = this.textLength - n;
                if (n5 < 0) {
                    throw new IndexOutOfBoundsException("sourceStart is greater thannumber of characters associated with this event");
                }
                int n6 = Math.min(n5, n3);
                System.arraycopy(this.base64EncodedText, this.getTextStart() + n, cArray, n2, n6);
                this.textStart = n;
                return n6;
            }
            return this.reader.getTextCharacters(n, cArray, n2, n3);
        }

        public String getText() {
            if (this.xopReferencePresent) {
                String string = this.base64AttData.toString();
                this.textLength = string.length();
            }
            return this.reader.getText();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MtomNamespaceContextEx
        implements NamespaceContextEx {
            private NamespaceContext nsContext;

            public MtomNamespaceContextEx(NamespaceContext namespaceContext) {
                this.nsContext = namespaceContext;
            }

            @Override
            public Iterator<NamespaceContextEx.Binding> iterator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getNamespaceURI(String string) {
                return this.nsContext.getNamespaceURI(string);
            }

            @Override
            public String getPrefix(String string) {
                return this.nsContext.getPrefix(string);
            }

            @Override
            public Iterator getPrefixes(String string) {
                return this.nsContext.getPrefixes(string);
            }
        }
    }
}

