/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap.ver1_2;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.internal.messaging.saaj.soap.SOAPDocument;
import com.sun.xml.internal.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.DetailImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.ElementImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.FaultElementImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.FaultImpl;
import com.sun.xml.internal.messaging.saaj.soap.name.NameImpl;
import com.sun.xml.internal.messaging.saaj.soap.ver1_2.Detail1_2Impl;
import com.sun.xml.internal.messaging.saaj.soap.ver1_2.FaultElement1_2Impl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Fault1_2Impl
extends FaultImpl {
    protected static Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap.ver1_2", "com.sun.xml.internal.messaging.saaj.soap.ver1_2.LocalStrings");
    private static final QName textName = new QName("http://www.w3.org/2003/05/soap-envelope", "Text");
    private final QName valueName = new QName("http://www.w3.org/2003/05/soap-envelope", "Value", this.getPrefix());
    private final QName subcodeName = new QName("http://www.w3.org/2003/05/soap-envelope", "Subcode", this.getPrefix());
    private SOAPElement innermostSubCodeElement = null;

    public Fault1_2Impl(SOAPDocumentImpl sOAPDocumentImpl, String string, String string2) {
        super(sOAPDocumentImpl, NameImpl.createFault1_2Name(string, string2));
    }

    public Fault1_2Impl(SOAPDocumentImpl sOAPDocumentImpl, String string) {
        super(sOAPDocumentImpl, NameImpl.createFault1_2Name(null, string));
    }

    protected NameImpl getDetailName() {
        return NameImpl.createSOAP12Name("Detail", this.getPrefix());
    }

    protected NameImpl getFaultCodeName() {
        return NameImpl.createSOAP12Name("Code", this.getPrefix());
    }

    protected NameImpl getFaultStringName() {
        return this.getFaultReasonName();
    }

    protected NameImpl getFaultActorName() {
        return this.getFaultRoleName();
    }

    private NameImpl getFaultRoleName() {
        return NameImpl.createSOAP12Name("Role", this.getPrefix());
    }

    private NameImpl getFaultReasonName() {
        return NameImpl.createSOAP12Name("Reason", this.getPrefix());
    }

    private NameImpl getFaultReasonTextName() {
        return NameImpl.createSOAP12Name("Text", this.getPrefix());
    }

    private NameImpl getFaultNodeName() {
        return NameImpl.createSOAP12Name("Node", this.getPrefix());
    }

    private static NameImpl getXmlLangName() {
        return NameImpl.createXmlName("lang");
    }

    protected DetailImpl createDetail() {
        return new Detail1_2Impl(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument());
    }

    protected FaultElementImpl createSOAPFaultElement(String string) {
        return new FaultElement1_2Impl(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument(), string);
    }

    protected void checkIfStandardFaultCode(String string, String string2) throws SOAPException {
        QName qName = new QName(string2, string);
        if (SOAPConstants.SOAP_DATAENCODINGUNKNOWN_FAULT.equals(qName) || SOAPConstants.SOAP_MUSTUNDERSTAND_FAULT.equals(qName) || SOAPConstants.SOAP_RECEIVER_FAULT.equals(qName) || SOAPConstants.SOAP_SENDER_FAULT.equals(qName) || SOAPConstants.SOAP_VERSIONMISMATCH_FAULT.equals(qName)) {
            return;
        }
        log.log(Level.SEVERE, "SAAJ0435.ver1_2.code.not.standard", qName);
        throw new SOAPExceptionImpl(qName + " is not a standard Code value");
    }

    protected void finallySetFaultCode(String string) throws SOAPException {
        SOAPElement sOAPElement = this.faultCodeElement.addChildElement(this.valueName);
        sOAPElement.addTextNode(string);
    }

    private void findReasonElement() {
        this.findFaultStringElement();
    }

    public Iterator getFaultReasonTexts() throws SOAPException {
        if (this.faultStringElement == null) {
            this.findReasonElement();
        }
        Iterator iterator = this.faultStringElement.getChildElements(textName);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            SOAPElement sOAPElement = (SOAPElement)iterator.next();
            Locale locale = Fault1_2Impl.getLocale(sOAPElement);
            if (locale == null) {
                log.severe("SAAJ0431.ver1_2.xml.lang.missing");
                throw new SOAPExceptionImpl("\"xml:lang\" attribute is not present on the Text element");
            }
            arrayList.add(sOAPElement.getValue());
        }
        if (arrayList.isEmpty()) {
            log.severe("SAAJ0434.ver1_2.text.element.not.present");
            throw new SOAPExceptionImpl("env:Text must be present inside env:Reason");
        }
        return arrayList.iterator();
    }

    public void addFaultReasonText(String string, Locale locale) throws SOAPException {
        SOAPElement sOAPElement;
        if (locale == null) {
            log.severe("SAAJ0430.ver1_2.locale.required");
            throw new SOAPException("locale is required and must not be null");
        }
        if (this.faultStringElement == null) {
            this.findReasonElement();
        }
        if (this.faultStringElement == null) {
            this.faultStringElement = this.addSOAPFaultElement("Reason");
            sOAPElement = this.faultStringElement.addChildElement(this.getFaultReasonTextName());
        } else {
            this.removeDefaultFaultString();
            sOAPElement = this.getFaultReasonTextElement(locale);
            if (sOAPElement != null) {
                sOAPElement.removeContents();
            } else {
                sOAPElement = this.faultStringElement.addChildElement(this.getFaultReasonTextName());
            }
        }
        String string2 = Fault1_2Impl.localeToXmlLang(locale);
        sOAPElement.addAttribute(Fault1_2Impl.getXmlLangName(), string2);
        sOAPElement.addTextNode(string);
    }

    private void removeDefaultFaultString() throws SOAPException {
        String string;
        SOAPElement sOAPElement = this.getFaultReasonTextElement(Locale.getDefault());
        if (sOAPElement != null && (string = "Fault string, and possibly fault code, not set").equals(sOAPElement.getValue())) {
            sOAPElement.detachNode();
        }
    }

    public String getFaultReasonText(Locale locale) throws SOAPException {
        SOAPElement sOAPElement;
        if (locale == null) {
            return null;
        }
        if (this.faultStringElement == null) {
            this.findReasonElement();
        }
        if (this.faultStringElement != null && (sOAPElement = this.getFaultReasonTextElement(locale)) != null) {
            sOAPElement.normalize();
            return sOAPElement.getFirstChild().getNodeValue();
        }
        return null;
    }

    public Iterator getFaultReasonLocales() throws SOAPException {
        if (this.faultStringElement == null) {
            this.findReasonElement();
        }
        Iterator iterator = this.faultStringElement.getChildElements(textName);
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        while (iterator.hasNext()) {
            SOAPElement sOAPElement = (SOAPElement)iterator.next();
            Locale locale = Fault1_2Impl.getLocale(sOAPElement);
            if (locale == null) {
                log.severe("SAAJ0431.ver1_2.xml.lang.missing");
                throw new SOAPExceptionImpl("\"xml:lang\" attribute is not present on the Text element");
            }
            arrayList.add(locale);
        }
        if (arrayList.isEmpty()) {
            log.severe("SAAJ0434.ver1_2.text.element.not.present");
            throw new SOAPExceptionImpl("env:Text elements with mandatory xml:lang attributes must be present inside env:Reason");
        }
        return arrayList.iterator();
    }

    public Locale getFaultStringLocale() {
        Locale locale = null;
        try {
            locale = (Locale)this.getFaultReasonLocales().next();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return locale;
    }

    private SOAPElement getFaultReasonTextElement(Locale locale) throws SOAPException {
        Iterator iterator = this.faultStringElement.getChildElements(textName);
        while (iterator.hasNext()) {
            SOAPElement sOAPElement = (SOAPElement)iterator.next();
            Locale locale2 = Fault1_2Impl.getLocale(sOAPElement);
            if (locale2 == null) {
                log.severe("SAAJ0431.ver1_2.xml.lang.missing");
                throw new SOAPExceptionImpl("\"xml:lang\" attribute is not present on the Text element");
            }
            if (!locale2.equals(locale)) continue;
            return sOAPElement;
        }
        return null;
    }

    public String getFaultNode() {
        SOAPElement sOAPElement = this.findChild(this.getFaultNodeName());
        if (sOAPElement == null) {
            return null;
        }
        return sOAPElement.getValue();
    }

    public void setFaultNode(String string) throws SOAPException {
        SOAPElement sOAPElement = this.findChild(this.getFaultNodeName());
        if (sOAPElement != null) {
            sOAPElement.detachNode();
        }
        sOAPElement = this.createSOAPFaultElement(this.getFaultNodeName());
        sOAPElement = sOAPElement.addTextNode(string);
        if (this.getFaultRole() != null) {
            this.insertBefore(sOAPElement, this.faultActorElement);
            return;
        }
        if (this.hasDetail()) {
            this.insertBefore(sOAPElement, this.detail);
            return;
        }
        this.addNode(sOAPElement);
    }

    public String getFaultRole() {
        return this.getFaultActor();
    }

    public void setFaultRole(String string) throws SOAPException {
        if (this.faultActorElement == null) {
            this.findFaultActorElement();
        }
        if (this.faultActorElement != null) {
            this.faultActorElement.detachNode();
        }
        this.faultActorElement = this.createSOAPFaultElement(this.getFaultActorName());
        this.faultActorElement.addTextNode(string);
        if (this.hasDetail()) {
            this.insertBefore(this.faultActorElement, this.detail);
            return;
        }
        this.addNode(this.faultActorElement);
    }

    public String getFaultCode() {
        if (this.faultCodeElement == null) {
            this.findFaultCodeElement();
        }
        Iterator iterator = this.faultCodeElement.getChildElements(this.valueName);
        return ((SOAPElement)iterator.next()).getValue();
    }

    public QName getFaultCodeAsQName() {
        String string = this.getFaultCode();
        if (string == null) {
            return null;
        }
        if (this.faultCodeElement == null) {
            this.findFaultCodeElement();
        }
        Iterator iterator = this.faultCodeElement.getChildElements(this.valueName);
        return Fault1_2Impl.convertCodeToQName(string, (SOAPElement)iterator.next());
    }

    public Name getFaultCodeAsName() {
        String string = this.getFaultCode();
        if (string == null) {
            return null;
        }
        if (this.faultCodeElement == null) {
            this.findFaultCodeElement();
        }
        Iterator iterator = this.faultCodeElement.getChildElements(this.valueName);
        return NameImpl.convertToName(Fault1_2Impl.convertCodeToQName(string, (SOAPElement)iterator.next()));
    }

    public String getFaultString() {
        String string = null;
        try {
            string = (String)this.getFaultReasonTexts().next();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return string;
    }

    public void setFaultString(String string) throws SOAPException {
        this.addFaultReasonText(string, Locale.getDefault());
    }

    public void setFaultString(String string, Locale locale) throws SOAPException {
        this.addFaultReasonText(string, locale);
    }

    public void appendFaultSubcode(QName qName) throws SOAPException {
        if (qName == null) {
            return;
        }
        if (qName.getNamespaceURI() == null || "".equals(qName.getNamespaceURI())) {
            log.severe("SAAJ0432.ver1_2.subcode.not.ns.qualified");
            throw new SOAPExceptionImpl("A Subcode must be namespace-qualified");
        }
        if (this.innermostSubCodeElement == null) {
            if (this.faultCodeElement == null) {
                this.findFaultCodeElement();
            }
            this.innermostSubCodeElement = this.faultCodeElement;
        }
        String string = null;
        string = qName.getPrefix() == null || "".equals(qName.getPrefix()) ? ((ElementImpl)this.innermostSubCodeElement).getNamespacePrefix(qName.getNamespaceURI()) : qName.getPrefix();
        if (string == null || "".equals(string)) {
            string = "ns1";
        }
        this.innermostSubCodeElement = this.innermostSubCodeElement.addChildElement(this.subcodeName);
        SOAPElement sOAPElement = this.innermostSubCodeElement.addChildElement(this.valueName);
        ((ElementImpl)sOAPElement).ensureNamespaceIsDeclared(string, qName.getNamespaceURI());
        sOAPElement.addTextNode(string + ":" + qName.getLocalPart());
    }

    public void removeAllFaultSubcodes() {
        Iterator iterator;
        if (this.faultCodeElement == null) {
            this.findFaultCodeElement();
        }
        if ((iterator = this.faultCodeElement.getChildElements(this.subcodeName)).hasNext()) {
            SOAPElement sOAPElement = (SOAPElement)iterator.next();
            sOAPElement.detachNode();
        }
    }

    public Iterator getFaultSubcodes() {
        if (this.faultCodeElement == null) {
            this.findFaultCodeElement();
        }
        final ArrayList<QName> arrayList = new ArrayList<QName>();
        SOAPElement sOAPElement = this.faultCodeElement;
        Iterator iterator = sOAPElement.getChildElements(this.subcodeName);
        while (iterator.hasNext()) {
            sOAPElement = (ElementImpl)iterator.next();
            Iterator iterator2 = sOAPElement.getChildElements(this.valueName);
            SOAPElement sOAPElement2 = (SOAPElement)iterator2.next();
            String string = sOAPElement2.getValue();
            arrayList.add(Fault1_2Impl.convertCodeToQName(string, sOAPElement2));
            iterator = sOAPElement.getChildElements(this.subcodeName);
        }
        return new Iterator(){
            Iterator subCodeIter;
            {
                this.subCodeIter = arrayList.iterator();
            }

            public boolean hasNext() {
                return this.subCodeIter.hasNext();
            }

            public Object next() {
                return this.subCodeIter.next();
            }

            public void remove() {
                throw new UnsupportedOperationException("Method remove() not supported on SubCodes Iterator");
            }
        };
    }

    private static Locale getLocale(SOAPElement sOAPElement) {
        return Fault1_2Impl.xmlLangToLocale(sOAPElement.getAttributeValue(Fault1_2Impl.getXmlLangName()));
    }

    public void setEncodingStyle(String string) throws SOAPException {
        log.severe("SAAJ0407.ver1_2.no.encodingStyle.in.fault");
        throw new SOAPExceptionImpl("encodingStyle attribute cannot appear on Fault");
    }

    public SOAPElement addAttribute(Name name, String string) throws SOAPException {
        if (name.getLocalName().equals("encodingStyle") && name.getURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
            this.setEncodingStyle(string);
        }
        return super.addAttribute(name, string);
    }

    public SOAPElement addAttribute(QName qName, String string) throws SOAPException {
        if (qName.getLocalPart().equals("encodingStyle") && qName.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
            this.setEncodingStyle(string);
        }
        return super.addAttribute(qName, string);
    }

    public SOAPElement addTextNode(String string) throws SOAPException {
        log.log(Level.SEVERE, "SAAJ0416.ver1_2.adding.text.not.legal", this.getElementQName());
        throw new SOAPExceptionImpl("Adding text to SOAP 1.2 Fault is not legal");
    }

    public SOAPElement addChildElement(SOAPElement sOAPElement) throws SOAPException {
        Object object;
        String string = sOAPElement.getLocalName();
        if ("Detail".equalsIgnoreCase(string)) {
            if (this.hasDetail()) {
                log.severe("SAAJ0436.ver1_2.detail.exists.error");
                throw new SOAPExceptionImpl("Cannot add Detail, Detail already exists");
            }
            object = sOAPElement.getElementQName().getNamespaceURI();
            if (!((String)object).equals("http://www.w3.org/2003/05/soap-envelope")) {
                log.severe("SAAJ0437.ver1_2.version.mismatch.error");
                throw new SOAPExceptionImpl("Cannot add Detail, Incorrect SOAP version specified for Detail element");
            }
        }
        if (sOAPElement instanceof Detail1_2Impl) {
            object = (ElementImpl)this.importElement(sOAPElement);
            this.addNode((Node)object);
            return this.convertToSoapElement((Element)object);
        }
        return super.addChildElement(sOAPElement);
    }

    protected boolean isStandardFaultElement(String string) {
        return string.equalsIgnoreCase("code") || string.equalsIgnoreCase("reason") || string.equalsIgnoreCase("node") || string.equalsIgnoreCase("role") || string.equalsIgnoreCase("detail");
    }

    protected QName getDefaultFaultCode() {
        return SOAPConstants.SOAP_SENDER_FAULT;
    }

    protected FaultElementImpl createSOAPFaultElement(QName qName) {
        return new FaultElement1_2Impl(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument(), qName);
    }

    protected FaultElementImpl createSOAPFaultElement(Name name) {
        return new FaultElement1_2Impl(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument(), (NameImpl)name);
    }
}

