/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.AdobeMarkerSegment;
import com.sun.imageio.plugins.jpeg.DHTMarkerSegment;
import com.sun.imageio.plugins.jpeg.DQTMarkerSegment;
import com.sun.imageio.plugins.jpeg.DRIMarkerSegment;
import com.sun.imageio.plugins.jpeg.JFIFMarkerSegment;
import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGMetadata;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import com.sun.imageio.plugins.jpeg.SOFMarkerSegment;
import com.sun.imageio.plugins.jpeg.SOSMarkerSegment;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.security.action.LoadLibraryAction;

public class JPEGImageWriter
extends ImageWriter {
    private boolean debug = false;
    private long structPointer = 0L;
    private ImageOutputStream ios = null;
    private Raster srcRas = null;
    private WritableRaster raster = null;
    private boolean indexed = false;
    private IndexColorModel indexCM = null;
    private boolean convertTosRGB = false;
    private WritableRaster converted = null;
    private boolean isAlphaPremultiplied = false;
    private ColorModel srcCM = null;
    private List thumbnails = null;
    private ICC_Profile iccProfile = null;
    private int sourceXOffset = 0;
    private int sourceYOffset = 0;
    private int sourceWidth = 0;
    private int[] srcBands = null;
    private int sourceHeight = 0;
    private int currentImage = 0;
    private ColorConvertOp convertOp = null;
    private JPEGQTable[] streamQTables = null;
    private JPEGHuffmanTable[] streamDCHuffmanTables = null;
    private JPEGHuffmanTable[] streamACHuffmanTables = null;
    private boolean ignoreJFIF = false;
    private boolean forceJFIF = false;
    private boolean ignoreAdobe = false;
    private int newAdobeTransform = -1;
    private boolean writeDefaultJFIF = false;
    private boolean writeAdobe = false;
    private JPEGMetadata metadata = null;
    private boolean sequencePrepared = false;
    private int numScans = 0;
    private Object disposerReferent = new Object();
    private DisposerRecord disposerRecord;
    protected static final int WARNING_DEST_IGNORED = 0;
    protected static final int WARNING_STREAM_METADATA_IGNORED = 1;
    protected static final int WARNING_DEST_METADATA_COMP_MISMATCH = 2;
    protected static final int WARNING_DEST_METADATA_JFIF_MISMATCH = 3;
    protected static final int WARNING_DEST_METADATA_ADOBE_MISMATCH = 4;
    protected static final int WARNING_IMAGE_METADATA_JFIF_MISMATCH = 5;
    protected static final int WARNING_IMAGE_METADATA_ADOBE_MISMATCH = 6;
    protected static final int WARNING_METADATA_NOT_JPEG_FOR_RASTER = 7;
    protected static final int WARNING_NO_BANDS_ON_INDEXED = 8;
    protected static final int WARNING_ILLEGAL_THUMBNAIL = 9;
    protected static final int WARNING_IGNORING_THUMBS = 10;
    protected static final int WARNING_FORCING_JFIF = 11;
    protected static final int WARNING_THUMB_CLIPPED = 12;
    protected static final int WARNING_METADATA_ADJUSTED_FOR_THUMB = 13;
    protected static final int WARNING_NO_RGB_THUMB_AS_INDEXED = 14;
    protected static final int WARNING_NO_GRAY_THUMB_AS_INDEXED = 15;
    private static final int MAX_WARNING = 15;
    static final Dimension[] preferredThumbSizes;

    public JPEGImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
        this.structPointer = this.initJPEGImageWriter();
        this.disposerRecord = new JPEGWriterDisposerRecord(this.structPointer);
        Disposer.addRecord(this.disposerReferent, this.disposerRecord);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        this.resetInternalState();
        this.ios = (ImageOutputStream)object;
        this.setDest(this.structPointer, this.ios);
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new JPEGImageWriteParam(null);
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return new JPEGMetadata(imageWriteParam, this);
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return new JPEGMetadata(imageTypeSpecifier, imageWriteParam, this);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        if (iIOMetadata instanceof JPEGMetadata) {
            JPEGMetadata jPEGMetadata = (JPEGMetadata)iIOMetadata;
            if (jPEGMetadata.isStream) {
                return iIOMetadata;
            }
        }
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        String string;
        Node node;
        if (iIOMetadata instanceof JPEGMetadata) {
            JPEGMetadata jPEGMetadata = (JPEGMetadata)iIOMetadata;
            if (!jPEGMetadata.isStream) {
                return iIOMetadata;
            }
            return null;
        }
        if (iIOMetadata.isStandardMetadataFormatSupported() && (node = iIOMetadata.getAsTree(string = "javax_imageio_1.0")) != null) {
            JPEGMetadata jPEGMetadata = new JPEGMetadata(imageTypeSpecifier, imageWriteParam, this);
            try {
                jPEGMetadata.setFromTree(string, node);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                return null;
            }
            return jPEGMetadata;
        }
        return null;
    }

    public int getNumThumbnailsSupported(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        if (this.jfifOK(imageTypeSpecifier, imageWriteParam, iIOMetadata, iIOMetadata2)) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    public Dimension[] getPreferredThumbnailSizes(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        if (this.jfifOK(imageTypeSpecifier, imageWriteParam, iIOMetadata, iIOMetadata2)) {
            return (Dimension[])preferredThumbSizes.clone();
        }
        return null;
    }

    private boolean jfifOK(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        if (imageTypeSpecifier != null && !JPEG.isJFIFcompliant(imageTypeSpecifier, true)) {
            return false;
        }
        if (iIOMetadata2 != null) {
            JPEGMetadata jPEGMetadata = null;
            jPEGMetadata = iIOMetadata2 instanceof JPEGMetadata ? (JPEGMetadata)iIOMetadata2 : (JPEGMetadata)this.convertImageMetadata(iIOMetadata2, imageTypeSpecifier, imageWriteParam);
            if (jPEGMetadata.findMarkerSegment(JFIFMarkerSegment.class, true) == null) {
                return false;
            }
        }
        return true;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int n;
        Object object;
        boolean bl;
        int n2;
        int n3;
        Object object2;
        Object object3;
        int n4;
        int n5;
        int[] nArray;
        int[] nArray2;
        if (this.ios == null) {
            throw new IllegalStateException("Output has not been set!");
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException("image is null!");
        }
        if (iIOMetadata != null) {
            this.warningOccurred(1);
        }
        boolean bl2 = iIOImage.hasRaster();
        RenderedImage renderedImage = null;
        if (bl2) {
            this.srcRas = iIOImage.getRaster();
        } else {
            renderedImage = iIOImage.getRenderedImage();
            if (renderedImage instanceof BufferedImage) {
                this.srcRas = ((BufferedImage)renderedImage).getRaster();
            } else if (renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1) {
                this.srcRas = renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY());
                if (this.srcRas.getWidth() != renderedImage.getWidth() || this.srcRas.getHeight() != renderedImage.getHeight()) {
                    this.srcRas = this.srcRas.createChild(this.srcRas.getMinX(), this.srcRas.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), this.srcRas.getMinX(), this.srcRas.getMinY(), null);
                }
            } else {
                this.srcRas = renderedImage.getData();
            }
        }
        int n6 = this.srcRas.getNumBands();
        this.indexed = false;
        this.indexCM = null;
        ColorModel colorModel = null;
        ColorSpace colorSpace = null;
        this.isAlphaPremultiplied = false;
        this.srcCM = null;
        if (!bl2 && (colorModel = renderedImage.getColorModel()) != null) {
            colorSpace = colorModel.getColorSpace();
            if (colorModel instanceof IndexColorModel) {
                this.indexed = true;
                this.indexCM = (IndexColorModel)colorModel;
                n6 = colorModel.getNumComponents();
            }
            if (colorModel.isAlphaPremultiplied()) {
                this.isAlphaPremultiplied = true;
                this.srcCM = colorModel;
            }
        }
        this.srcBands = JPEG.bandOffsets[n6 - 1];
        int n7 = n6;
        if (imageWriteParam != null && (nArray2 = imageWriteParam.getSourceBands()) != null) {
            if (this.indexed) {
                this.warningOccurred(8);
            } else {
                this.srcBands = nArray2;
                n7 = this.srcBands.length;
                if (n7 > n6) {
                    throw new IIOException("ImageWriteParam specifies too many source bands");
                }
            }
        }
        boolean bl3 = n7 != n6;
        boolean bl4 = !bl2 && !bl3;
        int[] nArray3 = null;
        if (!this.indexed) {
            nArray3 = this.srcRas.getSampleModel().getSampleSize();
            if (bl3) {
                nArray = new int[n7];
                for (n5 = 0; n5 < n7; ++n5) {
                    nArray[n5] = nArray3[this.srcBands[n5]];
                }
                nArray3 = nArray;
            }
        } else {
            nArray = this.srcRas.getSampleModel().getSampleSize();
            nArray3 = new int[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                nArray3[n5] = nArray[0];
            }
        }
        for (n4 = 0; n4 < nArray3.length; ++n4) {
            if (nArray3[n4] > 8) {
                throw new IIOException("Sample size must be <= 8");
            }
            if (!this.indexed) continue;
            nArray3[n4] = 8;
        }
        if (this.debug) {
            System.out.println("numSrcBands is " + n6);
            System.out.println("numBandsUsed is " + n7);
            System.out.println("usingBandSubset is " + bl3);
            System.out.println("fullImage is " + bl4);
            System.out.print("Band sizes:");
            for (n4 = 0; n4 < nArray3.length; ++n4) {
                System.out.print(" " + nArray3[n4]);
            }
            System.out.println();
        }
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (imageWriteParam != null) {
            imageTypeSpecifier = imageWriteParam.getDestinationType();
            if (bl4 && imageTypeSpecifier != null) {
                this.warningOccurred(0);
                imageTypeSpecifier = null;
            }
        }
        this.sourceXOffset = this.srcRas.getMinX();
        this.sourceYOffset = this.srcRas.getMinY();
        n5 = this.srcRas.getWidth();
        int n8 = this.srcRas.getHeight();
        this.sourceWidth = n5;
        this.sourceHeight = n8;
        int n9 = 1;
        int n10 = 1;
        int n11 = 0;
        int n12 = 0;
        JPEGQTable[] jPEGQTableArray = null;
        JPEGHuffmanTable[] jPEGHuffmanTableArray = null;
        JPEGHuffmanTable[] jPEGHuffmanTableArray2 = null;
        boolean bl5 = false;
        JPEGImageWriteParam jPEGImageWriteParam = null;
        int n13 = 0;
        if (imageWriteParam != null) {
            object3 = imageWriteParam.getSourceRegion();
            if (object3 != null) {
                object2 = new Rectangle(this.sourceXOffset, this.sourceYOffset, this.sourceWidth, this.sourceHeight);
                object3 = ((Rectangle)object3).intersection((Rectangle)object2);
                this.sourceXOffset = ((Rectangle)object3).x;
                this.sourceYOffset = ((Rectangle)object3).y;
                this.sourceWidth = ((Rectangle)object3).width;
                this.sourceHeight = ((Rectangle)object3).height;
            }
            if (this.sourceWidth + this.sourceXOffset > n5) {
                this.sourceWidth = n5 - this.sourceXOffset;
            }
            if (this.sourceHeight + this.sourceYOffset > n8) {
                this.sourceHeight = n8 - this.sourceYOffset;
            }
            n9 = imageWriteParam.getSourceXSubsampling();
            n10 = imageWriteParam.getSourceYSubsampling();
            n11 = imageWriteParam.getSubsamplingXOffset();
            n12 = imageWriteParam.getSubsamplingYOffset();
            switch (imageWriteParam.getCompressionMode()) {
                case 0: {
                    throw new IIOException("JPEG compression cannot be disabled");
                }
                case 2: {
                    float f = imageWriteParam.getCompressionQuality();
                    f = JPEG.convertToLinearQuality(f);
                    jPEGQTableArray = new JPEGQTable[]{JPEGQTable.K1Luminance.getScaledInstance(f, true), JPEGQTable.K2Chrominance.getScaledInstance(f, true)};
                    break;
                }
                case 1: {
                    jPEGQTableArray = new JPEGQTable[]{JPEGQTable.K1Div2Luminance, JPEGQTable.K2Div2Chrominance};
                }
            }
            n13 = imageWriteParam.getProgressiveMode();
            if (imageWriteParam instanceof JPEGImageWriteParam) {
                jPEGImageWriteParam = (JPEGImageWriteParam)imageWriteParam;
                bl5 = jPEGImageWriteParam.getOptimizeHuffmanTables();
            }
        }
        if ((object3 = iIOImage.getMetadata()) != null) {
            if (object3 instanceof JPEGMetadata) {
                this.metadata = (JPEGMetadata)object3;
                if (this.debug) {
                    System.out.println("We have metadata, and it's JPEG metadata");
                }
            } else if (!bl2) {
                object2 = imageTypeSpecifier;
                if (object2 == null) {
                    object2 = new ImageTypeSpecifier(renderedImage);
                }
                this.metadata = (JPEGMetadata)this.convertImageMetadata((IIOMetadata)object3, (ImageTypeSpecifier)object2, imageWriteParam);
            } else {
                this.warningOccurred(7);
            }
        }
        this.ignoreJFIF = false;
        this.ignoreAdobe = false;
        this.newAdobeTransform = -1;
        this.writeDefaultJFIF = false;
        this.writeAdobe = false;
        int n14 = 0;
        int n15 = 0;
        JFIFMarkerSegment jFIFMarkerSegment = null;
        AdobeMarkerSegment adobeMarkerSegment = null;
        SOFMarkerSegment sOFMarkerSegment = null;
        if (this.metadata != null) {
            jFIFMarkerSegment = (JFIFMarkerSegment)this.metadata.findMarkerSegment(JFIFMarkerSegment.class, true);
            adobeMarkerSegment = (AdobeMarkerSegment)this.metadata.findMarkerSegment(AdobeMarkerSegment.class, true);
            sOFMarkerSegment = (SOFMarkerSegment)this.metadata.findMarkerSegment(SOFMarkerSegment.class, true);
        }
        this.iccProfile = null;
        this.convertTosRGB = false;
        this.converted = null;
        if (imageTypeSpecifier != null) {
            if (n7 != imageTypeSpecifier.getNumBands()) {
                throw new IIOException("Number of source bands != number of destination bands");
            }
            colorSpace = imageTypeSpecifier.getColorModel().getColorSpace();
            if (this.metadata != null) {
                this.checkSOFBands(sOFMarkerSegment, n7);
                this.checkJFIF(jFIFMarkerSegment, imageTypeSpecifier, false);
                if (jFIFMarkerSegment != null && !this.ignoreJFIF && JPEG.isNonStandardICC(colorSpace)) {
                    this.iccProfile = ((ICC_ColorSpace)colorSpace).getProfile();
                }
                this.checkAdobe(adobeMarkerSegment, imageTypeSpecifier, false);
            } else {
                if (JPEG.isJFIFcompliant(imageTypeSpecifier, false)) {
                    this.writeDefaultJFIF = true;
                    if (JPEG.isNonStandardICC(colorSpace)) {
                        this.iccProfile = ((ICC_ColorSpace)colorSpace).getProfile();
                    }
                } else {
                    n3 = JPEG.transformForType(imageTypeSpecifier, false);
                    if (n3 != -1) {
                        this.writeAdobe = true;
                        this.newAdobeTransform = n3;
                    }
                }
                this.metadata = new JPEGMetadata(imageTypeSpecifier, null, this);
            }
            n14 = this.getSrcCSType(imageTypeSpecifier);
            n15 = this.getDefaultDestCSType(imageTypeSpecifier);
        } else if (this.metadata == null) {
            if (bl4) {
                this.metadata = new JPEGMetadata(new ImageTypeSpecifier(renderedImage), imageWriteParam, this);
                if (this.metadata.findMarkerSegment(JFIFMarkerSegment.class, true) != null && JPEG.isNonStandardICC(colorSpace = renderedImage.getColorModel().getColorSpace())) {
                    this.iccProfile = ((ICC_ColorSpace)colorSpace).getProfile();
                }
                n14 = this.getSrcCSType(renderedImage);
                n15 = this.getDefaultDestCSType(renderedImage);
            }
        } else {
            this.checkSOFBands(sOFMarkerSegment, n7);
            if (bl4) {
                ImageTypeSpecifier imageTypeSpecifier2 = new ImageTypeSpecifier(renderedImage);
                n14 = this.getSrcCSType(renderedImage);
                if (colorModel != null) {
                    boolean bl6 = colorModel.hasAlpha();
                    block5 : switch (colorSpace.getType()) {
                        case 6: {
                            if (!bl6) {
                                n15 = 1;
                            } else if (jFIFMarkerSegment != null) {
                                this.ignoreJFIF = true;
                                this.warningOccurred(5);
                            }
                            if (adobeMarkerSegment == null || adobeMarkerSegment.transform == 0) break;
                            this.newAdobeTransform = 0;
                            this.warningOccurred(6);
                            break;
                        }
                        case 5: {
                            if (!bl6) {
                                if (jFIFMarkerSegment != null) {
                                    n15 = 3;
                                    if (!JPEG.isNonStandardICC(colorSpace) && (!(colorSpace instanceof ICC_ColorSpace) || jFIFMarkerSegment.iccSegment == null)) break;
                                    this.iccProfile = ((ICC_ColorSpace)colorSpace).getProfile();
                                    break;
                                }
                                if (adobeMarkerSegment != null) {
                                    switch (adobeMarkerSegment.transform) {
                                        case 0: {
                                            n15 = 2;
                                            break block5;
                                        }
                                        case 1: {
                                            n15 = 3;
                                            break block5;
                                        }
                                    }
                                    this.warningOccurred(6);
                                    this.newAdobeTransform = 0;
                                    n15 = 2;
                                    break;
                                }
                                n2 = sOFMarkerSegment.getIDencodedCSType();
                                if (n2 != 0) {
                                    n15 = n2;
                                    break;
                                }
                                bl = this.isSubsampled(sOFMarkerSegment.componentSpecs);
                                if (bl) {
                                    n15 = 3;
                                    break;
                                }
                                n15 = 2;
                                break;
                            }
                            if (jFIFMarkerSegment != null) {
                                this.ignoreJFIF = true;
                                this.warningOccurred(5);
                            }
                            if (adobeMarkerSegment != null) {
                                if (adobeMarkerSegment.transform != 0) {
                                    this.newAdobeTransform = 0;
                                    this.warningOccurred(6);
                                }
                                n15 = 6;
                                break;
                            }
                            n2 = sOFMarkerSegment.getIDencodedCSType();
                            if (n2 != 0) {
                                n15 = n2;
                                break;
                            }
                            bl = this.isSubsampled(sOFMarkerSegment.componentSpecs);
                            n15 = bl ? 7 : 6;
                            break;
                        }
                        case 13: {
                            if (colorSpace != JPEG.YCC) break;
                            if (!bl6) {
                                if (jFIFMarkerSegment != null) {
                                    this.convertTosRGB = true;
                                    this.convertOp = new ColorConvertOp(colorSpace, JPEG.sRGB, null);
                                    n15 = 3;
                                    break;
                                }
                                if (adobeMarkerSegment != null) {
                                    if (adobeMarkerSegment.transform != 1) {
                                        this.newAdobeTransform = 1;
                                        this.warningOccurred(6);
                                    }
                                    n15 = 5;
                                    break;
                                }
                                n15 = 5;
                                break;
                            }
                            if (jFIFMarkerSegment != null) {
                                this.ignoreJFIF = true;
                                this.warningOccurred(5);
                            } else if (adobeMarkerSegment != null && adobeMarkerSegment.transform != 0) {
                                this.newAdobeTransform = 0;
                                this.warningOccurred(6);
                            }
                            n15 = 10;
                        }
                    }
                }
            }
        }
        n3 = 0;
        int[] nArray4 = null;
        if (this.metadata != null) {
            if (sOFMarkerSegment == null) {
                sOFMarkerSegment = (SOFMarkerSegment)this.metadata.findMarkerSegment(SOFMarkerSegment.class, true);
            }
            if (sOFMarkerSegment != null && sOFMarkerSegment.tag == 194) {
                n3 = 1;
                if (n13 == 3) {
                    nArray4 = this.collectScans(this.metadata, sOFMarkerSegment);
                } else {
                    this.numScans = 0;
                }
            }
            if (jFIFMarkerSegment == null) {
                jFIFMarkerSegment = (JFIFMarkerSegment)this.metadata.findMarkerSegment(JFIFMarkerSegment.class, true);
            }
        }
        this.thumbnails = iIOImage.getThumbnails();
        n2 = iIOImage.getNumThumbnails();
        this.forceJFIF = false;
        if (!this.writeDefaultJFIF) {
            if (this.metadata == null) {
                this.thumbnails = null;
                if (n2 != 0) {
                    this.warningOccurred(10);
                }
            } else if (!bl4) {
                if (jFIFMarkerSegment == null) {
                    this.thumbnails = null;
                    if (n2 != 0) {
                        this.warningOccurred(10);
                    }
                }
            } else if (jFIFMarkerSegment == null) {
                if (n15 == 1 || n15 == 3) {
                    if (n2 != 0) {
                        this.forceJFIF = true;
                        this.warningOccurred(11);
                    }
                } else {
                    this.thumbnails = null;
                    if (n2 != 0) {
                        this.warningOccurred(10);
                    }
                }
            }
        }
        bl = this.metadata != null || this.writeDefaultJFIF || this.writeAdobe;
        boolean bl7 = true;
        boolean bl8 = true;
        DQTMarkerSegment dQTMarkerSegment = null;
        DHTMarkerSegment dHTMarkerSegment = null;
        int n16 = 0;
        if (this.metadata != null) {
            dQTMarkerSegment = (DQTMarkerSegment)this.metadata.findMarkerSegment(DQTMarkerSegment.class, true);
            dHTMarkerSegment = (DHTMarkerSegment)this.metadata.findMarkerSegment(DHTMarkerSegment.class, true);
            object = (DRIMarkerSegment)this.metadata.findMarkerSegment(DRIMarkerSegment.class, true);
            if (object != null) {
                n16 = object.restartInterval;
            }
            if (dQTMarkerSegment == null) {
                bl7 = false;
            }
            if (dHTMarkerSegment == null) {
                bl8 = false;
            }
        }
        if (jPEGQTableArray == null) {
            jPEGQTableArray = dQTMarkerSegment != null ? this.collectQTablesFromMetadata(this.metadata) : (this.streamQTables != null ? this.streamQTables : (jPEGImageWriteParam != null && jPEGImageWriteParam.areTablesSet() ? jPEGImageWriteParam.getQTables() : JPEG.getDefaultQTables()));
        }
        if (!bl5) {
            if (dHTMarkerSegment != null && n3 == 0) {
                jPEGHuffmanTableArray = this.collectHTablesFromMetadata(this.metadata, true);
                jPEGHuffmanTableArray2 = this.collectHTablesFromMetadata(this.metadata, false);
            } else if (this.streamDCHuffmanTables != null) {
                jPEGHuffmanTableArray = this.streamDCHuffmanTables;
                jPEGHuffmanTableArray2 = this.streamACHuffmanTables;
            } else if (jPEGImageWriteParam != null && jPEGImageWriteParam.areTablesSet()) {
                jPEGHuffmanTableArray = jPEGImageWriteParam.getDCHuffmanTables();
                jPEGHuffmanTableArray2 = jPEGImageWriteParam.getACHuffmanTables();
            } else {
                jPEGHuffmanTableArray = JPEG.getDefaultHuffmanTables(true);
                jPEGHuffmanTableArray2 = JPEG.getDefaultHuffmanTables(false);
            }
        }
        object = new int[n7];
        int[] nArray5 = new int[n7];
        int[] nArray6 = new int[n7];
        int[] nArray7 = new int[n7];
        for (n = 0; n < n7; ++n) {
            object[n] = n + 1;
            nArray5[n] = 1;
            nArray6[n] = 1;
            nArray7[n] = 0;
        }
        if (sOFMarkerSegment != null) {
            for (n = 0; n < n7; ++n) {
                if (!this.forceJFIF) {
                    object[n] = sOFMarkerSegment.componentSpecs[n].componentId;
                }
                nArray5[n] = sOFMarkerSegment.componentSpecs[n].HsamplingFactor;
                nArray6[n] = sOFMarkerSegment.componentSpecs[n].VsamplingFactor;
                nArray7[n] = sOFMarkerSegment.componentSpecs[n].QtableSelector;
            }
        }
        this.sourceXOffset += n11;
        this.sourceWidth -= n11;
        this.sourceYOffset += n12;
        this.sourceHeight -= n12;
        n = (this.sourceWidth + n9 - 1) / n9;
        int n17 = (this.sourceHeight + n10 - 1) / n10;
        int n18 = this.sourceWidth * n7;
        DataBufferByte dataBufferByte = new DataBufferByte(n18);
        int[] nArray8 = JPEG.bandOffsets[n7 - 1];
        this.raster = Raster.createInterleavedRaster(dataBufferByte, this.sourceWidth, 1, n18, n7, nArray8, null);
        this.processImageStarted(this.currentImage);
        boolean bl9 = false;
        if (this.debug) {
            System.out.println("inCsType: " + n14);
            System.out.println("outCsType: " + n15);
        }
        if (bl9 = this.writeImage(this.structPointer, dataBufferByte.getData(), n14, n15, n7, nArray3, this.sourceWidth, n, n17, n9, n10, jPEGQTableArray, bl7, jPEGHuffmanTableArray, jPEGHuffmanTableArray2, bl8, bl5, n13 != 0, this.numScans, nArray4, (int[])object, nArray5, nArray6, nArray7, bl, n16)) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
        }
        this.ios.flush();
        ++this.currentImage;
    }

    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        if (this.ios == null) {
            throw new IllegalStateException("Output has not been set!");
        }
        if (iIOMetadata != null) {
            if (iIOMetadata instanceof JPEGMetadata) {
                JPEGMetadata jPEGMetadata = (JPEGMetadata)iIOMetadata;
                if (!jPEGMetadata.isStream) {
                    throw new IllegalArgumentException("Invalid stream metadata object.");
                }
                if (this.currentImage != 0) {
                    throw new IIOException("JPEG Stream metadata must precede all images");
                }
                if (this.sequencePrepared) {
                    throw new IIOException("Stream metadata already written!");
                }
                this.streamQTables = this.collectQTablesFromMetadata(jPEGMetadata);
                if (this.debug) {
                    System.out.println("after collecting from stream metadata, streamQTables.length is " + this.streamQTables.length);
                }
                if (this.streamQTables == null) {
                    this.streamQTables = JPEG.getDefaultQTables();
                }
                this.streamDCHuffmanTables = this.collectHTablesFromMetadata(jPEGMetadata, true);
                if (this.streamDCHuffmanTables == null) {
                    this.streamDCHuffmanTables = JPEG.getDefaultHuffmanTables(true);
                }
                this.streamACHuffmanTables = this.collectHTablesFromMetadata(jPEGMetadata, false);
                if (this.streamACHuffmanTables == null) {
                    this.streamACHuffmanTables = JPEG.getDefaultHuffmanTables(false);
                }
                this.writeTables(this.structPointer, this.streamQTables, this.streamDCHuffmanTables, this.streamACHuffmanTables);
            } else {
                throw new IIOException("Stream metadata must be JPEG metadata");
            }
        }
        this.sequencePrepared = true;
    }

    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (!this.sequencePrepared) {
            throw new IllegalStateException("sequencePrepared not called!");
        }
        this.write(null, iIOImage, imageWriteParam);
    }

    public void endWriteSequence() throws IOException {
        if (!this.sequencePrepared) {
            throw new IllegalStateException("sequencePrepared not called!");
        }
        this.sequencePrepared = false;
    }

    public synchronized void abort() {
        super.abort();
        this.abortWrite(this.structPointer);
    }

    private void resetInternalState() {
        this.resetWriter(this.structPointer);
        this.srcRas = null;
        this.raster = null;
        this.convertTosRGB = false;
        this.currentImage = 0;
        this.numScans = 0;
        this.metadata = null;
    }

    public void dispose() {
        if (this.structPointer != 0L) {
            this.disposerRecord.dispose();
            this.structPointer = 0L;
        }
    }

    void warningOccurred(int n) {
        if (n < 0 || n > 15) {
            throw new InternalError("Invalid warning index");
        }
        this.processWarningOccurred(this.currentImage, "com.sun.imageio.plugins.jpeg.JPEGImageWriterResources", Integer.toString(n));
    }

    void warningWithMessage(String string) {
        this.processWarningOccurred(this.currentImage, string);
    }

    void thumbnailStarted(int n) {
        this.processThumbnailStarted(this.currentImage, n);
    }

    void thumbnailProgress(float f) {
        this.processThumbnailProgress(f);
    }

    void thumbnailComplete() {
        this.processThumbnailComplete();
    }

    private void checkSOFBands(SOFMarkerSegment sOFMarkerSegment, int n) throws IIOException {
        if (sOFMarkerSegment != null && sOFMarkerSegment.componentSpecs.length != n) {
            throw new IIOException("Metadata components != number of destination bands");
        }
    }

    private void checkJFIF(JFIFMarkerSegment jFIFMarkerSegment, ImageTypeSpecifier imageTypeSpecifier, boolean bl) {
        if (jFIFMarkerSegment != null && !JPEG.isJFIFcompliant(imageTypeSpecifier, bl)) {
            this.ignoreJFIF = true;
            this.warningOccurred(bl ? 5 : 3);
        }
    }

    private void checkAdobe(AdobeMarkerSegment adobeMarkerSegment, ImageTypeSpecifier imageTypeSpecifier, boolean bl) {
        int n;
        if (adobeMarkerSegment != null && adobeMarkerSegment.transform != (n = JPEG.transformForType(imageTypeSpecifier, bl))) {
            this.warningOccurred(bl ? 6 : 4);
            if (n == -1) {
                this.ignoreAdobe = true;
            } else {
                this.newAdobeTransform = n;
            }
        }
    }

    private int[] collectScans(JPEGMetadata jPEGMetadata, SOFMarkerSegment sOFMarkerSegment) {
        ArrayList<MarkerSegment> arrayList = new ArrayList<MarkerSegment>();
        int n = 9;
        int n2 = 4;
        for (MarkerSegment markerSegment : jPEGMetadata.markerSequence) {
            if (!(markerSegment instanceof SOSMarkerSegment)) continue;
            arrayList.add(markerSegment);
        }
        Object object = null;
        this.numScans = 0;
        if (!arrayList.isEmpty()) {
            this.numScans = arrayList.size();
            object = new int[this.numScans * n];
            int n3 = 0;
            for (int i = 0; i < this.numScans; ++i) {
                SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)arrayList.get(i);
                object[n3++] = sOSMarkerSegment.componentSpecs.length;
                block2: for (int j = 0; j < n2; ++j) {
                    if (j < sOSMarkerSegment.componentSpecs.length) {
                        int n4 = sOSMarkerSegment.componentSpecs[j].componentSelector;
                        for (int k = 0; k < sOFMarkerSegment.componentSpecs.length; ++k) {
                            if (n4 != sOFMarkerSegment.componentSpecs[k].componentId) continue;
                            object[n3++] = k;
                            continue block2;
                        }
                        continue;
                    }
                    object[n3++] = false;
                }
                object[n3++] = sOSMarkerSegment.startSpectralSelection;
                object[n3++] = sOSMarkerSegment.endSpectralSelection;
                object[n3++] = sOSMarkerSegment.approxHigh;
                object[n3++] = sOSMarkerSegment.approxLow;
            }
        }
        return object;
    }

    private JPEGQTable[] collectQTablesFromMetadata(JPEGMetadata jPEGMetadata) {
        JPEGQTable[] jPEGQTableArray2;
        ArrayList arrayList = new ArrayList();
        for (JPEGQTable[] jPEGQTableArray2 : jPEGMetadata.markerSequence) {
            if (!(jPEGQTableArray2 instanceof DQTMarkerSegment)) continue;
            DQTMarkerSegment dQTMarkerSegment = (DQTMarkerSegment)jPEGQTableArray2;
            arrayList.addAll(dQTMarkerSegment.tables);
        }
        jPEGQTableArray2 = null;
        if (arrayList.size() != 0) {
            jPEGQTableArray2 = new JPEGQTable[arrayList.size()];
            for (int i = 0; i < jPEGQTableArray2.length; ++i) {
                jPEGQTableArray2[i] = new JPEGQTable(((DQTMarkerSegment.Qtable)arrayList.get((int)i)).data);
            }
        }
        return jPEGQTableArray2;
    }

    private JPEGHuffmanTable[] collectHTablesFromMetadata(JPEGMetadata jPEGMetadata, boolean bl) throws IIOException {
        int n;
        Object object;
        JPEGHuffmanTable[] jPEGHuffmanTableArray2;
        ArrayList<DHTMarkerSegment.Htable> arrayList = new ArrayList<DHTMarkerSegment.Htable>();
        for (JPEGHuffmanTable[] jPEGHuffmanTableArray2 : jPEGMetadata.markerSequence) {
            if (!(jPEGHuffmanTableArray2 instanceof DHTMarkerSegment)) continue;
            object = (DHTMarkerSegment)jPEGHuffmanTableArray2;
            for (n = 0; n < object.tables.size(); ++n) {
                DHTMarkerSegment.Htable htable = (DHTMarkerSegment.Htable)object.tables.get(n);
                if (htable.tableClass != (bl ? 0 : 1)) continue;
                arrayList.add(htable);
            }
        }
        jPEGHuffmanTableArray2 = null;
        if (arrayList.size() != 0) {
            object = new DHTMarkerSegment.Htable[arrayList.size()];
            arrayList.toArray((T[])object);
            jPEGHuffmanTableArray2 = new JPEGHuffmanTable[arrayList.size()];
            for (n = 0; n < jPEGHuffmanTableArray2.length; ++n) {
                jPEGHuffmanTableArray2[n] = null;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (object[i].tableID != n) continue;
                    if (jPEGHuffmanTableArray2[n] != null) {
                        throw new IIOException("Metadata has duplicate Htables!");
                    }
                    jPEGHuffmanTableArray2[n] = new JPEGHuffmanTable(object[i].numCodes, object[i].values);
                }
            }
        }
        return jPEGHuffmanTableArray2;
    }

    private int getSrcCSType(ImageTypeSpecifier imageTypeSpecifier) {
        return this.getSrcCSType(imageTypeSpecifier.getColorModel());
    }

    private int getSrcCSType(RenderedImage renderedImage) {
        return this.getSrcCSType(renderedImage.getColorModel());
    }

    private int getSrcCSType(ColorModel colorModel) {
        int n = 0;
        if (colorModel != null) {
            boolean bl = colorModel.hasAlpha();
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 6: {
                    n = 1;
                    break;
                }
                case 5: {
                    if (bl) {
                        n = 6;
                        break;
                    }
                    n = 2;
                    break;
                }
                case 3: {
                    if (bl) {
                        n = 7;
                        break;
                    }
                    n = 3;
                    break;
                }
                case 13: {
                    if (colorSpace == JPEG.YCC) {
                        n = bl ? 10 : 5;
                    }
                }
                case 9: {
                    n = 4;
                }
            }
        }
        return n;
    }

    private int getDestCSType(ImageTypeSpecifier imageTypeSpecifier) {
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        boolean bl = colorModel.hasAlpha();
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n = 0;
        switch (colorSpace.getType()) {
            case 6: {
                n = 1;
                break;
            }
            case 5: {
                if (bl) {
                    n = 6;
                    break;
                }
                n = 2;
                break;
            }
            case 3: {
                if (bl) {
                    n = 7;
                    break;
                }
                n = 3;
                break;
            }
            case 13: {
                if (colorSpace == JPEG.YCC) {
                    n = bl ? 10 : 5;
                }
            }
            case 9: {
                n = 4;
            }
        }
        return n;
    }

    private int getDefaultDestCSType(ImageTypeSpecifier imageTypeSpecifier) {
        return this.getDefaultDestCSType(imageTypeSpecifier.getColorModel());
    }

    private int getDefaultDestCSType(RenderedImage renderedImage) {
        return this.getDefaultDestCSType(renderedImage.getColorModel());
    }

    private int getDefaultDestCSType(ColorModel colorModel) {
        int n = 0;
        if (colorModel != null) {
            boolean bl = colorModel.hasAlpha();
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 6: {
                    n = 1;
                    break;
                }
                case 5: {
                    if (bl) {
                        n = 7;
                        break;
                    }
                    n = 3;
                    break;
                }
                case 3: {
                    if (bl) {
                        n = 7;
                        break;
                    }
                    n = 3;
                    break;
                }
                case 13: {
                    if (colorSpace == JPEG.YCC) {
                        n = bl ? 10 : 5;
                    }
                }
                case 9: {
                    n = 11;
                }
            }
        }
        return n;
    }

    private boolean isSubsampled(SOFMarkerSegment.ComponentSpec[] componentSpecArray) {
        int n = componentSpecArray[0].HsamplingFactor;
        int n2 = componentSpecArray[0].VsamplingFactor;
        for (int i = 1; i < componentSpecArray.length; ++i) {
            if (componentSpecArray[i].HsamplingFactor == n && componentSpecArray[i].HsamplingFactor == n) continue;
            return true;
        }
        return false;
    }

    private static native void initWriterIDs(Class var0, Class var1, Class var2);

    private native long initJPEGImageWriter();

    private native void setDest(long var1, ImageOutputStream var3);

    private native boolean writeImage(long var1, byte[] var3, int var4, int var5, int var6, int[] var7, int var8, int var9, int var10, int var11, int var12, JPEGQTable[] var13, boolean var14, JPEGHuffmanTable[] var15, JPEGHuffmanTable[] var16, boolean var17, boolean var18, boolean var19, int var20, int[] var21, int[] var22, int[] var23, int[] var24, int[] var25, boolean var26, int var27);

    private void writeMetadata() throws IOException {
        if (this.metadata == null) {
            if (this.writeDefaultJFIF) {
                JFIFMarkerSegment.writeDefaultJFIF(this.ios, this.thumbnails, this.iccProfile, this);
            }
            if (this.writeAdobe) {
                AdobeMarkerSegment.writeAdobeSegment(this.ios, this.newAdobeTransform);
            }
        } else {
            this.metadata.writeToStream(this.ios, this.ignoreJFIF, this.forceJFIF, this.thumbnails, this.iccProfile, this.ignoreAdobe, this.newAdobeTransform, this);
        }
    }

    private native void writeTables(long var1, JPEGQTable[] var3, JPEGHuffmanTable[] var4, JPEGHuffmanTable[] var5);

    private void grabPixels(int n) {
        Object object;
        Raster raster = null;
        if (this.indexed) {
            raster = this.srcRas.createChild(this.sourceXOffset, this.sourceYOffset + n, this.sourceWidth, 1, 0, 0, new int[]{0});
            boolean bl = this.indexCM.getTransparency() != 1;
            object = this.indexCM.convertToIntDiscrete(raster, bl);
            raster = ((BufferedImage)object).getRaster();
        } else {
            raster = this.srcRas.createChild(this.sourceXOffset, this.sourceYOffset + n, this.sourceWidth, 1, 0, 0, this.srcBands);
        }
        if (this.convertTosRGB) {
            if (this.debug) {
                System.out.println("Converting to sRGB");
            }
            this.converted = this.convertOp.filter(raster, this.converted);
            raster = this.converted;
        }
        if (this.isAlphaPremultiplied) {
            WritableRaster writableRaster = raster.createCompatibleWritableRaster();
            object = null;
            object = raster.getPixels(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), (int[])object);
            writableRaster.setPixels(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), (int[])object);
            this.srcCM.coerceData(writableRaster, false);
            raster = writableRaster.createChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, this.srcBands);
        }
        this.raster.setRect(raster);
        if (n > 7 && n % 8 == 0) {
            this.processImageProgress((float)n / (float)this.sourceHeight * 100.0f);
        }
    }

    private native void abortWrite(long var1);

    private native void resetWriter(long var1);

    private static native void disposeWriter(long var0);

    static {
        AccessController.doPrivileged(new LoadLibraryAction("jpeg"));
        JPEGImageWriter.initWriterIDs(ImageOutputStream.class, JPEGQTable.class, JPEGHuffmanTable.class);
        preferredThumbSizes = new Dimension[]{new Dimension(1, 1), new Dimension(255, 255)};
    }

    private static class JPEGWriterDisposerRecord
    implements DisposerRecord {
        private long pData;

        public JPEGWriterDisposerRecord(long l) {
            this.pData = l;
        }

        public synchronized void dispose() {
            if (this.pData != 0L) {
                JPEGImageWriter.disposeWriter(this.pData);
                this.pData = 0L;
            }
        }
    }
}

