{
  This demo makes PDF files using LLPDFLib (http://www.llion.net)
  It creates A4 documents. To change page size, replace values srvfmA4 and psA4.
}

unit MakePDFFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, ExtCtrls, SclRView, PDF, Printers, ComCtrls, RVStyle, CRVData;

type
  TfrmMakePDF = class(TForm)
    srve: TSRichViewEdit;
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    cbClipMargins: TCheckBox;
    cbPageNoVisible: TCheckBox;
    btnOpenFile: TButton;
    btnSavePDF: TButton;
    SaveDialog1: TSaveDialog;
    pdf: TPDFDocument;
    StatusBar1: TStatusBar;
    procedure btnOpenFileClick(Sender: TObject);
    procedure btnSavePDFClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure srveDrawHyperlink(Sender: TSRichViewEdit; Canvas: TCanvas;
      RVData: TCustomRVData; PageNo, ItemNo: Integer; RepaintRect,
      R: TRect);
  private
    { Private declarations }
    function MakePageMetafile(PageNo, Width, Height: Integer): TMetafile;
  public
    { Public declarations }
  end;

var
  frmMakePDF: TfrmMakePDF;
  pdfPageNo : Integer;

implementation

{$R *.DFM}

// Form.OnCreate: assigning page properties for document
procedure TfrmMakePDF.FormCreate(Sender: TObject);
begin
  srve.PageProperty.Orientation := poPortrait;
  srve.PageProperty.PageFormat := srvfmA4;
end;

// Returns page image as metafile Width x Height pixels
function TfrmMakePDF.MakePageMetafile(PageNo, Width, Height: Integer): TMetafile;
begin
  Result := TMetafile.Create;
  Result.Width := Width;
  Result.Height := Height;
  pdfPageNo := PageNo;
  srve.CanUpdate := False;
  srve.UseDrawHyperlinksEvent := True;
  srve.DrawMetafile(PageNo, Result, cbPageNoVisible.Checked, cbClipMargins.Checked,
    False);
  srve.UseDrawHyperlinksEvent := False;
  srve.CanUpdate := True;
end;

// Opening RVF or RTF file
procedure TfrmMakePDF.btnOpenFileClick(Sender: TObject);
begin
  if OpenDialog1.Execute then begin
    Application.Hint := 'Reading file...';
    srve.Update;
    Screen.Cursor := crHourGlass;
    try
      case OpenDialog1.FilterIndex of
        1: srve.LoadRVF(OpenDialog1.FileName);
        2: begin
             srve.RichViewEdit.Clear;
             srve.RichViewEdit.DeleteUnusedStyles(True, True, True);
             srve.RichViewEdit.LeftMargin := 132;
             srve.RichViewEdit.RightMargin := 57;
             srve.RichViewEdit.TopMargin := 94;
             srve.RichViewEdit.BottomMargin := 94;
             srve.RichViewEdit.LoadRTF(OpenDialog1.FileName);
             srve.RichViewEdit.Format;
           end;
      end;
    finally
      Screen.Cursor := crDefault;
      Application.Hint := '';
    end;
  end;
end;

// Making PDF
procedure TfrmMakePDF.btnSavePDFClick(Sender: TObject);
var i: Integer;
    Metafile: TMetafile;
begin
  if not SaveDialog1.Execute then
    exit;
  srve.Update;
  pdf.FileName := SaveDialog1.FileName;
  pdf.Resolution := Round(srve.UnitsPerInchH(rvuPixels));
  pdf.BeginDoc;

  pdf.Page[0].Size := psA4;
  pdf.Page[0].Orientation := poPagePortrait;

  Screen.Cursor := crHourGlass;
  try
    Application.Hint := 'Formatting...';
    for i := 0 to srve.PageCount-1 do begin
      if i>0 then begin
        pdf.NewPage;
        pdf.Page[i].Size        := pdf.Page[0].Size;
        pdf.Page[i].Orientation := pdf.Page[0].Orientation;
      end;
      Metafile := MakePageMetafile(i+1, pdf.Page[i].Width, pdf.Page[i].Height);
      pdf.Canvas.Draw(0, 0, Metafile);
      Metafile.Free;
      Application.Hint := Format('Collecting PDF pages (%d of %d)... ', [i+1, srve.PageCount]);
    end;
    Application.Hint := 'Writing PDF file...';
    pdf.EndDoc;
  finally
    Screen.Cursor := crDefault;
    Application.Hint := '';
  end;
end;

procedure TfrmMakePDF.srveDrawHyperlink(Sender: TSRichViewEdit;
  Canvas: TCanvas; RVData: TCustomRVData; PageNo, ItemNo: Integer;
  RepaintRect, R: TRect);
var
     url : String;
begin
  url := PChar(RVData.GetItemTag(ItemNo));
  pdf.Page[pdfPageNo-1].SetUrl(R, url);
end;

end.