unit MFSRVControls;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SclRView, RVScroll, SRVButton, SRVCheckBox, SRVEdit, SRVGroupBox, SRVLabel,
  SRVPanel, SRVRadioButton, SRVMediaPlayer;

type
  TFSRVControls = class(TForm)
    SRichViewEdit1: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure SRichViewEdit1MessageControl(Sender: TSRichViewEdit;
      AControl: TControl; var Message: TMessage);
    procedure SRichViewEdit1CheckControl(Sender: TSRichViewEdit;
      AControl: TControl);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FSRVControls: TFSRVControls;

implementation

{$R *.DFM}

procedure TFSRVControls.FormCreate(Sender: TObject);
begin
  SRichViewEdit1.RichViewEdit.ReadOnly := True;
  SRichViewEdit1.RichViewEdit.Options := SRichViewEdit1.RichViewEdit.Options - [rvoAllowSelection];
  SRichViewEdit1.LoadRVF('SRVControls.rvf');
  SRichViewEdit1.ProcessControls;
end;

procedure TFSRVControls.SRichViewEdit1MessageControl(
  Sender: TSRichViewEdit; AControl: TControl; var Message: TMessage);
begin
  if Message.Msg <> WM_LBUTTONUP then exit;

  if AControl is TSRVButton then
    Application.MessageBox('Pressed', 'TSRVButton', 0);

  if AControl is TSRVEdit then
    Application.MessageBox(PChar('Text: ' + TSRVEdit(AControl).Text), 'TSRVEdit', 0);

  if AControl is TSRVCheckBox then
    if TSRVCheckBox(AControl).Checked then
      Application.MessageBox('Checked = True', 'TSRVCheckBox', 0)
    else
      Application.MessageBox('Checked = False', 'TSRVCheckBox', 0);

  if AControl is TSRVRadioButton then
    Application.MessageBox('Pressed', 'TSRVRadioButton', 0);

  if AControl is TSRVLabel then
    Application.MessageBox('Clicked', 'TSRVLabel', 0);

  if AControl is TSRVGroupBox then
    Application.MessageBox('Clicked', 'TSRVGroupBox', 0);

  if AControl is TSRVPanel then
    Application.MessageBox('Clicked', 'TSRVPanel', 0);
end;

procedure TFSRVControls.SRichViewEdit1CheckControl(Sender: TSRichViewEdit;
  AControl: TControl);
begin
  if (AControl is TSRVMediaPlayer) then
    with TSRVMediaPlayer(AControl) do begin
      OnMouseDown := FormMouseDown;
      Display := Sender;
      Open;
      Width := VideoWidth;
      Height := VideoHeight;
      Play;
    end;
end;

procedure TFSRVControls.FormMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  with TSRVMediaPlayer(Sender) do
    Application.MessageBox(PChar('FileName: ' + FileName + #13 + #10 +
                                 'VideoWidth: ' + IntToStr(VideoWidth) + #13 + #10 +
                                 'VideoHeight: ' + IntToStr(VideoHeight)), 'TSRVMediaPlayer', 0)
end;

initialization
  RegisterClass(TSRVButton);
  RegisterClass(TSRVEdit);
  RegisterClass(TSRVCheckBox);
  RegisterClass(TSRVRadioButton);
  RegisterClass(TSRVLabel);
  RegisterClass(TSRVGroupBox);
  RegisterClass(TSRVPanel);

  RegisterClass(TSRVMediaPlayer);

end.
