
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Demo project.                                   }
{       You can use it as a basis for your              }
{       applications.                                   }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}


unit Unit3Tnt;

interface

{
  Remove dots from the defines below to enable support for Gif and Png.

  GifImage (by Anders Melander)
    http://www.torry.net/vcl/graphics/gif/gifimage.exe (original)
    http://www.trichview.com/resources/thirdparty/gifimage.zip (update)
  Note: for Delphi 2007, use the built in TGifImage instead)
  PngObject (by Gustavo Huffenbacher Daud)
    http://pngdelphi.sourceforge.net/
}

{$I RV_Defs.inc}          // contains defines about Delphi compiler versions

{.$DEFINE USE_GIFIMAGE}
{.$DEFINE USE_PNGOBJECT}


uses
  Windows, Messages, SysUtils,
  Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,
  ActnList, StdActns, ImgList,
  Menus, ShellApi, Printers, ToolWin, RVUni,

  {$IFDEF USE_GIFIMAGE}
  GifImage, { Change to GifImg for Delphi 2007 }
  {$ENDIF}
  {$IFDEF USE_PNGOBJECT}
  PngImage,
  {$ENDIF}

  RVScroll, RichView, RVEdit,
  RVStyle, PtblRV, CRVFData, RVTable, RVItem, CRVData, RVFuncs,

  // RVAAddictLanguages,

  RichViewActions, RVALocRuler, RVFontCombos, RVALocalize, Ruler, RVRuler,
  BaseRVFrm,

  TntComCtrls, TntMenus, TntForms;

type
  TForm3 = class(TTntForm)
    RichViewEdit1: TRichViewEdit;
    MainMenu1: TTntMainMenu;
    mitFile: TTntMenuItem;
    mitEdit: TTntMenuItem;
    New1: TTntMenuItem;
    Load1: TTntMenuItem;
    PrintPreview1: TTntMenuItem;
    N1: TTntMenuItem;
    Print1: TTntMenuItem;
    mitExit: TTntMenuItem;
    Cut1: TTntMenuItem;
    Copy1: TTntMenuItem;
    n2: TTntMenuItem;
    mitFont: TTntMenuItem;
    Bold1: TTntMenuItem;
    Italic1: TTntMenuItem;
    Underline1: TTntMenuItem;
    N3: TTntMenuItem;
    mitPara: TTntMenuItem;
    Leftjustify1: TTntMenuItem;
    N4: TTntMenuItem;
    Undo1: TTntMenuItem;
    Redo1: TTntMenuItem;
    Changefont1: TTntMenuItem;
    Save1: TTntMenuItem;
    Strikeout1: TTntMenuItem;
    mitTable: TTntMenuItem;
    InsertTable1: TTntMenuItem;
    N5: TTntMenuItem;
    SelectAll1: TTntMenuItem;
    AlignLeft1: TTntMenuItem;
    AlignCenter1: TTntMenuItem;
    AlignRight1: TTntMenuItem;
    N6: TTntMenuItem;
    DecreaseIndent1: TTntMenuItem;
    IncreaseIndent1: TTntMenuItem;
    RVStyle1: TRVStyle;
    N7: TTntMenuItem;
    StatusBar1: TTntStatusBar;
    Justify1: TTntMenuItem;
    InsertRowAbove1: TTntMenuItem;
    InsertRowBelow1: TTntMenuItem;
    N8: TTntMenuItem;
    InsertColumnLeft1: TTntMenuItem;
    InsertColumnRight1: TTntMenuItem;
    N9: TTntMenuItem;
    N10: TTntMenuItem;
    DeleteRows1: TTntMenuItem;
    rvActionTableDeleteCols11: TTntMenuItem;
    N11: TTntMenuItem;
    MergeCells1: TTntMenuItem;
    SplitCells1: TTntMenuItem;
    N12: TTntMenuItem;
    mitTableSelect: TTntMenuItem;
    SelectTable1: TTntMenuItem;
    SelectColumns1: TTntMenuItem;
    SelectRows1: TTntMenuItem;
    SelectCell1: TTntMenuItem;
    mitFontStyle: TTntMenuItem;
    mitFontSize: TTntMenuItem;
    ShrinkFont1: TTntMenuItem;
    GrowFont1: TTntMenuItem;
    N13: TTntMenuItem;
    ShrinkFontByOnePoint1: TTntMenuItem;
    GrowFontByOnePoint1: TTntMenuItem;
    N14: TTntMenuItem;
    AllCapitals1: TTntMenuItem;
    Overline1: TTntMenuItem;
    N15: TTntMenuItem;
    Find1: TTntMenuItem;
    FindNext1: TTntMenuItem;
    Replace1: TTntMenuItem;
    CoolBar1: TCoolBar;
    ToolBar1: TTntToolBar;
    ToolButton11: TTntToolButton;
    ToolButton1: TTntToolButton;
    ToolButton2: TTntToolButton;
    ToolButton13: TTntToolButton;
    ToolButton22: TTntToolButton;
    ToolButton17: TTntToolButton;
    ToolButton18: TTntToolButton;
    ToolButton19: TTntToolButton;
    ToolButton20: TTntToolButton;
    ToolButton21: TTntToolButton;
    ToolBar2: TTntToolBar;
    ToolButton41: TTntToolButton;
    ToolButton42: TTntToolButton;
    ToolButton43: TTntToolButton;
    ToolButton44: TTntToolButton;
    ToolButton49: TTntToolButton;
    ToolButton50: TTntToolButton;
    ToolButton51: TTntToolButton;
    ToolButton53: TTntToolButton;
    ToolButton54: TTntToolButton;
    ToolButton3: TTntToolButton;
    ToolButton4: TTntToolButton;
    ToolButton5: TTntToolButton;
    ToolButton6: TTntToolButton;
    ToolButton7: TTntToolButton;
    ToolBar3: TTntToolBar;
    ToolButton9: TTntToolButton;
    ToolButton10: TTntToolButton;
    ToolButton12: TTntToolButton;
    ToolButton14: TTntToolButton;
    ToolButton15: TTntToolButton;
    ToolButton16: TTntToolButton;
    ToolButton23: TTntToolButton;
    ToolButton24: TTntToolButton;
    ToolButton25: TTntToolButton;
    ToolButton26: TTntToolButton;
    ToolButton28: TTntToolButton;
    ToolButton8: TTntToolButton;
    ToolButton27: TTntToolButton;
    ToolButton29: TTntToolButton;
    ToolButton30: TTntToolButton;
    ToolButton31: TTntToolButton;
    ToolButton32: TTntToolButton;
    ToolButton33: TTntToolButton;
    ToolButton34: TTntToolButton;
    ToolButton35: TTntToolButton;
    N16: TTntMenuItem;
    ToolButton36: TTntToolButton;
    ToolButton37: TTntToolButton;
    extColor1: TTntMenuItem;
    ToolButton38: TTntToolButton;
    extBackgroundColor1: TTntMenuItem;
    N17: TTntMenuItem;
    ParagraphBackgroundColor1: TTntMenuItem;
    ToolButton39: TTntToolButton;
    ToolButton40: TTntToolButton;
    mitFormat: TTntMenuItem;
    BackgroundColor1: TTntMenuItem;
    DeleteTable1: TTntMenuItem;
    ToolButton45: TTntToolButton;
    N18: TTntMenuItem;
    rvActionParagraph11: TTntMenuItem;
    RVAControlPanel1: TRVAControlPanel;
    Font1: TTntMenuItem;
    FillColor1: TTntMenuItem;
    SaveAs1: TTntMenuItem;
    Export1: TTntMenuItem;
    mitInsert: TTntMenuItem;
    File1: TTntMenuItem;
    Picture1: TTntMenuItem;
    ToolButton46: TTntToolButton;
    PasteSpecial1: TTntMenuItem;
    N19: TTntMenuItem;
    SingleLineSpacing1: TTntMenuItem;
    N15LineSpacing1: TTntMenuItem;
    DoubleLineSpacing1: TTntMenuItem;
    N20: TTntMenuItem;
    InsertPageBreak1: TTntMenuItem;
    RemovePageBreak1: TTntMenuItem;
    N21: TTntMenuItem;
    mitTableAlignCellContents: TTntMenuItem;
    AlignCellToTheTop1: TTntMenuItem;
    AlignCellToTheMiddle1: TTntMenuItem;
    AlignCellToTheBottom1: TTntMenuItem;
    DefaultCellVerticalAlignment1: TTntMenuItem;
    ParagraphBorders1: TTntMenuItem;
    N22: TTntMenuItem;
    Properties1: TTntMenuItem;
    HorizontalLine1: TTntMenuItem;
    HypertextLink1: TTntMenuItem;
    ToolButton47: TTntToolButton;
    N23: TTntMenuItem;
    ableProperties1: TTntMenuItem;
    N24: TTntMenuItem;
    ShowGridLines1: TTntMenuItem;
    N25: TTntMenuItem;
    BulletsandNumbering1: TTntMenuItem;
    InsertSymbol1: TTntMenuItem;
    mitTableCellBorders: TTntMenuItem;
    LeftBorder1: TTntMenuItem;
    rvActionTableCellTopBorder11: TTntMenuItem;
    rvActionTableCellRightBorder11: TTntMenuItem;
    rvActionTableCellBottomBorder11: TTntMenuItem;
    rvActionTableCellAllBorders11: TTntMenuItem;
    rvActionTableCellNoBorders11: TTntMenuItem;
    ToolBar4: TTntToolBar;
    ToolButton48: TTntToolButton;
    ToolButton52: TTntToolButton;
    ToolButton55: TTntToolButton;
    ToolButton56: TTntToolButton;
    ToolButton58: TTntToolButton;
    ToolButton59: TTntToolButton;
    Bullets1: TTntMenuItem;
    Numbering1: TTntMenuItem;
    ToolButton57: TTntToolButton;
    ToolButton60: TTntToolButton;
    ToolButton61: TTntToolButton;
    ToolBar5: TTntToolBar;
    cmbFont: TRVFontComboBox;
    RVAPopupMenu1: TRVAPopupMenu;
    Background1: TTntMenuItem;
    RVPrint1: TRVPrint;
    ColorDialog1: TColorDialog;
    Button1: TButton;
    cmbFontSize: TRVFontSizeComboBox;
    PageSetup1: TTntMenuItem;
    N26: TTntMenuItem;
    CharacterCase1: TTntMenuItem;
    RVRuler1: TRVRuler;
    ToolButton62: TTntToolButton;
    ToolButton63: TTntToolButton;
    pmFakeDropDown: TPopupMenu;
    N27: TTntMenuItem;
    rvActionSubscript11: TTntMenuItem;
    rvActionSuperscript11: TTntMenuItem;
    ToolButton64: TTntToolButton;
    ToolButton65: TTntToolButton;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure mitExitClick(Sender: TObject);
    procedure RichViewEdit1Jump(Sender: TObject; id: Integer);
    procedure RichViewEdit1ReadHyperlink(Sender: TCustomRichView;
      const Target, Extras: String; DocFormat: TRVLoadFormat; var StyleNo,
      ItemTag: Integer; var ItemName: String);
    procedure cmbFontClick(Sender: TObject);
    procedure cmbKeyPress(Sender: TObject; var Key: Char);
    procedure RichViewEdit1CurTextStyleChanged(Sender: TObject);
    procedure cmbFontSizeClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure RichViewEdit1WriteHyperlink(Sender: TCustomRichView;
      id: Integer; RVData: TCustomRVData; ItemNo: Integer;
      SaveFormat: TRVSaveFormat; var Target, Extras: String);
    procedure RVAControlPanel1MarginsChanged(Sender: TrvAction;
      Edit: TCustomRichViewEdit);
    procedure RVAControlPanel1Download(Sender: TrvAction;
      const Source: String);
    procedure pmFakeDropDownPopup(Sender: TObject);
    procedure RichViewEdit1KeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    UpdatingCombos: Boolean;
    procedure ColorPickerShow(Sender: TObject);
    procedure ColorPickerHide(Sender: TObject);
    procedure rvActionSave1DocumentFileChange(Sender: TObject;
      Editor: TCustomRichViewEdit; const FileName: String;
      FileFormat: TrvFileSaveFilter; IsNew: Boolean);
    procedure Localize;
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

uses dmActions;
{$R *.dfm}

procedure TForm3.FormCreate(Sender: TObject);
begin
  // Almost all these assignments could be done at design time in the Object Inspector
  // But in this demo we do not want to modify rvActionsResource
  // (and we recommend to use a copy of it in your applications)

  rvActionsResource.rvActionSave1.OnDocumentFileChange := rvActionSave1DocumentFileChange;

  // Code for making color-picking buttons stay pressed while a
  // color-picker window is visible.
  rvActionsResource.rvActionColor1.OnShowColorPicker := ColorPickerShow;
  rvActionsResource.rvActionColor1.OnHideColorPicker := ColorPickerHide;
  rvActionsResource.rvActionParaColor1.OnShowColorPicker := ColorPickerShow;
  rvActionsResource.rvActionParaColor1.OnHideColorPicker := ColorPickerHide;
  rvActionsResource.rvActionFontColor1.OnShowColorPicker := ColorPickerShow;
  rvActionsResource.rvActionFontColor1.OnHideColorPicker := ColorPickerHide;
  rvActionsResource.rvActionFontBackColor1.OnShowColorPicker := ColorPickerShow;
  rvActionsResource.rvActionFontBackColor1.OnHideColorPicker := ColorPickerHide;

  // Delphi 4 and 5 do not have ActionComponent property for actions.
  // Coloring actions have a substitution - CallerControl property
  // It is ignored in Delphi 6 and 7
  rvActionsResource.rvActionParaColor1.CallerControl := ToolButton39;
  rvActionsResource.rvActionFontBackColor1.CallerControl := ToolButton38;
  rvActionsResource.rvActionFontColor1.CallerControl := ToolButton36;

  {$IFDEF RICHVIEWDEF6}
  // AutoComplete feature causes OnClick generation when editing combo-box's text.
  // Since in OnClick we move input focus in RichViewEdit1, this effect is
  // undesirable
  cmbFont.AutoComplete := False;
  cmbFontSize.AutoComplete := False;
  {$ENDIF}

  Localize;

  // Loading initial file via ActionOpen (allowing to update user interface)
  rvActionsResource.rvActionOpen1.LoadFile(RichViewEdit1,
    ExtractFilePath(Application.ExeName)+'readme.rvf', ffiRVF);

  {
  // alternative way to start
    rvActionsResource.rvActionNew1.ExecuteTarget(RichViewEdit1);
  }
end;


{------------------- Working with document ------------------------------------}

// When document is created, saved, loaded...
procedure TForm3.rvActionSave1DocumentFileChange(Sender: TObject;
  Editor: TCustomRichViewEdit; const FileName: String;
  FileFormat: TrvFileSaveFilter; IsNew: Boolean);
var s: String;
begin
  s := ExtractFileName(FileName);
  rvActionsResource.rvActionPrint1.Title := s;
  rvActionsResource.rvActionQuickPrint1.Title := s;
  if IsNew then
    s := s+' (*)';
  Caption := s + ' - RichViewActionsTest';
end;

// Prompt for saving...
procedure TForm3.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := rvActionsResource.rvActionSave1.CanCloseDoc(RichViewEdit1);
end;

procedure TForm3.mitExitClick(Sender: TObject);
begin
  Close;
end;

{--------------- Working with color-picking buttons ---------------------------}

// Code for making color-picking buttons pressed while
// a color-picker window is visible.
procedure TForm3.ColorPickerShow(Sender: TObject);
begin
  {$IFDEF RICHVIEWDEF6}
  if (Sender as TAction).ActionComponent is TToolButton then
    TToolButton(TAction(Sender).ActionComponent).Down := True;
  {$ELSE}
  if TrvActionCustomColor(Sender).CallerControl<>nil then
    TToolButton(TrvActionCustomColor(Sender).CallerControl).Down := True;
  {$ENDIF};
end;

procedure TForm3.ColorPickerHide(Sender: TObject);
begin
  {$IFDEF RICHVIEWDEF6}
  if (Sender as TAction).ActionComponent is TToolButton then
    TToolButton(TAction(Sender).ActionComponent).Down := False;
  {$ELSE}
  if TrvActionCustomColor(Sender).CallerControl<>nil then
    TToolButton(TrvActionCustomColor(Sender).CallerControl).Down := False;
  {$ENDIF}
end;

{-------------- Set of events for processing hypertext jumps ------------------}

// Hyperlink click
procedure TForm3.RichViewEdit1Jump(Sender: TObject; id: Integer);
begin
  rvActionsResource.rvActionInsertHyperlink1.GoToLink(RichViewEdit1, id);
end;

// Importing hyperlink from RTF
procedure TForm3.RichViewEdit1ReadHyperlink(Sender: TCustomRichView;
  const Target, Extras: String; DocFormat: TRVLoadFormat; var StyleNo,
  ItemTag: Integer; var ItemName: String);
var URL: String;
begin
  if DocFormat=rvlfURL then
    StyleNo :=
      rvActionsResource.rvActionInsertHyperlink1.GetHyperlinkStyleNo(RichViewEdit1);
  URL := rvActionsResource.rvActionInsertHyperlink1.EncodeTarget(Target);
  ItemTag := Integer(StrNew(PChar(URL)));
end;

// Exporting hyperlink to RTF and HTML
procedure TForm3.RichViewEdit1WriteHyperlink(Sender: TCustomRichView;
  id: Integer; RVData: TCustomRVData; ItemNo: Integer;
  SaveFormat: TRVSaveFormat; var Target, Extras: String);
begin
  Target := PChar(RVData.GetItemTag(ItemNo));
end;

// URL detection on typing
procedure TForm3.RichViewEdit1KeyPress(Sender: TObject; var Key: Char);
begin
  {
  // uncomment if you use Addict3
  if (Key in ['''', #13, #9]) or (Pos(Key, RichViewEdit1.Delimiters)<>0) then
    RVA_Addict3AutoCorrect(RichViewEdit1);
  }
  if Key in [#13, #9, ' ', ',', ';'] then begin
    rvActionsResource.rvActionInsertHyperlink1.DetectURL(RichViewEdit1);
    rvActionsResource.rvActionInsertHyperlink1.TerminateHyperlink(RichViewEdit1);
  end;
end;

{----------------------- Insert table popup      -----------------------------}
{ We use a trick: insert-table button has style tbsDropDown and assigned
  DropDownMenu (pmFakeDropDown). This menu is empty, but shows table size
  popup instead of itself }
procedure TForm3.pmFakeDropDownPopup(Sender: TObject);
begin
  rvActionsResource.rvActionInsertTable1.ShowTableSizeDialog(RichViewEdit1,
    ToolButton12);
end;

{----------------------- Working with combo-boxes -----------------------------}

// Current font is changed. Updating the combo-boxes.
procedure TForm3.RichViewEdit1CurTextStyleChanged(Sender: TObject);
var CurStyle: TFontInfo;
begin
  UpdatingCombos := True;
  try
    CurStyle := RVStyle1.TextStyles[RichViewEdit1.CurTextStyleNo];
    cmbFont.Text := CurStyle.FontName;
    cmbFont.OnClick(Sender);
    cmbFontSize.FontName := CurStyle.FontName;
    cmbFontSize.Text := IntToStr(CurStyle.Size);
  finally
    UpdatingCombos := False;
  end;
end;

// Applying the font name
procedure TForm3.cmbFontClick(Sender: TObject);
var FontName: String;
begin
  if cmbFont.ItemIndex<0 then
    FontName := cmbFont.Text
  else
    FontName := cmbFont.Items[cmbFont.ItemIndex];
  if UpdatingCombos then
    exit;
  UpdatingCombos := True;
  cmbFontSize.FontName := FontName;
  UpdatingCombos := False;
  if cmbFont.ItemIndex<0 then
    cmbFont.ItemIndex := cmbFont.Items.IndexOf(FontName);
  if cmbFont.ItemIndex<0 then begin
      Beep
    end
  else
    with rvActionsResource.rvActionFontEx1 do begin
      UserInterface := False;
      ValidProperties := [rvfimFontName];
      Font.Name := FontName;
      Execute;
      UserInterface := True;
    end;
  RichViewEdit1.SetFocus;
end;

// Changing the font size
procedure TForm3.cmbFontSizeClick(Sender: TObject);
var FontSize: Integer;
begin
  if UpdatingCombos then
    exit;
  try
    FontSize := StrToInt(cmbFontSize.Text);
    with rvActionsResource.rvActionFontEx1 do begin
      UserInterface := False;
      ValidProperties := [rvfimSize];
      Font.Size := FontSize;
      Execute;
      UserInterface := True;
    end;
  except
    Beep;
  end;
  RichViewEdit1.SetFocus;
end;

procedure TForm3.cmbKeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#13 then begin
    Key := #0;
    TComboBox(Sender).OnClick(Sender);
  end;
end;

{---------------------------- Ruler ------------------------------------}

procedure TForm3.RVAControlPanel1MarginsChanged(Sender: TrvAction;
  Edit: TCustomRichViewEdit);
begin
  RVRuler1.UpdateRulerMargins;
end;

{---------------------------- Localization ------------------------------------}

procedure TForm3.Button1Click(Sender: TObject);
begin
  if RVA_ChooseLanguage then
    Localize;
end;

procedure TForm3.Localize;
begin
  // Fonts
  Font.Charset            := RVA_GetCharset;
  StatusBar1.Font.Charset := RVA_GetCharset;
  {$IFDEF RICHVIEWDEF6}
  Screen.HintFont.Charset := RVA_GetCharset;
  Screen.MenuFont.Charset := RVA_GetCharset;
  {$ENDIF}
  // Localizing all actions on rvActionsResource
  RVA_LocalizeForm(rvActionsResource);
  // Localizing all actions on this form
  RVA_LocalizeForm(Self);
  // Localizing ruler
  RVALocalizeRuler(RVRuler1);
  // Localizing menus (not all menus in this demo are translated)
  mitFile.Caption := _GetWideString(RVA_GetS(rvam_menu_File));
  mitEdit.Caption := _GetWideString(RVA_GetS(rvam_menu_Edit));
  mitFont.Caption := _GetWideString(RVA_GetS(rvam_menu_Font));
  mitPara.Caption := _GetWideString(RVA_GetS(rvam_menu_Para));
  mitFormat.Caption := _GetWideString(RVA_GetS(rvam_menu_Format));
  mitInsert.Caption := _GetWideString(RVA_GetS(rvam_menu_Insert));
  mitTable.Caption := _GetWideString(RVA_GetS(rvam_menu_Table));
  mitExit.Caption := _GetWideString(RVA_GetS(rvam_menu_Exit));

  mitFontSize.Caption := _GetWideString(RVA_GetS(rvam_menu_FontSize));
  mitFontStyle.Caption := _GetWideString(RVA_GetS(rvam_menu_FontStyle));
  mitTableSelect.Caption := _GetWideString(RVA_GetS(rvam_menu_TableSelect));
  mitTableCellBorders.Caption := _GetWideString(RVA_GetS(rvam_menu_TableCellBorders));
  mitTableAlignCellContents.Caption := _GetWideString(RVA_GetS(rvam_menu_TableCellAlign));
  // In your application, you can use either TrvActionFonts or TrvActionFontEx
  rvActionsResource.rvActionFonts1.Caption := rvActionsResource.rvActionFonts1.Caption+' (Standard)';
  rvActionsResource.rvActionFontEx1.Caption := rvActionsResource.rvActionFontEx1.Caption+' (Advanced)';

  {
  // uncomment if you use Addict3. It's assumed that RVAddictSpell31
  // and RVThesaurus31 are on this form.
  RVAddictSpell31.UILanguage := GetAddictSpellLanguage(RVA_GetLanguageName);
  RVThesaurus31.UILanguage := GetAddictThesLanguage(RVA_GetLanguageName);
  }
end;

{-------------------------------- Misc. ---------------------------------------}

procedure TForm3.RVAControlPanel1Download(Sender: TrvAction;
  const Source: String);
begin
  if Source='' then
    Application.Hint := ''
  else
    Application.Hint := 'Downloading '+Source+'...';
end;

{---------------------- Live spelling with Addict 3 ---------------------------}
(*
// Add these events if you use Addict3
// (Assuming that you have RVAddictSpell31: TRVAddictSpell3 on the form)

// RichViewEdit1.OnSpellingCheck event
procedure TForm3.RichViewEdit1SpellingCheck(Sender: TCustomRichView;
  const AWord: String; StyleNo: Integer; var Misspelled: Boolean);
begin
  Misspelled := not RVAddictSpell31.WordAcceptable(AWord);
end;

// RVAddictSpell31.OnParserIgnoreWord: if Ignore All or Add buttons were pressed
// in spellchecker dialog, removing underlines from the ignored word
procedure TForm3.RVAddictSpell31ParserIgnoreWord(Sender: TObject;
  Before: Boolean; State: Integer);
begin
  if not Before and (State in [IgnoreState_IgnoreAll, IgnoreState_Add]) then
    RichViewEdit1.LiveSpellingValidateWord(RVAddictSpell31.CurrentWord);
end;

// Besides, if you want spelling check starting when loading document, call
// RichViewEdit1.StartLiveSpelling in rvActionFileOpen.OnOpenFile event
*)

initialization

{$IFDEF USE_GIFIMAGE}
  RegisterClasses([TGifImage]);
  // uncomment the line below if Gif does not appear in Insert | Image
  //TPicture.RegisterFileFormat('gif', 'Gif Image', TGifImage);
  RV_RegisterHTMLGraphicFormat(TGifImage);
{$ENDIF}
{$IFDEF USE_PNGOBJECT}
  RegisterClass(TPngObject);
  RV_RegisterHTMLGraphicFormat(TPngObject);
  RV_RegisterPngGraphic(TPngObject);
{$ENDIF}

end.
