
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Property editors for RichViewActions            }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit RVADsgn;

interface

{$I RV_Defs.inc}

uses RVALocalize, Classes,
  {$IFDEF RICHVIEWDEF6}
  DesignEditors, DesignIntf
  {$ELSE}
  DsgnIntf
  {$ENDIF};

type

  TRVALanguageProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure SetValue(const Value: string); override;
  end;

procedure Register;  

implementation

{ TRVALanguageProperty }

function TRVALanguageProperty.GetAttributes: TPropertyAttributes;
begin
  Result := (inherited GetAttributes) + [paValueList];
end;

procedure TRVALanguageProperty.GetValues(Proc: TGetStrProc);
begin
  RVA_EnumLanguages(Proc);
end;

procedure TRVALanguageProperty.SetValue(const Value: string);
begin
  inherited;
end;

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(TRVALanguageName), nil,'',  TRVALanguageProperty);
end;

end.
