
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Dialog for hyperlink properties                 }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit HypPropRVFrm;

interface

{$I RichViewActions.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, BaseRVFrm, StdCtrls, RVColorCombo, RVALocalize;

type
  TfrmRVHypProp = class(TfrmRVBase)
    gbNormal: TGroupBox;
    lblText: TLabel;
    cmbText: TRVColorCombo;
    cmbTextBack: TRVColorCombo;
    lblTextBack: TLabel;
    gbHover: TGroupBox;
    lblHoverText: TLabel;
    lblHoverTextBack: TLabel;
    cmbHoverText: TRVColorCombo;
    cmbHoverTextBack: TRVColorCombo;
    cbAsNormal: TCheckBox;
    btnOk: TButton;
    btnCancel: TButton;
    procedure cbAsNormalClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    _cbAsNormal: TControl;
  protected
    {$IFDEF RVASKINNED}
    procedure OnCreateThemedControl(OldControl, NewControl: TControl); override;
    {$ENDIF}
  public
    { Public declarations }
    procedure Localize; override;
  end;

implementation
uses RichViewActions;

{$R *.dfm}

procedure TfrmRVHypProp.cbAsNormalClick(Sender: TObject);
begin
  if GetCheckBoxChecked(_cbAsNormal) then begin
    cmbHoverText.ChosenColor     := cmbText.ChosenColor;
    cmbHoverTextBack.ChosenColor := cmbTextBack.ChosenColor;
  end;
  cmbHoverText.Enabled := not GetCheckBoxChecked(_cbAsNormal);
  cmbHoverTextBack.Enabled := not GetCheckBoxChecked(_cbAsNormal);
end;

procedure TfrmRVHypProp.Localize;
begin
  inherited;
  Caption := {$IFDEF USERVTNT}_GetWideString{$ENDIF}(RVA_GetS(rvam_hp_Title));
  gbNormal.Caption := RVA_GetSH(rvam_hp_GBNormal);
  gbHover.Caption := RVA_GetSH(rvam_hp_GBActive);
  lblText.Caption := RVA_GetS(rvam_hp_Text);
  lblTextBack.Caption := RVA_GetS(rvam_hp_TextBack);
  lblHoverText.Caption := RVA_GetS(rvam_hp_HoverText);
  lblHoverTextBack.Caption := RVA_GetS(rvam_hp_HoverTextBack);
  cbAsNormal.Caption := RVA_GetS(rvam_hp_AsNormal);
  btnOk.Caption := RVA_GetS(rvam_btn_OK);
  btnCancel.Caption := RVA_GetS(rvam_btn_Cancel);
end;

procedure TfrmRVHypProp.FormCreate(Sender: TObject);
begin
  _cbAsNormal := cbAsNormal;
  inherited;
  cmbText.ColorDialog := RVA_ColorDialog;
  cmbTextBack.ColorDialog := RVA_ColorDialog;
  cmbHoverText.ColorDialog := RVA_ColorDialog;
  cmbHoverTextBack.ColorDialog := RVA_ColorDialog;
end;

{$IFDEF RVASKINNED}
procedure TfrmRVHypProp.OnCreateThemedControl(OldControl,
  NewControl: TControl);
begin
  if OldControl=_cbAsNormal then
   _cbAsNormal := NewControl;
end;
{$ENDIF}

end.
