
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Dialog for changing document background         }
{       and margins.                                    }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit BackRVFrm;

interface

{$I RV_Defs.inc}
{$I RichViewActions.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, ActnList,
  Dialogs, BaseRVFrm, StdCtrls, RVColorCombo, RVScroll, RichView,
  RVOfficeRadioBtn, ImgList, RVStyle, ExtDlgs, RVEdit;

type
  TfrmRVBack = class(TfrmRVBase)
    il: TImageList;
    rg: TRVOfficeRadioGroup;
    gbBack: TGroupBox;
    rv: TRichView;
    cmbColor: TRVColorCombo;
    lblColor: TLabel;
    btnOk: TButton;
    btnCancel: TButton;
    btnOpen: TButton;
    btnSave: TButton;
    btnClear: TButton;
    spd: TSavePictureDialog;
    btnMargins: TButton;
    RVStyle1: TRVStyle;
    procedure btnSaveClick(Sender: TObject);
    procedure btnOpenClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure rgClick(Sender: TObject);
    procedure cmbColorColorChange(Sender: TObject);
    procedure btnMarginsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    _btnSave, _btnClear: TControl;
    _rv: TRichView;
    FAction: TAction;
  protected
    {$IFDEF RVASKINNED}
    procedure OnCreateThemedControl(OldControl, NewControl: TControl); override;
    {$ENDIF}
  public
    { Public declarations }
    ImageFileName: String;
    procedure Init(rve: TCustomRichViewEdit; cd: TColorDialog; Action: TAction);
    procedure GetResult(rv: TCustomRichViewEdit);
    procedure Localize; override;
  end;

implementation
uses FourSidesRVFrm, RVALocalize, RichViewActions;

{$R *.dfm}

procedure TfrmRVBack.btnSaveClick(Sender: TObject);
begin
  if _rv.BackgroundBitmap.Empty then begin
    Beep;
    exit;
  end;
  if spd.Execute then
    _rv.BackgroundBitmap.SaveToFile(spd.FileName);
end;

procedure TfrmRVBack.btnOpenClick(Sender: TObject);
var opd: TOpenPictureDialog;
    pic : TPicture;
    bmp : TBitmap;
begin
  opd := TOpenPictureDialog.Create(nil);
  try
    opd.Options := [ofPathMustExist, ofFileMustExist, ofEnableSizing, ofHideReadOnly];
    opd.DefaultExt := 'bmp';
    if opd.Execute then
    try
      pic := TPicture.Create;
      bmp := TBitmap.Create;
      try
        pic.LoadFromFile(opd.FileName);
        try
          if pic.Graphic is TIcon then
            TIcon(pic.Graphic).Handle;
          bmp.Assign(pic.Graphic);
          ImageFileName := opd.FileName;
        except
          bmp.Width := pic.Graphic.Width;
          bmp.Height := pic.Graphic.Height;
          bmp.Canvas.Draw(0,0,pic.Graphic);
        end;
        _rv.BackgroundBitmap  := bmp;
        if _rv.BackgroundStyle=bsNoBitmap then
          _rv.BackgroundStyle:=bsTiled;
      finally
        pic.Free;
        bmp.Free;
      end;
    except
      ImageFileName := '';
      Application.MessageBox(RVA_GetPC(rvam_err_ErrorLoadingImageFile),RVA_GetPC(rvam_err_Title),
        MB_OK or MB_ICONSTOP);
    end;
  finally
    opd.Free;
  end;
  _btnSave.Enabled := not _rv.BackgroundBitmap.Empty;
  _btnClear.Enabled := not _rv.BackgroundBitmap.Empty;
  rg.ItemIndex := ord(_rv.BackgroundStyle);  
end;

procedure TfrmRVBack.Init(rve: TCustomRichViewEdit; cd: TColorDialog;
  Action: TAction);
var i, StyleNo: Integer;
begin
  if RVA_UserInterface=rvauiHTML then
    rg.Items[1].Enabled := False;
  ImageFileName := '';
  FAction := Action;
  _rv.LeftMargin   := rve.LeftMargin;
  _rv.TopMargin    := rve.TopMargin;
  _rv.RightMargin  := rve.RightMargin;
  _rv.BottomMargin := rve.BottomMargin;
  _rv.BackgroundBitmap := rve.BackgroundBitmap;
  _rv.BackgroundStyle  := rve.BackgroundStyle;
  _rv.Style.TextStyles :=rve.Style.TextStyles;
  _rv.Style.ParaStyles :=rve.Style.ParaStyles;
  if rve.Color = clNone then
    _rv.Color := rve.Style.Color
  else
    _rv.Color := rve.Color;
  if _rv.BackgroundStyle in [bsNoBitmap..bsCentered] then
    rg.ItemIndex := ord(_rv.BackgroundStyle)
  else
    rg.ItemIndex := 4;
  _btnSave.Enabled := not rve.BackgroundBitmap.Empty;
  _btnClear.Enabled := not rve.BackgroundBitmap.Empty;
  cmbColor.ColorDialog := cd;
  cmbColor.ChosenColor := _rv.Color;
  StyleNo := rve.CurTextStyleNo;
  _rv.Style.TextStyles[StyleNo].Charset := RVA_GetCharset;
  for i := 0 to 50 do
    {$IFDEF RVUNICODESTR}_rv.AddNLWTag{$ELSE}_rv.AddNLATag{$ENDIF}
      (RVA_GetS(rvam_back_SampleText), StyleNo, 0, 0);
  _rv.Format;
end;

procedure TfrmRVBack.GetResult(rv: TCustomRichViewEdit);
begin
  rv.Color := _rv.Color;
  rv.BackgroundStyle := _rv.BackgroundStyle;
  rv.BackgroundBitmap := _rv.BackgroundBitmap;
  if rvfoSaveBack in rv.RVFOptions then
    rv.Change;
  if (rv.LeftMargin<>_rv.LeftMargin) or
     (rv.TopMargin<>_rv.TopMargin) or
     (rv.RightMargin<>_rv.RightMargin) or
     (rv.BottomMargin<>_rv.BottomMargin) then begin
    rv.LeftMargin   := _rv.LeftMargin;
    rv.TopMargin    := _rv.TopMargin;
    rv.RightMargin  := _rv.RightMargin;
    rv.BottomMargin := _rv.BottomMargin;
    RVA_Events.DoOnMarginsChanged(TrvAction(FAction), TCustomRichViewEdit(rv));    
    rv.Reformat;
    if rvfoSaveLayout in rv.RVFOptions then
      rv.Change;
  end;
end;

procedure TfrmRVBack.btnClearClick(Sender: TObject);
begin
  ImageFileName := '';
  _rv.BackgroundBitmap.Handle := 0;
  _btnSave.Enabled := not _rv.BackgroundBitmap.Empty;
  _btnClear.Enabled := not _rv.BackgroundBitmap.Empty;
end;

procedure TfrmRVBack.rgClick(Sender: TObject);
begin
  if rg.ItemIndex<0 then
    exit;
  _rv.BackgroundStyle := TBackgroundStyle(rg.ItemIndex);
end;

procedure TfrmRVBack.cmbColorColorChange(Sender: TObject);
begin
  _rv.Color := cmbColor.ChosenColor;
end;

procedure TfrmRVBack.btnMarginsClick(Sender: TObject);
var frm: TfrmRVFourSides;
    l,t,r,b: Integer;
    fl,ft,fr,fb: Boolean;
begin
  frm := TfrmRVFourSides.Create(Application);
  try
    l := _rv.LeftMargin;
    t := _rv.TopMargin;
    r := _rv.RightMargin;
    b := _rv.BottomMargin;
    fl := True;
    ft := True;
    fr := True;
    fb := True;
    frm.SetValues(l,t,r,b,fl,ft,fr,fb);
    frm.HelpContext := 90302;
    if frm.ShowModal=mrOk then begin
      frm.GetValues(l,t,r,b,fl,ft,fr,fb);
      if fl then
        _rv.LeftMargin := l;
      if fr then
        _rv.RightMargin := r;
      if ft then
        _rv.TopMargin := t;
      if fb then
        _rv.BottomMargin := b;
      _rv.Format;
    end;
  finally
    frm.Free;
  end;
end;

procedure TfrmRVBack.Localize;
begin
  inherited;
  Caption := {$IFDEF USERVTNT}_GetWideString{$ENDIF}(RVA_GetS(rvam_back_Title));
  btnOk.Caption := RVA_GetS(rvam_btn_OK);
  btnCancel.Caption := RVA_GetS(rvam_btn_Cancel);
  btnOpen.Caption := RVA_GetS(rvam_btn_Open);
  btnSave.Caption := RVA_GetS(rvam_btn_Save);
  btnClear.Caption := RVA_GetS(rvam_btn_Clear);
  lblColor.Caption := RVA_GetS(rvam_back_Color);
  rg.Caption := RVA_GetSH(rvam_back_Position);
  gbBack.Caption := RVA_GetSH(rvam_back_Background);
  rg.Items[0].Caption := RVA_GetS(rvam_back_None);
  rg.Items[1].Caption := RVA_GetS(rvam_back_FullWindow);
  rg.Items[2].Caption := RVA_GetS(rvam_back_FixedTiles);
  rg.Items[3].Caption := RVA_GetS(rvam_back_Tiles);
  rg.Items[4].Caption := RVA_GetS(rvam_back_Center);
  btnMargins.Caption := RVA_GetS(rvam_back_Padding);
end;

{$IFDEF RVASKINNED}
procedure TfrmRVBack.OnCreateThemedControl(OldControl, NewControl: TControl);
begin
  if OldControl = _btnSave then
    _btnSave := NewControl
  else if OldControl = _btnClear then
    _btnClear := NewControl
  else if OldControl = _rv then
    _rv := TRichView(NewControl);
end;
{$ENDIF}

procedure TfrmRVBack.FormCreate(Sender: TObject);
begin
  _btnSave := btnSave;
  _btnClear := btnClear;
  _rv := rv;
  inherited;
end;

end.
