/*
 * Decompiled with CFR 0.152.
 */
package cc.gammasoft.date;

import cc.gammasoft.date.CalendarControllerEvent;
import cc.gammasoft.date.CalendarControllerListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;

public class CalendarController
implements ActionListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected static final Calendar today = Calendar.getInstance();
    protected SimpleDateFormat dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, Locale.getDefault());
    protected DateFormatSymbols symbols;
    private boolean _$10419 = true;
    private Calendar _$10266 = Calendar.getInstance();
    static Class class$cc$gammasoft$date$CalendarControllerListener;

    public CalendarController(SimpleDateFormat dateFormat) {
        this.setDateFormat(dateFormat);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("--")) {
            this.actionPreviousYear(e);
        } else if (e.getActionCommand().equals("++")) {
            this.actionNextYear(e);
        } else if (e.getActionCommand().equals("-")) {
            this.actionPreviousMonth(e);
        } else if (e.getActionCommand().equals("+")) {
            this.actionNextMonth(e);
        } else if (e.getSource() instanceof JTextField) {
            this.actionYear(e.getActionCommand(), e);
        }
    }

    public void actionYear(String year, ActionEvent e) {
        try {
            Integer.parseInt(year);
            this._$10266.set(1, Integer.parseInt(year));
            this.fireYearChangedEvent(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionMonth(int month, ActionEvent e) {
        try {
            this._$10266.set(2, month);
            this.fireYearChangedEvent(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionPreviousYear(ActionEvent e) {
        this._$10266.add(1, -1);
        this.fireYearChangedEvent(e);
    }

    public void actionNextYear(ActionEvent e) {
        this._$10266.add(1, 1);
        this.fireYearChangedEvent(e);
    }

    public void actionNextMonth(ActionEvent e) {
        this._$10266.add(2, 1);
        this.fireMonthChangedEvent(e);
    }

    public void actionPreviousMonth(ActionEvent e) {
        this._$10266.add(2, -1);
        this.fireMonthChangedEvent(e);
    }

    public void fireYearChangedEvent(ActionEvent e) {
        CalendarControllerEvent event = new CalendarControllerEvent(1, this.getCurrentDate(), e);
        this.notifyListenersControllerChanged(event);
    }

    public void fireMonthChangedEvent(ActionEvent e) {
        CalendarControllerEvent event = new CalendarControllerEvent(0, this.getCurrentDate(), e);
        this.notifyListenersControllerChanged(event);
    }

    public void fireDayChangedEvent(ActionEvent e) {
        CalendarControllerEvent event = new CalendarControllerEvent(2, this.getCurrentDate(), e);
        this.notifyListenersControllerChanged(event);
    }

    protected void notifyListenersControllerChanged(CalendarControllerEvent viewerEvent) {
        if (this._$10419 && (this._$10266.get(1) > 2002 || this._$10266.get(1) < 2002)) {
            JOptionPane.showMessageDialog(null, "Demo Version. \n www.gammasoft.cc\n info@gammasoft.cc \n +1 (201) 945-4644", "Demo", 0);
            this.setCurrentDate((Calendar)this.getToday().clone());
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$cc$gammasoft$date$CalendarControllerListener == null ? CalendarController.class$("cc.gammasoft.date.CalendarControllerListener") : class$cc$gammasoft$date$CalendarControllerListener) || viewerEvent == null) continue;
            ((CalendarControllerListener)listeners[i + 1]).calendarControllerChanged(viewerEvent);
        }
    }

    public void addCalendarControllerListener(CalendarControllerListener l) {
        this.listenerList.add(class$cc$gammasoft$date$CalendarControllerListener == null ? (class$cc$gammasoft$date$CalendarControllerListener = CalendarController.class$("cc.gammasoft.date.CalendarControllerListener")) : class$cc$gammasoft$date$CalendarControllerListener, l);
    }

    public void removeCalendarControllerListener(CalendarControllerListener l) {
        this.listenerList.remove(class$cc$gammasoft$date$CalendarControllerListener == null ? (class$cc$gammasoft$date$CalendarControllerListener = CalendarController.class$("cc.gammasoft.date.CalendarControllerListener")) : class$cc$gammasoft$date$CalendarControllerListener, l);
    }

    public String formatCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.dateFormat.format(calendar.getTime());
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        if (dateFormat != null) {
            this.dateFormat = dateFormat;
        }
        this.symbols = this.dateFormat.getDateFormatSymbols();
        this.notifyListenersControllerChanged(new CalendarControllerEvent(3, this.getCurrentDate(), null));
    }

    public String formatToday() {
        return this.formatCalendar(today);
    }

    public String formatCurrentDate() {
        if (this._$10266 == null) {
            return null;
        }
        return this.formatCalendar(this.getCurrentDate());
    }

    public Calendar getToday() {
        return today;
    }

    public Calendar getCurrentDate() {
        Calendar tempCalendar = null;
        if (this._$10266 != null) {
            tempCalendar = (Calendar)this._$10266.clone();
        }
        return tempCalendar;
    }

    public void setCurrentDate(Calendar currentDate) {
        if (currentDate != null) {
            this._$10266 = currentDate;
            this._$10266 = (Calendar)currentDate.clone();
        }
        this.viewChanged(this._$10266);
    }

    public void setCurrentDate(String YMD) {
        Calendar temp = null;
        if (YMD != null && !YMD.equals("")) {
            String year = YMD.substring(0, 4);
            String month = YMD.substring(5, 7);
            String day = YMD.substring(8, 10);
            temp = Calendar.getInstance();
            temp.set(1, Integer.parseInt(year));
            temp.set(2, Integer.parseInt(month) - 1);
            temp.set(5, Integer.parseInt(day));
        }
        this.setCurrentDate(temp);
    }

    public static Calendar formatSQLDate(String YMD) {
        Calendar temp = null;
        if (YMD == null || YMD.equals("")) {
            return null;
        }
        String year = YMD.substring(0, 4);
        String month = YMD.substring(5, 7);
        String day = YMD.substring(8, 10);
        temp = Calendar.getInstance();
        temp.set(1, Integer.parseInt(year));
        temp.set(2, Integer.parseInt(month) - 1);
        temp.set(5, Integer.parseInt(day));
        return temp;
    }

    public void viewChanged(Calendar calendar) {
        if (calendar != this._$10266) {
            this._$10266 = calendar;
        }
        this.fireDayChangedEvent(null);
    }

    public String getSQLDate() {
        return CalendarController.getSQLDate(this.getCurrentDate());
    }

    public static String getSQLDate(Calendar calendar) {
        if (calendar != null) {
            return new Date(calendar.getTime().getTime()).toString();
        }
        return "";
    }

    public static String getSQLTime(Calendar calendar) {
        if (calendar != null) {
            return new Time(calendar.getTime().getTime()).toString();
        }
        return "";
    }

    public static String getSQLTimestamp(Calendar calendar) {
        if (calendar != null) {
            return new Timestamp(calendar.getTime().getTime()).toString();
        }
        return "";
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return this.symbols;
    }

    public String toString() {
        return this.getSQLDate();
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

