/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import palm.conduit.AbstractRecord;

public class TodoRecord
extends AbstractRecord {
    private String description;
    private Date dueDate;
    private boolean isCompleted;
    private int priority;
    private boolean isPrivate;
    private String note;
    private static final int COMPLETED_BIT = 128;
    private static final int PRIORITY_BITS = 127;

    public String getDescription() {
        return this.description;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public String getNote() {
        return this.note;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void readData(DataInputStream dataInputStream) throws IOException {
        this.dueDate = AbstractRecord.readDate(dataInputStream);
        byte by = dataInputStream.readByte();
        this.isCompleted = (by & 0x80) != 0;
        this.priority = by & 0x7F;
        this.description = AbstractRecord.readCString(dataInputStream);
        this.note = AbstractRecord.readCString(dataInputStream);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDueDate(Date date) {
        this.dueDate = date;
    }

    public void setIsCompleted(boolean bl) {
        this.isCompleted = bl;
    }

    public void setNote(String string) {
        this.note = string;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public String toFormattedString() {
        return "Todo record: " + this.getDescription() + "\r\n" + super.toFormattedString();
    }

    public String toString() {
        return "Todo record: " + this.getDescription() + " " + super.toString();
    }

    public void writeData(DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        AbstractRecord.writeDate(dataOutputStream, this.dueDate);
        if (this.isCompleted) {
            n = (byte)(n | 0x80);
        }
        n = (byte)(n | this.priority & 0x7F);
        dataOutputStream.writeByte(n);
        AbstractRecord.writeCString(dataOutputStream, AbstractRecord.stringWithoutCarriageReturns(this.description));
        AbstractRecord.writeCString(dataOutputStream, AbstractRecord.stringWithoutCarriageReturns(this.note));
    }
}

