/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Vector;
import org.hsql.Trace;
import org.hsql.User;

class Access {
    static final int SELECT = 1;
    static final int DELETE = 2;
    static final int INSERT = 4;
    static final int UPDATE = 8;
    static final int ALL = 15;
    private Vector uUser = new Vector();
    private User uPublic = this.createUser("PUBLIC", null, false);

    Access() throws SQLException {
    }

    User createUser(String string, String string2, boolean bl) throws SQLException {
        int n = 0;
        while (n < this.uUser.size()) {
            User user = (User)this.uUser.elementAt(n);
            if (user != null && user.getName().equals(string)) {
                throw Trace.error(34, string);
            }
            ++n;
        }
        User user = new User(string, string2, bl, this.uPublic);
        this.uUser.addElement(user);
        return user;
    }

    void dropUser(String string) throws SQLException {
        Trace.check(!string.equals("PUBLIC"), 31);
        int n = 0;
        while (n < this.uUser.size()) {
            User user = (User)this.uUser.elementAt(n);
            if (user != null && user.getName().equals(string)) {
                this.uUser.setElementAt(null, n);
                user.revokeAll();
                return;
            }
            ++n;
        }
        throw Trace.error(35, string);
    }

    private User get(String string) throws SQLException {
        int n = 0;
        while (n < this.uUser.size()) {
            User user = (User)this.uUser.elementAt(n);
            if (user != null && user.getName().equals(string)) {
                return user;
            }
            ++n;
        }
        throw Trace.error(35, string);
    }

    static String getRight(int n) {
        if (n == 15) {
            return "ALL";
        }
        if (n == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append("SELECT,");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("UPDATE,");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("DELETE,");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("INSERT,");
        }
        String string = stringBuffer.toString();
        return string.substring(0, string.length() - 1);
    }

    static int getRight(String string) throws SQLException {
        if (string.equals("ALL")) {
            return 15;
        }
        if (string.equals("SELECT")) {
            return 1;
        }
        if (string.equals("UPDATE")) {
            return 8;
        }
        if (string.equals("DELETE")) {
            return 2;
        }
        if (string.equals("INSERT")) {
            return 4;
        }
        throw Trace.error(10, string);
    }

    User getUser(String string, String string2) throws SQLException {
        Trace.check(!string.equals("PUBLIC"), 31);
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        User user = this.get(string);
        user.checkPassword(string2);
        return user;
    }

    Vector getUsers() {
        return this.uUser;
    }

    void grant(String string, String string2, int n) throws SQLException {
        this.get(string).grant(string2, n);
    }

    void revoke(String string, String string2, int n) throws SQLException {
        this.get(string).revoke(string2, n);
    }
}

