/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import palm.conduit.AbstractRecord;
import palm.conduit.ApptDBRecordFlags;

public class DateRecord
extends AbstractRecord {
    private Date startDate = null;
    private Date endDate = null;
    private boolean isUntimed = false;
    private boolean isAlarmed = false;
    private int alarmAdvanceTime = 0;
    private int alarmAdvanceUnit = 0;
    private boolean isRepeating = false;
    private int repeatType = 0;
    private Date repeatEndDate = null;
    private int repeatFrequency = 1;
    private int repeatOn = 0;
    private int repeatStartWeek = 0;
    private int exceptionsNum = 0;
    private Vector dateExceptions = new Vector();
    private String description = null;
    private String note = null;
    static final int REPEAT_TYPE_NO_REPEAT = 0;
    static final int REPEAT_TYPE_DAILY = 1;
    static final int REPEAT_TYPE_WEEKLY = 2;
    static final int REPEAT_TYPE_MONTHLY_BY_DAY = 3;
    static final int REPEAT_TYPE_MONTHLY_BY_DATE = 4;
    static final int REPEAT_TYPE_YEARLY_BY_DATE = 5;
    static final int REPEAT_TYPE_YEARLY_BY_DAY = 6;
    private static final String[] repeatTypeText = new String[]{"NoRepeat", "Daily", "Weekly", "MonthlyByDay", "MonthlyByDate", "YearlyByDate", "YearlyByDay"};
    static final int DAY_SUNDAY = 0;
    static final int DAY_MONDAY = 1;
    static final int DAY_TUESDAY = 2;
    static final int DAY_WEDNESDAY = 3;
    static final int DAY_THURSDAY = 4;
    static final int DAY_FRIDAY = 5;
    static final int DAY_SATURDAY = 6;
    private static final String[] dayText = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    static final int WEEK_FIRST = 0;
    static final int WEEK_SECOND = 1;
    static final int WEEK_THIRD = 2;
    static final int WEEK_FORTH = 3;
    static final int WEEK_LAST = 4;
    private static final String[] weekText = new String[]{"First", "Second", "Third", "Forth", "Last"};
    static final int MONTH_JANUARY = 0;
    static final int MONTH_FEBRUARY = 1;
    static final int MONTH_MARCH = 2;
    static final int MONTH_APRIL = 3;
    static final int MONTH_MAY = 4;
    static final int MONTH_JUNE = 5;
    static final int MONTH_JULY = 6;
    static final int MONTH_AUGUST = 7;
    static final int MONTH_SEPTEMBER = 8;
    static final int MONTH_OCTOBER = 9;
    static final int MONTH_NOVEMBER = 10;
    static final int MONTH_DECEMBER = 11;
    private static final String[] monthText = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    static final int ALARM_UNIT_MINUTES = 0;
    static final int ALARM_UNIT_HOURS = 1;
    static final int ALARM_UNIT_DAYS = 2;
    private static final String[] alarmUnitText = new String[]{"Minutes", "Hours", "Days"};

    public static String getRepeatTypeText(int n) {
        return repeatTypeText[n];
    }

    public static String getDayText(int n) {
        return dayText[n];
    }

    public static String getWeekText(int n) {
        return weekText[n];
    }

    public static String getMonthText(int n) {
        return monthText[n];
    }

    public static String getAlarmUnitText(int n) {
        return alarmUnitText[n];
    }

    public void DateRecord(Date date, Date date2) {
        this.startDate = date;
        this.endDate = date2;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setEndDate(Date date) {
        this.endDate = date;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean getIsUntimed() {
        return this.isUntimed;
    }

    public void setIsUntimed(boolean bl) {
        this.isUntimed = bl;
    }

    public boolean getIsAlarmed() {
        return this.isAlarmed;
    }

    public void setIsAlarmed(boolean bl) {
        this.isAlarmed = bl;
    }

    public void setAlarmAdvanceTime(int n) {
        this.alarmAdvanceTime = (byte)n;
        this.isAlarmed = true;
    }

    public int getAlarmAdvanceTime() {
        return this.alarmAdvanceTime;
    }

    public void setAlarmAdvanceUnit(int n) {
        this.alarmAdvanceUnit = (byte)n;
        this.isAlarmed = true;
    }

    public int getAlarmAdvanceUnit() {
        return this.alarmAdvanceUnit;
    }

    public boolean getIsRepeating() {
        return this.isRepeating;
    }

    public void setIsRepeating(boolean bl) {
        this.isRepeating = bl;
    }

    public void setRepeatType(int n) {
        this.repeatType = n;
    }

    public int getRepeatType() {
        return this.repeatType;
    }

    public void setRepeatEndDate(Date date) {
        this.repeatEndDate = date;
    }

    public Date getRepeatEndDate() {
        return this.repeatEndDate;
    }

    public void setRepeatFrequency(int n) {
        this.repeatFrequency = n;
    }

    public int getRepeatFrequency() {
        return this.repeatFrequency;
    }

    public void addDateException(Date date) {
        this.dateExceptions.addElement(date);
    }

    public void removeDateException(Date date) {
        this.dateExceptions.removeElement(date);
    }

    public Vector getDateExceptions() {
        return this.dateExceptions;
    }

    public void setDateExceptions(Vector vector) {
        this.dateExceptions = vector;
        if (this.dateExceptions == null) {
            vector = new Vector();
        }
    }

    public void setRepeatOn(int[] nArray) {
        this.repeatOn = 0;
        if (nArray != null) {
            int n = nArray.length;
            while (n-- > 0) {
                this.repeatOn |= 1 << nArray[n];
            }
        }
    }

    public int[] getRepeatOn() {
        int n = this.repeatOn;
        int[] nArray = new int[7];
        int n2 = 0;
        int n3 = 0;
        while (n3 < 7) {
            if ((this.repeatOn & 1) == 1) {
                nArray[n2++] = n3;
            }
            this.repeatOn >>= 1;
            ++n3;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public void setRepeatOnWeek(int n) {
        int n2 = this.repeatOn % 7;
        this.repeatOn = n * 7 + n2;
    }

    public void addRepeatOnDay(int n) {
        this.repeatOn |= 1 << n;
    }

    public void removeRepeatOnDay(int n) {
        this.repeatOn &= ~(1 << n);
    }

    public int getRepeatOnWeek() {
        return this.repeatOn / 7;
    }

    public void setRepeatOnDay(int n) {
        int n2 = this.repeatOn / 7;
        this.repeatOn = n2 * 7 + n;
    }

    public int getRepeatOnDay() {
        return this.repeatOn % 7;
    }

    public void setRepeatStartWeek(int n) {
        this.repeatStartWeek = n;
    }

    public int getRepeatStartWeek() {
        return this.repeatStartWeek;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setNote(String string) {
        this.note = string;
    }

    public String getNote() {
        return this.note;
    }

    public void writeData(DataOutputStream dataOutputStream) throws IOException {
        ApptDBRecordFlags apptDBRecordFlags = new ApptDBRecordFlags();
        if (this.isUntimed) {
            dataOutputStream.writeShort(-1);
            dataOutputStream.writeShort(0);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.startDate);
            int n = calendar.get(11) * 60 + calendar.get(12);
            calendar.setTime(this.endDate);
            int n2 = calendar.get(11) * 60 + calendar.get(12);
            dataOutputStream.writeShort(AbstractRecord.fromMinutes(n));
            dataOutputStream.writeShort(AbstractRecord.fromMinutes(n2));
        }
        AbstractRecord.writeDate(dataOutputStream, this.startDate);
        apptDBRecordFlags.alarm = this.isAlarmed;
        apptDBRecordFlags.repeat = this.repeatType != 0;
        apptDBRecordFlags.exception = this.dateExceptions.size() > 0;
        apptDBRecordFlags.description = this.description != null && !"".equals(this.description);
        apptDBRecordFlags.note = this.note != null && !"".equals(this.note);
        apptDBRecordFlags.writeData(dataOutputStream);
        dataOutputStream.write(0);
        if (apptDBRecordFlags.alarm) {
            dataOutputStream.write(this.alarmAdvanceTime);
            dataOutputStream.write(this.alarmAdvanceUnit);
        }
        if (apptDBRecordFlags.repeat) {
            dataOutputStream.write(this.repeatType);
            dataOutputStream.write(0);
            AbstractRecord.writeDate(dataOutputStream, this.repeatEndDate);
            dataOutputStream.write(this.repeatFrequency);
            dataOutputStream.write(this.repeatOn);
            dataOutputStream.write(this.repeatStartWeek);
            dataOutputStream.write(0);
        }
        if (apptDBRecordFlags.exception) {
            dataOutputStream.writeShort(this.dateExceptions.size());
            int n = 0;
            while (n < this.dateExceptions.size()) {
                AbstractRecord.writeDate(dataOutputStream, (Date)this.dateExceptions.elementAt(n));
                ++n;
            }
        }
        if (apptDBRecordFlags.description) {
            AbstractRecord.writeCString(dataOutputStream, this.description);
        }
        if (apptDBRecordFlags.note) {
            AbstractRecord.writeCString(dataOutputStream, this.note);
        }
    }

    public void readData(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        ApptDBRecordFlags apptDBRecordFlags = new ApptDBRecordFlags();
        Calendar calendar = Calendar.getInstance();
        short s = dataInputStream.readShort();
        if (s == -1) {
            this.isUntimed = true;
            n2 = 0;
            n = 0;
            dataInputStream.readShort();
        } else {
            this.isUntimed = false;
            n2 = AbstractRecord.toMinutes(s);
            n = AbstractRecord.toMinutes(dataInputStream.readShort());
        }
        this.startDate = AbstractRecord.readDate(dataInputStream);
        calendar.setTime(this.startDate);
        calendar.set(11, n2 / 60);
        calendar.set(12, n2 % 60);
        this.startDate = calendar.getTime();
        this.endDate = new Date(this.startDate.getTime());
        calendar.setTime(this.endDate);
        calendar.set(11, n / 60);
        calendar.set(12, n % 60);
        this.endDate = calendar.getTime();
        apptDBRecordFlags.readData(dataInputStream);
        dataInputStream.read();
        if (apptDBRecordFlags.alarm) {
            this.isAlarmed = true;
            this.alarmAdvanceTime = dataInputStream.read();
            this.alarmAdvanceUnit = dataInputStream.read();
        } else {
            this.isAlarmed = false;
            this.alarmAdvanceTime = 0;
            this.alarmAdvanceUnit = 0;
        }
        if (apptDBRecordFlags.repeat) {
            this.repeatType = dataInputStream.read();
            dataInputStream.read();
            this.repeatEndDate = AbstractRecord.readDate(dataInputStream);
            this.repeatFrequency = dataInputStream.read();
            this.repeatOn = dataInputStream.read();
            this.repeatStartWeek = dataInputStream.read();
            dataInputStream.read();
        } else {
            this.repeatType = 0;
            this.repeatEndDate = null;
            this.repeatFrequency = 0;
            this.repeatOn = 0;
            this.repeatStartWeek = 0;
        }
        if (apptDBRecordFlags.exception) {
            this.exceptionsNum = dataInputStream.readShort();
            this.dateExceptions = new Vector(this.exceptionsNum);
            int n3 = 0;
            while (n3 < this.exceptionsNum) {
                this.dateExceptions.addElement(AbstractRecord.readDate(dataInputStream));
                ++n3;
            }
        } else {
            this.exceptionsNum = 0;
            this.dateExceptions = new Vector();
        }
        if (apptDBRecordFlags.description) {
            this.description = AbstractRecord.readCString(dataInputStream);
        }
        if (apptDBRecordFlags.note) {
            this.note = AbstractRecord.readCString(dataInputStream);
        }
    }

    public String toString() {
        return "Date Book record: " + super.toString();
    }

    String[] getRepeatOnText() {
        int[] nArray = this.getRepeatOn();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = dayText[nArray[n]];
            ++n;
        }
        return stringArray;
    }

    public String toFormattedString() {
        int n;
        String string = "";
        String string2 = "";
        switch (this.getRepeatType()) {
            case 2: {
                String[] stringArray = this.getRepeatOnText();
                n = 0;
                while (n < stringArray.length) {
                    string = string + stringArray[n] + " ";
                    ++n;
                }
                break;
            }
            case 3: {
                string = DateRecord.getWeekText(this.getRepeatOnWeek()) + " " + DateRecord.getDayText(this.getRepeatOnDay());
                break;
            }
            default: {
                string = "" + this.getRepeatType();
            }
        }
        n = 0;
        while (n < this.dateExceptions.size()) {
            string2 = string2 + "    " + this.dateExceptions.elementAt(n) + "\n";
            ++n;
        }
        return "Date Book record: {\r\n  startDate: " + this.getStartDate() + "\r\n" + "  endDate: " + this.getEndDate() + "\r\n" + "  isUntimed: " + this.getIsUntimed() + "\r\n" + "  isAlarmed: " + this.getIsAlarmed() + "\r\n" + "  alarmAdvanceTime: " + this.getAlarmAdvanceTime() + "\r\n" + "  alarmAdvanceUnit: " + DateRecord.getAlarmUnitText(this.getAlarmAdvanceUnit()) + "\r\n" + "  isRepeating: " + this.getIsRepeating() + "\r\n" + "  repeatType: " + DateRecord.getRepeatTypeText(this.getRepeatType()) + "\r\n" + "  repeatEndDate: " + this.getRepeatEndDate() + "\r\n" + "  repeatFrequency: " + this.getRepeatFrequency() + "\r\n" + "  repeatOn: " + string + "\r\n" + "  repeatStartWeek: " + DateRecord.getWeekText(this.getRepeatStartWeek()) + "\r\n" + "  exceptions: \r\n" + string2 + "  description: " + this.getDescription() + "\r\n" + "  note: " + this.getNote() + "\r\n" + "}\r\n" + super.toFormattedString();
    }
}

