#include "sources.cpp\xmode.h"


/*
 Grafik-Primitiven (gekuerzte Version)

 Inspiriert von Michael Abrash's Artikel ueber Grafikprogrammierung
 Dr.Dobb's Journal  Feb.1991 - Feb.1993

 Autor: Tobias Schwinger
*/



void init_video_320x200x256()
{
  asm {
        mov     ax,0x0013      // video mode 320x200
	int     0x10
	mov     dx,0x03c4      // Sequencer Controller Index
	mov     ax,0x0604      // unchained mode
	out     dx,ax
	mov     dx,0x03d4      // byte mode an
	mov     ax,0xe317
	out     dx,ax
	mov     ax,0x0014      // dword mode aus
	out     dx,ax
  }
  resolution_x=320; resolution_y=200;
  flipping_off();
  clear_vga_mem();
}


void init_video_320x240x256()
{
  init_video_320x200x256();
  asm {
	mov     dx,0x03c4
	mov     ax,0x0100      // Sequencer reset
	out     dx,ax

	mov     dx,0x03c2      // Miscellaneous Output Register
	mov     al,0xe3        // Pixel clock to 25MHz 60Hz/frame
	out     dx,al

	mov     dx,0x03c4      // Sequencer restart
	mov     ax,0x0300
	out     dx,ax

	mov     dx,0x03d4      // CRT Controller Index
	mov     al,0x11
	out     dx,al
	inc     dx
	in      al,dx
        and     al,0x7f        // write protection aus
	out     dx,al

	mov     dx,0x03d4      // CRT Controller Index
	mov     ax,0x0d06      // vertical total
	out     dx,ax
	mov     ax,0x3e07      // overflow (8th bit of vert.count)
	out     dx,ax
	mov     ax,0x4109      // cell heigth (2 to double scan)
	out     dx,ax
	mov     ax,0xea10      // vsync start
	out     dx,ax
	mov     ax,0xac11      // vsync end (protect cr0-cr7)
	out     dx,ax
	mov     ax,0xdf12      // vertical displayed
	out     dx,ax
	mov     ax,0xe715      // vertical blank start
	out     dx,ax
	mov     ax,0x0616      // vertical blank end
	out     dx,ax
  }
  resolution_y=240;
}

void clear_vga_mem()
{
  asm {
	mov     ax,0xa000
	mov     es,ax
	mov     dx,0x03c4      // Sequencer:
	mov     ax,0x0f02      //  alle vier 'Bitplanes' anwaehlen
	out     dx,ax
	cld
	xor     ax,ax          // ax und di loeschen
	mov     di,ax
	mov     cx,0x8000      // $8000 words um den Grafikspeicher
	rep     stosw          //  zu reinigen
  }
}

void cls(word start,word length)
{
  asm {
	mov     ax,0xa000
	mov     es,ax
	mov     dx,0x03c4      // Sequencer:
	mov     ax,0x0f02      //  plane select - alle viere
	out     dx,ax
	cld
	xor     ax,ax          // ax und di loeschen
	mov     di,[start]
	mov     cx,[length]    // [length] words vom VGA-Memory
	rep     stosw          // ausradieren
  }
}

void pix_w80(word x,word y,byte c)
{
  asm {
	mov     ax,0xa000      // VGA-Base nach es, Parameter laden
	mov     es,ax
	mov     cx,[y]
	mov     bx,[x]
	mov     di,cx          // y * 80
	shl     di,4
	shl     cx,6
	add     di,cx          // + (x shr 2)
	mov     cx,bx
	shr     bx,2
	add     di,bx
	and     cl,3           // x mod 4
	mov     ax,0x0102      // Maskeneintrage ermitteln (1 << cl)
	shl     ah,cl
	mov     dx,0x03c4
	out     dx,ax
	mov     bl,[c]         // Farbe laden
	mov     [es:di],bl     // <- und das alles um einen Punkt zu zeichnen
  }
}

void flip_w80()                // Logische und physikal. Seiten tauschen
{
  if (phys_addr_offset==0) {
    phys_addr_offset=19200; phys_y_offset=240;
    log_y_offset=0; log_addr_offset=0;
    log_page=1; phys_page=2;
  } else {
    phys_addr_offset=0; phys_y_offset=0;
    log_y_offset=240; log_addr_offset=19200;
    log_page=2; phys_page=1;
  }
  set_screen(phys_addr_offset);
}

void flipping_off()
{
  phys_addr_offset=0; log_addr_offset=0;
  phys_y_offset=0; log_y_offset=0;
  phys_page=1; log_page=1;
  set_screen(phys_addr_offset);
}


void set_screen(word o)
{
  asm {
        mov     ax,[o]         // Zwei Selectregister mit je High- und Low-
	mov     dx,0x03d4      //  byte der Addresse schreiben
	mov     bl,al
	mov     al,0xc
	out     dx,ax
	inc     al
	mov     ah,bl
	out     dx,ax
  }
}

void set_col(byte cnr,byte r,byte g,byte b)
{
  asm {
	mov     dx,0x3c8       // Farbnummer auswaehlen
	mov     al,[cnr]
	out     dx,al
	inc     dx
	mov     al,[r]         // Rot-, Gruen- und Blaukomponenten schreiben
	out     dx,al
	mov     al,[g]
	out     dx,al
	mov     al,[b]
	out     dx,al
  }
}

void vsync()
{
  _DX = 0x03DA;

  w1: asm {
        in      al,dx;
        and     al,0x08;
        jnz     w1;
  }

  w2: asm {
        in      al,dx;
        and     al,0x08;
        jz      w2;
  }
}

void to_tmode()
{
  asm {
        mov     ax,0x0003
	int     0x10
  }
}


