Attribute VB_Name = "IDAutomationNativeWindowsDLLVBA"
'*********************************************************************
'*  VBA Functions for IDAutomation Native Windows DLL 6.09.0
'*  Copyright, IDAutomation.com, Inc. 2006. All rights reserved.
'*
'*  Visit www.idautomation.com/fonts/tools/windows_dll/
'*  for more information about the functions in this file.
'*
'*  You may incorporate our Source Code in your application
'*  only if you own a valid license from IDAutomation.com, Inc.
'*  for the associated font and this text and the copyright notices
'*  are not removed from the source code.
'*
'*  Distributing our source code or fonts outside your
'*  organization requires a Developer License.
'*********************************************************************


Public Declare Function IDAutomation_UPCe _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Codabar _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Code128a _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Code128b _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Code128c _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Interleaved2of5 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Interleaved2of5Mod10 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Code39 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Code39Mod43 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Code93 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_EAN8 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_EAN13 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_UPCa _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_MSI _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Postnet _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Code128 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, ByRef iApplyTilde As Long, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Code128HumanReadable _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, ByRef iApplyTilde As Long, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_UCC128 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_C128A _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_C128B _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_C128C _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_UCC128 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_C128 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, ByRef iApplyTilde As Long, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_C128HR _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, ByRef iApplyTilde As Long, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_Postnet _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, ByRef iIncludeCheckDigit As Long, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_Planet _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, ByRef iIncludeCheckDigit As Long, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_Codabar _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, ByVal dN_Dimension As Double, ByVal StartChar As String, ByVal StopChar As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_C39 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, ByVal dN_Dimension As Double, ByRef iIncludeCheckDigit As Long, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_I2of5 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, ByVal dN_Dimension As Double, ByRef iIncludeCheckDigit As Long, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_MSI _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, ByVal dN_Dimension As Double, ByRef iIncludeCheckDigit As Long, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_MODU10 _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
Public Declare Function IDAutomation_Universal_OneCode _
      Lib "IDAutomationNativeFontEncoder.dll" _
                     (ByVal D2E As String, _
                     ByVal out As String, _
                     ByRef iSize As Long) As Long
                     
                     


Dim ShowError As Boolean

Public Function Code39Mod43(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True
myOut = String(250, " ")

lRetVal = IDAutomation_Code39Mod43(DataToEncode, myOut, iSize)
Code39Mod43 = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Code 39 Mod 43 " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function


Public Function Code39(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(250, " ")

lRetVal = IDAutomation_Code39(DataToEncode, myOut, iSize)
Code39 = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Code 39 " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function



Public Function Code93(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True
myOut = String(250, " ")

lRetVal = IDAutomation_Code93(DataToEncode, myOut, iSize)
Code93 = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Code 93" + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function



Public Function Code128a(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(250, " ")

lRetVal = IDAutomation_Code128a(DataToEncode, myOut, iSize)
Code128a = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Code128A " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function Code128b(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(250, " ")

lRetVal = IDAutomation_Code128b(DataToEncode, myOut, iSize)
Code128b = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Code128B " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function Code128c(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(250, " ")

lRetVal = IDAutomation_Code128c(DataToEncode, myOut, iSize)
Code128c = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Code 128C " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function Code128(DataToEncode As String, Optional applyTilde As Boolean = False) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(512, " ")

If applyTilde = True Then
    lRetVal = IDAutomation_Code128(DataToEncode, 1, myOut, iSize)
Else
    lRetVal = IDAutomation_Code128(DataToEncode, 0, myOut, iSize)
End If

Code128 = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Code128 " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function Code128HR(DataToEncode As String, Optional applyTilde As Boolean = True) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(512, " ")
If applyTilde = True Then
    lRetVal = IDAutomation_Code128HumanReadable(DataToEncode, 1, myOut, iSize)
Else
    lRetVal = IDAutomation_Code128HumanReadable(DataToEncode, 0, myOut, iSize)
End If

Code128HR = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Code 128HR " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function I2of5(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(250, " ")

lRetVal = IDAutomation_Interleaved2of5(DataToEncode, myOut, iSize)
I2of5 = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in I 2 of 5 " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function I2of5Mod10(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(250, " ")

lRetVal = IDAutomation_Interleaved2of5Mod10(DataToEncode, myOut, iSize)
I2of5Mod10 = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in I 2 of 5 Mod 10 " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function Postnet(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(250, " ")

lRetVal = IDAutomation_Postnet(DataToEncode, myOut, iSize)
Postnet = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Postnet " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function MSI(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(250, " ")

lRetVal = IDAutomation_MSI(DataToEncode, myOut, iSize)
MSI = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in MSI" + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function UPCa(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(250, " ")

lRetVal = IDAutomation_UPCa(DataToEncode, myOut, iSize)
UPCa = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in UPCa " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function UPCe(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(250, " ")

lRetVal = IDAutomation_UPCe(DataToEncode, myOut, iSize)
UPCe = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in UPCE " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function EAN13(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(250, " ")

lRetVal = IDAutomation_EAN13(DataToEncode, myOut, iSize)
EAN13 = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in EAN13 " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function EAN8(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(250, " ")

lRetVal = IDAutomation_EAN8(DataToEncode, myOut, iSize)
EAN8 = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in EAN8 " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function UCC128(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(250, " ")

lRetVal = IDAutomation_UCC128(DataToEncode, myOut, iSize)
UCC128 = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in UCC128 " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function

Public Function IDAutomation_Uni_C39(DataToEncode As String, Optional n_Dimension As Double = 2, Optional IncludeCheckDigit As Boolean = False) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
Dim long_ICD As Long
ShowError = True
If IncludeCheckDigit = True Then
    long_ICD = True
Else
    long_ICD = False
End If
myOut = String(512, " ")

lRetVal = IDAutomation_Universal_C39(DataToEncode, n_Dimension, long_ICD, myOut, iSize)

IDAutomation_Uni_C39 = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Universal Code 39 " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function IDAutomation_Uni_C128a(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(512, " ")

lRetVal = IDAutomation_Universal_C128A(DataToEncode, myOut, iSize)
IDAutomation_Uni_C128a = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Universal Code 128A " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function IDAutomation_Uni_C128b(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(512, " ")

lRetVal = IDAutomation_Universal_C128B(DataToEncode, myOut, iSize)
IDAutomation_Uni_C128b = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Universal Code 128B " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function IDAutomation_Uni_C128c(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(512, " ")

lRetVal = IDAutomation_Universal_C128C(DataToEncode, myOut, iSize)
IDAutomation_Uni_C128c = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Universal Code 128C " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function

Public Function IDAutomation_Uni_C128(DataToEncode As String, Optional applyTilde As Boolean = False) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
Dim long_AT As Long
ShowError = True
If applyTilde = True Then
    L_AT = True
Else
    L_AT = False
End If
myOut = String(512, " ")
lRetVal = IDAutomation_Universal_C128(DataToEncode, L_AT, myOut, iSize)

IDAutomation_Uni_C128 = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Universal Code 128 " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function IDAutomation_Uni_C128HR(DataToEncode As String, Optional applyTilde As Boolean = True) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
Dim long_AT As Long
ShowError = True

myOut = String(512, " ")
If applyTilde = True Then
    L_AT = True
Else
    L_AT = False
End If
    
lRetVal = IDAutomation_Universal_C128HR(DataToEncode, L_AT, myOut, iSize)

IDAutomation_Uni_C128HR = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Universal Code 128HR " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function IDAutomation_Uni_I2of5(DataToEncode As String, Optional n_Dimension As Double = 2, Optional IncludeCheckDigit As Boolean = False) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
Dim long_ICD As Long

ShowError = True
If IncludeCheckDigit = True Then
    long_ICD = True
Else
    long_ICD = False
End If

myOut = String(512, " ")

lRetVal = IDAutomation_Universal_I2of5(DataToEncode, n_Dimension, long_ICD, myOut, iSize)

IDAutomation_Uni_I2of5 = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Universal I 2 of 5 " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function IDAutomation_Uni_Postnet(DataToEncode As String, Optional IncludeCheckDigit As Boolean = True) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
Dim long_ICD As Long

ShowError = True
If IncludeCheckDigit = True Then
    long_ICD = True
Else
    long_ICD = False
End If

myOut = String(512, " ")

lRetVal = IDAutomation_Universal_Postnet(DataToEncode, long_ICD, myOut, iSize)

IDAutomation_Uni_Postnet = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Universal Postnet " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function IDAutomation_Uni_Planet(DataToEncode As String, Optional IncludeCheckDigit As Boolean = True) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
Dim long_ICD As Long

ShowError = True
If IncludeCheckDigit = True Then
    long_ICD = True
Else
    long_ICD = False
End If

myOut = String(512, " ")

lRetVal = IDAutomation_Universal_Planet(DataToEncode, long_ICD, myOut, iSize)

IDAutomation_Uni_Planet = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Universal IDAutomation_Uni_Planet " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function

Public Function IDAutomation_Uni_MSI(DataToEncode As String, Optional n_Dimension As Double = 2, Optional IncludeCheckDigit As Boolean = True) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
Dim long_ICD As Long

ShowError = True
If IncludeCheckDigit = True Then
    long_ICD = True
Else
    long_ICD = False
End If

myOut = String(512, " ")

lRetVal = IDAutomation_Universal_MSI(DataToEncode, n_Dimension, long_ICD, myOut, iSize)

IDAutomation_Uni_MSI = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Universal MSI " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function IDAutomation_Uni_UCC128(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(512, " ")

lRetVal = IDAutomation_Universal_UCC128(DataToEncode, myOut, iSize)

IDAutomation_Uni_UCC128 = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Universal UCC128 " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function
Public Function IDAutomation_Uni_Codabar(DataToEncode As String, Optional n_Dimension As Double = 2, Optional StartChar As String = "A", Optional StopChar As String = "B") As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(512, " ")

lRetVal = IDAutomation_Universal_Codabar(DataToEncode, n_Dimension, StartChar, StopChar, myOut, iSize)

IDAutomation_Uni_Codabar = Mid(myOut, 1, iSize)
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Universal Codabar " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function

Public Function IDAutomation_Uni_OneCode(DataToEncode As String) As String
On Error GoTo ErrorHandler
Dim myOut As String
Dim iSize As Long
Dim lRetVal As Long
ShowError = True

myOut = String(512, " ")

lRetVal = IDAutomation_Universal_OneCode(DataToEncode, myOut, iSize)
IDAutomation_Uni_OneCode = myOut
Exit Function
ErrorHandler:
    If ShowError Then
        MsgBox "Error in Universal OneCode " + Err.Description, vbOKOnly, "Error in VBA"
    End If
    Resume Next
End Function

