/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ColorUtils;
import common.DirButton;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;

public class TabPanel
extends Panel {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int ROUNDED = 0;
    public static final int CUTTED = 1;
    public static final int SLANTED = 2;
    public static final int NONE = 0;
    public static final int RAISED = 1;
    public int bevel = 1;
    Vector vPanels;
    String[] labels = null;
    private Vector vEnabled;
    protected Vector vPolys;
    protected int curIndex = -1;
    protected transient boolean suppressRepaints = false;
    protected int firstVisibleTab = 0;
    protected DirButton dbLeft;
    protected DirButton dbRight;
    protected Polygon nullPoly;
    protected Vector vLabels;
    protected Color borderDarkerColor = null;
    protected Color borderLightColor = null;
    protected Color borderDarkColor = null;
    protected Color disabledTextColor = null;
    protected Color cachedForeground = null;
    protected Color cachedBackground = null;
    private int TF_LEFT = 0;
    private int TF_RIGHT = 0;
    private int TF_TOP = 24;
    private int TF_BOTTOM = -2;
    private int TF_BTN_HEIGHT = 20;
    private Font fReg;
    private Font fSel;
    private Component userPanel = null;
    private int iTabsPosition = 0;
    private int iTabsStyle = 0;
    private transient int osAdjustment;
    private int lastWidth = -1;
    private Insets btpInsets;
    private Mouse mouse = null;
    private Action action = null;
    Font tabRegFont = new Font("Dialog", 0, 14);
    Font tabSelFont = new Font("Dialog", 1, 14);
    public int previousIndex = 0;
    int marginl = 3;
    int margint = 3;
    int marginr = 6;
    int marginb = 5;

    public TabPanel(int n, int n2) {
        this.vLabels = new Vector();
        this.vEnabled = new Vector();
        this.vPolys = new Vector();
        this.btpInsets = new Insets(0, 0, 0, 0);
        this.setTabsInfo(n, n2);
        this.fReg = this.tabRegFont;
        this.fSel = this.tabSelFont;
        this.osAdjustment = System.getProperty("os.name").startsWith("S") ? -1 : 0;
        super.setLayout(null);
        this.dbLeft = new DirButton(0);
        this.dbRight = new DirButton(1);
        this.dbLeft.setShowFocus(false);
        this.dbRight.setShowFocus(false);
        super.add((Component)this.dbLeft, -1);
        super.add((Component)this.dbRight, -1);
        this.nullPoly = new Polygon();
        this.nullPoly.addPoint(0, 0);
        this.nullPoly.addPoint(1, 1);
        this.nullPoly.addPoint(0, 0);
        this.cachedForeground = this.getForeground();
        this.cachedBackground = this.getBackground();
        this.vPanels = new Vector();
    }

    public TabPanel() {
        this(0, 0);
    }

    public void setBevel(int n) {
        this.bevel = n;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.dbLeft != null) {
            this.dbLeft.setBackground(color);
        }
        if (this.dbRight != null) {
            this.dbRight.setBackground(color);
        }
    }

    public void setTabFonts(Font font, Font font2) {
        this.tabRegFont = font;
        this.tabSelFont = font2;
    }

    public void setTabsPosition(int n) {
        if (this.iTabsPosition != n) {
            this.setTabsInfo(n, this.iTabsStyle);
        }
    }

    public int getTabsPosition() {
        return this.iTabsPosition;
    }

    public void setTabsStyle(int n) {
        if (this.iTabsStyle != n) {
            this.setTabsInfo(this.iTabsPosition, n);
        }
    }

    public int getTabsStyle() {
        return this.iTabsStyle;
    }

    public void setTabsInfo(int n, int n2) {
        this.iTabsPosition = n;
        this.iTabsStyle = n2;
        this.TF_BTN_HEIGHT = this.iTabsStyle == 2 && n == 1 ? 17 : 20;
        this.triggerRepaint();
    }

    public boolean setSuppressRepaints(boolean bl) {
        boolean bl2 = this.suppressRepaints;
        this.suppressRepaints = bl;
        return bl2;
    }

    protected void triggerRepaint() {
        if (!this.suppressRepaints) {
            this.repaint();
        }
    }

    public synchronized void setTab(String string, boolean bl, int n) {
        boolean bl2 = this.setSuppressRepaints(true);
        try {
            this.setLabel(string, n);
            this.setEnabled(bl, n);
            Object var6_5 = null;
            this.setSuppressRepaints(bl2);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setSuppressRepaints(bl2);
            throw throwable;
        }
        this.triggerRepaint();
    }

    public synchronized void setLabel(String string, int n) {
        try {
            this.vLabels.setElementAt(string, n);
            this.triggerRepaint();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public synchronized String getLabel(int n) {
        try {
            String string = (String)this.vLabels.elementAt(n);
            return string;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    public void setPanelLabels(String[] stringArray) {
        this.labels = stringArray;
        this.updatePanelLabels();
    }

    public String[] getPanelLabels() {
        return this.labels;
    }

    public synchronized void setEnabled(boolean bl, int n) {
        if (n < 0 || n >= this.vLabels.size()) {
            return;
        }
        if (n == this.curIndex && !bl) {
            return;
        }
        try {
            Boolean bl2 = new Boolean(bl);
            this.vEnabled.setElementAt(bl2, n);
            this.triggerRepaint();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean isEnabled(int n) {
        try {
            Boolean bl = (Boolean)this.vEnabled.elementAt(n);
            if (bl.booleanValue()) {
                boolean bl2 = true;
                return bl2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public synchronized int getPanelIndex(Component component) {
        return this.vPanels.indexOf(component);
    }

    public void setPanel(int n) {
        if (n == this.curIndex) {
            return;
        }
        this.select(n);
    }

    public synchronized void select(int n) {
        if (this.isEnabled(n)) {
            try {
                Component component = (Component)this.vPanels.elementAt(n);
                this.setCurrentTab(n);
                this.showPanel(component);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void setCurrentTab(int n) {
        if (n == this.curIndex) {
            return;
        }
        if (this.isEnabled(n)) {
            try {
                this.previousIndex = this.curIndex;
                this.curIndex = n;
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    public void showPanel(Component component) {
        if (this.userPanel != null) {
            this.userPanel.setVisible(false);
        }
        this.userPanel = component;
        if (this.userPanel != null) {
            int n;
            Component[] componentArray = this.getComponents();
            int n2 = componentArray.length;
            for (n = 0; n < n2 && componentArray[n] != this.userPanel; ++n) {
            }
            if (n == n2) {
                super.add(this.userPanel, -1);
            }
            this.userPanel.setVisible(true);
            this.userPanel.requestFocus();
            this.validate();
            this.triggerRepaint();
        }
    }

    public void backTab() {
        this.setCurrentTab(this.previousIndex);
    }

    public int getCurrentTab() {
        return this.curIndex;
    }

    public int getTab() {
        return this.curIndex;
    }

    public int addTab(String string, boolean bl) {
        return this.addTab(string, bl, -1);
    }

    public int addTab(String string, boolean bl, int n) {
        int n2;
        if (n == -1) {
            this.vLabels.addElement(string);
            this.vEnabled.addElement(new Boolean(bl));
            n2 = this.vLabels.size() - 1;
        } else {
            this.vLabels.insertElementAt(string, n);
            this.vEnabled.insertElementAt(new Boolean(bl), n);
            n2 = n;
        }
        if (this.curIndex == -1 && bl) {
            this.setCurrentTab(n2);
        }
        return n2;
    }

    public synchronized void insertTab(String string, boolean bl, int n) {
        if (n == this.curIndex && !bl) {
            return;
        }
        try {
            this.vLabels.insertElementAt(string, n);
            this.vEnabled.insertElementAt(new Boolean(bl), n);
            this.triggerRepaint();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int addTabPanel(String string, boolean bl, Component component) {
        return this.addTabPanel(string, bl, component, -1);
    }

    public int addTabPanel(String string, boolean bl, Component component, int n) {
        if (n == -1) {
            this.vPanels.addElement(component);
        } else {
            this.vPanels.insertElementAt(component, n);
        }
        return this.addTab(string, bl, n);
    }

    public synchronized void insertTabPanel(String string, boolean bl, Component component, int n) {
        if (n < 0 || n >= this.vPanels.size()) {
            return;
        }
        if (n == this.getCurrentTab() && !bl) {
            return;
        }
        try {
            this.vPanels.insertElementAt(component, n);
            this.insertTab(string, bl, n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public synchronized Component add(String string, Component component) {
        this.addTabPanel(string, true, component);
        return component;
    }

    public Component add(Component component) {
        this.addTabPanel(this.createDefaultLabel(this.vPanels.size()), true, component);
        return component;
    }

    public synchronized Component add(Component component, int n) {
        this.add(this.createDefaultLabel(this.vPanels.size()), component, n);
        return component;
    }

    public synchronized Component add(String string, Component component, int n) {
        boolean bl = this.setSuppressRepaints(true);
        try {
            int n2 = this.addTabPanel(string, true, component, n);
            if (n2 == this.curIndex) {
                this.select(n2);
            }
            this.updatePanelLabels();
            Object var7_6 = null;
            this.setSuppressRepaints(bl);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setSuppressRepaints(bl);
            throw throwable;
        }
        this.triggerRepaint();
        return component;
    }

    public void setPanelLabel(String string, int n) {
        if (n >= 0 && n < this.labels.length && this.labels[n] != string) {
            this.labels[n] = string;
            this.updatePanelLabels();
        }
    }

    public String getPanelLabel(int n) {
        if (n >= 0 && n < this.labels.length) {
            return this.labels[n];
        }
        return null;
    }

    public synchronized void setTabPanel(String string, boolean bl, Component component, int n) {
        if (n < 0 || n >= this.vPanels.size()) {
            return;
        }
        if (n == this.getCurrentTab() && !bl) {
            return;
        }
        try {
            this.vPanels.setElementAt(component, n);
            this.setTab(string, bl, n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public synchronized Component getTabPanel(int n) {
        if (n < 0 || n >= this.vPanels.size()) {
            return null;
        }
        Component component = null;
        try {
            component = (Component)this.vPanels.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return component;
    }

    public synchronized void remove(Component component) {
        int n = this.getPanelIndex(component);
        if (this.countTabs() == 1) {
            this.removeAllTabPanels();
        } else {
            if (n == 0) {
                this.select(1);
            } else {
                this.select(n - 1);
            }
            this.removeTabPanel(n);
        }
    }

    public void removeTab(int n) {
        if (n == this.curIndex) {
            return;
        }
        try {
            this.vLabels.removeElementAt(n);
            this.vEnabled.removeElementAt(n);
            this.triggerRepaint();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void removeAllTabs() {
        this.vLabels = new Vector();
        this.vEnabled = new Vector();
        this.vPolys = new Vector();
        this.curIndex = -1;
        this.firstVisibleTab = 0;
        this.lastWidth = -1;
        this.removeAll();
        this.triggerRepaint();
    }

    public synchronized void removeTabPanel(int n) {
        if (n < 0 || n >= this.vPanels.size() || n == this.curIndex) {
            return;
        }
        try {
            Component component = (Component)this.vPanels.elementAt(n);
            super.remove(component);
            this.vPanels.removeElementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.removeTab(n);
    }

    public synchronized void removeAllTabPanels() {
        this.vPanels = new Vector();
        this.curIndex = -1;
        this.removeAllTabs();
    }

    public void updatePanelLabels() {
        try {
            for (int i = 0; i < this.vPanels.size(); ++i) {
                String string;
                if (this.labels != null) {
                    try {
                        string = this.labels[i];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        string = this.createDefaultLabel(i);
                    }
                } else {
                    string = this.createDefaultLabel(i);
                }
                this.setLabel(string, i);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this.marginl = n;
        this.margint = n2;
        this.marginr = n3;
        this.marginb = n4;
    }

    public void doLayout() {
        Rectangle rectangle = this.getBounds();
        int n = rectangle.width - this.TF_LEFT + this.TF_RIGHT;
        if (n < 0) {
            return;
        }
        int n2 = rectangle.height - this.TF_TOP + this.TF_BOTTOM;
        if (n2 < 0) {
            return;
        }
        int n3 = this.TF_LEFT;
        int n4 = 0;
        n4 = this.iTabsPosition == 0 ? this.TF_TOP : this.TF_TOP - this.TF_BTN_HEIGHT;
        if (this.userPanel != null) {
            this.userPanel.setBounds(n3 + this.marginl, n4 + this.margint, n - this.marginr, n2 - this.marginb);
            this.userPanel.invalidate();
            this.userPanel.validate();
            if (this.userPanel instanceof Canvas || this.userPanel instanceof Panel) {
                this.userPanel.repaint();
            } else {
                this.triggerRepaint();
            }
        }
    }

    void drawUnderlined(Graphics graphics, String string, int n, int n2) {
        if (string.charAt(0) == '+') {
            graphics.drawString("_", n, n2);
            graphics.drawString(string.substring(1, string.length()), n, n2);
        } else {
            graphics.drawString(string, n, n2);
        }
    }

    void drawNoUnderlined(Graphics graphics, String string, int n, int n2) {
        if (string.charAt(0) == '+') {
            graphics.drawString(string.substring(1, string.length()), n, n2);
        } else {
            graphics.drawString(string, n, n2);
        }
    }

    public synchronized void paint(Graphics graphics) {
        int n;
        int n2;
        Rectangle rectangle = this.getBounds();
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        if (!TabPanel.objectsEqual(color, this.cachedForeground)) {
            this.cachedForeground = color;
            this.calculateDisabledTextColor(color);
        }
        if (!TabPanel.objectsEqual(color2, this.cachedBackground)) {
            this.cachedBackground = color2;
            this.calculateBorderColors(color2);
        }
        if ((n2 = rectangle.width - this.TF_LEFT + this.TF_RIGHT) < 0) {
            return;
        }
        int n3 = rectangle.height - this.TF_TOP + this.TF_BOTTOM;
        if (n3 < 0) {
            return;
        }
        if (rectangle.width > this.lastWidth) {
            this.firstVisibleTab = 0;
        }
        this.lastWidth = rectangle.width;
        int n4 = this.TF_LEFT;
        Color color3 = graphics.getColor();
        graphics.setColor(color2);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        int n5 = this.iTabsPosition == 0 ? this.TF_TOP : this.TF_TOP - this.TF_BTN_HEIGHT;
        int n6 = 8;
        if (this.iTabsStyle == 2) {
            n6 = 14;
        }
        graphics.setColor(this.borderLightColor);
        graphics.drawLine(n4, n5, n4 + n2 - 1, n5);
        if (this.bevel == 1) {
            graphics.drawLine(n4, n5, n4, n5 + n3 - 1);
            graphics.setColor(this.borderDarkColor);
            graphics.drawLine(n4 + 2, n5 + n3 - 2, n4 + n2 - 2, n5 + n3 - 2);
            graphics.drawLine(n4 + n2 - 2, n5 + 2, n4 + n2 - 2, n5 + n3 - 2);
            graphics.setColor(this.borderDarkerColor);
            graphics.drawLine(n4 + 1, n5 + n3 - 1, n4 + n2 - 1, n5 + n3 - 1);
            graphics.drawLine(n4 + n2 - 1, n5 + 1, n4 + n2 - 1, n5 + n3 - 1);
        }
        int n7 = this.TF_LEFT + 8;
        int n8 = 0;
        int n9 = this.TF_LEFT;
        int n10 = 0;
        int n11 = this.vLabels.size();
        this.vPolys.removeAllElements();
        Font font = graphics.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(this.fReg);
        FontMetrics fontMetrics2 = this.getFontMetrics(this.fSel);
        int n12 = 0;
        for (n = 0; n < this.firstVisibleTab; ++n) {
            this.vPolys.addElement(this.nullPoly);
        }
        if (n > 0) {
            n9 += 2;
        }
        while (n < n11) {
            Polygon polygon = new Polygon();
            try {
                int n13;
                int n14;
                int n15;
                String string = (String)this.vLabels.elementAt(n);
                String string2 = string.charAt(0) == '+' ? string.substring(1, string.length()) : string;
                n12 = n == this.curIndex ? fontMetrics2.stringWidth(string2) : fontMetrics.stringWidth(string2);
                if (this.iTabsPosition == 0) {
                    n15 = this.TF_TOP - this.TF_BTN_HEIGHT;
                    n14 = this.TF_TOP - 1;
                } else {
                    n15 = rectangle.height + this.TF_BOTTOM + 1;
                    n14 = rectangle.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT;
                }
                if (this.iTabsStyle == 0) {
                    n13 = n9 + 2;
                    n7 = n13 + n12 + 13;
                } else if (this.iTabsStyle == 1) {
                    n13 = n9 + 2;
                    n7 = n13 + n12 + 13;
                    n10 = 4;
                } else {
                    n13 = n7 - 7;
                    n7 = n13 + n12 + 28;
                }
                if (n7 + 36 - this.TF_RIGHT > rectangle.width) break;
                if (this.iTabsPosition == 0) {
                    if (this.iTabsStyle == 2) {
                        graphics.setColor(this.borderLightColor);
                        graphics.drawLine(n13 + 9, n15, n7 - 9, n15);
                        if (n == 0 || n == this.curIndex) {
                            graphics.drawLine(n13, n14, n13 + 9, n15);
                            polygon.addPoint(n13, n14);
                        } else {
                            graphics.drawLine(n13 + 4, n15 + 9, n13 + 9, n15);
                            polygon.addPoint(n13 + 9, n14);
                            polygon.addPoint(n13 + 4, n15 + 9);
                        }
                        polygon.addPoint(n13 + 9, n15);
                        polygon.addPoint(n7 - 9, n15);
                        graphics.setColor(this.borderDarkColor);
                        if (n + 1 == this.curIndex) {
                            graphics.drawLine(n7 - 9, n15, n7 - 5, n15 + 9);
                            polygon.addPoint(n7 - 9, n15);
                            polygon.addPoint(n7 - 5, n14);
                        } else {
                            graphics.drawLine(n7, n14, n7 - 9, n15);
                            polygon.addPoint(n7, n14);
                        }
                        if (n == 1 || n == this.curIndex) {
                            polygon.addPoint(n13, n14);
                        } else {
                            polygon.addPoint(n13 + 9, n14);
                        }
                        graphics.setColor(this.borderDarkerColor);
                        if (n + 1 == this.curIndex) {
                            graphics.drawLine(n7 - 8, n15 + 1, n7 - 4, n15 + 9);
                        } else {
                            graphics.drawLine(n7 + 1, n14, n7 - 8, n15 + 1);
                        }
                    } else {
                        if (n == this.curIndex) {
                            n15 -= 3;
                            n13 -= 2;
                        }
                        graphics.setColor(this.borderLightColor);
                        if (this.curIndex == n + 1) {
                            graphics.drawLine(n13 + 2 + n10, n15, n7 - 2, n15);
                        } else {
                            graphics.drawLine(n13 + 2 + n10, n15, n7, n15);
                        }
                        if (this.curIndex != n - 1) {
                            graphics.drawLine(n13, n15 + 2 + n10, n13, n14);
                            n8 = n13;
                        } else {
                            n8 = n13 + 1;
                        }
                        graphics.drawLine(n13 + 1, n15 + 1 + n10, n13 + 1 + n10, n15 + 1);
                        if (this.curIndex != n + 1) {
                            graphics.setColor(this.borderDarkColor);
                            graphics.drawLine(n7, n15, n7, n14);
                            graphics.setColor(this.borderDarkerColor);
                            graphics.drawLine(n7 + 1, n15 + 2, n7 + 1, n14);
                            n9 = n7;
                        } else {
                            n9 = n7 - 1;
                        }
                    }
                } else if (this.iTabsStyle == 2) {
                    graphics.setColor(this.borderDarkColor);
                    graphics.drawLine(n13 + 9, n15, n7 - 9, n15);
                    graphics.setColor(this.borderDarkerColor);
                    if (n == 0 || n == this.curIndex) {
                        graphics.drawLine(n13, n14, n13 + 9, n15);
                        polygon.addPoint(n13, n14);
                    } else {
                        graphics.drawLine(n13 + 4, n15 - 9, n13 + 9, n15);
                        polygon.addPoint(n13 + 9, n14);
                        polygon.addPoint(n13 + 4, n15 - 9);
                    }
                    polygon.addPoint(n13 + 9, n15);
                    polygon.addPoint(n7 - 9, n15);
                    if (n + 1 == this.curIndex) {
                        graphics.drawLine(n7 - 5, n15 - 9, n7 - 9, n15);
                        polygon.addPoint(n7 - 5, n15);
                        polygon.addPoint(n7 - 9, n14);
                    } else {
                        graphics.drawLine(n7, n14, n7 - 9, n15);
                        polygon.addPoint(n7, n14);
                    }
                    if (n == 1 || n == this.curIndex) {
                        polygon.addPoint(n13, n14);
                    } else {
                        polygon.addPoint(n13 + 9, n14);
                    }
                } else {
                    if (n == this.curIndex) {
                        n15 += 3;
                        n13 -= 2;
                    }
                    graphics.setColor(this.borderLightColor);
                    if (this.curIndex == n + 1) {
                        graphics.drawLine(n13 + 2, n15, n7 - 2, n15);
                    } else {
                        graphics.drawLine(n13 + 2, n15, n7, n15);
                    }
                    if (this.curIndex != n - 1) {
                        graphics.drawLine(n13, n15 - 2, n13, n14);
                        n8 = n13;
                    } else {
                        n8 = n13 + 1;
                    }
                    graphics.drawLine(n13 + 1, n15 - 1, n13 + 1, n15 - 1);
                    if (this.curIndex != n + 1) {
                        graphics.setColor(this.borderDarkColor);
                        graphics.drawLine(n7, n15, n7, n14);
                        graphics.setColor(this.borderDarkerColor);
                        graphics.drawLine(n7 + 1, n15 - 2, n7 + 1, n14);
                        n9 = n7;
                    } else {
                        n9 = n7 - 1;
                    }
                }
                boolean bl = false;
                if (n == this.curIndex) {
                    bl = true;
                    n14 = this.iTabsPosition == 0 ? ++n14 : --n14;
                    graphics.setColor(color2);
                    graphics.drawLine(n13 + 1, n14, n7, n14);
                    if (this.iTabsPosition == 1) {
                        graphics.drawLine(n13 + 1, n14 - 1, n7, n14 - 1);
                    }
                    graphics.setFont(this.fSel);
                } else {
                    graphics.setFont(this.fReg);
                }
                if (this.iTabsStyle == 0 || this.iTabsStyle == 1) {
                    polygon.addPoint(n8, n14);
                    polygon.addPoint(n9, n14);
                    polygon.addPoint(n9, n15);
                    polygon.addPoint(n8, n15);
                    polygon.addPoint(n8, n14);
                }
                this.vPolys.addElement(polygon);
                Boolean bl2 = (Boolean)this.vEnabled.elementAt(n);
                if (bl2.booleanValue()) {
                    graphics.setColor(color);
                } else {
                    graphics.setColor(this.disabledTextColor);
                }
                if (this.iTabsPosition == 0) {
                    if (bl) {
                        this.drawNoUnderlined(graphics, string, n13 + n6, n15 + 15 + this.osAdjustment);
                    } else {
                        this.drawUnderlined(graphics, string, n13 + n6, n15 + 15 + this.osAdjustment);
                    }
                } else if (this.iTabsStyle == 0 || this.iTabsStyle == 1) {
                    graphics.drawString(string, n13 + n6, n15 - 6 + this.osAdjustment);
                } else {
                    graphics.drawString(string, n13 + n6, n15 - 4 + this.osAdjustment);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            ++n;
        }
        if (this.firstVisibleTab > 0 || n < n11) {
            this.dbLeft.setVisible(true);
            this.dbRight.setVisible(true);
            if (this.firstVisibleTab > 0) {
                this.dbLeft.setEnabled(true);
            } else {
                this.dbLeft.setEnabled(false);
            }
            if (n < n11) {
                this.dbRight.setEnabled(true);
            } else {
                this.dbRight.setEnabled(false);
            }
            if (this.iTabsPosition == 0) {
                this.dbLeft.setBounds(rectangle.width - 33 + this.TF_RIGHT, this.TF_TOP - 16, 16, 15);
                this.dbRight.setBounds(rectangle.width - 16 + this.TF_RIGHT, this.TF_TOP - 16, 16, 15);
            } else {
                this.dbLeft.setBounds(rectangle.width - 33 + this.TF_RIGHT, rectangle.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT, 16, 15);
                this.dbRight.setBounds(rectangle.width - 16 + this.TF_RIGHT, rectangle.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT, 16, 15);
            }
        } else {
            this.dbLeft.setVisible(false);
            this.dbRight.setVisible(false);
        }
        while (n < n11) {
            this.vPolys.addElement(this.nullPoly);
            ++n;
        }
        graphics.setFont(font);
        graphics.setColor(color3);
    }

    public synchronized void removeAll() {
        super.removeAll();
        super.add((Component)this.dbLeft, -1);
        super.add((Component)this.dbRight, -1);
        this.userPanel = null;
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public Insets getInsets() {
        this.btpInsets = super.getInsets();
        this.btpInsets.left += this.TF_LEFT + 3;
        this.btpInsets.right += 6 - this.TF_RIGHT;
        if (this.iTabsPosition == 0) {
            this.btpInsets.top += this.TF_TOP + 3;
            this.btpInsets.bottom += 5 - this.TF_BOTTOM;
        } else {
            this.btpInsets.top += this.TF_TOP - this.TF_BTN_HEIGHT + 3;
            this.btpInsets.bottom += this.TF_BTN_HEIGHT + 5 - this.TF_BOTTOM;
        }
        return this.btpInsets;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.action == null) {
            this.action = new Action();
            this.dbLeft.addActionListener(this.action);
            this.dbRight.addActionListener(this.action);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.action != null) {
            this.dbLeft.removeActionListener(this.action);
            this.dbRight.removeActionListener(this.action);
            this.action = null;
        }
        super.removeNotify();
    }

    protected void calculateBorderColors(Color color) {
        this.borderLightColor = ColorUtils.calculateHilightColor(color);
        this.borderDarkColor = ColorUtils.calculateShadowColor(color);
        this.borderDarkerColor = ColorUtils.darken(this.borderDarkColor, 0.2);
    }

    protected void calculateDisabledTextColor(Color color) {
        try {
            this.disabledTextColor = ColorUtils.fade(color, Color.lightGray, 0.5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static boolean objectsEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public int countTabs() {
        return this.vPanels.size();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }

    private String createDefaultLabel(int n) {
        return "Tab ".concat(String.valueOf(String.valueOf(String.valueOf(n))));
    }

    class Action
    implements ActionListener,
    Serializable {
        Action() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == TabPanel.this.dbLeft) {
                if (--TabPanel.this.firstVisibleTab < 0) {
                    TabPanel.this.firstVisibleTab = 0;
                } else {
                    TabPanel.this.triggerRepaint();
                }
            } else if (actionEvent.getSource() == TabPanel.this.dbRight) {
                int n = TabPanel.this.vLabels.size();
                if (++TabPanel.this.firstVisibleTab == n) {
                    --TabPanel.this.firstVisibleTab;
                } else {
                    TabPanel.this.triggerRepaint();
                }
            }
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        Mouse() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = TabPanel.this.vPolys.size();
            for (int i = 0; i < n; ++i) {
                try {
                    Polygon polygon = (Polygon)TabPanel.this.vPolys.elementAt(i);
                    if (polygon == TabPanel.this.nullPoly || !polygon.contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                    TabPanel.this.select(i);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }
}

