.code
;
; ****************************
; *****  %_div.SCOMPLEX  *****  z3 = z1 / z2
; ****************************
;
; in:	eax -> z3 (result)
;	esi -> z1
;	edi -> z2
; out:	eax -> z3 (result)
;
; destroys: nothing
;
;	   Re(z1) * Re(z2) + Im(z1) * Im(z2)
; Re(z3) = ---------------------------------
;	   Re(z2) * Re(z2) + Im(z2) * Im(z2)
;
;	   Im(z1) * Re(z2) - Im(z2) * Re(z1)
; Im(z3) = ---------------------------------
;	   Re(z2) * Re(z2) + Im(z2) * Im(z2)
;
%_div.SCOMPLEX:
fld	d[esi]												; calculate real part of quotient
fld	d[edi]
fmul
fld	d[esi+4]
fld	d[edi+4]
fmul
fadd															; st0 = numerator
fld	d[edi]
fld	st0
fmul
fld	d[edi+4]
fld	st0
fmul
fadd															; st0 = denominator, st1 = numerator
fst	st2														; save denominator for later
fdiv
fstp	d[eax]											; store real part of quotient
fld	d[esi+4] 											; calculate imaginary part of quotient
fld	d[edi]
fmul
fld	d[edi+4]
fld	d[esi]
fmul
fsub															; st0 = numerator, st1 = denominator
fdivr
fstp	d[eax+4] 										; store imaginary part of quotient
ret
