/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import teamdev.jxcapture.DrawableCapture;
import teamdev.jxcapture.ObjectOnScreenCapture;
import teamdev.jxcapture.controllers.SelectionController;
import teamdev.jxcapture.controllers.ObjectOnScreenController;
import teamdev.jxcapture.events.CaptureAdapter;
import teamdev.jxcapture.painters.SelectionPainter;
import teamdev.jxcapture.painters.ObjectOnScreenPainter;
import teamdev.jxcapture.toolkit.DrawableArea;

import javax.imageio.ImageIO;
import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

/**
 * The example demonstrates how to set the specified popup menu for the capture operation.
 *
 * @author Ikryanov Vladimir
 */
public class CaptureWithPopupSample {
    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SelectionPainter painter = new ObjectOnScreenPainter();
        SelectionController controller = new ObjectOnScreenController(painter);
        final DrawableCapture captureOperation = new ObjectOnScreenCapture(controller);

        captureOperation.addCaptureListener(new CaptureAdapter() {
            public void cancel() {
                System.out.println("Cancel");
            }

            public void complete(BufferedImage image) {
                try {
                    ImageIO.write(image, "PNG", new File("C:/region.png"));
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });

        // creating the popup menu
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new AbstractAction("Abort Capture") {
            public void actionPerformed(ActionEvent e) {
                captureOperation.cancel();
            }
        }));
        popupMenu.add(new JMenuItem(new AbstractAction("Finish Capture") {
            public void actionPerformed(ActionEvent e) {
                captureOperation.complete();
            }
        }));

        // setting the popup menu for the DrawableArea component
        DrawableArea drawableArea = captureOperation.getDrawableArea();
        drawableArea.setPopupMenu(popupMenu);

        // executing the capture operation
        captureOperation.execute();
    }
}
