import teamdev.jxdesktop.CaptureUtilities;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;

/**
 * @author Ikryanov Vladimir
 */
public class CaptureUtilitiesSample {
    public static void main(String[] args) throws Exception {
        final Rectangle RECTANGLE = new Rectangle(0, 0, 1280, 1024);

        // JxCapture test
        CaptureUtilities utilities = CaptureUtilities.getInstance();
        long time = System.currentTimeMillis();
        BufferedImage jxcaptureImage = utilities.createScreenCapture(RECTANGLE);
        System.out.println("Result time = " + (System.currentTimeMillis() - time));
        ImageIO.write(jxcaptureImage, "png", new File("C:/jxcaptureImage.png"));

        // Robot test
        Robot robot = new Robot();
        long robotTime = System.currentTimeMillis();
        BufferedImage robotImage = robot.createScreenCapture(RECTANGLE);
        System.out.println("Robot time = " + (System.currentTimeMillis() - robotTime));
        ImageIO.write(robotImage, "png", new File("C:/robotImage.png"));
    }
}
