/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import teamdev.jxcapture.samples.demo.ApplicationSettings;
import teamdev.jxcapture.samples.demo.EscapeDialog;

public class SettingsDialog
extends EscapeDialog {
    private static SettingsDialog instance;
    private JCheckBox delay = new JCheckBox();
    private JCheckBox includeCursor = new JCheckBox();
    private JCheckBox transparentWindows = new JCheckBox();
    private JCheckBox autoSave = new JCheckBox();
    private JLabel folderLabel = new JLabel();
    private JLabel formatLabel = new JLabel();
    private JLabel delayTimeLabel = new JLabel();
    private JTextField outputFolder;
    private JTextField templateName;
    private JSpinner templateNumber = new JSpinner();
    private JSpinner delayTime = new JSpinner();
    private JComboBox formats;
    private JButton chooseFolder = new JButton();
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private ApplicationSettings settings = ApplicationSettings.getInstance();

    private SettingsDialog() {
        ApplicationContext applicationContext = Application.getInstance().getContext();
        this.actionMap = applicationContext.getActionMap(SettingsDialog.class, (Object)this);
        this.resourceMap = applicationContext.getResourceMap(SettingsDialog.class);
        this.createGUI();
        this.setName("dialog");
        this.setModal(true);
        this.setResizable(false);
        this.setIconImage(this.resourceMap.getImageIcon("window.icon").getImage());
        this.setLocationRelativeTo(null);
        this.resourceMap.injectComponents((Component)this);
    }

    public static SettingsDialog getInstance() {
        return instance == null ? (instance = new SettingsDialog()) : instance;
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.createContentPane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createActionPane(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContentPane(jPanel);
        this.pack();
    }

    private JPanel createContentPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.createCapturePane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createFilePane(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createFilePane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new BorderUIResource.TitledBorderUIResource(this.resourceMap.getString("filePanel.title", new Object[0])));
        this.templateName = new JTextField(this.settings.getTemplateFileName(), 10);
        int n = this.settings.getTemplateNumber();
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, 0, 1000, 1);
        this.templateNumber.setModel(spinnerNumberModel);
        this.templateNumber.setPreferredSize(new Dimension(45, 20));
        this.outputFolder = new JTextField(this.settings.getOutputFolder(), 20);
        this.chooseFolder.setPreferredSize(new Dimension(20, 20));
        this.formats = new JComboBox<String>(this.settings.getImageFormats());
        this.formats.setPreferredSize(new Dimension(60, 20));
        this.formats.setSelectedIndex(this.settings.getImageFormatIndex());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.outputFolder, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 3), 0, 0));
        jPanel2.add((Component)this.chooseFolder, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 0, 0), 0, 0));
        this.chooseFolder.setAction(this.actionMap.get("chooseFolder"));
        this.folderLabel.setName("folderLabel");
        this.formatLabel.setName("formatLabel");
        this.autoSave.setAction(this.actionMap.get("autoSave"));
        this.autoSave.setSelected(this.settings.isAutoSave());
        JLabel jLabel = new JLabel();
        jLabel.setName("fileNameTemplate");
        JLabel jLabel2 = new JLabel();
        jLabel2.setName("startsFrom");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 17, new Insets(0, 10, 0, 0), 0, 0));
        jPanel.add((Component)this.templateName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 6, 0, 3), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 17, new Insets(0, 3, 0, 3), 0, 0));
        jPanel.add((Component)this.templateNumber, new GridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 0, 10), 0, 0));
        jPanel.add((Component)this.autoSave, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 17, new Insets(11, 10, 0, 0), 0, 0));
        jPanel.add((Component)this.folderLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 13, new Insets(7, 3, 0, 3), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 17, 2, new Insets(7, 3, 0, 10), 0, 0));
        jPanel.add((Component)this.formatLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 13, new Insets(7, 3, 10, 3), 0, 0));
        jPanel.add((Component)this.formats, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 17, new Insets(7, 3, 10, 10), 0, 0));
        this.updateAutoSave();
        return jPanel;
    }

    private JPanel createCapturePane() {
        this.includeCursor.setName("includeCursor");
        this.includeCursor.setSelected(this.settings.isIncludeCursor());
        this.transparentWindows.setName("captureTransparentWindows");
        this.transparentWindows.setSelected(this.settings.isCaptureTransparentWindows());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new BorderUIResource.TitledBorderUIResource(" Capture "));
        jPanel.add((Component)this.includeCursor, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 17, new Insets(0, 10, 3, 10), 0, 0));
        jPanel.add((Component)this.transparentWindows, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 17, new Insets(0, 10, 3, 10), 0, 0));
        jPanel.add((Component)this.createDelayTimePane(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 17, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createDelayTimePane() {
        int n = this.settings.getDelayTime() / 1000;
        int n2 = this.settings.getMaxDelayTime() / 1000;
        this.delayTime.setModel(new SpinnerNumberModel(n, 1, n2, 1));
        this.delayTime.setPreferredSize(new Dimension(50, 20));
        this.delay.setAction(this.actionMap.get("delayBeforeCapture"));
        this.delay.setSelected(this.settings.isDelayBeforeCapture());
        this.delayTimeLabel.setName("seconds");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.delay, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 10, 0), 0, 0));
        jPanel.add((Component)this.delayTime, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 10, 3), 0, 0));
        jPanel.add((Component)this.delayTimeLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 10, 10), 0, 0));
        this.updateDelayArea();
        return jPanel;
    }

    private JPanel createActionPane() {
        Dimension dimension = new Dimension(75, 23);
        JButton jButton = new JButton(this.actionMap.get("apply"));
        jButton.setPreferredSize(dimension);
        JButton jButton2 = new JButton(this.actionMap.get("cancel"));
        jButton2.setPreferredSize(dimension);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jButton2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 6, 0, 0), 0, 0));
        jPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        return jPanel;
    }

    private void updateDelayArea() {
        boolean bl = this.delay.isSelected();
        this.delayTime.setEnabled(bl);
        this.delayTimeLabel.setEnabled(bl);
    }

    private void updateAutoSave() {
        boolean bl = this.autoSave.isSelected();
        this.folderLabel.setEnabled(bl);
        this.formatLabel.setEnabled(bl);
        this.outputFolder.setEnabled(bl);
        this.chooseFolder.setEnabled(bl);
        this.formats.setEnabled(bl);
    }

    private String getOutputFolder() {
        String string = this.outputFolder.getText();
        if (string.length() == 0) {
            String string2 = this.resourceMap.getString("erremptyFolderError.title", new Object[0]);
            String string3 = this.resourceMap.getString("emptyFolderError.message", new Object[0]);
            JOptionPane.showMessageDialog(this, string3, string2, 0);
            return null;
        }
        if (!new File(string).exists()) {
            String string4 = this.resourceMap.getString("existFolderError.title", new Object[0]);
            String string5 = this.resourceMap.getString("existFolderError.message", new Object[0]);
            JOptionPane.showMessageDialog(this, string5, string4, 0);
            return null;
        }
        return string;
    }

    @Action
    public void delayBeforeCapture() {
        this.updateDelayArea();
    }

    @Action
    public void autoSave() {
        this.updateAutoSave();
    }

    @Action
    public void chooseFolder() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.outputFolder.setText(string);
        }
    }

    @Action
    public void apply() {
        String string = this.templateName.getText();
        if (string.length() == 0) {
            String string2 = this.resourceMap.getString("emptyFileNameError.title", new Object[0]);
            String string3 = this.resourceMap.getString("emptyFileNameError.message", new Object[0]);
            JOptionPane.showMessageDialog(this, string3, string2, 0);
            return;
        }
        if (this.autoSave.isSelected()) {
            String string4 = this.getOutputFolder();
            if (string4 == null) {
                return;
            }
            this.settings.setOutputFolder(string4);
            this.settings.setImageFormatIndex(this.formats.getSelectedIndex());
        }
        this.settings.setIncludeCursor(this.includeCursor.isSelected());
        this.settings.setCaptureTransparentWindows(this.transparentWindows.isSelected());
        this.settings.setAutoSave(this.autoSave.isSelected());
        this.settings.setTemplateFileName(string);
        this.settings.setTemplateNumber((Integer)this.templateNumber.getValue());
        this.settings.setDelayBeforeCapture(this.delay.isSelected());
        if (this.settings.isDelayBeforeCapture()) {
            this.settings.setDelayTime((Integer)this.delayTime.getValue() * 1000);
        }
        this.destroy();
    }

    @Action
    public void cancel() {
        this.destroy();
    }

    private void destroy() {
        instance.dispose();
        instance = null;
    }
}

