/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import teamdev.jxcapture.ActiveWindowCapture;
import teamdev.jxcapture.CaptureOperation;
import teamdev.jxcapture.CaptureSettings;
import teamdev.jxcapture.DesktopCapture;
import teamdev.jxcapture.ObjectOnScreenCapture;
import teamdev.jxcapture.RegionCapture;
import teamdev.jxcapture.controllers.ObjectOnScreenController;
import teamdev.jxcapture.controllers.RegionController;
import teamdev.jxcapture.controllers.SelectionController;
import teamdev.jxcapture.events.CaptureAdapter;
import teamdev.jxcapture.painters.ObjectOnScreenPainter;
import teamdev.jxcapture.painters.RegionPainter;
import teamdev.jxcapture.painters.SelectionPainter;
import teamdev.jxcapture.positioners.DiagonalPositioner;
import teamdev.jxcapture.positioners.Positioner;
import teamdev.jxcapture.samples.demo.ApplicationSettings;
import teamdev.jxcapture.samples.demo.HelperComponent;
import teamdev.jxcapture.samples.demo.ImageFileChooser;
import teamdev.jxcapture.samples.demo.ImageViewer;
import teamdev.jxcapture.samples.demo.TimerDialog;
import teamdev.jxcapture.toolkit.DialogComponent;
import teamdev.jxcapture.toolkit.DrawableArea;
import teamdev.jxdesktop.win32.process.Process;
import teamdev.jxdesktop.win32.ui.Wnd;

public class CaptureOperations {
    private static CaptureOperations instance;
    private ApplicationSettings appSettings = ApplicationSettings.getInstance();
    private CaptureSettings captureSettings = CaptureSettings.getInstance();
    private CaptureListener listener = new CaptureListener();
    private List<ImageViewer> imageViewers = new LinkedList<ImageViewer>();
    private List<CaptureOperationsListener> listeners = new LinkedList<CaptureOperationsListener>();
    private boolean busy;

    private CaptureOperations() {
    }

    public static CaptureOperations getInstance() {
        return instance == null ? (instance = new CaptureOperations()) : instance;
    }

    public void activeWindowCapture() {
        this.prepareOperation();
        ActiveWindowCapture activeWindowCapture = new ActiveWindowCapture();
        activeWindowCapture.addCaptureListener((teamdev.jxcapture.events.CaptureListener)this.listener);
        this.waitBeforeCapture((CaptureOperation)activeWindowCapture);
    }

    public void objectCapture() {
        this.prepareOperation();
        ObjectOnScreenPainter objectOnScreenPainter = new ObjectOnScreenPainter();
        ObjectOnScreenController objectOnScreenController = new ObjectOnScreenController((SelectionPainter)objectOnScreenPainter);
        ObjectOnScreenCapture objectOnScreenCapture = new ObjectOnScreenCapture((SelectionController)objectOnScreenController);
        objectOnScreenCapture.addCaptureListener((teamdev.jxcapture.events.CaptureListener)this.listener);
        this.waitBeforeCapture((CaptureOperation)objectOnScreenCapture);
    }

    public void regionCapture() {
        this.prepareOperation();
        RegionPainter regionPainter = new RegionPainter();
        RegionController regionController = new RegionController((SelectionPainter)regionPainter);
        RegionCapture regionCapture = new RegionCapture((SelectionController)regionController);
        DrawableArea drawableArea = regionCapture.getDrawableArea();
        RegionCaptureDialog regionCaptureDialog = new RegionCaptureDialog(drawableArea, regionPainter);
        drawableArea.setDialogComponent((DialogComponent)regionCaptureDialog);
        regionCapture.addCaptureListener((teamdev.jxcapture.events.CaptureListener)this.listener);
        this.waitBeforeCapture((CaptureOperation)regionCapture);
    }

    public void desktopCapture() {
        this.prepareOperation();
        DesktopCapture desktopCapture = new DesktopCapture();
        desktopCapture.addCaptureListener((teamdev.jxcapture.events.CaptureListener)this.listener);
        this.waitBeforeCapture((CaptureOperation)desktopCapture);
    }

    public void addCaptureOperationsListener(CaptureOperationsListener captureOperationsListener) {
        if (!this.listeners.contains(captureOperationsListener)) {
            this.listeners.add(captureOperationsListener);
        }
    }

    public void removeCaptureOperationsListener(CaptureOperationsListener captureOperationsListener) {
        this.listeners.remove(captureOperationsListener);
    }

    public boolean isBusy() {
        return this.busy;
    }

    public List<ImageViewer> getActiveViewers() {
        return this.imageViewers;
    }

    private void fireOperationBegin() {
        this.busy = true;
        for (CaptureOperationsListener captureOperationsListener : this.listeners) {
            captureOperationsListener.operationBegin();
        }
    }

    private void fireOperationComplete(boolean bl) {
        this.busy = false;
        for (CaptureOperationsListener captureOperationsListener : this.listeners) {
            captureOperationsListener.operationComplete(bl);
        }
    }

    private void prepareOperation() {
        this.fireOperationBegin();
        this.updateSettings();
        this.restorePrevWindow();
    }

    private void updateSettings() {
        this.captureSettings.setIncludeCursor(this.appSettings.isIncludeCursor());
        this.captureSettings.setCaptureTransparentWindow(this.appSettings.isCaptureTransparentWindows());
    }

    private void restorePrevWindow() {
        List list = Process.getApplicationWindows();
        if (!list.isEmpty()) {
            Wnd wnd = (Wnd)list.get(1);
            wnd.setForeground();
        }
    }

    private void waitBeforeCapture(final CaptureOperation captureOperation) {
        if (this.appSettings.isDelayBeforeCapture()) {
            int n = this.appSettings.getDelayTime() / 1000;
            TimerDialog timerDialog = new TimerDialog(n);
            timerDialog.show(new TimerDialog.TimerListener(){

                @Override
                public void complete(boolean bl) {
                    if (!bl) {
                        captureOperation.execute();
                    } else {
                        CaptureOperations.this.fireOperationComplete(bl);
                    }
                }
            });
        } else {
            captureOperation.execute();
        }
    }

    private void saveImage(BufferedImage bufferedImage) {
        if (this.appSettings.isCaptureToViewer()) {
            final ImageViewer imageViewer = new ImageViewer();
            imageViewer.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    CaptureOperations.this.imageViewers.remove(imageViewer);
                }
            });
            imageViewer.setImage(bufferedImage);
            imageViewer.setVisible(true);
            imageViewer.toFront();
            this.imageViewers.add(imageViewer);
        } else if (this.appSettings.isCaptureToFile()) {
            File file = this.appSettings.isAutoSave() ? this.getFileBySettings() : this.getFileByChooser();
            try {
                String string;
                int n;
                if (file != null && (n = (string = file.getName()).indexOf(".")) > 0) {
                    String string2 = string.substring(n + 1);
                    ImageIO.write((RenderedImage)bufferedImage, string2, file);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (this.appSettings.isCaptureToClipboard()) {
            this.copyToClipboard(bufferedImage);
        }
    }

    private File getFileByChooser() {
        ImageFileChooser imageFileChooser = new ImageFileChooser();
        return imageFileChooser.saveImageFile();
    }

    private File getFileBySettings() {
        String[] stringArray = this.appSettings.getImageFormats();
        String string = stringArray[this.appSettings.getImageFormatIndex()];
        String string2 = this.appSettings.getOutputFolder();
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdir();
        }
        String string3 = this.appSettings.getTemplateFileName();
        int n = this.appSettings.getTemplateNumber();
        this.appSettings.setTemplateNumber(n + 1);
        String string4 = string3.replaceFirst("#", Integer.toString(n));
        String string5 = string2 + File.separator + string4 + "." + string;
        return new File(string5);
    }

    public void copyToClipboard(BufferedImage bufferedImage) {
        ImageTransferData imageTransferData = new ImageTransferData(bufferedImage);
        DemoClipboardOwner demoClipboardOwner = new DemoClipboardOwner();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(imageTransferData, demoClipboardOwner);
    }

    private class ImageTransferData
    implements Transferable {
        private Image data;

        public ImageTransferData(Image image) {
            this.data = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(DataFlavor.imageFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (DataFlavor.imageFlavor.equals(dataFlavor)) {
                return this.data;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    private class DemoClipboardOwner
    implements ClipboardOwner {
        private DemoClipboardOwner() {
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    private class CaptureListener
    extends CaptureAdapter {
        private CaptureListener() {
        }

        public void cancel() {
            CaptureOperations.this.fireOperationComplete(true);
        }

        public void complete(BufferedImage bufferedImage) {
            CaptureOperations.this.saveImage(bufferedImage);
            CaptureOperations.this.fireOperationComplete(false);
        }
    }

    private class RegionCaptureDialog
    implements DialogComponent {
        private HelperComponent helperDialog;
        private DrawableArea drawableArea;
        private RegionPainter painter;

        public RegionCaptureDialog(DrawableArea drawableArea, RegionPainter regionPainter) {
            this.drawableArea = drawableArea;
            this.painter = regionPainter;
        }

        public JComponent createComponent() {
            this.helperDialog = new HelperComponent(this.drawableArea.getBackgroundImage());
            Component component = this.drawableArea.getComponent();
            component.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    this.updateDialogData(mouseEvent.getPoint());
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    this.updateDialogData(mouseEvent.getPoint());
                }

                public void updateDialogData(Point point) {
                    Rectangle rectangle = RegionCaptureDialog.this.painter.getCurrentSelectedRegion();
                    RegionCaptureDialog.this.helperDialog.updateComponent(point, rectangle);
                }
            });
            return this.helperDialog;
        }

        public int getInvisibleBorder() {
            return 10;
        }

        public int getLocation() {
            return 0;
        }

        public Positioner getPositioner() {
            return new DiagonalPositioner();
        }
    }

    public static interface CaptureOperationsListener {
        public void operationBegin();

        public void operationComplete(boolean var1);
    }
}

