/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.plaf.BorderUIResource;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import teamdev.jxcapture.samples.demo.EscapeDialog;

public class AboutDialog
extends EscapeDialog {
    private static AboutDialog instance;
    private HTMLLabel companyLink;
    private ResourceMap resourceMap;

    private AboutDialog() {
        ApplicationContext applicationContext = Application.getInstance().getContext();
        this.resourceMap = applicationContext.getResourceMap(AboutDialog.class);
        this.setName("dialog");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.createContentPane(), "Center");
        jPanel.add(this.createActionPane(), "South");
        this.setContentPane(jPanel);
        this.setSize(424, 360);
        this.setPreferredSize(new Dimension(this.getSize()));
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setModal(true);
        this.resourceMap.injectComponents((Component)this);
    }

    public static AboutDialog getInstance() {
        return instance == null ? (instance = new AboutDialog()) : instance;
    }

    private Component createActionPane() {
        ApplicationContext applicationContext = Application.getInstance().getContext();
        ApplicationActionMap applicationActionMap = applicationContext.getActionMap(AboutDialog.class, (Object)this);
        JButton jButton = new JButton(applicationActionMap.get((Object)"close"));
        jButton.setPreferredSize(new Dimension(75, 23));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JSeparator(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(8, 8, 8, 8), 0, 0));
        return jPanel;
    }

    private Component createContentPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.createLogoPane(), "West");
        jPanel.add(this.createInfoPane(), "Center");
        return jPanel;
    }

    private Component createLogoPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(new BorderUIResource.EmptyBorderUIResource(4, 4, 4, 4));
        JLabel jLabel = new JLabel();
        jLabel.setName("about");
        jPanel.add((Component)jLabel, "Center");
        return jPanel;
    }

    private Component createInfoPane() {
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        jLabel.setName("company");
        jLabel2.setName("product");
        this.companyLink = new HTMLLabel(this.resourceMap.getString("CompanyLink.text", new Object[0]), this.resourceMap.getString("CompanyLink.url", new Object[0]));
        this.companyLink.setToolTipText(this.resourceMap.getString("CompanyLink.url", new Object[0]));
        HTMLLabel hTMLLabel = new HTMLLabel(this.resourceMap.getString("SwingApplicationFramework.text", new Object[0]), this.resourceMap.getString("SwingApplicationFramework.url", new Object[0]));
        hTMLLabel.setToolTipText(this.resourceMap.getString("SwingApplicationFramework.url", new Object[0]));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new BorderUIResource.EmptyBorderUIResource(4, 4, 4, 4));
        jPanel.setBackground(Color.WHITE);
        jPanel.add(this.createProductNamePane(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 16, 15, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 16, 15, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.companyLink, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 16, 2, new Insets(0, 4, 4, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 16, 2, new Insets(4, 4, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 16, 2, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(this.resourceMap.getString("note.text1", new Object[0])), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 16, 2, new Insets(10, 4, 0, 0), 0, 0));
        jPanel.add((Component)hTMLLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 16, 2, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(this.resourceMap.getString("note.text2", new Object[0])), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 16, 2, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(this.resourceMap.getString("note.text3", new Object[0])), new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 16, 2, new Insets(0, 4, 10, 0), 0, 0));
        return jPanel;
    }

    private Component createProductNamePane() {
        JLabel jLabel = new JLabel();
        jLabel.setName("logotype");
        JLabel jLabel2 = new JLabel();
        jLabel2.setName("version");
        jLabel2.setForeground(Color.GRAY);
        jLabel2.setBorder(new BorderUIResource.EmptyBorderUIResource(0, 112, 0, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(new BorderUIResource.EmptyBorderUIResource(15, 0, 0, 0));
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jLabel2, "South");
        return jPanel;
    }

    @Action
    public void close() {
        this.companyLink.dispose();
        this.setVisible(false);
        this.dispose();
    }

    public class HTMLLabel
    extends JLabel {
        private String url;
        private Color mouseEnteredColor;
        private Color mouseExitedColor;
        private boolean mouseEntered;
        private HTMLLabelMouseListener mouseListener = new HTMLLabelMouseListener();

        public HTMLLabel(String string, String string2) {
            this(string, string2, Color.BLUE, Color.BLUE);
        }

        public HTMLLabel(String string, String string2, Color color, Color color2) {
            this.url = string2;
            this.mouseEnteredColor = color;
            this.mouseExitedColor = color2;
            this.setText(string);
            this.setCursor(new Cursor(12));
            this.setForeground(color2);
            this.addMouseListener(this.mouseListener);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.isEnabled() && this.mouseEntered) {
                graphics.drawLine(0, this.getHeight() - 1, (int)this.getPreferredSize().getWidth(), this.getHeight() - 1);
            }
        }

        public void dispose() {
            this.removeMouseListener(this.mouseListener);
        }

        private class HTMLLabelMouseListener
        extends MouseAdapter {
            private HTMLLabelMouseListener() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    Runtime.getRuntime().exec("cmd /c start " + HTMLLabel.this.url);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                HTMLLabel.this.setForeground(HTMLLabel.this.mouseEnteredColor);
                HTMLLabel.this.mouseEntered = true;
                HTMLLabel.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                HTMLLabel.this.setForeground(HTMLLabel.this.mouseExitedColor);
                HTMLLabel.this.mouseEntered = false;
                HTMLLabel.this.repaint();
            }
        }
    }
}

