/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskService;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskMonitor
extends AbstractBean {
    private final PropertyChangeListener applicationPCL = new ApplicationPCL();
    private final PropertyChangeListener taskServicePCL = new TaskServicePCL();
    private final PropertyChangeListener taskPCL = new TaskPCL();
    private final LinkedList<Task> taskQueue = new LinkedList();
    private boolean autoUpdateForegroundTask = true;
    private Task foregroundTask = null;

    public TaskMonitor(ApplicationContext context) {
        context.addPropertyChangeListener(this.applicationPCL);
        for (TaskService taskService : context.getTaskServices()) {
            taskService.addPropertyChangeListener(this.taskServicePCL);
        }
    }

    public void setForegroundTask(Task foregroundTask) {
        Task newTask;
        Task oldTask = this.foregroundTask;
        if (oldTask != null) {
            oldTask.removePropertyChangeListener(this.taskPCL);
        }
        if ((newTask = (this.foregroundTask = foregroundTask)) != null) {
            newTask.addPropertyChangeListener(this.taskPCL);
        }
        this.firePropertyChange("foregroundTask", (Object)oldTask, (Object)newTask);
    }

    public Task getForegroundTask() {
        return this.foregroundTask;
    }

    public boolean getAutoUpdateForegroundTask() {
        return this.autoUpdateForegroundTask;
    }

    public void setAutoUpdateForegroundTask(boolean autoUpdateForegroundTask) {
        boolean oldValue = this.autoUpdateForegroundTask;
        this.autoUpdateForegroundTask = autoUpdateForegroundTask;
        this.firePropertyChange("autoUpdateForegroundTask", oldValue, this.autoUpdateForegroundTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Task> copyTaskQueue() {
        LinkedList<Task> linkedList = this.taskQueue;
        synchronized (linkedList) {
            if (this.taskQueue.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<Task>(this.taskQueue);
        }
    }

    public List<Task> getTasks() {
        return this.copyTaskQueue();
    }

    private void updateTasks(List<Task> oldTasks, List<Task> newTasks) {
        boolean tasksChanged = false;
        List<Task> oldTaskQueue = this.copyTaskQueue();
        for (Task oldTask : oldTasks) {
            if (newTasks.contains((Object)oldTask) || !this.taskQueue.remove((Object)oldTask)) continue;
            tasksChanged = true;
        }
        for (Task newTask : newTasks) {
            if (this.taskQueue.contains((Object)newTask)) continue;
            this.taskQueue.addLast(newTask);
            tasksChanged = true;
        }
        Iterator tasks = this.taskQueue.iterator();
        while (tasks.hasNext()) {
            Task task = (Task)((Object)tasks.next());
            if (!task.isDone()) continue;
            tasks.remove();
            tasksChanged = true;
        }
        if (tasksChanged) {
            List<Task> newTaskQueue = this.copyTaskQueue();
            this.firePropertyChange("tasks", oldTaskQueue, newTaskQueue);
        }
        if (this.autoUpdateForegroundTask && this.getForegroundTask() == null) {
            this.setForegroundTask(this.taskQueue.isEmpty() ? null : this.taskQueue.getLast());
        }
    }

    private class TaskPCL
    implements PropertyChangeListener {
        private TaskPCL() {
        }

        private void fireStateChange(Task task, String propertyName) {
            TaskMonitor.this.firePropertyChange(new PropertyChangeEvent((Object)task, propertyName, false, true));
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            Task task = (Task)((Object)e.getSource());
            Object newValue = e.getNewValue();
            if (task != null && task == TaskMonitor.this.getForegroundTask()) {
                TaskMonitor.this.firePropertyChange(e);
                if ("state".equals(propertyName)) {
                    SwingWorker.StateValue newState = (SwingWorker.StateValue)e.getNewValue();
                    switch (newState) {
                        case PENDING: {
                            this.fireStateChange(task, "pending");
                            break;
                        }
                        case STARTED: {
                            this.fireStateChange(task, "started");
                            break;
                        }
                        case DONE: {
                            this.fireStateChange(task, "done");
                            TaskMonitor.this.setForegroundTask(null);
                        }
                    }
                }
            }
        }
    }

    private class TaskServicePCL
    implements PropertyChangeListener {
        private TaskServicePCL() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("tasks".equals(propertyName)) {
                List oldList = (List)e.getOldValue();
                List newList = (List)e.getNewValue();
                TaskMonitor.this.updateTasks(oldList, newList);
            }
        }
    }

    private class ApplicationPCL
    implements PropertyChangeListener {
        private ApplicationPCL() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("taskServices".equals(propertyName)) {
                List oldList = (List)e.getOldValue();
                List newList = (List)e.getNewValue();
                for (TaskService oldTaskService : oldList) {
                    oldTaskService.removePropertyChangeListener(TaskMonitor.this.taskServicePCL);
                }
                for (TaskService newTaskService : newList) {
                    newTaskService.addPropertyChangeListener(TaskMonitor.this.taskServicePCL);
                }
            }
        }
    }
}

