/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32.process;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.IntBool;
import com.jniwrapper.NativeResource;
import com.jniwrapper.NativeResourceCollector;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.Enums;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.util.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import teamdev.jxdesktop.win32.FunctionName;
import teamdev.jxdesktop.win32.Handle;
import teamdev.jxdesktop.win32.LastErrorException;
import teamdev.jxdesktop.win32.io.FileTime;
import teamdev.jxdesktop.win32.process.IOCounters;
import teamdev.jxdesktop.win32.process.ProcessInformation;
import teamdev.jxdesktop.win32.process.ProcessMemoryCounters;
import teamdev.jxdesktop.win32.process.ProcessOptions;
import teamdev.jxdesktop.win32.process.ProcessSecurityOptions;
import teamdev.jxdesktop.win32.process.ProcessVariables;
import teamdev.jxdesktop.win32.process.Psapi;
import teamdev.jxdesktop.win32.process.StartupInfo;
import teamdev.jxdesktop.win32.system.AdvApi32;
import teamdev.jxdesktop.win32.system.Kernel32;
import teamdev.jxdesktop.win32.system.SecurityAttributes;
import teamdev.jxdesktop.win32.ui.User32;
import teamdev.jxdesktop.win32.ui.Wnd;

public class Process
extends Handle {
    private static final Logger f = Logger.getInstance((Class)(i == null ? (i = Process.a("teamdev.jxdesktop.win32.process.Process")) : i));
    private static final FunctionName c = new FunctionName("CreateProcess");
    private static final FunctionName d = new FunctionName("GetProcessImageFileName");
    private static final FunctionName e = new FunctionName("GetModuleFileNameEx");
    private Handle a = new Handle();
    private long j;
    private long h;
    static Class i;
    static Class g;
    static Class k;
    static Class b;

    Process(long l2) {
        super(l2);
    }

    Process() {
    }

    public Process(String string) {
        this(null, string, new ProcessOptions(true), null, new StartupInfo());
    }

    public Process(String string, String string2, ProcessOptions processOptions, String string3, StartupInfo startupInfo) {
        this(string, string2, null, null, false, processOptions, null, string3, startupInfo);
    }

    public Process(String string, String string2, SecurityAttributes securityAttributes, SecurityAttributes securityAttributes2, boolean bl, ProcessOptions processOptions, ProcessVariables processVariables, String string3, StartupInfo startupInfo) {
        ProcessInformation processInformation = new ProcessInformation();
        Bool bool = new Bool();
        Function function = Kernel32.getInstance().getFunction(c.toString());
        long l2 = function.invoke((Parameter)bool, new Parameter[]{string == null ? new Handle() : new Str(string), string2 == null ? new Handle() : new Str(string2), new Pointer((Parameter)securityAttributes, securityAttributes == null), new Pointer((Parameter)securityAttributes2, securityAttributes2 == null), new Bool(bl), new UInt32(processOptions.getFlags()), processVariables == null ? new Handle() : processVariables, string3 == null ? new Handle() : new Str(string3), new Pointer((Parameter)startupInfo), new Pointer.OutOnly((Parameter)processInformation)});
        if (!bool.getValue()) {
            throw new LastErrorException(l2);
        }
        this.setValue(processInformation.getProcess().getValue());
        this.j = processInformation.getProcessID();
        this.h = processInformation.getThreadID();
        this.registerResource();
    }

    public Process(String string, String string2, String string3, boolean bl, String string4, String string5, ProcessOptions processOptions, ProcessVariables processVariables, String string6, StartupInfo startupInfo) {
        ProcessInformation processInformation = new ProcessInformation();
        Bool bool = new Bool();
        Function function = AdvApi32.getInstance().getFunction("CreateProcessWithLogonW");
        long l2 = function.invoke((Parameter)bool, new Parameter[]{new Str(string), string2 == null ? new Handle() : new Str(string2), new Str(string3), new UInt32(bl ? 1L : 2L), string4 == null ? new Handle() : new Str(string4), string5 == null ? new Handle() : new Str(string5), new UInt32(processOptions.getFlags()), processVariables == null ? new Handle() : processVariables, string6 == null ? new Handle() : new Str(string6), new Pointer((Parameter)startupInfo), new Pointer.OutOnly((Parameter)processInformation)});
        if (!bool.getValue()) {
            throw new LastErrorException(l2);
        }
        this.setValue(processInformation.getProcess().getValue());
        this.j = processInformation.getProcessID();
        this.h = processInformation.getThreadID();
        this.registerResource();
    }

    public static Process openProcess(ProcessSecurityOptions processSecurityOptions, boolean bl, long l2) {
        Process process = new Process();
        Function function = Kernel32.getInstance().getFunction("OpenProcess");
        function.invoke((Parameter)process, (Parameter)new UInt32(processSecurityOptions.getFlags()), (Parameter)new Bool(bl), (Parameter)new UInt32(l2));
        process.j = l2;
        process.h = 0L;
        process.registerResource();
        return process;
    }

    protected void registerResource() {
        NativeResourceCollector.getInstance().addNativeResource((Object)this, (NativeResource)new ProcessResource(this.getValue()));
    }

    public static long getProcessID(Process process) {
        UInt32 uInt32 = new UInt32();
        Function function = Kernel32.getInstance().getFunction("GetProcessId");
        function.invoke((Parameter)uInt32, (Parameter)process);
        return uInt32.getValue();
    }

    public long getExitCode() {
        UInt32 uInt32 = new UInt32();
        Function function = Kernel32.getInstance().getFunction("GetExitCodeProcess");
        function.invoke(null, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)uInt32));
        return uInt32.getValue();
    }

    public PriorityClass getPriorityClass() {
        UInt32 uInt32 = new UInt32();
        Function function = Kernel32.getInstance().getFunction("GetPriorityClass");
        function.invoke((Parameter)uInt32, (Parameter)this);
        return (PriorityClass)Enums.getItem((Class)(g == null ? (g = Process.a("teamdev.jxdesktop.win32.process.Process$PriorityClass")) : g), (int)((int)uInt32.getValue()));
    }

    public void setPriorityClass(PriorityClass priorityClass) {
        Function function = Kernel32.getInstance().getFunction("SetPriorityClass");
        Bool bool = new Bool();
        long l2 = function.invoke((Parameter)bool, (Parameter)this, (Parameter)new UInt32((long)priorityClass.getValue()));
        if (!bool.getValue()) {
            throw new LastErrorException(l2);
        }
    }

    private long a(long l2) {
        UInt32 uInt32 = new UInt32();
        Function function = User32.getInstance().getFunction("GetGuiResources");
        function.invoke((Parameter)uInt32, (Parameter)this, (Parameter)new UInt32(l2));
        return uInt32.getValue();
    }

    public long getGdiObjectsCount() {
        return this.a(0L);
    }

    public long getUSERObjectsCount() {
        return this.a(1L);
    }

    public long getHandleCount() {
        UInt32 uInt32 = new UInt32();
        Function function = Kernel32.getInstance().getFunction("GetProcessHandleCount");
        Bool bool = new Bool();
        long l2 = function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Pointer((Parameter)uInt32));
        if (!bool.getValue()) {
            throw new LastErrorException(l2);
        }
        return uInt32.getValue();
    }

    public IOCounters getIOCounters() {
        IOCounters iOCounters = new IOCounters();
        Function function = Kernel32.getInstance().getFunction("GetProcessIoCounters");
        Bool bool = new Bool();
        long l2 = function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)iOCounters));
        if (!bool.getValue()) {
            throw new LastErrorException(l2);
        }
        return iOCounters;
    }

    public void getProcessTimes(FileTime fileTime, FileTime fileTime2, FileTime fileTime3, FileTime fileTime4) {
        Function function = Kernel32.getInstance().getFunction("GetProcessTimes");
        Bool bool = new Bool();
        long l2 = function.invoke((Parameter)bool, new Parameter[]{this, new Pointer.OutOnly((Parameter)fileTime), new Pointer.OutOnly((Parameter)fileTime2), new Pointer.OutOnly((Parameter)fileTime3), new Pointer.OutOnly((Parameter)fileTime4)});
        if (!bool.getValue()) {
            throw new LastErrorException(l2);
        }
    }

    public void setPriorityBoost(boolean bl) {
        Function function = Kernel32.getInstance().getFunction("SetProcessPriorityBoost");
        Bool bool = new Bool();
        long l2 = function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Bool(!bl));
        if (!bool.getValue()) {
            throw new LastErrorException(l2);
        }
    }

    public boolean getPriorityBoost() {
        Function function = Kernel32.getInstance().getFunction("GetProcessPriorityBoost");
        Bool bool = new Bool();
        Bool bool2 = new Bool();
        long l2 = function.invoke((Parameter)bool2, (Parameter)this, (Parameter)new Pointer((Parameter)bool));
        if (!bool2.getValue()) {
            throw new LastErrorException(l2);
        }
        return !bool.getValue();
    }

    public void terminate(long l2) {
        Function function = Kernel32.getInstance().getFunction("TerminateProcess");
        Bool bool = new Bool();
        long l3 = function.invoke((Parameter)bool, (Parameter)this, (Parameter)new UInt(l2));
        if (!bool.getValue()) {
            throw new LastErrorException(l3);
        }
    }

    public long getVersion() {
        return Process.getVersion(this.getProcessID());
    }

    public static long getVersion(long l2) {
        Function function = Kernel32.getInstance().getFunction("GetProcessVersion");
        UInt32 uInt32 = new UInt32();
        function.invoke((Parameter)uInt32, (Parameter)new UInt32(l2));
        return uInt32.getValue();
    }

    public void getWorkingSetSize(UInt32 uInt32, UInt32 uInt322) {
        Function function = Kernel32.getInstance().getFunction("GetProcessWorkingSetSize");
        Bool bool = new Bool();
        long l2 = function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Pointer((Parameter)uInt32), (Parameter)new Pointer((Parameter)uInt322));
        if (!bool.getValue()) {
            throw new LastErrorException(l2);
        }
    }

    public void setWorkingSetSize(long l2, long l3) {
        Function function = Kernel32.getInstance().getFunction("SetProcessWorkingSetSize");
        Bool bool = new Bool();
        long l4 = function.invoke((Parameter)bool, (Parameter)this, (Parameter)new UInt32(l2), (Parameter)new UInt32(l3));
        if (!bool.getValue()) {
            throw new LastErrorException(l4);
        }
    }

    private void a(UInt32 uInt32, UInt32 uInt322) {
        Function function = Kernel32.getInstance().getFunction("GetProcessAffinityMask");
        Bool bool = new Bool();
        long l2 = function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Pointer((Parameter)uInt32), (Parameter)new Pointer((Parameter)uInt322));
        if (!bool.getValue()) {
            throw new LastErrorException(l2);
        }
    }

    public long getAffinityMask() {
        UInt32 uInt32 = new UInt32();
        UInt32 uInt322 = new UInt32();
        this.a(uInt32, uInt322);
        return uInt32.getValue();
    }

    public long getSystemAffinityMask() {
        UInt32 uInt32 = new UInt32();
        UInt32 uInt322 = new UInt32();
        this.a(uInt32, uInt322);
        return uInt322.getValue();
    }

    public void setAffinityMask(long l2) {
        Function function = Kernel32.getInstance().getFunction("SetProcessAffinityMask");
        Bool bool = new Bool();
        long l3 = function.invoke((Parameter)bool, (Parameter)this, (Parameter)new UInt32(l2));
        if (!bool.getValue()) {
            throw new LastErrorException(l3);
        }
    }

    public static long getThreadProcessID(Handle handle) {
        Function function = Kernel32.getInstance().getFunction("GetProcessIdOfThread");
        UInt32 uInt32 = new UInt32();
        function.invoke((Parameter)uInt32, (Parameter)handle);
        return uInt32.getValue();
    }

    public static long getThreadID(Handle handle) {
        Function function = Kernel32.getInstance().getFunction("GetThreadId");
        UInt32 uInt32 = new UInt32();
        function.invoke((Parameter)uInt32, (Parameter)handle);
        return uInt32.getValue();
    }

    public long waitFor(long l2) {
        long l3 = Handle.waitFor(this, l2);
        switch ((int)l3) {
            case 128: {
                throw new RuntimeException("Abandoned.");
            }
            case 258: {
                throw new RuntimeException("Timeout elapsed.");
            }
        }
        return l3;
    }

    public long waitFor() {
        long l2 = Handle.waitFor(this);
        switch ((int)l2) {
            case 128: {
                throw new RuntimeException("Abandoned.");
            }
            case 258: {
                throw new RuntimeException("Timeout elapsed.");
            }
        }
        return l2;
    }

    public long getThreadID() {
        return this.h;
    }

    public long getProcessID() {
        return this.j;
    }

    public Handle getThread() {
        return this.a;
    }

    public void close() {
        try {
            Process.a(this);
        }
        catch (Throwable throwable) {
            f.error((Object)"", throwable);
        }
    }

    public ProcessMemoryCounters getProcessMemoryCounters() {
        ProcessMemoryCounters processMemoryCounters = new ProcessMemoryCounters();
        Function function = Psapi.getInstance().getFunction("GetProcessMemoryInfo");
        IntBool intBool = new IntBool();
        long l2 = function.invoke((Parameter)intBool, (Parameter)this, (Parameter)new Pointer((Parameter)processMemoryCounters), (Parameter)new UInt32((long)processMemoryCounters.getLength()));
        if (intBool.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
        return processMemoryCounters;
    }

    public String getProcessImageFileName() {
        Function function = Psapi.getInstance().getFunction(d.toString());
        UInt32 uInt32 = new UInt32();
        int n2 = 1000;
        Str str = new Str(n2);
        long l2 = function.invoke((Parameter)uInt32, (Parameter)this, (Parameter)new Pointer((Parameter)str), (Parameter)new UInt32((long)n2));
        if (uInt32.getValue() == 0L) {
            return null;
        }
        return str.getValue();
    }

    public String getProcessFileName() {
        try {
            List list = this.getModules();
            return this.getModuleFileName((Handle)((Object)list.get(0)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void a(Process process) {
        if (!process.isNull()) {
            Handle handle = process.getThread();
            if (!handle.isNull()) {
                Handle.closeHandle(handle);
            }
            Handle.closeHandle(process);
        }
    }

    public static List getProcesses() {
        ProcessSecurityOptions processSecurityOptions = new ProcessSecurityOptions();
        processSecurityOptions.setQueryInformation(true);
        processSecurityOptions.setVMRead(true);
        return Process.getProcesses(processSecurityOptions);
    }

    public static List getProcesses(ProcessSecurityOptions processSecurityOptions) {
        Function function = Psapi.getInstance().getFunction("EnumProcesses");
        Bool bool = new Bool();
        PrimitiveArray primitiveArray = new PrimitiveArray(k == null ? (k = Process.a("com.jniwrapper.UInt32")) : k, 1024);
        UInt32 uInt32 = new UInt32();
        uInt32.setValue((long)primitiveArray.getLength());
        UInt32 uInt322 = new UInt32();
        while (true) {
            function.invoke((Parameter)bool, (Parameter)new Pointer((Parameter)primitiveArray), (Parameter)uInt32, (Parameter)new Pointer((Parameter)uInt322));
            if (!bool.getValue()) {
                return null;
            }
            if (uInt322.getValue() != uInt32.getValue()) break;
            primitiveArray.setElementCount(primitiveArray.getElementCount() * 10);
            uInt32.setValue((long)primitiveArray.getLength());
        }
        int n2 = (int)uInt322.getValue() / uInt322.getLength();
        ArrayList<Process> arrayList = new ArrayList<Process>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = (int)((UInt32)primitiveArray.getElement(i2)).getValue();
            arrayList.add(Process.openProcess(processSecurityOptions, false, n3));
        }
        return arrayList;
    }

    public List getModules() {
        long l2;
        Function function = Psapi.getInstance().getFunction("EnumProcessModules");
        IntBool intBool = new IntBool();
        UInt32 uInt32 = new UInt32();
        PrimitiveArray primitiveArray = new PrimitiveArray(b == null ? (b = Process.a("teamdev.jxdesktop.win32.Handle")) : b, 1024);
        while (true) {
            intBool.setValue(0L);
            l2 = function.invoke((Parameter)intBool, (Parameter)this, (Parameter)new Pointer((Parameter)primitiveArray), (Parameter)new UInt32((long)primitiveArray.getLength()), (Parameter)new Pointer((Parameter)uInt32));
            if (uInt32.getValue() <= (long)primitiveArray.getLength()) break;
            primitiveArray.setElementCount(primitiveArray.getElementCount() * 10);
        }
        if (intBool.getValue() == 0L) {
            throw new LastErrorException(l2, "Unable to get list of modules of the process.");
        }
        int n2 = (int)(uInt32.getValue() / (long)new Handle().getLength());
        ArrayList<Handle> arrayList = new ArrayList<Handle>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add((Handle)primitiveArray.getElement(i2));
        }
        return arrayList;
    }

    public String getModuleFileName(Handle handle) {
        Function function = Psapi.getInstance().getFunction(e.toString());
        UInt32 uInt32 = new UInt32();
        Str str = new Str(1024);
        function.invoke((Parameter)uInt32, (Parameter)this, (Parameter)handle, (Parameter)new Pointer((Parameter)str), (Parameter)new UInt32((long)str.getLength()));
        if (uInt32.getValue() > (long)str.getMaxLength()) {
            str = new Str((int)uInt32.getValue());
            function.invoke((Parameter)uInt32, (Parameter)this, (Parameter)handle, (Parameter)new Pointer((Parameter)str), (Parameter)new UInt32((long)str.getLength()));
        }
        return str.getValue();
    }

    public static List getApplicationWindows() {
        List list = Wnd.getAllWindows();
        LinkedList<Wnd> linkedList = new LinkedList<Wnd>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Wnd wnd = (Wnd)((Object)list.get(i2));
            FlagSet flagSet = new FlagSet(wnd.getWindowStyle());
            if (!wnd.getParent().isNull() || !wnd.isVisible() || !flagSet.contains(0xCF0000L)) continue;
            linkedList.add(wnd);
        }
        return linkedList;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static void b(Process process) {
        Process.a(process);
    }

    protected static class ProcessResource
    implements NativeResource {
        private long a;

        public ProcessResource(long l2) {
            this.a = l2;
        }

        public void release() throws Throwable {
            Process.b(new Process(this.a));
        }
    }

    public static class PriorityClass
    extends EnumItem {
        public static final PriorityClass NORMAL_PRIORITY_CLASS = new PriorityClass(32);
        public static final PriorityClass IDLE_PRIORITY_CLASS = new PriorityClass(64);
        public static final PriorityClass HIGH_PRIORITY_CLASS = new PriorityClass(128);
        public static final PriorityClass REALTIME_PRIORITY_CLASS = new PriorityClass(256);

        PriorityClass(int n2) {
            super(n2);
        }
    }
}

