/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32.gdi.bitmap;

import com.jniwrapper.ArrayParameter;
import com.jniwrapper.Int8;
import com.jniwrapper.Parameter;
import com.jniwrapper.PrimitiveArray;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import teamdev.jxdesktop.win32.gdi.BitmapInfo;
import teamdev.jxdesktop.win32.gdi.BitmapInfoHeader;

public abstract class BitmapBuilder {
    private int a;
    private BufferedImage d;
    private int c;
    private PrimitiveArray b;

    protected BitmapBuilder(int n2, BufferedImage bufferedImage) {
        this.a = n2;
        this.d = bufferedImage;
        this.c = this.c();
        this.b = new PrimitiveArray(this.a(this.getScansizeBytes() * this.getHeight()));
    }

    public final BitmapInfo getBitmapInfo() {
        BitmapInfo bitmapInfo = this.getColorTableSize() > 0 ? new BitmapInfo(this.getColorTableSize()) : new BitmapInfo();
        this.buildColorTable((ArrayParameter)bitmapInfo.getColors());
        BitmapInfoHeader bitmapInfoHeader = bitmapInfo.getBitmapInfoHeader();
        bitmapInfoHeader.setWidth(this.getWidth());
        bitmapInfoHeader.setHeight(this.getHeight());
        bitmapInfoHeader.setPlanes(1L);
        bitmapInfoHeader.setBitCount(this.getBitCount());
        bitmapInfoHeader.setClrUsed(this.getColorTableSize());
        return bitmapInfo;
    }

    public abstract void setBitmapColors();

    protected int getBitCount() {
        return this.a;
    }

    protected final int getScansizeBytes() {
        return this.c;
    }

    private int c() {
        int n2 = this.getWidth() * this.getBitCount();
        return (n2 + 32 - 1) / 32 * 4;
    }

    protected void setBitmapByte(int n2, byte by) {
        this.b.setElement(n2, (Parameter)new Int8(by));
    }

    public int getWidth() {
        return this.d.getWidth();
    }

    public int getHeight() {
        return this.d.getHeight();
    }

    private byte[] a(int n2) {
        return new byte[n2];
    }

    protected abstract int getColorTableSize();

    protected abstract void buildColorTable(ArrayParameter var1);

    protected int getImageOffset(int n2, int n3) {
        return n2 + n3 * this.getWidth();
    }

    protected int getOffsetInBitmapBytes(int n2, int n3) {
        return this.getBitCount() * n2 / 8 + (this.getHeight() - n3 - 1) * this.getScansizeBytes();
    }

    public abstract Image getTransparentMask();

    protected BufferedImage getBufferedImage() {
        return this.d;
    }

    protected ColorModel getColorModel() {
        return this.d.getColorModel();
    }

    public PrimitiveArray getBitmapData() {
        return this.b;
    }
}

