/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import teamdev.jxdesktop.win32.LastErrorException;
import teamdev.jxdesktop.win32.Point;
import teamdev.jxdesktop.win32.Rect;
import teamdev.jxdesktop.win32.gdi.Gdi32;
import teamdev.jxdesktop.win32.gdi.GdiObject;
import teamdev.jxdesktop.win32.gdi.PolyFillMode;

public class Region
extends GdiObject {
    public static final int RGN_ERROR = 0;
    public static final int NULLREGION = 1;
    public static final int SIMPLEREGION = 2;
    public static final int COMPLEXREGION = 3;
    static Class b;
    static Class c;

    public Region() {
    }

    public Region(long l2) {
        super(l2);
    }

    public static Region createElliptic(int n2, int n3, int n4, int n5) {
        Function function = Gdi32.getInstance().getFunction("CreateEllipticRgn");
        Region region = new Region();
        function.invoke((Parameter)region, (Parameter)new Int((long)n2), (Parameter)new Int((long)n3), (Parameter)new Int((long)n4), (Parameter)new Int((long)n5));
        return region;
    }

    public static Region createElliptic(Rect rect) {
        Region region = new Region();
        Function function = Gdi32.getInstance().getFunction("CreateEllipticRgnIndirect");
        function.invoke((Parameter)region, (Parameter)new Pointer((Parameter)rect));
        return null;
    }

    public static Region createRoundRectRegion(int n2, int n3, int n4, int n5, int n6, int n7) {
        Region region = new Region();
        Function function = Gdi32.getInstance().getFunction("CreateRoundRectRgn");
        function.invoke((Parameter)region, new Parameter[]{new Int((long)n2), new Int((long)n3), new Int((long)n4), new Int((long)n5), new Int((long)n6), new Int((long)n7)});
        return region;
    }

    public static Region combineRgn(Region region, Region region2, CombineMode combineMode) {
        Region region3 = Region.createRectRegion(0, 0, 0, 0);
        Int intVal = new Int();
        Function function = Gdi32.getInstance().getFunction("CombineRgn");
        long l2 = function.invoke((Parameter)intVal, (Parameter)region3, (Parameter)region, (Parameter)region2, (Parameter)new Int((long)combineMode.getValue()));
        long l3 = intVal.getValue();
        if (0L == l3) {
            throw new LastErrorException(l2, "Failed to combine regions.");
        }
        return region3;
    }

    public static Region createPolygonRgn(Point[] pointArray, int n2, PolyFillMode polyFillMode) {
        PrimitiveArray primitiveArray = new PrimitiveArray(b == null ? (b = Region.a("teamdev.jxdesktop.win32.Point")) : b, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            primitiveArray.setElement(i2, (Parameter)pointArray[i2]);
        }
        Region region = new Region();
        Function function = Gdi32.getInstance().getFunction("CreatePolygonRgn");
        function.invoke((Parameter)region, (Parameter)new Pointer((Parameter)primitiveArray), (Parameter)new Int((long)n2), (Parameter)new Int((long)polyFillMode.getValue()));
        return region;
    }

    public static Region createPolyPolygonRgn(Point[] pointArray, int[] nArray, int n2, PolyFillMode polyFillMode) {
        Region region = new Region();
        int n3 = pointArray.length;
        PrimitiveArray primitiveArray = new PrimitiveArray(b == null ? (b = Region.a("teamdev.jxdesktop.win32.Point")) : b, n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            primitiveArray.setElement(i2, (Parameter)pointArray[i2]);
        }
        PrimitiveArray primitiveArray2 = new PrimitiveArray(c == null ? (c = Region.a("com.jniwrapper.Int")) : c, n2);
        for (int i3 = 0; i3 < n3; ++i3) {
            primitiveArray2.setElement(i3, (Parameter)new Int((long)nArray[i3]));
        }
        Function function = Gdi32.getInstance().getFunction("CreatePolyPolygonRgn");
        function.invoke((Parameter)region, (Parameter)new Pointer((Parameter)primitiveArray), (Parameter)new Pointer((Parameter)primitiveArray2), (Parameter)new Int((long)n2), (Parameter)new Int((long)polyFillMode.getValue()));
        return region;
    }

    public static Region createRectRegion(int n2, int n3, int n4, int n5) {
        Region region = new Region();
        Function function = Gdi32.getInstance().getFunction("CreateRectRgn");
        function.invoke((Parameter)region, new Parameter[]{new Int((long)n2), new Int((long)n3), new Int((long)n4), new Int((long)n5)});
        return region;
    }

    public static Region createRectRegion(Rect rect) {
        Region region = new Region();
        Function function = Gdi32.getInstance().getFunction("CreateRectRgnIndirect");
        function.invoke((Parameter)region, (Parameter)new Pointer((Parameter)rect));
        return region;
    }

    public boolean equalRegion(Region region) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction("CreateRectRgn");
        function.invoke((Parameter)bool, (Parameter)this, (Parameter)region);
        return bool.getValue();
    }

    public int getRagionData(PrimitiveArray primitiveArray, int n2) {
        Function function = Gdi32.getInstance().getFunction("GetRegionData");
        UInt32 uInt32 = new UInt32();
        function.invoke((Parameter)uInt32, (Parameter)this, (Parameter)new UInt32((long)n2), (Parameter)new Pointer((Parameter)primitiveArray));
        return (int)uInt32.getValue();
    }

    public Rect getRegionBox() {
        Rect rect = new Rect();
        Function function = Gdi32.getInstance().getFunction("GetRgnBox");
        Int intVal = new Int();
        function.invoke((Parameter)intVal, (Parameter)this, (Parameter)new Pointer((Parameter)rect));
        return rect;
    }

    public void offsetRegion(int n2, int n3) {
        Function function = Gdi32.getInstance().getFunction("OffsetRgn");
        function.invoke(null, (Parameter)this, (Parameter)new Int((long)n2), (Parameter)new Int((long)n3));
    }

    public boolean isPointInRegion(int n2, int n3) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction("PtInRegion");
        function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Int((long)n2), (Parameter)new Int((long)n3));
        return bool.getValue();
    }

    public boolean isPointInRegion(Point point) {
        return this.isPointInRegion((int)point.getY(), (int)point.getY());
    }

    public boolean isRectInRegion(Rect rect) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction("RectInRegion");
        function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Pointer((Parameter)rect));
        return bool.getValue();
    }

    public void setRectRegion(int n2, int n3, int n4, int n5) {
        Function function = Gdi32.getInstance().getFunction("SetRectRgn");
        function.invoke(null, new Parameter[]{this, new Int((long)n2), new Int((long)n3), new Int((long)n4), new Int((long)n5)});
    }

    public static Region createFromImage(Image image, Color color) {
        return Region.createFromImage(image, color, null);
    }

    public static Region createFromImage(Image image, Color color, Color color2) {
        if (image == null || color == null) {
            throw new IllegalArgumentException();
        }
        if (color2 == null) {
            color2 = new Color(0x101010);
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, color, null);
        graphics2D.dispose();
        Region region = Region.createRectRegion(new Rect());
        int n4 = color.getRed();
        int n5 = color.getGreen();
        int n6 = color.getBlue();
        int n7 = Math.min(n4 + color2.getRed(), 255);
        int n8 = Math.min(n5 + color2.getGreen(), 255);
        int n9 = Math.min(n6 + color2.getBlue(), 255);
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl = false;
            int n10 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n11;
                int n12 = bufferedImage.getRGB(i2, i3);
                int n13 = (n12 & 0xFF0000) >> 16;
                boolean bl2 = false;
                if (n13 >= n4 && n13 <= n7 && (n11 = (n12 & 0xFF00) >> 8) >= n5 && n11 <= n8) {
                    int n14 = n12 & 0xFF;
                    boolean bl3 = bl2 = n14 >= n6 && n14 <= n9;
                }
                if (bl2) {
                    if (!bl) continue;
                    bl = false;
                    Region region2 = Region.createRectRegion(i2, n10, i2 + 1, i3 - 1);
                    Region region3 = Region.combineRgn(region, region2, CombineMode.OR);
                    region.deleteObject();
                    region = region3;
                    region2.deleteObject();
                    continue;
                }
                if (bl) continue;
                bl = true;
                n10 = i3;
            }
            if (!bl) continue;
            Region region4 = Region.createRectRegion(i2, n10, i2 + 1, n3);
            Region region5 = Region.combineRgn(region, region4, CombineMode.OR);
            region.deleteObject();
            region = region5;
            region4.deleteObject();
        }
        return region;
    }

    public static Region createFromImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        Region region = Region.createRectRegion(new Rect());
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl = false;
            int n4 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                boolean bl2;
                int n5 = bufferedImage.getRGB(i2, i3);
                boolean bl3 = bl2 = (n5 & 0xFF000000) >> 24 == 0;
                if (bl2) {
                    if (!bl) continue;
                    bl = false;
                    Region region2 = Region.createRectRegion(i2, n4, i2 + 1, i3 - 1);
                    Region region3 = Region.combineRgn(region, region2, CombineMode.OR);
                    region.deleteObject();
                    region = region3;
                    region2.deleteObject();
                    continue;
                }
                if (bl) continue;
                bl = true;
                n4 = i3;
            }
            if (!bl) continue;
            Region region4 = Region.createRectRegion(i2, n4, i2 + 1, n3);
            Region region5 = Region.combineRgn(region, region4, CombineMode.OR);
            region.deleteObject();
            region = region5;
            region4.deleteObject();
        }
        return region;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class CombineMode
    extends EnumItem {
        public static final CombineMode AND = new CombineMode(1);
        public static final CombineMode OR = new CombineMode(2);
        public static final CombineMode XOR = new CombineMode(3);
        public static final CombineMode DIFF = new CombineMode(4);
        public static final CombineMode COPY = new CombineMode(5);
        public static final CombineMode MIN = AND;
        public static final CombineMode MAX = COPY;

        private CombineMode(int n2) {
            super(n2);
        }
    }
}

