/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32;

import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import teamdev.jxdesktop.UIElement;
import teamdev.jxdesktop.WindowManager;
import teamdev.jxdesktop.win32.WindowsUIElement;
import teamdev.jxdesktop.win32.ui.Wnd;

public class WindowsWindowManager
extends WindowManager {
    public WindowsWindowManager() {
        WindowsUIElement.a();
    }

    public UIElement getDesktopWindow() {
        Wnd wnd = Wnd.getDesktopWindow();
        return new WindowsUIElement(wnd);
    }

    public UIElement getActiveWindow() {
        Wnd wnd = Wnd.getForegroundWindow();
        if (wnd.getBounds().getRightAsInt() <= 0 && wnd.getBounds().getBottomAsInt() <= 0) {
            return this.getFullScreen();
        }
        return new WindowsUIElement(wnd);
    }

    public List getAllWindows() {
        LinkedList<WindowsUIElement> linkedList = new LinkedList<WindowsUIElement>();
        List list = Wnd.getAllWindows();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Wnd wnd = (Wnd)((Object)list.get(i2));
            WindowsUIElement windowsUIElement = new WindowsUIElement(wnd);
            linkedList.add(windowsUIElement);
        }
        return linkedList;
    }

    public UIElement getWindowAtPoint(Point point) {
        Wnd wnd = Wnd.getWindowFromPoint(point.x, point.y);
        return new WindowsUIElement(wnd);
    }

    public UIElement getFullScreen() {
        Wnd wnd = Wnd.findWindow("Progman");
        return new WindowsUIElement(wnd);
    }

    public UIElement findWindow(String string) {
        Wnd wnd = Wnd.findWindowByName(string);
        return !wnd.isNull() ? new WindowsUIElement(wnd) : null;
    }
}

