/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32;

import com.jniwrapper.Bool;
import com.jniwrapper.DataBufferFactory;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.MemoryBuffer;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.WritableRaster;
import teamdev.jxcapture.CaptureSettings;
import teamdev.jxdesktop.CaptureUtilities;
import teamdev.jxdesktop.image.DataBufferByte;
import teamdev.jxdesktop.win32.Handle;
import teamdev.jxdesktop.win32.Point;
import teamdev.jxdesktop.win32.e;
import teamdev.jxdesktop.win32.gdi.Bitmap;
import teamdev.jxdesktop.win32.gdi.BitmapInfoHeader;
import teamdev.jxdesktop.win32.gdi.DC;
import teamdev.jxdesktop.win32.gdi.DDBitmap;
import teamdev.jxdesktop.win32.gdi.Icon;
import teamdev.jxdesktop.win32.gdi.IconInfo;
import teamdev.jxdesktop.win32.gdi.RGBQuad;
import teamdev.jxdesktop.win32.ui.SystemMetrics;
import teamdev.jxdesktop.win32.ui.User32;

public class WindowsCaptureUtilities
extends CaptureUtilities {
    private static final int d = new RGBQuad().getLength();
    private Bitmap c = new DDBitmap();
    private ColorModel b;

    public WindowsCaptureUtilities() {
        DC.createDC("DISPLAY", null, null, null);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        this.b = new ComponentColorModel(colorSpace, false, false, 1, 0);
    }

    public BufferedImage createScreenCapture(Rectangle rectangle) {
        int n2 = rectangle.width * rectangle.height;
        int n3 = n2 * d;
        DC dC = DC.createDC("DISPLAY", null, null, null);
        DC dC2 = DC.createCompatibleDC(dC);
        DDBitmap.CREATE_COMPATIBLE_BITMAP.invoke((Parameter)this.c, (Parameter)dC, (Parameter)new Int((long)rectangle.width), (Parameter)new Int((long)rectangle.height));
        Bitmap bitmap = dC2.selectObject(this.c);
        long l2 = DC.RasterOperation.SRCCOPY.getValue();
        if (CaptureSettings.getInstance().isCaptureTransparentWindow()) {
            l2 |= (long)DC.RasterOperation.CAPTUREBLT.getValue();
        }
        DC.RasterOperation rasterOperation = new DC.RasterOperation(l2);
        DC.bitBlt(dC2, 0, 0, rectangle.width, rectangle.height, dC, rectangle.x, rectangle.y, rasterOperation);
        DataBufferFactory dataBufferFactory = DataBufferFactory.getInstance();
        MemoryBuffer memoryBuffer = dataBufferFactory.allocateMemoryBuffer(n3);
        BitmapInfoHeader bitmapInfoHeader = new BitmapInfoHeader();
        Pointer pointer = new Pointer((Parameter)bitmapInfoHeader);
        int n4 = bitmapInfoHeader.getLength() + d * (n2 + 3);
        MemoryBuffer memoryBuffer2 = dataBufferFactory.allocateMemoryBuffer(n4);
        Handle handle = new Handle(memoryBuffer2.getHandle());
        handle.castTo(pointer);
        bitmapInfoHeader.setSize(bitmapInfoHeader.getLength());
        bitmapInfoHeader.setWidth(rectangle.width);
        bitmapInfoHeader.setHeight(-rectangle.height);
        bitmapInfoHeader.setPlanes(1L);
        bitmapInfoHeader.setBitCount(32L);
        bitmapInfoHeader.setCompression(Bitmap.Compression.BITFIELDS);
        if (CaptureSettings.getInstance().isIncludeCursor()) {
            this.a(dC2);
        }
        Bitmap.FUNCTION_GET_DIBITS.invoke(null, new Parameter[]{dC2, this.c, new UInt(0L), new UInt((long)rectangle.height), new Handle(memoryBuffer.getHandle()), handle, new UInt(0L)});
        dC2.selectObject(bitmap);
        DC.deleteObject(this.c);
        DC.deleteDC(dC2);
        DC.deleteDC(dC);
        return this.a(memoryBuffer, n3, rectangle);
    }

    private BufferedImage a(MemoryBuffer memoryBuffer, int n2, Rectangle rectangle) {
        DataBufferByte dataBufferByte = new DataBufferByte(memoryBuffer, n2);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, rectangle.width, rectangle.height, d, rectangle.width * d, new int[]{2, 1, 0});
        WritableRaster writableRaster = WritableRaster.createWritableRaster(componentSampleModel, dataBufferByte, new java.awt.Point());
        return new BufferedImage(this.b, writableRaster, false, null);
    }

    private void a(DC dC) {
        e e2 = WindowsCaptureUtilities.a();
        Handle handle = e2.b();
        Point point = e2.a();
        int n2 = (int)point.getX();
        int n3 = (int)point.getY();
        int n4 = SystemMetrics.getSystemMetrics(SystemMetrics.SM_CXCURSOR);
        int n5 = SystemMetrics.getSystemMetrics(SystemMetrics.SM_CYCURSOR);
        Icon icon = new Icon(handle.getValue());
        IconInfo iconInfo = icon.getIconInfo();
        int n6 = (int)iconInfo.getXHotSpot().getValue();
        int n7 = (int)iconInfo.getYHotSpot().getValue();
        dC.drawIconEx(n2 - n6, n3 - n7, icon, n4, n5, 0, new Handle(), 3);
    }

    private static e a() {
        Function function = User32.getInstance().getFunction("GetCursorInfo");
        e e2 = new e();
        Bool bool = new Bool();
        function.invoke((Parameter)bool, (Parameter)new Pointer((Parameter)e2));
        return e2;
    }
}

