/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import teamdev.jxdesktop.PlatformContext;
import teamdev.jxdesktop.win32.ui.Wnd;

public class TimerDialog {
    private final Rectangle rectangle = new Rectangle(74, 46, 69, 23);
    private final Dimension dialogSize = new Dimension(150, 75);
    private final ImageIcon mouseEnterImage = new ImageIcon((class$teamdev$jxcapture$samples$demo$TimerDialog == null ? (class$teamdev$jxcapture$samples$demo$TimerDialog = TimerDialog.class$("teamdev.jxcapture.samples.demo.TimerDialog")) : class$teamdev$jxcapture$samples$demo$TimerDialog).getResource("resources/images/mouseEnter.png"));
    private final ImageIcon mouseLeaveImage = new ImageIcon((class$teamdev$jxcapture$samples$demo$TimerDialog == null ? (class$teamdev$jxcapture$samples$demo$TimerDialog = TimerDialog.class$("teamdev.jxcapture.samples.demo.TimerDialog")) : class$teamdev$jxcapture$samples$demo$TimerDialog).getResource("resources/images/mouseLeave.png"));
    private final ImageIcon mousePressImage = new ImageIcon((class$teamdev$jxcapture$samples$demo$TimerDialog == null ? (class$teamdev$jxcapture$samples$demo$TimerDialog = TimerDialog.class$("teamdev.jxcapture.samples.demo.TimerDialog")) : class$teamdev$jxcapture$samples$demo$TimerDialog).getResource("resources/images/mousePress.png"));
    private ImageIcon currentImage = this.mouseLeaveImage;
    private JWindow dialog;
    private TimerListener timerListener;
    private Timer dialogTimer = new Timer();
    private int delayTime;
    private boolean mousePressed;
    static /* synthetic */ Class class$teamdev$jxcapture$samples$demo$TimerDialog;

    public TimerDialog(int n) {
        this.delayTime = n;
        this.dialog = new JWindow();
        this.dialog.setContentPane(this.createContentPane());
        this.dialog.setSize(this.dialogSize);
        this.dialog.setLocation(this.getLocation());
    }

    private JComponent createContentPane() {
        final TimerPane timerPane = new TimerPane();
        timerPane.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                this.updateDialog(mouseEvent.getPoint());
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                this.updateDialog(mouseEvent.getPoint());
            }

            private void updateDialog(Point point) {
                if (TimerDialog.this.rectangle.contains(point)) {
                    TimerDialog.this.currentImage = TimerDialog.this.mousePressed ? TimerDialog.this.mousePressImage : TimerDialog.this.mouseEnterImage;
                    timerPane.repaint();
                } else {
                    TimerDialog.this.currentImage = TimerDialog.this.mouseLeaveImage;
                    timerPane.repaint();
                }
            }
        });
        timerPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (TimerDialog.this.rectangle.contains(mouseEvent.getPoint())) {
                    TimerDialog.this.mousePressed = true;
                    TimerDialog.this.currentImage = TimerDialog.this.mousePressImage;
                    timerPane.repaint();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (TimerDialog.this.rectangle.contains(mouseEvent.getPoint()) && TimerDialog.this.mousePressed) {
                    TimerDialog.this.currentImage = TimerDialog.this.mouseEnterImage;
                    timerPane.repaint();
                    TimerDialog.this.complete(true);
                }
                TimerDialog.this.mousePressed = false;
            }
        });
        return timerPane;
    }

    private Point getLocation() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        return new Point(rectangle.width - this.dialogSize.width, rectangle.height - this.dialogSize.height);
    }

    private void complete(boolean bl) {
        this.dialogTimer.cancel();
        this.dialog.setVisible(false);
        this.dialog.dispose();
        if (this.timerListener != null) {
            this.timerListener.complete(bl);
        }
    }

    public void show(TimerListener timerListener) {
        if (this.dialog.isVisible()) {
            return;
        }
        this.timerListener = timerListener;
        this.dialog.setVisible(true);
        if (PlatformContext.isWindows()) {
            Wnd wnd = new Wnd((Component)this.dialog);
            wnd.setTopmost(true);
        }
        this.dialogTimer.schedule(new TimerTask(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        TimerDialog.access$810(3.access$900(this.this$1));
                        TimerDialog.access$1000(3.access$900(this.this$1)).repaint();
                        if (TimerDialog.access$800(3.access$900(this.this$1)) == 0) {
                            TimerDialog.access$700(3.access$900(this.this$1), false);
                        }
                    }
                });
            }

            static /* synthetic */ TimerDialog access$900(3 var0) {
                return var0.TimerDialog.this;
            }
        }, 0L, 1000L);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$810(TimerDialog timerDialog) {
        return timerDialog.delayTime--;
    }

    static /* synthetic */ JWindow access$1000(TimerDialog timerDialog) {
        return timerDialog.dialog;
    }

    public static interface TimerListener {
        public void complete(boolean var1);
    }

    private class TimerPane
    extends JPanel {
        private TimerPane() {
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawImage(TimerDialog.this.currentImage.getImage(), 0, 0, null);
            graphics2D.setFont(new Font("Verdana", 0, 45));
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(String.valueOf(TimerDialog.this.delayTime), 15, 55);
        }
    }
}

