/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.plaf.BorderUIResource;
import teamdev.jxcapture.samples.demo.ApplicationSettings;
import teamdev.jxcapture.samples.demo.EscapeDialog;

public class AboutDialog
extends EscapeDialog {
    private static AboutDialog instance;
    private ResourceBundle resource = ApplicationSettings.getResourceBundle();

    private AboutDialog() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.createContentPane(), "Center");
        jPanel.add(this.createActionPane(), "South");
        this.setContentPane(jPanel);
        this.setTitle(this.resource.getString("AboutDialog.Title"));
        this.setSize(424, 360);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
    }

    public static AboutDialog getInstance() {
        return instance == null ? (instance = new AboutDialog()) : instance;
    }

    private Component createActionPane() {
        JButton jButton = new JButton(new CloseDialogAction());
        jButton.setPreferredSize(new Dimension(75, 23));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JSeparator(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(8, 8, 8, 8), 0, 0));
        return jPanel;
    }

    private Component createContentPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.createLogoPane(), "West");
        jPanel.add(this.createInfoPane(), "Center");
        return jPanel;
    }

    private Component createLogoPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(new BorderUIResource.EmptyBorderUIResource(4, 4, 4, 4));
        URL uRL = this.getClass().getResource(this.resource.getString("AboutDialog.Icon.About"));
        JLabel jLabel = new JLabel(new ImageIcon(uRL));
        jPanel.add((Component)jLabel, "Center");
        return jPanel;
    }

    private Component createInfoPane() {
        JLabel jLabel = new JLabel(this.resource.getString("AboutDialog.Label.Company.Text"));
        JLabel jLabel2 = new JLabel(this.resource.getString("AboutDialog.Label.Product.Text"));
        String string = this.resource.getString("AboutDialog.HTMLLabel.URL");
        String string2 = this.resource.getString("AboutDialog.HTMLLabel.Text");
        HTMLLabel hTMLLabel = new HTMLLabel(string2, string);
        hTMLLabel.setToolTipText(string);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new BorderUIResource.EmptyBorderUIResource(4, 4, 4, 4));
        jPanel.setBackground(Color.WHITE);
        jPanel.add(this.createProductNamePane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 16, 15, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 16, 15, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)hTMLLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 4, 4, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 16, 2, new Insets(4, 4, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 4, 0, 0), 0, 0));
        return jPanel;
    }

    private Component createProductNamePane() {
        URL uRL = this.getClass().getResource(this.resource.getString("AboutDialog.Icon.Logo"));
        JLabel jLabel = new JLabel(new ImageIcon(uRL));
        JLabel jLabel2 = new JLabel(this.resource.getString("AboutDialog.Label.Version.Text"));
        jLabel2.setForeground(Color.GRAY);
        jLabel2.setBorder(new BorderUIResource.EmptyBorderUIResource(0, 112, 0, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(new BorderUIResource.EmptyBorderUIResource(15, 0, 0, 0));
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jLabel2, "South");
        return jPanel;
    }

    private class CloseDialogAction
    extends AbstractAction {
        private CloseDialogAction() {
            this.putValue("Name", AboutDialog.this.resource.getString("AboutDialog.Action.Close.Text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AboutDialog.this.setVisible(false);
        }
    }

    private class HTMLLabel
    extends JLabel {
        private String url;
        private Color mouseEnteredColor;
        private Color mouseExitedColor;
        private boolean mouseEntered;
        private HTMLLabelMouseListener mouseListener = new HTMLLabelMouseListener();

        public HTMLLabel(String string, String string2) {
            this(string, string2, Color.BLUE, Color.BLUE);
        }

        public HTMLLabel(String string, String string2, Color color, Color color2) {
            this.url = string2;
            this.mouseEnteredColor = color;
            this.mouseExitedColor = color2;
            this.setText(string);
            this.setCursor(new Cursor(12));
            this.setForeground(color2);
            this.addMouseListener(this.mouseListener);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.isEnabled() && this.mouseEntered) {
                graphics.drawLine(0, this.getHeight() - 1, (int)this.getPreferredSize().getWidth(), this.getHeight() - 1);
            }
        }

        public void dispose() {
            this.removeMouseListener(this.mouseListener);
        }

        private class HTMLLabelMouseListener
        extends MouseAdapter {
            private HTMLLabelMouseListener() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    Runtime.getRuntime().exec("cmd /c start " + HTMLLabel.this.url);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                HTMLLabel.this.setForeground(HTMLLabel.this.mouseEnteredColor);
                HTMLLabel.this.mouseEntered = true;
                HTMLLabel.this.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                HTMLLabel.this.setForeground(HTMLLabel.this.mouseExitedColor);
                HTMLLabel.this.mouseEntered = false;
                HTMLLabel.this.repaint();
            }
        }
    }
}

