unit Main;

{$IFDEF CONDITIONALEXPRESSIONS}
{$IF RTLVersion >= 14.0}
{$DEFINE D6_UP}
{$IFEND}
{$ENDIF}

interface

uses Windows, Classes, Graphics, Controls, Forms, StdCtrls, Dialogs, Menus;

type
  TMainForm = class(TForm)
    OpenBtn: TButton;
    ContactsLB: TListBox;
    AddBtn: TButton;
    EditBtn: TButton;
    DeleteBtn: TButton;
    OpenDialog1: TOpenDialog;
    AddPM: TPopupMenu;
    AddContactMI: TMenuItem;
    procedure FormDestroy(Sender: TObject);
    procedure OpenBtnClick(Sender: TObject);
    procedure AddContClick(Sender: TObject);
    procedure AddGroupClick(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure EditBtnClick(Sender: TObject);
    procedure DeleteBtnClick(Sender: TObject);
    procedure ContactsLBClick(Sender: TObject);
    procedure ContactsLBDblClick(Sender: TObject);
    procedure ContactsLBDrawItem(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
  private
    procedure UpdateContacts;
    procedure UpdateButtons;
    procedure EditContact;
    procedure EditGroup;
  end;

var
  MainForm: TMainForm;

implementation

uses Registry, {$IFDEF D6_UP} Variants, {$ENDIF} WabObj, WabTags, EditCont, EditGroup;

{$R *.dfm}

var
  WAB: TWAB;

function GetDefaultWABFileName: String;
begin
  Result := '';
  with TRegistry.Create do
   try
    RootKey := HKEY_CURRENT_USER;
    if OpenKey('\Software\Microsoft\Wab\WAB4\Wab File Name', False) then
     Result := ReadString('');
   finally
    Free;
   end;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  WAB.Free;
  WAB := nil;
end;

procedure TMainForm.UpdateContacts;
var
  I: Integer;
begin
  with ContactsLB.Items do
  begin
   BeginUpdate;
   try
    Clear;
    for I := 0 to WAB.ContactCount - 1 do
     Add(WAB[I].PropByTag[PR_DISPLAY_NAME]);
    for I := 0 to WAB.DistListCount - 1 do
     Add(WAB.DistLists[I].PropByTag[PR_DISPLAY_NAME]);
   finally
    EndUpdate;
   end;
  end;
  UpdateButtons;
end;

procedure TMainForm.UpdateButtons;
begin
  AddBtn.Enabled := WAB <> nil;
  EditBtn.Enabled := ContactsLB.ItemIndex >= 0;
  DeleteBtn.Enabled := ContactsLB.ItemIndex >= 0;
end;

procedure TMainForm.OpenBtnClick(Sender: TObject);
begin
  OpenDialog1.FileName := GetDefaultWABFileName;
  if OpenDialog1.Execute then
  begin
   WAB.Free;
   WAB := TWAB.Create(OpenDialog1.FileName);
   UpdateContacts;
  end;
end;

procedure TMainForm.AddContClick(Sender: TObject);
begin
  EditContForm.WAB := WAB;
  EditContForm.Contact := nil;
  if EditContForm.ShowModal = mrOK then
   UpdateContacts;
end;

procedure TMainForm.AddGroupClick(Sender: TObject);
begin
  EditGroupForm.WAB := WAB;
  EditGroupForm.DistList := nil;
  EditGroupForm.ShowModal;
  UpdateContacts;
end;

procedure TMainForm.AddBtnClick(Sender: TObject);
begin
  with ClientToScreen(Point(AddBtn.Left, AddBtn.Top)) do
   AddPM.Popup(X, Y);
end;

procedure TMainForm.EditContact;
begin
  EditContForm.WAB := WAB;
  EditContForm.Contact := WAB[ContactsLB.ItemIndex];
  if EditContForm.ShowModal = mrOK then
  begin
   ContactsLB.Items[ContactsLB.ItemIndex] := EditContForm.Contact.PropByTag[PR_DISPLAY_NAME];
   UpdateButtons;
  end;
end;

procedure TMainForm.EditGroup;
begin
  EditGroupForm.WAB := WAB;
  EditGroupForm.DistList := WAB.DistLists[ContactsLB.ItemIndex - WAB.ContactCount];
  EditGroupForm.ShowModal;
  UpdateContacts;
end;

procedure TMainForm.EditBtnClick(Sender: TObject);
begin
  if ContactsLB.ItemIndex < WAB.ContactCount then
   EditContact
  else
   EditGroup;
end;

procedure TMainForm.DeleteBtnClick(Sender: TObject);
begin
  if ContactsLB.ItemIndex < WAB.ContactCount then
   WAB.Delete(ContactsLB.ItemIndex)
  else
   WAB.DeleteDistList(ContactsLB.ItemIndex - WAB.ContactCount);
  ContactsLB.Items.Delete(ContactsLB.ItemIndex);
  UpdateButtons;
end;

procedure TMainForm.ContactsLBClick(Sender: TObject);
begin
  UpdateButtons;
end;

procedure TMainForm.ContactsLBDblClick(Sender: TObject);
begin
  if ContactsLB.ItemIndex >= 0 then
   EditBtnClick(Self);
end;

procedure TMainForm.ContactsLBDrawItem(Control: TWinControl; Index: Integer; Rect: TRect;
  State: TOwnerDrawState);
begin
  with ContactsLB.Canvas do
  begin
   FillRect(Rect);
   if Index >= WAB.ContactCount then
    Font.Style := Font.Style + [fsBold];
   TextOut(Rect.Left + 2, Rect.Top, ContactsLB.Items[Index]);
  end;
end;

end.
