unit EditCont;

{$IFDEF CONDITIONALEXPRESSIONS}
{$IF RTLVersion >= 14.0}
{$DEFINE D6_UP}
{$IFEND}
{$ENDIF}

interface

uses Classes, Controls, Forms, StdCtrls, WabObj;

type
  TEditContForm = class(TForm)
    OKBtn: TButton;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    FirstNameEd: TEdit;
    LastNameEd: TEdit;
    EmailEd: TEdit;
    MobileEd: TEdit;
    PhoneEd: TEdit;
    HomeAddrCityEd: TEdit;
    HomeAddrStateEd: TEdit;
    HomeAddrPostalEd: TEdit;
    HomeAddrContryEd: TEdit;
    HomePageEd: TEdit;
    BusAddrCityEd: TEdit;
    BusAddrStateEd: TEdit;
    BusAddrPostalEd: TEdit;
    BusAddrCountryEd: TEdit;
    ProfessionEd: TEdit;
    CompanyEd: TEdit;
    BusFaxEd: TEdit;
    BusPhoneEd: TEdit;
    BusHomePageEd: TEdit;
    DisplayNameEd: TEdit;
    HomeAddrStreetEd: TMemo;
    BusAddrStreetEd: TMemo;
    NotesMem: TMemo;
    procedure FormShow(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure NameEdChange(Sender: TObject);
  public
    WAB: TWAB;
    Contact: TWABContact;
  end;

var
  EditContForm: TEditContForm;

implementation

uses {$IFDEF D6_UP} Variants, {$ENDIF} WabTags;

{$R *.DFM}

procedure TEditContForm.FormShow(Sender: TObject);
begin
  if Contact = nil then
  begin
   DisplayNameEd.Text := '';
   FirstNameEd.Text := '';
   LastNameEd.Text := '';
   MobileEd.Text := '';
   PhoneEd.Text := '';
   EmailEd.Text := '';
   HomePageEd.Text := '';
   HomeAddrStreetEd.Text := '';
   HomeAddrCityEd.Text := '';
   HomeAddrStateEd.Text := '';
   HomeAddrPostalEd.Text := '';
   HomeAddrContryEd.Text := '';
   CompanyEd.Text := '';
   ProfessionEd.Text := '';
   BusFaxEd.Text := '';
   BusPhoneEd.Text := '';
   BusHomePageEd.Text := '';
   BusAddrStreetEd.Text := '';
   BusAddrCityEd.Text := '';
   BusAddrStateEd.Text := '';
   BusAddrPostalEd.Text := '';
   BusAddrCountryEd.Text := '';
   NotesMem.Text := '';
  end
  else
   with Contact do
   begin
    DisplayNameEd.Text := VarToStr(PropByTag[PR_DISPLAY_NAME]);
    FirstNameEd.Text := VarToStr(PropByTag[PR_GIVEN_NAME]);
    LastNameEd.Text := VarToStr(PropByTag[PR_SURNAME]);
    MobileEd.Text := VarToStr(PropByTag[PR_MOBILE_TELEPHONE_NUMBER]);
    PhoneEd.Text := VarToStr(PropByTag[PR_HOME_TELEPHONE_NUMBER]);
    EmailEd.Text := VarToStr(PropByTag[PR_EMAIL_ADDRESS]);
    HomePageEd.Text := VarToStr(PropByTag[PR_PERSONAL_HOME_PAGE]);
    HomeAddrStreetEd.Text := VarToStr(PropByTag[PR_HOME_ADDRESS_STREET]);
    HomeAddrCityEd.Text := VarToStr(PropByTag[PR_HOME_ADDRESS_CITY]);
    HomeAddrStateEd.Text := VarToStr(PropByTag[PR_HOME_ADDRESS_STATE_OR_PROVINCE]);
    HomeAddrPostalEd.Text := VarToStr(PropByTag[PR_HOME_ADDRESS_POSTAL_CODE]);
    HomeAddrContryEd.Text := VarToStr(PropByTag[PR_HOME_ADDRESS_COUNTRY]);
    CompanyEd.Text := VarToStr(PropByTag[PR_COMPANY_NAME]);
    ProfessionEd.Text := VarToStr(PropByTag[PR_PROFESSION]);
    BusFaxEd.Text := VarToStr(PropByTag[PR_BUSINESS_FAX_NUMBER]);
    BusPhoneEd.Text := VarToStr(PropByTag[PR_BUSINESS_TELEPHONE_NUMBER]);
    BusHomePageEd.Text := VarToStr(PropByTag[PR_BUSINESS_HOME_PAGE]);
    BusAddrStreetEd.Text := VarToStr(PropByTag[PR_BUSINESS_ADDRESS_STREET]);
    BusAddrCityEd.Text := VarToStr(PropByTag[PR_BUSINESS_ADDRESS_CITY]);
    BusAddrStateEd.Text := VarToStr(PropByTag[PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE]);
    BusAddrPostalEd.Text := VarToStr(PropByTag[PR_BUSINESS_ADDRESS_POSTAL_CODE]);
    BusAddrCountryEd.Text := VarToStr(PropByTag[PR_BUSINESS_ADDRESS_COUNTRY]);
    NotesMem.Text := VarToStr(PropByTag[PR_COMMENT]);
   end;
end;

procedure TEditContForm.OKBtnClick(Sender: TObject);
begin
  if Contact = nil then
   Contact := WAB.NewContact;
  with Contact do
  begin
   PropByTag[PR_DISPLAY_NAME] := DisplayNameEd.Text;
   PropByTag[PR_GIVEN_NAME] := FirstNameEd.Text;
   PropByTag[PR_SURNAME] := LastNameEd.Text;
   PropByTag[PR_MOBILE_TELEPHONE_NUMBER] := MobileEd.Text;
   PropByTag[PR_HOME_TELEPHONE_NUMBER] := PhoneEd.Text;
   PropByTag[PR_EMAIL_ADDRESS] := EmailEd.Text;
   PropByTag[PR_PERSONAL_HOME_PAGE] := HomePageEd.Text;
   PropByTag[PR_HOME_ADDRESS_STREET] := HomeAddrStreetEd.Text;
   PropByTag[PR_HOME_ADDRESS_CITY] := HomeAddrCityEd.Text;
   PropByTag[PR_HOME_ADDRESS_STATE_OR_PROVINCE] := HomeAddrStateEd.Text;
   PropByTag[PR_HOME_ADDRESS_POSTAL_CODE] := HomeAddrPostalEd.Text;
   PropByTag[PR_HOME_ADDRESS_COUNTRY] := HomeAddrContryEd.Text;
   PropByTag[PR_COMPANY_NAME] := CompanyEd.Text;
   PropByTag[PR_PROFESSION] := ProfessionEd.Text;
   PropByTag[PR_BUSINESS_FAX_NUMBER] := BusFaxEd.Text;
   PropByTag[PR_BUSINESS_TELEPHONE_NUMBER] := BusPhoneEd.Text;
   PropByTag[PR_BUSINESS_HOME_PAGE] := BusHomePageEd.Text;
   PropByTag[PR_BUSINESS_ADDRESS_STREET] := BusAddrStreetEd.Text;
   PropByTag[PR_BUSINESS_ADDRESS_CITY] := BusAddrCityEd.Text;
   PropByTag[PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE] := BusAddrStateEd.Text;
   PropByTag[PR_BUSINESS_ADDRESS_POSTAL_CODE] := BusAddrPostalEd.Text;
   PropByTag[PR_BUSINESS_ADDRESS_COUNTRY] := BusAddrCountryEd.Text;
   PropByTag[PR_COMMENT] := NotesMem.Text;
   Save;
  end;
end;

procedure TEditContForm.NameEdChange(Sender: TObject);
begin
  if (FirstNameEd.Text <> '') and (LastNameEd.Text <> '') then
   DisplayNameEd.Text := FirstNameEd.Text + ' ' + LastNameEd.Text
  else
   DisplayNameEd.Text := FirstNameEd.Text + LastNameEd.Text;
end;

end.
