'====================================================================
'                H I M E W o r k b e n c h . b a s
'   This is a 'workbench', a testprogram to test performance of the
'                        H I M E . d l l
'          Huge Integer Math and Encryption library dll
'                            V 2.00
'                 (C) 2002-2006 DevOTechS
'                 e-mail: support@devotechs.com
'
' This is a testprogram to show performance of the HIME.dll
' Note that not all HIMEs functions are used in this program.
' It is free for everyone to study and modify in able to get acquainted
' with the use and functioning of the HIME.dll
' DevOTechS does not accept responsibility for loss of data or 
' unexpected results from using this program.
' Use this program at your own risk!
'====================================================================


#PBFORMS Created
#COMPILE EXE
#DIM ALL
'--------------------------------------------------------------------------------
'     Include HIME.dll header file
#INCLUDE "HIME.inc"


'--------------------------------------------------------------------------------
'   ** Includes **
'--------------------------------------------------------------------------------
#PBFORMS BEGIN INCLUDES 
'#INCLUDE "WIN32API.INC"
'#INCLUDE "PBForms.INC"
#PBFORMS END INCLUDES


'--------------------------------------------------------------------------------
'   ** Constants **
'--------------------------------------------------------------------------------
%WINAPI               = 1           
%TRUE                 = 1           
%FALSE                = 0           
%LF_FACESIZE          = 32          
%ANSI_CHARSET         = 0           
%FF_DONTCARE          = 0           ' Don't care or don't know.
%FW_DONTCARE          = 0           
%FW_NORMAL            = 400         
%LOGPIXELSY           = 90          ' Logical pixels/inch in Y
%SW_HIDE              = 0           
%SW_SHOW              = 5
%SW_SHOWNORMAL        = 1           
%WM_SETFONT           = &H30        
%WM_COMMAND           = &H111       
%WS_POPUP             = &H80000000  
%WS_CHILD             = &H40000000  
%WS_VISIBLE           = &H10000000  
%WS_CLIPSIBLINGS      = &H04000000  
%WS_CAPTION           = &H00C00000  ' WS_BORDER OR WS_DLGFRAME
%WS_BORDER            = &H00800000  
%WS_DLGFRAME          = &H00400000  
%WS_VSCROLL           = &H00200000  
%WS_HSCROLL           = &H00100000  
%WS_SYSMENU           = &H00080000  
%WS_TABSTOP           = &H00010000  
%WS_MINIMIZEBOX       = &H00020000  
%WS_MAXIMIZEBOX       = &H00010000  
%WS_EX_WINDOWEDGE     = &H00000100  
%WS_EX_CLIENTEDGE     = &H00000200  
%WS_EX_LEFT           = &H00000000  
%WS_EX_LTRREADING     = &H00000000  
%WS_EX_RIGHTSCROLLBAR = &H00000000  
%WS_EX_CONTROLPARENT  = &H00010000  
%WS_EX_STATICEDGE     = &H00020000
%WS_GROUP             = &H00020000  
%HWND_DESKTOP         = 0           
%ES_LEFT              = &H0&        
%ES_MULTILINE         = &H4&        
%ES_AUTOVSCROLL       = &H40&       
%BN_CLICKED           = 0           
%SS_LEFT              = &H00000000  
%SS_CENTER            = &H00000001  
%SS_RIGHT             = &H00000002  
%SS_CENTERIMAGE       = &H00000200  
%SS_SUNKEN            = &H00001000  
%DS_3DLOOK            = &H0004&     
%DS_NOFAILCREATE      = &H0010&     
%DS_SETFONT           = &H0040&     ' User specified font for Dlg controls
%DS_MODALFRAME        = &H0080&     ' Can be combined with WS_CAPTION
%LBN_SELCHANGE        = 1           
%COMMCTRL_INC         = 1           

'-----------------------------------------------------------------
' TYPE and UNION structures:  2
'-----------------------------------------------------------------
TYPE LOGFONT
  lfHeight         AS LONG                  
  lfWidth          AS LONG                  
  lfEscapement     AS LONG                  
  lfOrientation    AS LONG                  
  lfWeight         AS LONG                  
  lfItalic         AS BYTE                  
  lfUnderline      AS BYTE                  
  lfStrikeOut      AS BYTE                  
  lfCharSet        AS BYTE                  
  lfOutPrecision   AS BYTE                  
  lfClipPrecision  AS BYTE                  
  lfQuality        AS BYTE                  
  lfPitchAndFamily AS BYTE                  
  lfFaceName       AS ASCIIZ * %LF_FACESIZE 
END TYPE

TYPE INIT_COMMON_CONTROLSEX
    dwSize AS DWORD   ' size of this structure
    dwICC  AS DWORD   ' flags indicating which classes to be initialized
END TYPE

#PBFORMS BEGIN CONSTANTS 
%MAIN               = 101
%IDC_LISTBOX1       = 1001
%TITLE              = 1002
%IDC_LABEL2         = 1003
%PARAMa             = 1004
%IDC_LABEL3         = 1005
%IDC_LABEL4         = 1007
%PARAMb             = 1006
%IDC_LABEL5         = 1010
%PARAMc             = 1008
%IDC_LABEL6         = 1011
%RESULT             = 1009
%IDC_LABEL7         = 1013
%BITLENGTH          = 1014
%FILLRANDOM         = 1012
%IDC_FRAME1         = 1015
%CLEARPARAMS        = 1016
%CALCTIME           = 1017
%IDC_FRAME2         = 1018
%CALCULATE          = 1019
%EXIT               = 1020
%IDC_LABEL1         = 1021
%CALCULATINGLBL2    = 1022
%IDC_BUTTON1        = 1023
%CLEARRESULT        = 1023
%GOWEBSITE          = 1024
%RADIO_HEX          = 1025
%RADIO_DEC          = 1026

#PBFORMS END CONSTANTS
'--------------------------------------------------------------------------------

'--------------------------------------------------------------------------------
'   ** Globals **
'--------------------------------------------------------------------------------
GLOBAL hMain           AS LONG             
GLOBAL gOperations    ()      AS STRING 
GLOBAL gNrOperations          AS LONG    
GLOBAL gRSARandom_he          AS STRING  
GLOBAL gRSARandom_hd          AS STRING  
GLOBAL gRSARandom_hn          AS STRING  
GLOBAL gRSARandom_Seed        AS STRING  
GLOBAL gBBSRandom_he          AS STRING  
GLOBAL gBBSRandom_hd          AS STRING  
GLOBAL gBBSRandom_hn          AS STRING  
GLOBAL gBBSRandom_Seed        AS STRING  
GLOBAL gRSA_he                AS STRING  
GLOBAL gRSA_hd                AS STRING  
GLOBAL gRSA_hn                AS STRING  
GLOBAL gCurrent_Number_System AS STRING  
GLOBAL gRSA_hp                AS STRING  
GLOBAL gRSA_hq                AS STRING  
GLOBAL gRSA_hdp               AS STRING  
GLOBAL gRSA_hdq               AS STRING  
GLOBAL gRSA_hPInvQ            AS STRING  


'--------------------------------------------------------------------------------
'   ** Declarations **
'--------------------------------------------------------------------------------
DECLARE CALLBACK FUNCTION ShowMainProc()
DECLARE FUNCTION SampleListBox(BYVAL hDlg AS DWORD, BYVAL lID AS LONG, BYVAL lCount AS LONG) AS LONG
DECLARE FUNCTION ShowMain(BYVAL hParent AS DWORD) AS LONG

DECLARE FUNCTION CREATEFONTINDIRECT LIB "GDI32.DLL" ALIAS "CreateFontIndirectA" (lpLogFont AS LOGFONT) AS DWORD
DECLARE FUNCTION DELETEOBJECT LIB "GDI32.DLL" ALIAS "DeleteObject" (BYVAL hObject AS DWORD) AS LONG
DECLARE FUNCTION FREELIBRARY LIB "KERNEL32.DLL" ALIAS "FreeLibrary" (BYVAL hLibModule AS DWORD) AS LONG
DECLARE FUNCTION GETDC LIB "USER32.DLL" ALIAS "GetDC" (BYVAL hWnd AS DWORD) AS DWORD
DECLARE FUNCTION GETDEVICECAPS LIB "GDI32.DLL" ALIAS "GetDeviceCaps" (BYVAL hdc AS DWORD, BYVAL nIndex AS LONG) AS LONG
DECLARE FUNCTION GETPROCADDRESS LIB "KERNEL32.DLL" ALIAS "GetProcAddress" (BYVAL hModule AS DWORD, lpProcName AS ASCIIZ) AS LONG
DECLARE FUNCTION LOADLIBRARY LIB "KERNEL32.DLL" ALIAS "LoadLibraryA" (lpLibFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION RELEASEDC LIB "USER32.DLL" ALIAS "ReleaseDC" (BYVAL hWnd AS DWORD, BYVAL hDC AS DWORD) AS LONG
DECLARE FUNCTION SHELLEXECUTE LIB "SHELL32.DLL" ALIAS "ShellExecuteA" (BYVAL hwnd AS DWORD, lpOperation AS ASCIIZ, lpFile AS ASCIIZ, lpParameters AS ASCIIZ, lpDirectory AS ASCIIZ, BYVAL nShowCmd AS LONG) AS DWORD

#PBFORMS DECLARATIONS


'--------------------------------------------------------------------------------
'Convert huge integer number to the selected number system
SUB Huge2xxx(lReg1 AS LONG, lReg2 AS LONG)
    IF gCurrent_Number_System = "hex" THEN
        hi_Huge2Hex lReg1, lReg2
        hi_TrimLZeroes lReg2, lReg2
    ELSE 
        hi_Huge2Dec lReg1, lReg2
    END IF
END SUB
       

'--------------------------------------------------------------------------------
'Convert number from the selected number system to huge integer number
SUB xxx2Huge(lReg1 AS LONG, lReg2 AS LONG)
    IF gCurrent_Number_System = "hex" THEN
        hi_Hex2Huge lReg1, lReg2
    ELSE 
        hi_Dec2Huge lReg1, lReg2
    END IF
END SUB

       
'--------------------------------------------------------------------------------
'Fill 3 parameters with a random number. The max. length of the random number is defined
'in the 'Bitlength' textbox
SUB FillParamsWithRandoms
    LOCAL Bitlen AS LONG
    LOCAL a AS STRING
   
    CONTROL GET TEXT hMain, %BITLENGTH TO a
    Bitlen = VAL(a)

    hi_GenerateRandom(BitLen, 1)
    Huge2xxx(1,1)
    CONTROL SET TEXT hMain, %PARAMa, hi_GetReg(1)

    hi_GenerateRandom(BitLen, 1)
    Huge2xxx(1,1)
    CONTROL SET TEXT hMain, %PARAMb, hi_GetReg(1)

    hi_GenerateRandom(BitLen, 1)
    Huge2xxx(1,1)
    CONTROL SET TEXT hMain, %PARAMc, hi_GetReg(1)
    
END SUB

'--------------------------------------------------------------------------------
'Clear 3 parameters.
SUB ClearParams
    CONTROL SET TEXT hMain, %PARAMa, ""
    CONTROL SET TEXT hMain, %PARAMb, ""
    CONTROL SET TEXT hMain, %PARAMc, ""
    CONTROL SET TEXT hMain, %RESULT, ""
END SUB


'--------------------------------------------------------------------------------
'Hide 2nd edit control
SUB Hide2ndEditControl
    CONTROL SHOW STATE hMain, %PARAMb, %SW_HIDE
    CONTROL SHOW STATE hMain, %IDC_LABEL4, %SW_HIDE
END SUB


'--------------------------------------------------------------------------------
'Hide 3rd edit control
SUB Hide3rdEditControl
    CONTROL SHOW STATE hMain, %PARAMc, %SW_HIDE
    CONTROL SHOW STATE hMain, %IDC_LABEL5, %SW_HIDE
END SUB


'--------------------------------------------------------------------------------
'Hide 2nd and 3rd edit control
SUB Hide2nd3rdEditControl
    CONTROL SHOW STATE hMain, %PARAMb    , %SW_HIDE 
    CONTROL SHOW STATE hMain, %IDC_LABEL4, %SW_HIDE 
    CONTROL SHOW STATE hMain, %PARAMc    , %SW_HIDE 
    CONTROL SHOW STATE hMain, %IDC_LABEL5, %SW_HIDE 
END SUB


'--------------------------------------------------------------------------------
'Hide all edit controls
SUB HideAllEditControls
    CONTROL SHOW STATE hMain, %PARAMa    , %SW_HIDE 
    CONTROL SHOW STATE hMain, %IDC_LABEL3, %SW_HIDE 
    CONTROL SHOW STATE hMain, %PARAMb    , %SW_HIDE 
    CONTROL SHOW STATE hMain, %IDC_LABEL4, %SW_HIDE 
    CONTROL SHOW STATE hMain, %PARAMc    , %SW_HIDE 
    CONTROL SHOW STATE hMain, %IDC_LABEL5, %SW_HIDE 
END SUB


'--------------------------------------------------------------------------------
'Show all edit controls
SUB ShowAllEditControls
    CONTROL SHOW STATE hMain, %PARAMa    , %SW_SHOW 
    CONTROL SHOW STATE hMain, %IDC_LABEL3, %SW_SHOW 
    CONTROL SHOW STATE hMain, %PARAMb    , %SW_SHOW 
    CONTROL SHOW STATE hMain, %IDC_LABEL4, %SW_SHOW 
    CONTROL SHOW STATE hMain, %PARAMc    , %SW_SHOW 
    CONTROL SHOW STATE hMain, %IDC_LABEL5, %SW_SHOW 
END SUB

'--------------------------------------------------------------------------------
'New listboxitem (operation) selected. Adjust display
SUB NewListboxItemSelected
    LOCAL a AS STRING
    
            'Show all editboxes
    ShowAllEditControls
    CONTROL SET TEXT hMain, %IDC_LABEL3, "Parameter 'a'"
    CONTROL SET TEXT hMain, %IDC_LABEL4, "Parameter 'b'"
    CONTROL SET TEXT hMain, %IDC_LABEL5, "Parameter 'c'"
    CONTROL SET TEXT hMain, %RESULT, ""
    LISTBOX GET TEXT hMain, %IDC_LISTBOX1 TO a
    SELECT CASE a
        CASE "a + b"
            Hide3rdEditControl
                 
        CASE "a - b"
            Hide3rdEditControl
            
        CASE "a * b"
            Hide3rdEditControl

        CASE "a * a"
            Hide2nd3rdEditControl
                        
        CASE "a * 2"
            Hide2nd3rdEditControl
            
        CASE "a \ b"
            
        CASE "a \ 2"
            Hide2ndEditControl
             
        CASE "a ^ b"
            Hide3rdEditControl
             
        CASE "a mod b"
            Hide3rdEditControl
            
        CASE "a ^ b mod c"

        CASE "a ^ -1 mod b"
            Hide3rdEditControl
                        
        CASE "GCD a, b"
            Hide3rdEditControl
            
        CASE "Generate prime number"
            HideAllEditControls
             
        CASE "Generate random number"
            HideAllEditControls
                                               
        CASE "Generate RSA random number"
            HideAllEditControls
            
        CASE "Generate BBS random number"
            HideAllEditControls
            
        CASE "Generate RSA public key"
            CONTROL SET TEXT hMain, %IDC_LABEL3, "Modulus n"
            CONTROL SET TEXT hMain, %IDC_LABEL4, "Public key e"
            CONTROL SET TEXT hMain, %IDC_LABEL5, "Private key d"      

        CASE "RSA encrypt/decrypt data", "AES encrypt/decrypt data"
            CONTROL SET TEXT hMain, %IDC_LABEL3, "Plaintext"
            CONTROL SET TEXT hMain, %IDC_LABEL4, "Encrypted text"
            CONTROL SET TEXT hMain, %IDC_LABEL5, "Decrypted text"      

        CASE "SHA-256 hash algorithm"
            CONTROL SET TEXT hMain, %IDC_LABEL3, "Text"
            CONTROL SET TEXT hMain, %IDC_LABEL4, "Hash value"
            'CONTROL SET TEXT hMain, %IDC_LABEL5, "Decrypted text"            
            Hide3rdEditControl
            
        CASE "Diffie-Hellman algorithm"
            HideAllEditControls
            
        CASE "a = 0?"
            Hide2nd3rdEditControl
            
        CASE "a < b?"
            Hide3rdEditControl

        CASE "a is odd?"
            Hide2nd3rdEditControl
            
        CASE "a is prime? (Div. lower primes)"
            Hide2nd3rdEditControl
        
        CASE "a is prime? (Slow, 100%)"
            Hide2nd3rdEditControl
            
        CASE "a is prime? (Fermat, <>100%)"
            Hide2nd3rdEditControl
            
        CASE "a is prime? (Rabin-Miller, <>100%)" 
            Hide2nd3rdEditControl
            
        CASE "a, b relative primes?"
            Hide3rdEditControl
                     
     END SELECT
END SUB


'--------------------------------------------------------------------------------
'Perform selected calculation
SUB Calculate
   LOCAL a            AS STRING  
   LOCAL i            AS LONG    
   LOCAL ParamA       AS STRING  
   LOCAL ParamB       AS STRING  
   LOCAL ParamC       AS STRING  
   LOCAL Result       AS STRING  
   LOCAL StartTime    AS SINGLE  
   LOCAL Bits_         AS LONG    
   LOCAL Tests        AS LONG    
   LOCAL Bytes        AS LONG    
   LOCAL ModBits      AS LONG    
   LOCAL Ciphertext   AS STRING  
   LOCAL Plaintext    AS STRING  
   LOCAL Passphrase   AS STRING  
   LOCAL DH_Bitlength AS LONG    

        
            'Get selected operation
    LISTBOX GET TEXT hMain, %IDC_LISTBOX1 TO a
    IF a = "" THEN
        MSGBOX "Select an operation first..."
        EXIT SUB
    END IF

            'Get parameters from textboxes (as ascii strings)
    CONTROL GET TEXT hMain, %PARAMa TO ParamA
    CONTROL GET TEXT hMain, %PARAMb TO ParamB
    CONTROL GET TEXT hMain, %PARAMc TO ParamC
            'Store in registers and convert to binary
    hi_PutReg(ParamA, 1)
    xxx2Huge(1,1)

    hi_PutReg(ParamB, 2)
    xxx2Huge(2,2)
    
    hi_PutReg(ParamC, 3)
    xxx2Huge(3,3)
        
            'Perform operation
    CONTROL SET TEXT hMain, %IDC_LABEL6, ""        
    CONTROL SET TEXT hMain, %CALCULATINGLBL2, "Calculating..."
    CONTROL SET TEXT hMain, %RESULT, ""

    StartTime = TIMER
    LISTBOX GET TEXT hMain, %IDC_LISTBOX1 TO a  'Get selected operation
    SELECT CASE a
        CASE "a + b"
            hi_Add(1,2,9)
                
        CASE "a - b"
            IF hi_IsLess(1,2) THEN
                MSGBOX "a < b. Result will be negative (sign not shown)..."
            END IF
            hi_Sub(1,2,9)

        CASE "a * b"
            hi_Mul(1,2,9)

        CASE "a * a"
            hi_Square(1,9)
            
        CASE "a * 2"
            hi_MulBy2(1,9)
            
        CASE "a \ b"
            IF hi_IsZero(2) THEN
                MSGBOX "Division by zero!"
            ELSE            
                hi_Div(1,2,9,4)
                        'Already show Remainder:
                Huge2xxx(4,4)
                ParamC = hi_GetReg(4)
                CONTROL SET TEXT hMain, %PARAMc, "Remainder: " + ParamC
            END IF

        CASE "a \ 2"
            hi_DivBy2(1,9,8)
                        'Already show remainder:
            Huge2xxx(8,8)
            ParamC = hi_GetReg(8)                        
            CONTROL SET TEXT hMain, %PARAMc, "Remainder: " + ParamC
            
        CASE "a ^ b"
            hi_Pow(1,2,9)
            
        CASE "a mod b"
            hi_Mod(1,2,9)
            
        CASE "a ^ b mod c"
            IF hi_IsZero(3) THEN
                MSGBOX "C parameter must not be zero!"
                hi_RegClear(9) 
            ELSE        
                hi_PowMod(1,2,3,9)
            END IF
            
           
        CASE "a ^ -1 mod b"
            i = hi_ModInv(1,2,9)
            
            IF i = 1 THEN
                a = "No result: GCD(a,b) <> 1 !"            
                CONTROL SET TEXT hMain, %Result, a
                CONTROL SET TEXT hMain, %CALCULATINGLBL2, ""
                EXIT SUB
            END IF   
            
            
        CASE "GCD a, b"
            hi_GCD(1,2,9)
            
            
        CASE "Generate prime number"
            a = "Enter the length of the prime number to be generated (in bytes)"
            Bits_ = 8 * VAL(INPUTBOX$(a , , "100"))
            a = "Number of tests to be performed by Rabin-Miller test [2-15]"
            Tests = VAL(INPUTBOX$(a , , "5"))
            StartTime = TIMER
            hi_GeneratePrime(Bits_, Tests, 9)
            
            
        CASE "Generate random number"
            a = "Enter the length of the random number to be generated (in bytes)"
            Bits_ = 8 * VAL(INPUTBOX$(a , , "100"))
            StartTime = TIMER
            hi_GenerateRandom(Bits_, 9)
            
                                              
        CASE "Generate RSA random number"
            a = "Enter the length of the random number to be generated (in bytes)"
            Bytes = VAL(INPUTBOX$(a , , "100"))
            
            IF gRSARandom_he = "" THEN
                a = "Enter the length of the RSA modulus (in bits)"
                ModBits = VAL(INPUTBOX$(a , , "128"))            
                a = "Initializing RSA generator. Only needed once..."
                CONTROL SET TEXT hMain, %RESULT, a
                
                hi_GenerateRSAKeys(ModBits, 3, 1,2,3) 'he, hd, hn
                hi_GenerateRandom(ModBits - 8, 4)   'Generate seed
            END IF
            StartTime = TIMER
            hi_GenerateRSARandomBits(Bytes, 4, 1, 3, 9, 4)    
            
            
        CASE "Generate BBS random number"
            a = "Enter the length of the random number to be generated (in bytes)"
            Bytes = VAL(INPUTBOX$(a , , "100"))
            
            a = "Enter the length of the BBS modulus (in bits)"
            ModBits = VAL(INPUTBOX$(a , , "128"))            
            a = "Initializing BBS generator. Only needed once..."
            CONTROL SET TEXT hMain, %RESULT, a
            hi_InitBBS(ModBits, 4, 1, 2)    'bitlength, primetests, modulus, seed
            
            StartTime = TIMER                                  
            hi_GenerateBBSRandomBits(Bytes, %True, 2, 1, 9, 2)  'Bytes, MultipleBits, New seed, modulus, result, old seed
             
              
        CASE "Generate RSA public key"
            'GOSUB GenerateRSAkey       'Use original RSA
            GOSUB GenerateRSA_CRTkey    'Use RSA-CRT


        CASE "RSA encrypt/decrypt data"
            GOSUB RSA_Encrypt_Decrypt


        CASE "AES encrypt/decrypt data"
            GOSUB AES_Encrypt_Decrypt
            EXIT SUB
        
        
        CASE "SHA-256 hash algorithm"
                    'Store Parameter A in register 1
            hi_PutReg(ParamA, 1)
            
                    'Calculate its hash value
            hi_Hash_SHA_256(1, 2)   'Register 2 contains hash value
            hi_RegReverse 2, 2      'Reverse hash value because Huge2xxx changes endian
            Huge2xxx(2, 3)       'Convert hash value to hex
            CONTROL SET TEXT hMain, %PARAMb, hi_GetReg(3)
            
            CONTROL SET TEXT hMain, %CALCULATINGLBL2, ""
            EXIT SUB                                    
        
        CASE "Diffie-Hellman algorithm"
            GOSUB DiffieHellmanAlgo        
                        
        CASE "a = 0?"
            IF hi_IsZero(1) THEN
                CONTROL SET TEXT hMain, %RESULT, "a = 0"
            ELSE
                CONTROL SET TEXT hMain, %RESULT, "a <> 0"
            END IF
            GOSUB DisplayFalseTrue
            EXIT SUB
            
        CASE "a < b?" 
            IF hi_IsLess(1, 2) THEN
                CONTROL SET TEXT hMain, %RESULT, "a < b"
            ELSE
                CONTROL SET TEXT hMain, %RESULT, "a >= b"
            END IF
            GOSUB DisplayFalseTrue    
            EXIT SUB
            
        CASE "a is odd?"
            IF hi_IsOdd(1) THEN
                CONTROL SET TEXT hMain, %RESULT, "a is odd"
            ELSE
                CONTROL SET TEXT hMain, %RESULT, "a is even"
            END IF
            GOSUB DisplayFalseTrue    
            EXIT SUB

        CASE "a is prime? (Div. lower primes)"
            IF hi_IsPrime_Div(1) THEN
                CONTROL SET TEXT hMain, %RESULT, "a is possibly a prime.."
            ELSE
                CONTROL SET TEXT hMain, %RESULT, "a is definitely NOT prime"
            END IF
            GOSUB DisplayFalseTrue    
            EXIT SUB

        CASE "a is prime? (Slow, 100%)"
            IF hi_IsPrime_Slow(1) THEN
                CONTROL SET TEXT hMain, %RESULT, "a is definitely a prime.."
            ELSE
                CONTROL SET TEXT hMain, %RESULT, "a is definitely NOT prime"
            END IF
            GOSUB DisplayFalseTrue    
            EXIT SUB
                    
        CASE "a is prime? (Fermat, <>100%)"
            a = "Number of tests to be performed by Fermat test [1-100]"
            Tests = VAL(INPUTBOX$(a , , "5"))
            
            IF hi_IsPrime_F(Tests, 1) THEN
                CONTROL SET TEXT hMain, %RESULT, "a is possibly a prime.."
            ELSE
                CONTROL SET TEXT hMain, %RESULT, "a is definitely NOT prime"
            END IF
            GOSUB DisplayFalseTrue    
            EXIT SUB
            
        CASE "a is prime? (Rabin-Miller, <>100%)" 
            a = "Number of tests to be performed by Rabin-Miller test [1-100]"
            Tests = VAL(INPUTBOX$(a , , "5"))
            IF hi_IsPrime_RB(Tests, 1) THEN
                CONTROL SET TEXT hMain, %RESULT, "a is possibly a prime.."
            ELSE
                CONTROL SET TEXT hMain, %RESULT, "a is definitely NOT prime"
            END IF
            GOSUB DisplayFalseTrue    
            EXIT SUB
            
        CASE "a, b relative primes?" 
            IF hi_IsRelPrime(1, 2) THEN
                CONTROL SET TEXT hMain, %RESULT, "a and b are relative primes"
            ELSE
                CONTROL SET TEXT hMain, %RESULT, "a and b are NOT relative primes"
            END IF
            GOSUB DisplayFalseTrue    
            EXIT SUB        
                                   
        CASE ELSE
            MSGBOX "Unknown operation.."    
            
    END SELECT
            'Display calculation time
    CONTROL SET TEXT hMain, %CALCTIME, STR$(TIMER - StartTime)
            'Display result
    CONTROL SET TEXT hMain, %CALCULATINGLBL2, "Preparing result"
    CONTROL SET TEXT hMain, %RESULT, "Preparing result to display. May take a while..."
    FOR i = 1 TO 5
        DIALOG DOEVENTS
    NEXT i
            'Convert binary result to decimal
    Huge2xxx(9,9)
    Result = hi_GetReg(9)
    CONTROL SET TEXT hMain, %RESULT, Result
    CONTROL SET TEXT hMain, %IDC_LABEL6, "Result (" + STR$(LEN(Result)) + " digits)"
    CONTROL SET TEXT hMain, %CALCULATINGLBL2, ""
    
     
    EXIT SUB
    
DisplayFalseTrue:
            'Display calculation time
    CONTROL SET TEXT hMain, %CALCTIME, STR$(TIMER - StartTime)

    CONTROL SET TEXT hMain, %IDC_LABEL6, "Result"
    CONTROL SET TEXT hMain, %CALCULATINGLBL2, "" 
RETURN


GenerateRSAkey:
        a = "Enter the length of the RSA modulus (in bits)"
        ModBits = VAL(INPUTBOX$(a , , "256"))            
        StartTime = TIMER
        
        hi_PutReg(MKL$(65537), 1)               'Preset he with a value
        hi_GenerateRSAKeys(ModBits, 4, 1, 2, 3) 'Bitlength, Primetests, he, hd, hn
        
        gRSA_hn = hi_GetReg(3)
        Huge2xxx(3, 4)
        a  = hi_GetReg(4)
        CONTROL SET TEXT hMain, %PARAMa, a
        
        gRSA_he = hi_GetReg(1)
        Huge2xxx(1, 4)
        a  = hi_GetReg(4)
        CONTROL SET TEXT hMain, %PARAMb, a
        
        gRSA_hd = hi_GetReg(2)
        Huge2xxx(2, 4)
        a  = hi_GetReg(4)
        CONTROL SET TEXT hMain, %PARAMc, a
        Result = ""            
        hi_RegClear(9)  'Clear result register
RETURN

     
GenerateRSA_CRTkey:
        a = "Enter the length of the RSA modulus (in bits)"
        ModBits = VAL(INPUTBOX$(a , , "256"))            
        StartTime = TIMER
        
        hi_PutReg(MKL$(65537), 1)               'Preset he with a value
        'hi_GenerateRSAKeys(ModBits, 4, 1, 2, 3) 'Bitlength, Primetests, he, hd, hn
        
        'hi_GenerateRSAKeys_CRT (lBitLength, lPrimeTests, lReg_he, lReg_Modul, lReg_hp, lReg_hq, lReg_hdp, lReg_hdq, lReg_hPInvQ)
        hi_GenerateRSAKeys_CRT (ModBits, 4,  1,3,  10,11,12,13,14)
        
        gRSA_hn = hi_GetReg(3)
        Huge2xxx(3, 4)
        a  = hi_GetReg(4)
        CONTROL SET TEXT hMain, %PARAMa, a
        
        gRSA_he = hi_GetReg(1)
        Huge2xxx(1, 4)
        a  = hi_GetReg(4)
        CONTROL SET TEXT hMain, %PARAMb, a
        
        gRSA_hp     = hi_GetReg(10)  
        gRSA_hq     = hi_GetReg(11)  
        gRSA_hdp    = hi_GetReg(12)  
        gRSA_hdq    = hi_GetReg(13)  
        gRSA_hPInvQ = hi_GetReg(14)  

'        Huge2xxx(10, 4)
'        a  = hi_GetReg(4)
        a = "Private key parameters not shown"
        CONTROL SET TEXT hMain, %PARAMc, a
        Result = ""            
        hi_RegClear(9)  'Clear result register
RETURN



DiffieHellmanAlgo:
            'Diffie-Hellman algorithm
            
            'Show some info for the user
    a =     "Diffie-Hellman algorithm" + $CRLF
    a = a + "---------------------------" + $CRLF
    a = a + "We are going to exchange some NON-SECRET data with another party, called Bob." + $CRLF        
    a = a + "After the procedure, both parties will possess a common secret number." + $CRLF
    a = a + $CRLF
    a = a + "First, 2 parameters P and G are generated. You must enter the required bitlength for P." + $CRLF + $CRLF
    a = a + "Depending on the bitlength, calculation may take some time..." + $CRLF
    a = a + "So, do not get worried when you don't see a message appear on your screen immediately.."
    MSGBOX a
                 
            '1)Calculate parameters P and G:
    a =     "Enter the bitlength of the parameter P." + $CRLF
    DH_Bitlength = VAL(INPUTBOX$(a , , "256"))  'Bitlength of parameter P   
    hi_DH_GenParams(DH_Bitlength, 1, 2) '(lBitLength AS LONG, lRegP AS LONG, lRegG AS LONG)

    Huge2xxx(1, 8)   'Convert P to decimal
    hi_BreakString(8, 50, 0, 1, 8)
    Huge2xxx(2, 9)   'Convert G to decimal
    hi_BreakString(9, 50, 0, 1, 9)
    
    a =     "Parameter P:" + $CRLF
    a = a + hi_GetReg(8) + $CRLF + $CRLF
    a = a + "Parameter G:" + $CRLF
    a = a + hi_GetReg(9) + $CRLF + $CRLF
    
    a = a + "These parameters P and G must be sent to Bob." + $CRLF
    a = a + "He must use the same parameters. Once we have agreed on using these" + $CRLF
    a = a + "parameters, we can reuse them the next time." + $CRLF
    a = a + " " + $CRLF
    a = a + "We must now choose a private key for ourselves. This key must be kept secret!" + $CRLF
    a = a + "With this private key and parameters P and G, we will calculate our public key." + $CRLF
    MSGBOX a
    
            
            '2) First, we must choose a private key for ourselves
            
            '2a) Choose a private key (0 < PrivKey < P-1) and keep it secret!            
            'Store our private key in register 3
    DO
        a =     "Enter a private key. It must be a number larger than 0" + $CRLF
        a = a + "and smaller than P - 1"
        a = INPUTBOX$(a , , "1000")
        hi_PutReg(a, 3)
        xxx2Huge(3, 3)
                
                '2b) Calculate our public key and store in register 4
        i = hi_DH_Step1(1, 2, 3, 4) '(lRegP AS LONG, lRegG AS LONG, lPriv AS LONG, lPub AS LONG)
        IF  i <> 0 THEN
            a =     "The private key you entered was out of range." + $CRLF
            MSGBOX a
        END IF
    LOOP UNTIL i = 0

        
            '3) Next let's pretend that we are Bob:
            '3a) Make up a private key (0 < PrivKey < P-1) and keep it secret!            
    hi_GenerateRandom(DH_Bitlength - 8, 13)  'Store Bobs private key in register 13
            '3b) Calculate a public key for Bob and store in register 14
    i = hi_DH_Step1(1, 2, 13, 14) '(lRegP AS LONG, lRegG AS LONG, lPriv AS LONG, lPub AS LONG)
    IF  i <> 0 THEN
'        PrintData "Bob: Illegal input parameter"
    END IF        
    
            '4) We send our public key to Bob and Bob sends his public key
            '   to us
            
            '5) We calculate our shared key, using our own private key and Bobs public key
            '   Our shared key is in register 5
    i = hi_DH_Step2(1, 14, 3, 5) '(lRegP AS LONG, lPub AS LONG, lPriv AS LONG, lShared AS LONG)
    IF  i <> 0 THEN
'        PrintData "Calculating our shared key: Illegal input parameter"
    END IF    

            '6) Bob calculates his shared key, using his own private key and our public key
            '   Bobs shared key is in register 15
    i = hi_DH_Step2(1, 4, 13, 15) '(lRegP AS LONG, lPub AS LONG, lPriv AS LONG, lShared AS LONG)
    IF  i <> 0 THEN
'        PrintData "Calculating Bobs shared key: Illegal input parameter"
    END IF
    a =     "We have sent our public key to Bob." + $CRLF
    a = a + "Bob has sent his public key to us." + $CRLF + $CRLF
    a = a + "We use that, together with our private key, to calculate the shared key." + $CRLF
    MSGBOX a 
                    
            '7) Both our and Bobs shared key MUST be the same! Check this:
    IF hi_IsNotEqual(5, 15) THEN
        a =     "Both our and Bobs shared key are not the same! " + $CRLF
        a = a + "Obviously something went wrong..." + $CRLF
        MSGBOX a       
    END IF 

    Huge2xxx(5, 5)   'Convert our key to decimal
    hi_BreakString(5, 50, 0, 1, 5)
    Huge2xxx(15, 15)   'Convert Bobs key to decimal
    hi_BreakString(15, 50, 0, 1, 15)
    a =     "Our shared key:" + $CRLF
    a = a + hi_GetReg(5) + $CRLF + $CRLF
    a = a + "Bobs shared key:" + $CRLF
    a = a + hi_GetReg(15) + $CRLF
    MSGBOX a
    hi_RegClear(9)  'clear result register 
RETURN



RSA_Encrypt_Decrypt:
            'Check if a keypair was already defined
    IF gRSA_hn = "" THEN
            'Keypair needs to be defined
        'GOSUB GenerateRSAkey       'Use original RSA
        GOSUB GenerateRSA_CRTkey    'Use RSA-CRT
    ELSE
'        hi_PutReg(gRSA_he, 1)      'For original RSA
'        hi_PutReg(gRSA_hd, 2)
'        hi_PutReg(gRSA_hn, 3)
        
        hi_PutReg(gRSA_he, 1)       'For RSA-CRT
        hi_PutReg(gRSA_hn, 3)
        
        hi_PutReg(gRSA_hp    , 10)
        hi_PutReg(gRSA_hq    , 11)
        hi_PutReg(gRSA_hdp   , 12)
        hi_PutReg(gRSA_hdq   , 13)
        hi_PutReg(gRSA_hPInvQ, 14)
                
    END IF
    a = "Enter a string to encrypt (max. length:" + STR$(LEN(gRSA_hn)) + " bytes)"
    a = INPUTBOX$(a , , "")
        'Make plaintext length a multiple of 4
    IF LEN(a) MOD 4 > 0 THEN
        a = a & STRING$(4 - LEN(a) MOD 4, "-")  
    END IF
            
    CONTROL SET TEXT hMain, %PARAMa, a
    hi_PutReg(a, 4) 'Store plaintext in register
    IF hi_IsLess(3, 4) THEN 'modulus < plaintext?
        MSGBOX "Message is too long!!"
        CONTROL SET TEXT hMain, %CALCULATINGLBL2, ""
        EXIT SUB
    END IF
     
    StartTime = TIMER
        'Encrypt plaintext into ciphertext
    hi_Encrypt_RSA(4, 1, 3, 5)  'plaintext, he, hn, ciphertext
    
    Ciphertext = hi_GetReg(5)
    CONTROL SET TEXT hMain, %PARAMb, Ciphertext

        'Decrypt ciphertext into plaintext
    'hi_Decrypt_RSA(5, 2, 3, 6)  'ciphertext, he, hn, plaintext   '<-- Original RSA
    
        'hi_Decrypt_RSA_CRT lReg_Cipher, lReg_p, lReg_q, lReg_dp, lReg_dq, lReg_PInvQ, lReg_Plain
    hi_Decrypt_RSA_CRT(5,  10,11,12,13,14,  6)
    Plaintext = hi_GetReg(6)
    CONTROL SET TEXT hMain, %PARAMc, Plaintext
    
    hi_RegClear(9)  'Clear result register
RETURN


AES_Encrypt_Decrypt:
    'Step 1: Encrypt some data ============================================
            'Enter some plaintext
    a = "Enter a string (of any length) to encrypt"
    Plaintext = INPUTBOX$(a , , "")
    CONTROL SET TEXT hMain, %PARAMa, Plaintext  'Show plaintext in textbox
    
            'Enter the passphrase
    a = "Enter a passphrase to encrypt the string"
    Passphrase = INPUTBOX$(a , , "")

            'Calculate the SHA-256 hash value of the passphrase to 
            'use that as the key for AES encryption
    hi_PutReg(Passphrase, 1)    'Store passphrase in register 1
    hi_Hash_SHA_256(1, 2)       'Hash register 1 --> 2
                                'Register 2 now holds the AES key (32 bytes/256 bits)
    
            'Store plaintext in register 3
    hi_PutReg(Plaintext, 3)
    
            'Use an empty string as IV (Initial Vector) and store in register 4
    hi_PutReg("", 4)
    
            'Encrypt plaintext
    i = hi_Encrypt_AES_CBC(3, 2, 4, 5)  'Ciphertext is in register 5
    IF i = 1 THEN
            MSGBOX "AES key is NOT equal to 16, 24 or 32 bytes"
            CONTROL SET TEXT hMain, %CALCULATINGLBL2, ""
            EXIT SUB
    END IF
    
    IF i = 2 THEN
            MSGBOX "IV is not empty and not equal to blocklength (16 bytes)"
            CONTROL SET TEXT hMain, %CALCULATINGLBL2, ""
            EXIT SUB
    END IF
          
            'Show ciphertext in textbox
    CONTROL SET TEXT hMain, %PARAMb, hi_GetReg(5)
    
    'Step 2: Decrypt the data ============================================
            'Enter the passphrase
    a = "Enter a passphrase to decrypt the string"
    Passphrase = INPUTBOX$(a , , "")

            'Calculate the SHA-256 hash value of the passphrase to 
            'use that as the key for AES encryption
    hi_PutReg(Passphrase, 1)    'Store passphrase in register 1
    hi_Hash_SHA_256(1, 2)       'Hash register 1 --> 2
                                'Register 2 now holds the AES key (32 bytes/256 bits)
                    
            'Decrypt ciphertext in register 5
    i = hi_Decrypt_AES_CBC(5, 2, 6) 'Register 6 contains the decrypted ciphertext. This should
                                    'equal the original plaintext
                                    
    IF i = 1 THEN
            MSGBOX "AES key is NOT equal to 16, 24 or 32 bytes"
            CONTROL SET TEXT hMain, %CALCULATINGLBL2, ""
            EXIT SUB
    END IF
    
    IF i = 2 THEN
            MSGBOX "Ciphertext length is not a multiple of an AES block (16 bytes)"
            CONTROL SET TEXT hMain, %CALCULATINGLBL2, ""
            EXIT SUB
    END IF                                        

            'Show decrypted ciphertext in textbox
    CONTROL SET TEXT hMain, %PARAMc, hi_GetReg(6)

    IF hi_IsNotEqual(3, 6) THEN
        MSGBOX "Decryption error: decrypted ciphertext does not equal original plaintext!"
    END IF
    
    CONTROL SET TEXT hMain, %CALCULATINGLBL2, ""
RETURN
                   
END SUB




'--------------------------------------------------------------------------------
FUNCTION PBMAIN()
    gNrOperations = 30
    DIM gOperations(gNrOperations) AS GLOBAL STRING
    
'    gOperations(1) = "a + b"
'    gOperations(2) = "a - b"
'    gOperations(3) = "a * b"
'    gOperations(4) = "a * 2"
'    gOperations(5) = "a \ b" 
'    gOperations(6) = "a \ 2" 
'    gOperations(7) = "a ^ b" 
'    gOperations(8) = "a mod b" 
'    gOperations(9) = "a ^ b mod c"
'    gOperations(10) = "a ^ -1 mod b" 
'    gOperations(11) = "GCD a, b" 
'    gOperations(12) = "Generate prime number"            
'    gOperations(13) = "Generate random number"            
'    gOperations(14) = "Generate RSA random number"            
'    gOperations(15) = "Generate BBS random number"            
'    gOperations(16) = "Generate RSA public key"
'    gOperations(17) = "RSA encrypt/decrypt data"
'    gOperations(18) = "AES encrypt/decrypt data"
'    gOperations(19) = "SHA-256 hash algorithm"
'    gOperations(20) = "Diffie-Hellman algorithm"
'                
'    gOperations(21) = "--------------------"            
'    gOperations(22) = "a = 0?"            
'    gOperations(23) = "a < b?"            
'    gOperations(24) = "a is odd?"            
'    gOperations(25) = "a is prime? (Div. lower primes)"            
'    gOperations(26) = "a is prime? (Slow, 100%)"            
'    gOperations(27) = "a is prime? (Fermat, <>100%)"            
'    gOperations(28) = "a is prime? (Rabin-Miller, <>100%)"            
'    gOperations(29) = "a, b relative primes?"

    gOperations(1 ) = "a + b"                               
    gOperations(2 ) = "a - b"                               
    gOperations(3 ) = "a * b"                               
    gOperations(4 ) = "a * a"                               
    gOperations(5 ) = "a * 2"                               
    gOperations(6 ) = "a \ b"                               
    gOperations(7 ) = "a \ 2"                               
    gOperations(8 ) = "a ^ b"                               
    gOperations(9 ) = "a mod b"                             
    gOperations(10) = "a ^ b mod c"                         
    gOperations(11) = "a ^ -1 mod b"                        
    gOperations(12) = "GCD a, b"                            
    gOperations(13) = "Generate prime number"               
    gOperations(14) = "Generate random number"              
    gOperations(15) = "Generate RSA random number"          
    gOperations(16) = "Generate BBS random number"          
    gOperations(17) = "Generate RSA public key"             
    gOperations(18) = "RSA encrypt/decrypt data"            
    gOperations(19) = "AES encrypt/decrypt data"            
    gOperations(20) = "SHA-256 hash algorithm"              
    gOperations(21) = "Diffie-Hellman algorithm"            
    gOperations(22) = "--------------------"                
    gOperations(23) = "a = 0?"                              
    gOperations(24) = "a < b?"                              
    gOperations(25) = "a is odd?"                           
    gOperations(26) = "a is prime? (Div. lower primes)"     
    gOperations(27) = "a is prime? (Slow, 100%)"            
    gOperations(28) = "a is prime? (Fermat, <>100%)"        
    gOperations(29) = "a is prime? (Rabin-Miller, <>100%)"  
    gOperations(30) = "a, b relative primes?"               

      
    RANDOMIZE TIMER
    
    
    hi_PutReg("12345678-12345678", 1)  '<<-- Invalid registration key
    hi_Register(1)

    hi_ReadPrimes 1000
    ShowMain %HWND_DESKTOP
END FUNCTION
'--------------------------------------------------------------------------------

'--------------------------------------------------------------------------------
'   ** CallBacks **
'--------------------------------------------------------------------------------
CALLBACK FUNCTION ShowMainProc()
    LOCAL Operation     AS ASCIIZ*10
    LOCAL File          AS ASCIIZ*30
    LOCAL Parameters    AS ASCIIZ*10
    LOCAL Directory     AS ASCIIZ*30
    LOCAL result        AS LONG
    
    SELECT CASE CBMSG
        CASE %WM_COMMAND
            SELECT CASE CBCTL
                CASE %RADIO_HEX
                    gCurrent_Number_System = "hex"
                    ClearParams
                    CONTROL SET TEXT hMain, %RESULT, ""
                    
                CASE %RADIO_DEC
                    gCurrent_Number_System = "dec"
                    ClearParams
                    CONTROL SET TEXT hMain, %RESULT, ""
                                        
                CASE %IDC_LISTBOX1
                    IF CBCTLMSG = %LBN_SELCHANGE THEN
                        NewListboxItemSelected
                    END IF                
                
                CASE %CLEARRESULT
                    CONTROL SET TEXT hMain, %RESULT, ""
                    
                CASE %FILLRANDOM
                    IF CBCTLMSG = %BN_CLICKED OR CBCTLMSG = 1 THEN
                        FillParamsWithRandoms
                    END IF
                    
                CASE %CLEARPARAMS
                    IF CBCTLMSG = %BN_CLICKED OR CBCTLMSG = 1 THEN
                        ClearParams
                    END IF
                    
                CASE %CALCULATE
                    IF CBCTLMSG = %BN_CLICKED OR CBCTLMSG = 1 THEN
                        Calculate
                    END IF

                CASE %GOWEBSITE
                    IF CBCTLMSG = %BN_CLICKED OR CBCTLMSG = 1 THEN
                        Operation="open"
                        File="http://www.devotechs.com/"
                        Parameters=""
                        Directory=""
                        result=SHELLEXECUTE(%HWND_DESKTOP, Operation, File, Parameters, Directory, %SW_SHOWNORMAL)
                    END IF
                                        
                CASE %EXIT
                    IF CBCTLMSG = %BN_CLICKED OR CBCTLMSG = 1 THEN
                        DIALOG END hMain
                    END IF

            END SELECT
    END SELECT

END FUNCTION
'--------------------------------------------------------------------------------

'--------------------------------------------------------------------------------
'   Enter text in listbox
FUNCTION FillListBox(BYVAL hDlg AS DWORD, BYVAL lID AS LONG, BYVAL lCount AS _
    LONG) AS LONG
    LOCAL i AS LONG
    FOR i = 1 TO lCount
        LISTBOX ADD hDlg, lID, gOperations(i)
    NEXT i
END FUNCTION
'--------------------------------------------------------------------------------

'--------------------------------------------------------------------------------
'   ** Dialogs **
FUNCTION ShowMain(BYVAL hParent AS DWORD) AS LONG
    LOCAL lRslt AS LONG
    LOCAL Mess  AS STRING
    
#PBFORMS BEGIN DIALOG %MAIN->->
    LOCAL hDlg AS DWORD
    LOCAL hFont1 AS DWORD
    LOCAL hFont2 AS DWORD
    LOCAL hFont3 AS DWORD

    DIALOG NEW hParent, "HIME (Huge Integer Math and Encryption) library - " + _
        "Workbench V2.00 -", 89, 114, 464, 278, %WS_POPUP OR %WS_BORDER OR %WS_DLGFRAME _
        OR %WS_CAPTION OR %WS_SYSMENU OR %WS_MINIMIZEBOX OR %WS_MAXIMIZEBOX OR _
        %WS_CLIPSIBLINGS OR %WS_VISIBLE OR %DS_MODALFRAME OR %DS_3DLOOK OR _
        %DS_NOFAILCREATE OR %DS_SETFONT, %WS_EX_WINDOWEDGE OR _
        %WS_EX_CONTROLPARENT OR %WS_EX_LEFT OR %WS_EX_LTRREADING OR _
        %WS_EX_RIGHTSCROLLBAR, TO hDlg
    CONTROL ADD LISTBOX, hDlg, %IDC_LISTBOX1, , 2, 48, 104, 226, %WS_CHILD OR _
        %WS_VISIBLE OR %WS_TABSTOP OR %WS_HSCROLL OR %WS_VSCROLL, _
        %WS_EX_CLIENTEDGE OR %WS_EX_LEFT OR %WS_EX_RIGHTSCROLLBAR
    CONTROL ADD LABEL, hDlg, %TITLE, "Choose an operation, enter parameters and " + _
        "hit 'calculate' button", 2, 4, 458, 18, %WS_CHILD OR %WS_VISIBLE OR _
        %SS_CENTER OR %SS_CENTERIMAGE OR %SS_SUNKEN, %WS_EX_STATICEDGE OR _
        %WS_EX_LEFT OR %WS_EX_LTRREADING
    CONTROL ADD LABEL, hDlg, %IDC_LABEL2, "Operation", 4, 36, 62, 10, %WS_CHILD _
        OR %WS_VISIBLE OR %SS_LEFT OR %SS_SUNKEN, %WS_EX_LEFT OR _
        %WS_EX_LTRREADING
    CONTROL ADD TEXTBOX, hDlg, %PARAMa, "0", 110, 48, 232, 36, %WS_CHILD OR _
        %WS_VISIBLE OR %WS_TABSTOP OR %WS_VSCROLL OR %ES_LEFT OR %ES_MULTILINE _
        OR %ES_AUTOVSCROLL, %WS_EX_CLIENTEDGE OR %WS_EX_LEFT OR _
        %WS_EX_LTRREADING OR %WS_EX_RIGHTSCROLLBAR
    CONTROL ADD LABEL, hDlg, %IDC_LABEL3, "Parameter 'a'", 110, 36, 68, 12, _
        %WS_CHILD OR %WS_VISIBLE OR %SS_LEFT OR %SS_SUNKEN, %WS_EX_LEFT OR _
        %WS_EX_LTRREADING
    CONTROL ADD TEXTBOX, hDlg, %PARAMb, "0", 110, 104, 232, 36, %WS_CHILD OR _
        %WS_VISIBLE OR %WS_TABSTOP OR %WS_VSCROLL OR %ES_LEFT OR %ES_MULTILINE _
        OR %ES_AUTOVSCROLL, %WS_EX_CLIENTEDGE OR %WS_EX_LEFT OR _
        %WS_EX_LTRREADING OR %WS_EX_RIGHTSCROLLBAR
    CONTROL ADD LABEL, hDlg, %IDC_LABEL4, "Parameter 'b'", 110, 92, 68, 12, _
        %WS_CHILD OR %WS_VISIBLE OR %SS_LEFT OR %SS_SUNKEN, %WS_EX_LEFT OR _
        %WS_EX_LTRREADING
    CONTROL ADD TEXTBOX, hDlg, %PARAMc, "0", 110, 160, 232, 36, %WS_CHILD OR _
        %WS_VISIBLE OR %WS_TABSTOP OR %WS_VSCROLL OR %ES_LEFT OR %ES_MULTILINE _
        OR %ES_AUTOVSCROLL, %WS_EX_CLIENTEDGE OR %WS_EX_LEFT OR _
        %WS_EX_LTRREADING OR %WS_EX_RIGHTSCROLLBAR
    CONTROL ADD TEXTBOX, hDlg, %RESULT, "", 110, 216, 232, 56, %WS_CHILD OR _
        %WS_VISIBLE OR %WS_TABSTOP OR %WS_VSCROLL OR %ES_LEFT OR %ES_MULTILINE _
        OR %ES_AUTOVSCROLL, %WS_EX_CLIENTEDGE OR %WS_EX_LEFT OR _
        %WS_EX_LTRREADING OR %WS_EX_RIGHTSCROLLBAR
    CONTROL ADD LABEL, hDlg, %IDC_LABEL5, "Parameter 'c'", 110, 148, 68, 12, _
        %WS_CHILD OR %WS_VISIBLE OR %SS_LEFT OR %SS_SUNKEN, %WS_EX_LEFT OR _
        %WS_EX_LTRREADING
    CONTROL ADD LABEL, hDlg, %IDC_LABEL6, "Result", 110, 202, 204, 12, %WS_CHILD _
        OR %WS_VISIBLE OR %SS_LEFT OR %SS_SUNKEN, %WS_EX_LEFT OR _
        %WS_EX_LTRREADING
    
    CONTROL ADD LABEL, hDlg, %IDC_LABEL7, "Bitlength:", 356, 48, 52, 10, _
        %WS_CHILD OR %WS_VISIBLE OR %SS_RIGHT, %WS_EX_LEFT OR %WS_EX_LTRREADING
    CONTROL ADD TEXTBOX, hDlg, %BITLENGTH, "120", 410, 46, 36, 12    
    CONTROL ADD BUTTON, hDlg, %FILLRANDOM, "&Random parameters", 362, 60, 84, 14
    
    
    CONTROL ADD FRAME, hDlg, %IDC_FRAME1, "Modify parameters", 348, 36, 110, 58
    CONTROL ADD BUTTON, hDlg, %CLEARPARAMS, "Clear &parameters", 362, 76, 84, 14
    CONTROL ADD LABEL, hDlg, %CALCTIME, "1000 seconds", 360, 110, 94, 10
    CONTROL ADD FRAME, hDlg, %IDC_FRAME2, "Calculation time", 348, 100, 110, 22
    CONTROL ADD BUTTON, hDlg, %CALCULATE, "&Calculate", 362, 132, 84, 14
    
    CONTROL ADD LABEL, hDlg, %CALCULATINGLBL2, "", 352, 152, 106, 16, %WS_CHILD _
        OR %WS_VISIBLE OR %SS_CENTER, %WS_EX_LEFT OR %WS_EX_LTRREADING
    CONTROL ADD BUTTON, hDlg, %GOWEBSITE, "Open HIME website", 362, 222, 84, 14    
    CONTROL ADD BUTTON, hDlg, %CLEARRESULT, "Clear result", 362, 240, 84, 14
    CONTROL ADD BUTTON, hDlg, %EXIT, "&Exit", 362, 258, 84, 14
    
    CONTROL SEND hDlg, %CALCULATINGLBL2, %WM_SETFONT, hFont3, 0

    CONTROL ADD FRAME, hDlg, %IDC_FRAME2, "Show numbers in:", 348, 170, 110, 42
    CONTROL ADD OPTION, hDlg, %RADIO_HEX, "Hexadecimal system", 362, 180, 84, 14, %WS_GROUP OR %WS_TABSTOP, ,
    CONTROL ADD OPTION, hDlg, %RADIO_DEC, "Decimal system", 362, 192, 84, 14, , ,    

#PBFORMS END DIALOG
    hMain = hDlg
    FillListBox hDlg, %IDC_LISTBOX1, gNrOperations

    Mess =        "NOTE: This workbench program has NOT all HIME functions implemented." + $CRLF
    Mess = Mess + "HIME Workbench was intended to let you discover and test SOME of HIME's functions and routines." + $CRLF
    Mess = Mess + "Read the HIME help file for an overview of all the HIME functions." + $CRLF
    CONTROL SET TEXT hDlg, %RESULT, Mess
    CONTROL SET OPTION hDlg, %RADIO_HEX, %RADIO_HEX, %RADIO_DEC
    gCurrent_Number_System = "hex"
    
    DIALOG SHOW MODAL hDlg, CALL ShowMainProc TO lRslt

    DELETEOBJECT hFont1
    DELETEOBJECT hFont2
    
    
    
    FUNCTION = lRslt
END FUNCTION
'--------------------------------------------------------------------------------







