Module MainModule

    Sub main()
        ' Check transparent mode
        If Not FlashPlayerControlLibrary.FlashPlayerForm.IsTransparentModeAvailable Then
            MessageBox.Show("Transparent mode is not available", Application.ProductName)
            Return
        End If

        ' MyTranslucencyForm is inherited from FlashPlayerControlLibrary.FlashPlayerForm; see MyTranslucencyForm.vb
        ' Creating translucency form 
        Dim FlashPlayerForm As New MyTranslucencyForm

        ' Loading movie from stream
        Dim MovieStream As System.IO.Stream = System.Reflection.Assembly.GetExecutingAssembly.GetManifestResourceStream("Sample4_Translucency.movie.swf")
        FlashPlayerForm.PutMovieFromStream(MovieStream)

        ' Positions
        FlashPlayerForm.Width = 400
        FlashPlayerForm.Height = 400
        FlashPlayerForm.Left = Screen.PrimaryScreen.WorkingArea.Width() / 2 - FlashPlayerForm.Width / 2
        FlashPlayerForm.Top = Screen.PrimaryScreen.WorkingArea.Height() / 2 - FlashPlayerForm.Height / 2

        ' Play and...
        FlashPlayerForm.FlashMethod_Play()
        ' ...show
        FlashPlayerForm.ShowDialog()
    End Sub

End Module
