unit ChartItem;

interface

uses Windows, Classes, Graphics, RVFuncs, RVScroll, DLines, RVItem, Chart;

const
  rvsChart = -1001;

type

  TRVChartItemInfo = class (TRVControlItemInfo)
    public
      constructor Create(RVData: TPersistent); override;
      function GetBoolValue(Prop: TRVItemBoolProperty): Boolean; override;
      procedure Print(Canvas: TCanvas; x,y,x2: Integer; Preview, Correction: Boolean;
                      const sad: TRVScreenAndDevice; RichView: TRVScroller;
                      dli: TRVDrawLineInfo;
                      Part: Integer); override;
  end;

implementation

{============================ TRVChartItemInfo ================================}
constructor TRVChartItemInfo.Create(RVData: TPersistent);
begin
  inherited Create(RVData);
  StyleNo := rvsChart;
end;

function TRVChartItemInfo.GetBoolValue(Prop: TRVItemBoolProperty): Boolean;
begin
  case Prop of
    rvbpPrintToBMP:
      Result := False;
    else
      Result := inherited GetBoolValue(Prop);
  end;
end;

procedure TRVChartItemInfo.Print(Canvas: TCanvas; x, y, x2: Integer;
  Preview, Correction: Boolean; const sad: TRVScreenAndDevice;
  RichView: TRVScroller; dli: TRVDrawLineInfo; Part: Integer);
var sv: Integer;
begin
   //TChart.PrintPartial modifies Canvas settings.
   // So we use SaveDC/RestoreDC to leave them unchanged
   sv := SaveDC(Canvas.Handle);
   (Control as TChart).PrintPartial(Bounds(x,y,dli.Width,dli.Height));
   RestoreDC(Canvas.Handle, sv);
end;

initialization
   RegisterRichViewItemClass(rvsChart, TRVChartItemInfo);

end.
