unit fPreview;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, sgDrawingNavigator,  sgSManager, DXFImage, DXFConv;

type
  TfmPreview = class(TForm)
    Label1: TLabel;
    pnlButton: TPanel;
    btnCancel: TButton;
    pnlNavigator: TPanel;
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    FSManager: TsgSelectionManager;
    FDNavigator: TsgDrawingNavigator;
  public
    procedure FillImage(ASManager: TsgSelectionManager; ADXFImage: TsgDXFImage);
    property DNavigator: TsgDrawingNavigator read FDNavigator;
  end;

  procedure CreatePreview(AOwner: TComponent; ASManager: TsgSelectionManager;
    ADXFImage: TsgDXFImage);

implementation
{$INCLUDE SGDXF.INC}

{$R *.dfm}

procedure CreatePreview(AOwner: TComponent; ASManager: TsgSelectionManager;
  ADXFImage: TsgDXFImage);
var
  Preview: TfmPreview;
begin
  if ASManager.SelectedEntities.Count < 1 then
  begin
    ShowMessage('There are no selected entities');
    Exit;
  end;
  Preview := TfmPreview.Create(AOwner);
  try
    Preview.FillImage(ASManager, ADXFImage);
    Preview.ShowModal;
  finally
    Preview.Free;
  end;
end;

{ TfmPrintPreview }

procedure TfmPreview.FillImage(ASManager: TsgSelectionManager;
  ADXFImage: TsgDXFImage);
var
  I: Integer;
  vEnt: TsgDXFEntity;
  vDXFImage: TsgDXFImage;
begin
  FSManager := ASManager;
  vDXFImage := TsgDXFImage.Create;
  for I := 0 to FSManager.SelectedEntities.Count - 1 do
  begin
    vEnt := TsgDXFEntityClass(TsgDXFEntity(FSManager.SelectedEntities[I]).ClassType).Create;
    vEnt.AssignEntity(TsgDXFEntity(FSManager.SelectedEntities[I]));
    vDXFImage.Converter.OnCreate(vEnt);
    vDXFImage.Converter.Sections[csEntities].AddEntity(vEnt);
    vDXFImage.Converter.Loads(vEnt);
  end;
  vDXFImage.GetExtents;
  FDNavigator.Picture.Graphic := vDXFImage;
  FDNavigator.Color := vDXFImage.BackgroundColor;
  //TsgDXFImage(sgImage.Picture.Graphic).IsWithoutBorder := True;// without border
  vDXFImage.Free;
  FDNavigator.FitToSize;
end;

procedure TfmPreview.FormResize(Sender: TObject);
begin
  btnCancel.Left := Width div 2 - btnCancel.Width div 2;
end;

procedure TfmPreview.FormCreate(Sender: TObject);
begin
  FDNavigator := TsgDrawingNavigator.Create(Self);
  FDNavigator.Parent := pnlNavigator;
  FDNavigator.AutoFocus := True;
  FDNavigator.RectZooming := True;
  FDNavigator.Align := alClient;
  FormResize(nil);
  {$IFDEF SGDEL_4}
  OldCreateOrder := True;
  btnCancel.Anchors := [akBottom];
  {$ENDIF}
end;

end.
