// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'TTF.pas' rev: 5.00

#ifndef TTFHPP
#define TTFHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <sgShellAPI.hpp>	// Pascal unit
#include <Registry.hpp>	// Pascal unit
#include <MVFont.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <sgConsts.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Ttf
{
//-- type declarations -------------------------------------------------------
typedef float TsgTTFFloat;

struct TsgPoint2D
{
	float X;
	float Y;
} ;

typedef TsgPoint2D *PsgPoint2D;

struct TsgRect2D
{
	
	union
	{
		struct 
		{
			TsgPoint2D TopLeft;
			TsgPoint2D BottomRight;
			
		};
		struct 
		{
			float Left;
			float Top;
			float Right;
			float Bottom;
			
		};
		
	};
} ;

typedef TsgRect2D *PsgRect2D;

class DELPHICLASS TsgGlyph;
class PASCALIMPLEMENTATION TsgGlyph : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TsgRect2D FBox;
	Classes::TList* FPolyPolyline;
	void __fastcall Curve3DivRecursiveBezierPt(const TsgPoint2D &APt1, const TsgPoint2D &APt2, const TsgPoint2D 
		&APt3, Word Level);
	
protected:
	void __fastcall AddFirstPoint(void);
	void __fastcall CalcBox(void);
	void __fastcall ClearPoints(void);
	void __fastcall CurveTo(const PsgPoint2D AP2, const PsgPoint2D AP3);
	void __fastcall Decompose(const void * ABuffer, int ASize);
	void __fastcall MoveTo(const PsgPoint2D AP);
	__property TsgRect2D RealBox = {read=FBox};
	
public:
	__fastcall TsgGlyph(void);
	__fastcall virtual ~TsgGlyph(void);
	void __fastcall Draw(Graphics::TCanvas* ACanvas, const double AHorzOffset, const Sgconsts::PFMatrix 
		AMatrix);
	TsgRect2D __fastcall GetBox(const Sgconsts::PFMatrix AMatrix);
};


class DELPHICLASS TsgTextGlyph;
class PASCALIMPLEMENTATION TsgTextGlyph : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TList* FGlyphs;
	Classes::TList* FGlyphsUniCode;
	double FKoef;
	#pragma pack(push, 1)
	_MAT2 FMatrix;
	#pragma pack(pop)
	
	TsgGlyph* __fastcall GetGlyph(int AIndex);
	TsgGlyph* __fastcall GetGlyphUni(int AIndex);
	
protected:
	void __fastcall AddGlyph(Graphics::TCanvas* ACanvas, int AKey);
	void __fastcall AddGlyphW(Graphics::TCanvas* ACanvas, bool AIsUniCode, int AKey);
	
public:
	__fastcall TsgTextGlyph(void);
	__fastcall virtual ~TsgTextGlyph(void);
	void __fastcall ClearPointsInGplyphs(void);
	void __fastcall InitKoef(Graphics::TCanvas* ACanvas);
	void __fastcall DrawText(Graphics::TCanvas* ACanvas, const AnsiString AText, const Sgconsts::PFMatrix 
		AMatrix);
	void __fastcall DrawTextW(Graphics::TCanvas* ACanvas, const AnsiString AText, const WideString ATextW
		, const Sgconsts::PFMatrix AMatrix);
	void __fastcall DrawTextExt(Graphics::TCanvas* ACanvas, const Mvfont::TmvFontStyles AFontStyles, const 
		AnsiString AText, const Sgconsts::PFMatrix AMatrix);
	void __fastcall DrawTextExtW(Graphics::TCanvas* ACanvas, const Mvfont::TmvFontStyles AFontStyles, const 
		AnsiString AText, const WideString ATextW, const Sgconsts::PFMatrix AMatrix);
	Sgconsts::TFRect __fastcall GetBox(const AnsiString AText, const Sgconsts::PFMatrix AMatrix);
	Sgconsts::TFRect __fastcall GetBoxW(const AnsiString AText, const WideString ATextW, const Sgconsts::PFMatrix 
		AMatrix);
	void __fastcall Loaded(const AnsiString AText, const Graphics::TFont* AFont);
	void __fastcall LoadedW(const AnsiString AText, const WideString ATextW, const Graphics::TFont* AFont
		);
	__property double HKoef = {read=FKoef};
};


class DELPHICLASS TsgContainerOfTextGlyphs;
class PASCALIMPLEMENTATION TsgContainerOfTextGlyphs : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TList* FContainer;
	int FRefs;
	int __fastcall GetCount(void);
	TsgTextGlyph* __fastcall GetTextGlyph(int Index);
	
public:
	__fastcall TsgContainerOfTextGlyphs(void);
	__fastcall virtual ~TsgContainerOfTextGlyphs(void);
	TsgTextGlyph* __fastcall AddTextGlyphsByFont(const Mvfont::TmvExtFont* AFont);
	void __fastcall Clear(void);
	int __fastcall IndexOf(const AnsiString AFontName, const Graphics::TFontStyles AStyles);
	void __fastcall Reference(void);
	void __fastcall Release(void);
	__property int Count = {read=GetCount, nodefault};
	__property TsgTextGlyph* TextGlyph[int Index] = {read=GetTextGlyph};
};


class DELPHICLASS TsgGDIAdapter;
class PASCALIMPLEMENTATION TsgGDIAdapter : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	Graphics::TCanvas* Canvas;
	virtual void __fastcall PolyPolygon(void *Points, void *Counts, int Count);
	virtual void __fastcall SetPolyFillMode(int Mode);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TsgGDIAdapter(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgGDIAdapter(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const Word cnstHeigthDef = 0x1560;
extern PACKAGE TsgContainerOfTextGlyphs* ContainerOfTextGlyphs;
extern PACKAGE TsgGDIAdapter* GDIAdapter;
extern PACKAGE AnsiString __fastcall GetFileNameByFontName(const AnsiString AFontName);
extern PACKAGE AnsiString __fastcall GetFontNameByFileName(const AnsiString AFileName);
extern PACKAGE AnsiString __fastcall GetFontNameWithoutStyle(const AnsiString AName);

}	/* namespace Ttf */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Ttf;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// TTF
