#!/bin/sh
# MetaCard 2.3 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                 v 
scheduler  5-- copyright 2001 Garth Catterall-Heart, SpiritWorks Software Development
-- all rights reserved worldwide

on openStack
  global gRegistered,gStack,gChars,gAM,gPM,gPrevCard
  put "scheduler" into gStack
  if the short name of this stack <> gStack then exit openStack
  if gRegistered is empty then
    open stack "launcher"
  else
    lock screen
    if gChars is empty then put 40 into gChars
    put field "AM" of stack "launch Prefs" into gAM
    put field "PM" of stack "launch Prefs" into gPM
    if field "date" of card 1 is empty then
      go first card
      put the long date into field "date"
    else
      if gPrevCard is not empty then
        go card gPrevCard
      else
        go last card
      end if
    end if
    setArrows
    saveData
    unlock screen with visual plain
  end if
end openStack

on listRepeatDates
  if field "date" is empty then exit to metaCard
  put field "date" into startDateItems
  put convertTime(startDateItems) into startDate
  convert startDateItems to dateitems
  # get the date
  # convert it to dateitems
  # if item 1 of it > item 1 of startDateItems then
  # put item 1 of it into item 1 of startDateItems
  # end if
  
  if field "until date" is empty then exit listRepeatDates
  put field "until date" into endDate
  delete item 1 of endDate
  put convertTime(endDate) into endingDate
  convert endDate to dateitems
  put checkDateItems(startDateItems,endDate) into endDateItems
  
  if startDate > endingDate then
    answer error "The Repeat Until Date is earlier than the start Date"
    put empty into field "until date"
    put empty into field "repeatDates"
    put "none" into field "repeat"
    openCard
    exit to metaCard
  end if
  
  put field "date" & return into field "repeatDates"
  put field "repeat" into which
  switch which
  case "none"
    put empty into field "repeatDates"
    exit listRepeatDates
    break
  case "daily"
    if field "days" is empty then
      send mouseUp to field "days"
      exit to metaCard
    end if
    put field "days" into numdays
    createList numdays,startDateItems,endDateItems,0
    break
  case "weekly"
    if field "wks" is empty then
      send mouseUp to field "wks"
      exit to metaCard
    end if
    put field "wks" * 7 into numdays
    createList numdays,startDateItems,endDateItems,0
    break
  case "week days"
    put 1 into numdays
    createList numdays,startDateItems,endDateItems,1
    break
  case "day of month"
    put field "date" into temp
    if temp is empty then exit to metacard
    convert temp to abbr date
    put item 1 of temp into zDayofWeek -- abbrev day of week
    convert temp to dateitems
    put temp into zdate
    put item 3 of temp into zDayofMonth
    put 1 into item 3 of temp
    convert temp to short date
    convert temp to dateitems
    put item 7 of temp into zFirstDay -- number of day of week
    put zDayofMonth/7 into zweek -- number of week of month
    if offset(".",zweek) > 0 then
      put trunc(zweek) + 1 into zWeek
    else
      put trunc(zweek) into zWeek
    end if
    switch zWeek
    case 1
      put "1st" into whichWk
      break
    case 2
      put "2nd" into whichWk
      break
    case 3
      put "3rd" into whichWk
      break
    case 4
      put "4th" into whichWk
      break
    case 5
      put "5th" into whichWk
    end switch
    put "Repeat every" && whichWk && zDayofWeek into field "repeat label"
    
    put item 2 of endDateItems into endMonth
    put item 3 of endDateItems into endDate
    repeat while item 2 of startDateItems < item 2 of endDateItems
      set cursor to busy
      add 1 to item 2 of startDateItems -- add a month
      put item 2 of startDateItems into thisMonth
      put startDateItems into temp
      put 1 into item 3 of temp
      convert temp to short date
      convert temp to dateitems
      put item 7 of temp into firstday -- number of day of week
      if zFirstDay > firstday then -- figure offset based on difference
        put zFirstDay - firstday into x
        put zDayofMonth + x into zdate
      else
        put firstDay - zFirstDay into x
        put zDayofMonth - x into zdate
      end if
      if zdate <= ((zWeek - 1) * 7) then -- check for previous week
        add 7 to zdate
      end if
      -- put zdate && endDate && thisMonth && endMonth & return after field "repeatDates" --**
      if zdate > endDate AND thisMonth = endMonth then exit repeat
      put zdate into item 3 of of temp
      convert temp to long date
      put temp & return after field "repeatDates"
    end repeat
    break
  case "monthly"
    put "Repeat" into field "repeat label"
    repeat forever -- while item 2 of startDateItems < item 2 of endDateItems
      add 1 to item 2 of startDateItems
      put startDateItems into temp
      convert temp to long date
      if item 2 of startDateItems < item 2 of endDateItems then
        put temp & return after field "repeatDates"
      else
        if item 3 of startDateItems <= item 3 of endDateItems then
          put temp & return after field "repeatDates"
        end if
        exit repeat
      end if
    end repeat
    break
  case "yearly"
    put "Repeat" into field "repeat label"
    repeat forever
      add 12 to item 2 of startDateItems
      put startDateItems into temp
      convert temp to long date
      if item 2 of startDateItems < item 2 of endDateItems then
        put temp & return after field "repeatDates"
      else
        if item 3 of startDateItems <= item 3 of endDateItems then
          put temp & return after field "repeatDates"
        end if
        exit repeat
      end if
      
    end repeat
    break
  end switch
  delete last char of field "repeatDates" -- return
end listRepeatDates

on createList numDays,startDateItems,endDateItems,wkdays
  lock screen
  repeat forever
    set cursor to busy
    put item 2 of startDateItems into zmonth
    put item 1of startDateItems into zyear
    if zmonth > 12 then
      repeat while zmonth > 12
        add 1 to zyear
        subtract 12 from zmonth
      end repeat
    end if
    
    put daysofmonth(zmonth,zyear) into zdays
    if (zdays - item 3 of startDateItems) <= numDays then
      put item 3 of startDateItems into daytocheck
      repeat while zdays < daytocheck
        subtract zdays from daytocheck
        add 1 to item 2 of startDateItems
        put daysofmonth(item 2 of startDateItems,zyear) into zdays
      end repeat
      put numDays - (zdays - daytocheck) into item 3 of startDateItems
      add 1 to item 2 of startDateItems
    else
      add numDays to item 3 of startDateItems
    end if
    
    put startDateItems into temp
    convert temp to long date
    if wkdays = 1 AND char 1 of temp = "S" then next repeat-- saturday or sunday
    
    if item 2 of startDateItems > item 2 of endDateItems then
      exit repeat
    end if
    if item 2 of startDateItems >= item 2 of endDateItems then
      if item 3 of startDateItems <= item 3 of endDateItems then
        put temp & return after field "repeatDates"
      else
        exit repeat
      end if
    else
      put temp & return after field "repeatDates"
    end if
  end repeat
end createList

function checkDateItems startDateItems,endDateItems
  if item 1 of startDateItems < item 1 of endDateItems then
    put (item 1 of endDateItems - item 1 of startDateItems) into zyears
    add 12 * zyears to item 2 of endDateItems -- add 12 months
    subtract 1* zyears from item 1 of endDateItems
  end if
  return endDateItems
end checkDateItems

on adjustTime dir,whichFld,whichNum
  if whichFld is "start time" AND field "start time" is empty then
    put "9:00 AM" into field "start time"
  end if
  
  if whichFld is "end time" AND field "end time" is empty then
    put "9:00 AM" into field "end time"
  end if
  
  if whichNum is "min" then
    put 5 into znum
  else
    put 4 into znum
  end if
  
  repeat while the mouse is "down"
    put field whichFld into temp
    convert temp to dateitems
    if dir is "up" then
      if znum = 4 then
        add 1 to item znum of temp
      else
        add 1 to item znum of temp
      end if
    else
      if znum = 4 then
        subtract 1 from item znum of temp
      else
        subtract 1 from item znum of temp
      end if
    end if
    convert temp to short time
    put temp into field whichFld
    wait 20 ticks
  end repeat
end adjustTime

on checkTime
  global gTimeErrorReminder
  if field "end time" is empty then
    put field "start time" into field "end time"
    exit checkTime
  else
    put field "end time" into endTime
  end if
  
  if field "start time" is empty then
    put field "end time" into field "start time"
    exit checkTime
  else
    put field "start time" into startTime
  end if
  
  if convertTime(endtime) < convertTime(startTime) then
    if gTimeErrorReminder then
      answer error "The Start Time is later then the End Time." with "Don't remind me again" or "OK"
      if it is "Don't remind me again" then
        put false into gTimeErrorReminder
      end if
    end if
    put field "Start time" into field "End Time"
  end if
end checkTime

function convertTime ztime
  convert ztime to dateitems
  put item 1 of ztime into temp
  repeat with n = 2 to 5
    if item n of ztime < 10 then
      put "0" & item n of ztime after temp
    else
      put item n of ztime after temp
    end if
  end repeat
  return temp
end convertTime

on clearCardOne
  put the number of field "date" into firstField
  repeat with i = firstField to the number of fields
    put empty into field i
  end repeat
  hide group "wks"
  hide group "until"
  hide group "days"
  put "none" into field "repeat"
  put empty into field "repeat label"
  put empty into field "repeatdates"
  set the label of button "repeat" to "Click to repeat"
  put 1 into field "record"
end clearCardOne

function validateDate temp
  convert temp to short date
  ask "Enter a Date" with temp
  if it is empty then return empty
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    return empty
  end if
  
  put it into zdate
  
  if zdate is not a date then
    answer error "You entered an invalid date. Try again."
    return empty
  end if
  
  put the date into thisYear
  convert thisYear to dateitems
  put item 1 of thisYear into thisYear
  put zdate into temp
  convert temp to dateitems
  convert zdate to long date
  if item 1 of temp < thisYear then
    answer "Event dates can't be earlier than this year."
    return empty
  end if
  return zdate
end validateDate

on openCard
  if the short name of this stack <> "scheduler" then exit openCard
  saveData
  set the label of button "repeat" to field "repeat"
  hide field "repeatDates"
  put field "repeat" into which
  --  lock screen
  switch which
  case "none"
    hide group "wks"
    hide group "until"
    hide group "days"
    put empty into field "repeat label"
    put empty into field "repeatdates"
    set the label of button "repeat"  to "Click to repeat"
    exit openCard
    break
  case "daily"
    put "Repeat every" into field "repeat label"
    hide group "wks"
    show group "until"
    show group "days"
    break
  case "weekly"
    put "Repeat every" into field "repeat label"
    show group "until"
    hide group "days"
    show group "wks"
    break
  case "day of month"
    show group "until"
    hide group "days"
    hide group "wks"
    
    put field "date" into temp
    if temp is empty then exit to metacard
    convert temp to abbr date
    put item 1 of temp into zDayofWeek -- abbrev day of week
    convert temp to dateitems
    put temp into zdate
    put item 3 of temp into zDayofMonth
    put 1 into item 3 of temp
    convert temp to short date
    convert temp to dateitems
    put item 7 of temp into zFirstDay -- number of day of week
    put zDayofMonth/7 into zweek -- number of week of month
    if offset(".",zweek) > 0 then
      put trunc(zweek) + 1 into zWeek
    else
      put trunc(zweek) into zWeek
    end if
    switch zWeek
    case 1
      put "1st" into whichWk
      break
    case 2
      put "2nd" into whichWk
      break
    case 3
      put "3rd" into whichWk
      break
    case 4
      put "4th" into whichWk
      break
    case 5
      put "5th" into whichWk
    end switch
    put "Repeat every" && whichWk && zDayofWeek into field "repeat label"
    
    break
  default
    put "Repeat" into field "repeat label"
    show group "until"
    hide group "days"
    hide group "wks"
  end switch
  -- unlock screen with visual plain
end openCard

on checkCompleted
  if the number of cards = 1 and field "event" is empty then exit checkCompleted
  
  if field "event" is empty OR field "date" is empty then
    answer warning "This record is missing the event date or description " & return & \
        "and will not be included in any schedule."  \
        with "Fix later" or "Delete Record" or "Fix now"
    
    if it is "fix now" then
      if field "date" is empty then send mouseUp to button "choose"
      if field "event" is empty then click at the loc of field "event"
      exit to metaCard
    end if
    if it is "Delete Record"  then
      if the number of cards > 1 then
        lock screen
        put the number of this card into cardNum
        delete this card
        go card cardNum
        unlock screen
      else
        clearCardOne
      end if
      repeat with i = 1 to the number of cards
        put i into field "record" of card i
      end repeat
    end if
  end if
end checkCompleted

on closeCard
  global gDontSave
  if gDontSave then
    put false into gDontSave
    exit closeCard
  end if
  if the short name of this stack is "scheduler" then
    checkData
  else
    set cursor to watch
    save this stack
  end if
end closeCard
  w            Cyan    white        
       ^ Schedule Tracker    	  W 
Helvetica   U 
Helvetica  
 U 
Helvetica   U monaco  	 U monaco   U 
helvetica  
 W 
Helvetica  
 W 
Helvetica   W 
Helvetica 8records,atmain.mc
taskTracker,tasks.mc
passwords,password.mc
launcher,itmain.mc
launcher,sbdmain.mc
launcher,aetmain.mc
launcher,sbmain.mc
writer,whelper.mc
versions,version.mc
vehicleExp,vehexp.mc
invoiceTracker,invoice.mc
inventory,inventry.mc
scheduler,schedule.mc
contacts,contact.mc
calculator,calculat.mc
   o    	@                  i          
   date label   on mouseUp
  ask "Go to the first record with date" with the short date
  if it is empty then exit mouseUp
  convert it to long date
  repeat with i = 1 to the number of cards
    if field "date" of card i is it then
      lock screen
      go card i
      setarrows
      unlock screen with visual plain
      exit mouseUp
    end if
  end repeat
  answer information "No records with that date."
end mouseUp
          l            Event Date 
   label2            ~            Start Time 
   label1c         Y  4            	H      M 
   label3           6 x            Event Description 
   label2c         Y L 4            	H      M 
   label4           6 j            	End Time 
   label5           b l            	Location 
   label6            l            Purpose 
  g label9            a            Notes 
   
repeat label           p                w New Ex  :on mouseUp
  global gRegistered,gUseBlankRecord,gSkipChooseDate
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    toplevel "Register"
    exit mouseUp
  end if
  
  if gUseBlankRecord is empty then put false into gUseBlankRecord
  if gSkipChooseDate is empty then put false into gSkipChooseDate
  if  field "event" is empty then
    if gUseBlankRecord is false then
      answer information "You need to enter an event description " & return & \
          "for this record before creating another."
    end if
    put false into gUseBlankRecord
    if field "date" is empty then put the long date into field "date"
    exit mouseUp
  end if
  
  checkCompleted
  lock screen
  lock messages
  go last
  create card
  put the number of this card into field "record"
  hide group "wks"
  hide group "until"
  hide group "days"
  put empty into field "repeat label"
  put empty into field "repeatdates"
  put "none" into field "repeat"
  put 1 into field "days"
  put 1 into field "wks"
  set the label of button "repeat" to "Click to repeat"
  openCard
  setArrows
  unlock screen with visual plain
  if gSkipChooseDate is false then
    send mouseUp to button "choose"
  else
    put false into gSkipChooseDate
    click at the loc of field "event"
  end if
end mouseUp
            
LightPink    & A             	     
  > recNumLabel    $on mouseUp
  goCardNum
end mouseUp
         E            	Record # 
   date  	x  %on mouseUp
  global gStartDate
  
  if field "date" is empty then
    put the long date into temp
  else
    put field "date" into temp
  end if
  put temp into gStartDate
  
  get validateDate(temp)
  if it is empty then exit mouseUp
  put it into field "date"
  listRepeatDates
end mouseUp
        
           o  
   start time  
x  Oon mouseUp
  put "start time" into whichField
  put "end time" into altField
  put "Start Time" into prompt
  put "9:00 AM" into defaultTime
  put true into OKtoEmpty
  
  setTime whichfield,prompt,altField,defaultTime,OKtoEmpty
  if field "end time" is empty then put field "start time" into field "end time"
  checkTime
end mouseUp
          N         o  
   	end time  
x  Hon mouseUp
  put "end time" into whichField
  put "start time" into altField
  put "End Time" into prompt
  put "" into defaultTime
  put true into OKtoEmpty
  
  setTime whichfield,prompt,altField,defaultTime,OKtoEmpty
  if field "start time" is empty then put field "end time" into field "start time"
  checkTime
end mouseUp
         K N         o  
   event  )x   Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
        
 K          o  
   	location  )x   Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
        
 w          o  
   purpose  )x   Zon returnInField
  -- trap
end returnInField

on enterInField
  -- trap
end enterInField
        
           o  
   notes  )h         
           o        	`    @        D Today Ex  
 Pon mouseUp
  put the long date into field "date"
  listRepeatDates
end mouseUp
    
LightPink    [ 
 2              	        Edit Ex  
 7on mouseUp
  send mouseUp to field "date"
end mouseUp
    
LightPink     
 (              	        Choose Ex  
ton mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "date" into gStartDate
  put "date" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Date"
  modal stack "dates"
end mouseUp
    
LightPink     
 2              	        Edit Ex  
 =on mouseUp
  send mouseUp to field "Start time"
end mouseUp
    
LightPink   c 
 "              	       s First @V  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go first
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
    
LightPink      * ,  ?         	  o 	  o   t Prev @F  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go prev
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
    
LightPink     * ,  @         	  o   u Next @F  
 on mouseUp
  global gVeffect
checkCompleted
  lock screen
  go next
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
    
LightPink   ?  * ,  A         	  o   v Last @F  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go last
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
    
LightPink   e  * ,  B         	  o   x Delete Ex  on mouseUp
  if the number of cards = 1 then
    if (field "date" is empty) then
      answer information "There are no more records to delete."
    else
      lock screen
      clearCardOne
      put the long date into field "date"
    end if
    exit mouseUp
  end if
  
  answer question "Delete all records, old records or just this one?" with "All" or "Older" or "Just this one" or "Cancel"
  if it is "Cancel" then exit mouseUp
  unlock screen
  lock messages
  put the number of this card -1 into cardNum
  if it is "Older" then
    ask "Delete records older than what date?" with field "date"
    if it is empty or it is not a date then exit mouseUp
    unlock screen
    put it into theDate
    convert theDate to seconds
    lock screen
    repeat with i = the number of cards of this stack down to 2
      set cursor to busy
      put field "date" of card i into zdate
      convert zdate to seconds
      if zdate < theDate then  delete card i
    end repeat
    
    go card 1
    put field "date" of card 1 into zdate
    convert zdate to seconds
    if zdate < theDate then
      if the number of cards of this stack is 1 then
        clearCardOne
        put the long date into field "date"
      else
        delete card 1
      end if
    end if
  end if
  
  if it is "All" then
    lock screen
    repeat with i = the number of cards of this stack down to 2
      set cursor to busy
      delete card i
    end repeat
    clearCardOne
    put the long date into field "date"
    openCard
    setArrows
    unlock screen with visual plain
    exit mouseUp
  end if
  
  if it is "Just this one" then
    lock screen
    if the number of cards > 1 then
      delete this card
    else
      clearCardOne
      put the long date into field "date"
    end if
    go card cardNum
  end if
  
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  openCard
  setArrows
  unlock screen with visual plain
end mouseUp
            
LightPink   C& A             	       y Find Ex  on mouseUp
  global gFindStack, gFoundOne
  put "atFind" into zFindStack
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 220 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack zFindStack to it
  go card 1 of stack zFindStack
  show stack zFindStack
  select text of field "find" of stack zFindStack
end mouseUp
            
LightPink    @ A              	       z Sort Ex  on mouseUp
  answer question "Sort records by date or event description?" with  "Cancel" or "Event Description"  or "Date"
  if it is "Cancel" then exit mouseUp
  unlock screen
  lock screen
  lock messages
  repeat with i = 1 to the number of cards
    put empty into temp
    put field "start time"  of card i into startTime
    put field "date"  of card i into startDate
    convert startDate to dateItems
    convert startTime to dateItems
    put item 4 to 5 of startTime into item 4 to 5 of startDate
    repeat with n = 1 to 5
      if item n of startDate < 10 then
        put "0"&item n of startDate after temp
      else
        put item n of startDate after temp
      end if
    end repeat
    put temp into field "Start items" of card i
  end repeat
  sort this stack by field "Start items"
  if it is "Event Description" then
    sort this stack by field "Event"
  end if
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  openCard
  setArrows
  unlock screen with visual plain
end mouseUp
            
LightPink   C@ A              	       { Import Ex  &on mouseUp
  put the number of cards into znum
  if (the number of cards = 1) and (field "event" is empty) then
    put 1 into firstCard
  else
    answer question "Delete all records first or add to existing?" with "Delete" or "Add" or "Cancel"
    if it is "cancel" then exit mouseUp
    unlock screen
    if it is "Delete" then
      lock messages
      lock screen
      repeat with i = znum down to 2
        set cursor to busy
        delete card i
      end repeat
      put 1 into firstCard
      clearCardOne
      put false into renumberTasks
      unlock screen with visual plain
    else
      go card znum
      if znum = 1 then
        put 1.5 into znum
      end if
      put znum into firstCard
      put true into renumberTasks
    end if
  end if
  answer "Import Schedule Tracker or Palm file?" with "Palm" or "Schedule Tracker"
  if it is "Palm" then
    importPalm firstCard, renumberTasks -- in this script
  else
    importRecords firstCard, renumberTasks -- in this script
  end if
  setArrows
  openCard
  unlock screen with visual plain
  set cursor to watch
  save this stack
end mouseUp

on  importRecords  firstCard, renumberTasks
  -- read from file, create and populate new cards
  answer file "Select a schedule records file to import." with "schedule_records.txt"
  if the result is "Cancel" then exit to metacard
  unlock screen
  put it into fileName
  open file fileName for read
  if the result is empty then
    read from file fileName until eof
    put it into temp
    if word 1 of temp <> "Event" then
      answer error "This is not a valid schedule records file. Try again."
      close file fileName
      exit to metaCard
    end if
    put the number of lines of temp into znum
    lock messages
    lock recent
    lock screen
    if firstCard = 1.5 then
      add .5 to firstCard
      go card 1
    else
      if firstCard > 1 then
        add 1 to firstCard
      end if
      go card firstCard
    end if
    
    repeat with i = 2 to znum
      if line i of temp is empty then next repeat
      set cursor to busy
      if firstCard > 1 then create card
      put firstCard into field "record"
      put line i of temp into zline
      set the itemDelimiter to tab
      if NOT item 1 of zline is a date then next repeat
      put item 1 of zline into field "date"
      put item 2 of zline into field "event"
      put item 3 of zline into field "location"
      put item 4 of zline into field "purpose"
      put item 5 of zline into field "start time"
      put item 6 of zline into field "end time"
      put item 7 of zline into field "repeat"
      put item 8 of zline into field "until date"
      put item 9 of zline into field "days"
      put item 10 of zline into field "wks"
      put addReturns(item 11 of zline) into field "notes"
      listRepeatDates
      add 1 to firstCard
    end repeat
    close file fileName
    if renumberTasks then
      repeat with n = 1 to the number of cards
        put n into field "record" of card n
      end repeat
    end if
  else
    answer "There was a problem opening this file." & return & the result & return & sysError()
  end if
end  importRecords

on  importPalm  firstCard, renumberTasks
  -- read from file, create and populate new cards
  answer file "Select a palm calendar file to import." with "calendar_export.txt"
  if the result is "Cancel" then exit to metacard
  unlock screen
  put it into fileName
  open file fileName for read
  if the result is empty then
    read from file fileName until eof
    put it into temp
    put the number of lines of temp into znum
    lock messages
    lock recent
    lock screen
    if firstCard = 1.5 then
      add .5 to firstCard
      go card 1
    else
      if firstCard > 1 then
        add 1 to firstCard
      end if
      go card firstCard
    end if
    
    repeat with i = 1 to znum
      if line i of temp is empty then next repeat
      set cursor to busy
      if firstCard > 1 then create card
      put firstCard into field "record"
      put line i of temp into zline
      set the itemDelimiter to tab
      -- if NOT item 1 of zline is a date then next repeat
      put item 1 of zline into field "event"
      put item 2 of zline into zdate
      convert zdate to long date
      put zdate into field "date"
      if item 3 of zline is empty or (item 2 of zline = item 3 of zline) then
        put "none" into  field "repeat"
      else
        put "daily" into  field "repeat"
        put item 3 of zline into udate
        convert udate to long date
        set the itemDelimiter to comma
        put item 1 of udate into zday
        convert udate to short date
        set the itemDelimiter to tab
        put zday & "," && udate into field "until date"
        put 1 into field "days"
        listRepeatDates
      end if
      put item 4 of zline into field "start time"
      put item 5 of zline into field "end time"
      put item 6 of zline into field "notes" -- category 1
      if item 7 of zline is not empty then
        put return & item 7 of zline after field "notes" -- category 2
      end if
      add 1 to firstCard
    end repeat
    close file fileName
    if renumberTasks then
      repeat with n = 1 to the number of cards
        put n into field "record" of card n
      end repeat
    end if
  else
    answer "There was a problem opening this file." & return & the result & return & sysError()
  end if
end  importPalm

function addReturns temp
  repeat while offset(" | ",temp) > 0
    put offset(" | ",temp) into firstChar
    put firstChar + 2 into lastChar
    put return into char  firstChar to lastChar of temp
  end repeat
  return temp
end addReturns
            
LightPink    U A              	       | Export Ex  bon mouseUp
  global gElapsed
  if (the number of cards = 1) and (field "date" is empty) then
    answer information "There are no records to export."
    exit mouseUp
  end if
  
  answer question "Export to Schedule Tracker or Palm?" with "Cancel" or "Palm" or "Schedule Tracker "
  if it is "cancel" then exit mouseUp
  unlock screen
  if it is "Palm" then
    answer question "Export just this event or all events?" with "Cancel" or "Just this one" or "All"
    if it is "cancel" then exit mouseUp
    unlock screen
    if it is "Just this one" then
      put the number of this card into whichCard
    else
      put "all" into whichCard
    end if
    
    ask file "Save records as... " with "palm_calendar.txt"
    if the result is "Cancel" then exit mouseUp
    unlock screen
    put checkExt(it) into fileName
    put empty into whichDate
    
    -- save data from all cards to txt file
    open file fileName for write
    if the result is empty then
      lock messages
      lock screen
      put true into noRecords
      if whichCard is "all" then
        repeat with i = 1 to the number of cards
          set cursor to busy
          go card i
          if field "repeatDates" is empty then
            put field "date" into temp
            delete item 1 of temp
            write field  "event" & tab & temp & tab & tab & field "Start time" & tab & field "end time" \
                & tab & tab & return to file fileName
          else
            put field "repeatDates" into rDates
            repeat with n = 1 to the number of lines of rDates
              put line n of rDates into temp
              if temp is empty then exit repeat
              delete item 1 of temp
              write field  "event" & tab & temp & tab & tab & field "Start time" & tab & field "end time" \
                  & tab & "from Schedule Tracker" & return to file fileName
            end repeat
          end if
        end repeat
      else
        
        if field "repeatDates" is empty then
          put field "date" into temp
          delete item 1 of temp
          write field  "event" & tab & temp & tab & tab & field "Start time" & tab & field "end time" \
              & tab & tab & return to file fileName
        else
          put field "repeatDates" into rDates
          repeat with n = 1 to the number of lines of rDates
            put line n of rDates into temp
            if temp is empty then exit repeat
            delete item 1 of temp
            write field  "event" & tab & temp & tab & tab & field "Start time" & tab & field "end time" \
                & tab & "from Schedule Tracker" & return to file fileName
          end repeat
        end if
      end if
      setarrows
      saveData
      unlock screen with visual plain
      close file fileName
    else
      answer "There was a problem saving this file." & return & the result & return & sysError()
    end if
    exit mouseUp
  end if
  
  answer question "Export just this event or all events?" with "Cancel" or "Just this one" or "All"
  if it is "cancel" then exit mouseUp
  unlock screen
  if it is "Just this one" then
    put the number of this card into whichCard
    ask file "Save records as... " with char 1 to 10 of field "event" & "_"& "schedule.txt"
  else
    put "all" into whichCard
    put the date into whichDate
    repeat while offset("/",whichDate) > 0
      put "_" into char offset("/",whichDate) of whichDate
    end repeat
    ask file "Save records as... " with "all_schedule_records_" & whichDate & ".txt"
  end if
  if the result is "Cancel" then exit mouseUp
  unlock screen
  put checkExt(it) into fileName
  put empty into whichDate
  
  -- save data from all cards to txt file
  open file fileName for write
  if the result is empty then
    lock messages
    lock screen
    put true into noRecords
    if whichCard is "all" then
      write "Event Date" & tab & "Event Description" & tab & "Location" & tab & \
          "Purpose" & tab & "Start Time" & tab & "End Time" & tab & "Repeat" & tab \
          & "Repeat Until" & tab & "Days" & tab & "Weeks" & tab & "Notes" & return to file fileName
      repeat with i = 1 to the number of cards
        set cursor to busy
        go card i
        put field "notes" into tnotes
        repeat while offset(return,tnotes) > 0
          put " | " into char offset(return,tnotes) of tnotes
        end repeat
        
        write field  "date" & tab & field  "event" & tab & field "location" & tab & \
            field "purpose" & tab & field "Start time" & tab & field "end time" & tab & \
            field "repeat" & tab & field "until date" & tab & field "days" & tab & field "wks" & tab \
            & tnotes & return to file fileName
        
      end repeat
      setarrows
      saveData
    else -- just export this card
      
      write "Date:" && field  "date" & return & "Event:" && field  "event" & return \
          & "Location:" && field "location" & return & "Purpose:" && field "purpose" & return \
          & "Start Time:" && field "Start time" & return & "End Time:" && field "end time" & return & \
          "Repeating on the following dates:" & return & field "repeatDates"  & return & return & \
          "Notes:" &&  tnotes & return to file fileName
      
    end if
    unlock screen with visual plain
    close file fileName
    
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
            
LightPink   CU A              	       } Prefs Ex   "on mouseUp
  goPrefs
end mouseUp
    
LightPink    j A              	        Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "sHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  goHelp "schedule tracker", helpStack, zStack
end mouseUp
    
LightPink   Cj A              	        Quit ux   (on mouseUp
  quitSBTracker
end mouseUp
    
LightPink     A      Quit          	        Save Ux   Kon mouseUp
  set cursor to watch
  save this stack
  saveData
end mouseUp
    
LightPink   C A              	        View Schedule Ex  on mouseUp
  global gCurrentContact,gChars
  if gChars is empty then put 70 into gChars
  
  if the number of cards is 1 and field "event" is empty then
    answer information "There are no records to report."
    exit mouseUp
  end if
  lock screen
  checkCompleted
  checkData
  put the number of this card into gCurrentContact
  if the openStacks contains "sLists" then close stack "sLists"
  setHeight "sLists"
  topLevel "sLists"
  setLoc "sLists"
  if field "date" of stack "sLists" is empty then
    put the long date into field "date" of stack "sLists"
  end if
  send mouseUp to button "create report" of stack "sLists"
  unlock screen with visual plain
end mouseUp
    
LightPink                  	     
   start items  !h          t         o             	D                   P !     Y  ~ >           > ~ ~     <      ?           ?                          UpSH A don mouseDown
  adjustTime "up","start time","hr"
end mouseDown

on mouseUp
  checkTime
end mouseUp
    
LightPink @ P                	        DnSH A fon mouseDown
  adjustTime "down","start time","hr"
end mouseDown

on mouseUp
  checkTime
end mouseUp
    
LightPink @ P )               	           	D                   k !     Y  ~ >           > ~ ~     <      ?           ?                          UpSM A eon mouseDown
  adjustTime "up","start time","min"
end mouseDown

on mouseUp
  checkTime
end mouseUp
    
LightPink @ k                	        DNSM A gon mouseDown
  adjustTime "down","start time","min"
end mouseDown

on mouseUp
  checkTime
end mouseUp
    
LightPink @ k )               	           	D                   k O     Y  ~ >           > ~ ~     <      ?           ?                             	D                   P O     Y  ~ >           > ~ ~     <      ?           ?                          UpEH A bon mouseDown
  adjustTime "up","end time","hr"
end mouseDown

on mouseUp
  checkTime
end mouseUp
    
LightPink @ P M               	        DnEH A don mouseDown
  adjustTime "down","end time","hr"
end mouseDown

on mouseUp
  checkTime
end mouseUp
    
LightPink @ P W               	        UpEM A con mouseDown
  adjustTime "up","end time","min"
end mouseDown

on mouseUp
  checkTime
end mouseUp
    
LightPink @ k M               	        DnEM A eon mouseDown
  adjustTime "down","end time","min"
end mouseDown

on mouseUp
  checkTime
end mouseUp
    
LightPink @ k W               	        Edit Ex  
 ;on mouseUp
  send mouseUp to field "end time"
end mouseUp
    
LightPink   c 8 "              	     
   record  x    %on mouseUp
  goCardNum
end mouseUp

       Z  *         o 1 
   repeat  h          v f         o none    repeat 	}  &on menuPick which
  lock screen
  put which into field "repeat"
  put field "date" into zdate
  convert zdate to dateitems
  openCard
  if field "repeat" is "none" then exit to metaCard
  --  if field "until date" is empty then
  switch which
  case "daily"
    add 5 to item 3 of zdate
    break
  case "weekly"
    add 2 to item 2 of zdate
    break
  case "Week Days"
    add 2 to item 2 of zdate
    break
  case "monthly"
    add 2 to item 1 of zdate
    break
  case "yearly"
    add 10 to item 1 of zdate
    break
  case "day of month"
    add 2 to item 1 of zdate
  end switch
  convert zdate to abbr date
  put word 1 of zdate into zday
  convert zdate to short date
  put zday && zdate into field "until date"
  listRepeatDates -- in stack script
  unlock screen with visual plain
end menuPick
            
LightPink            Click to repeat    8None
Daily
Weekly
Week Days
Day of Month
Monthly
Yearly         	  o 	        until   a           3
   until date  	x  on mouseUp
  global gStartDate
  
  if field "until date" is empty then
    if field "date" is empty then
      put the date into temp
    else
      put field "date" into temp
    end if
  else
    put item 2 of field "until date" into temp
  end if
  put temp into gStartDate
  
  convert temp to short date
  ask "Enter a date to stop repeating this event." with temp
  if the result is "cancel" then exit mouseUp
  if it is empty then
    abort
  end if
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid date. Try again." with the date
    if the result is "cancel" then exit mouseUp
    if it is empty then abort
    if it is not a date then
      answer "You entered an invalid date. Try again."
      abort
    end if
  end if
  put it into temp
  convert temp to abbr date
  put word 1 of temp into zday
  convert temp to short date
  put zday && temp into field "until date"
  listRepeatDates -- in stack script
end mouseUp

on abort
  put empty into field "until date"
  put empty into field "repeatdates"
  put "none" into field "repeat"
  openCard
  exit to metaCard
end abort
                   o     
EditUntil ex  
 =on mouseUp
  send mouseUp to field "Until Date"
end mouseUp
    
LightPink   (  (      Edit          	        
Choose Until ex  
on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "until date" into gStartDate
  put "until date" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Select a Stop Repeat Date"
  modal stack "dates"
end mouseUp
    
LightPink   R  2      Choose          	         Until  D
   mon mouseUp
  set the visible of  field "repeatdates" to NOT the visible of  field "repeatdates"
end mouseUp
    
LightPink      $              	  o 	        wks   a       K h E !
   wks  x  	on mouseUp
  if field "wks" is empty then put 1 into field "wks"
  ask "Repeat every how many weeks? (2 = every other week)" with field "wks"
  if the result is "cancel" then exit mouseUp
  if it is empty then
    put "none" into field "repeat"
    openCard
    exit mouseUp
  end if
  if it is not a number then
    answer error "Enter numbers only. Please try again."
    put "none" into field "repeat"
    openCard
  else
    put trunc(it) into field "wks"
    listRepeatDates -- in stack script
  end if
end mouseUp
       O l          o     wks  D
     
LightPink   d q (              	  o 	        days   a       K h E !
   days  x  on mouseUp
  if field "days" is empty then put 1 into field "days"
  ask "Repeat every how many days? (2 = every other day)" with field "days"
  if the result is "cancel" then exit mouseUp
  if it is empty then
    put "none" into field "repeat"
    openCard
    exit mouseUp
  end if
  if it is not a number then
    answer error "Enter numbers only. Please try again."
    put "none" into field "repeat"
    openCard
  else
    put trunc(it) into field "days"
    listRepeatDates -- in stack script
  end if
end mouseUp
       O l          o     days  D
     
LightPink   d q (              	  o 
   repeatDates  !h         
 9 Z        o        	`    @   : X   1 
Main Menu }    `on menuPick which
  checkCompleted
  set cursor to watch
  goSBTrackerStack which
end menuPick
    
LightPink    
       Small Business Tracker Menu   Activity && Expense Tracker
Contact Tracker - Address Book
(Schedule Tracker - Calendar
Task Tracker - To Do List
-
Inventory Tracker
Invoice Tracker
Password Tracker
Vehicle Expense Tracker
-
Universal Calculator
Version Tracker
Writer's Helper
Small Business Tracker Welcome
       	       
 sLists   on closeCard
  global gDontSave
  put true into gDontSave
  if the visible of group "font" then hide group "font"
end closeCard
  w        Black    Cyan ffffff      white       	darkgray    
 ?         Monthly Schedule      U Arial   U Arial   U 
Helvetica   U 
Helvetica   W Arial   W 
Helvetica   W Arial   W 
Helvetica  
 U 
Helvetica  
 U Arial   U 
Helvetica  	 U 
Helvetica   U Georgia   U Georgia   U Georgia  
 U Georgia   U Geneva   U Geneva   U Minion Web   U GarthGraphic ExtraBold       	@          ?&                                         options   i         2    
List Options  D     
LightPink      h              	      Day @D   on mouseUp
  set the disabled of button "Show all times" to false
  set the title of this stack to "Daily Schedule"
  send mouseUp to button "create report"
end mouseUp
    
LightPink    q  8              	      Week @D   on mouseUp
  set the disabled of button "Show all times" to false
  set the title of this stack to "Weekly Schedule"
  send mouseUp to button "create report"
end mouseUp
    
LightPink      >              	     Month @D   on mouseUp
  set the hilite of button "Show all times" to false
  set the disabled of button "Show all times" to true
  set the title of this stack to "Monthly Schedule"
  send mouseUp to button "create report"
end mouseUp
    
LightPink      H              	      Create Report Ex  *on mouseUp
  global gSchedTabs,gCurrentDate
  lock screen
  put empty into field "report"
  if the hilitedButtonName of group "options" is empty then
    set the hilitedButtonName of group "options" to "Day"
    set the title of this stack to "Daily Schedule"
  end if
  
  if gSchedTabs is empty then
    if the hilite of button "Show purpose" then
      set the tabstops of field "report" to "15,75,135,275,400,600"
    else
      set the tabstops of field "report" to "15,75,135,330,600"
    end if
  else
    set the tabstops of field "report" to gSchedTabs
  end if
  
  -- initialize startDate and endDate
  if field "date" is empty then put the long date into field "date"
  put field "date" into temp
  convert temp to dateitems
  put convertDate(temp) into startDate
  if the hilite of button "Day" then put startDate into endDate
  if the hilite of button "Week" then
    put field "date" into temp
    convert temp to dateitems
    put item 1 of temp into zyear
    put item 2 of temp into zmonth
    put item 3 of temp into zday
    put daysofmonth(zmonth, zyear) into numdays
    put zday + 6 into test
    if test > numdays then
      add 1 to item 2 of temp
      put test - numdays into item 3 of temp
    else
      add 6 to item 3 of temp
    end if
    put convertDate(temp) into endDate
  end if
  if the hilite of button "Month" then
    put field "date" into temp
    convert temp to dateitems
    add 1 to item 2 of temp
    put convertDate(temp) into endDate
  end if
  
  -- populate zsorter
  set the itemdelimiter to tab
  repeat with i = 1 to the number of cards of stack "scheduler"
    if field "date" of card i of stack "scheduler" is empty then next repeat
    if field "event" of card i of stack "scheduler" is empty then next repeat
    put field "date" of card i of stack "scheduler" into zdate
    convert zdate to dateitems
    put convertDate(zdate) into zdate
    if field "repeat" of card i of stack "scheduler" is "none" then
      if zdate < startDate then next repeat
      if zdate > endDate then next repeat
      put addzSorterLine(zdate,i)  & return after zSorter
    else
      put field "repeatDates" of card i of stack "scheduler" into rDates
      repeat with n = 1 to the number of lines of rDates
        put line n of rDates into temp
        convert temp to dateItems
        put convertDate(temp) into zdate
        if zdate < startDate then next repeat
        if zdate > endDate then exit repeat
        if zdate is empty then exit repeat
        put addzSorterLine(zdate,i)  & return after zSorter
      end repeat
    end if
  end repeat
  delete last char of zsorter -- return
  if zsorter is empty then
    answer "There were no records found with these options."
    unlock screen with visual plain
    exit to metaCard
  end if
  sort lines of zsorter by item 3 of each
  sort lines of zsorter by item 2 of each
  
  -- initialize new variables
  set the itemdelimiter to comma
  put field "date" into startDate
  convert startDate to dateitems
  put convertDate(startDate) into gCurrentDate -- 8 numbers
  put startDate into startTime -- dateitems
  put 7 into item 4 of startTime
  put 0 into item 5 of startTime
  put convertTime(gCurrentDate,startTime) into timeCount -- 12 numbers
  put "2345" into char 9 to 12 of endDate -- 12 numbers
  put 1 into zsorterLine
  
  --====================================================
  -- begin adding lines to report
  put field "date" & return into field "report"
  put tab & "Start" & tab & "End" & tab & "Event Description" & tab & "Location" & tab & "Purpose" & return after field "report"
  
  -- if there are events before 7AM on startDate then
  set the itemdelimiter to tab
  repeat while item 2 of line zsorterLine of zsorter < convertTime(gCurrentDate,startTime)
    if item 2 of line zsorterLine of zsorter is empty then exit repeat
    addLine2report (item 4 of line zsorterLine of zsorter),(item 1 of line zsorterLine of zsorter)
    add 1 to zsorterLine
  end repeat
  
  if the hilite of button "Show All Times" then
    global gAM,gPM
    
    put char 9 to 12 of convertTime(gCurrentDate,gAM) into AMlimit
    put char 9 to 12 of convertTime(gCurrentDate,gPM) into PMlimit
    repeat while timeCount <= endDate -- each 12 numbers
      put char 9 to 12 of  timeCount into temp
      if temp >= AMlimit AND temp <= PMlimit then
        put num2time(timeCount) & return after field "report"
      end if
      if temp = 930 or temp = 1130 or temp = 1230 or temp = 1430 or temp = 1630 then
        put addSeparator(75,"- ") & return after field "report"
      end if
      set the itemdelimiter to comma
      if item 4 of startTime > 23 then -- new day
        add 1 to item 3 of startTime
        put convertDate(startTime) into gCurrentDate
        put 7 into item 4 of startTime
        put 0 into item 5 of startTime
        put convertTime(gCurrentDate,startTime) into timeCount
        if timeCount < endDate then
          put addSeparator(75,"= ") & return after field "report"
          put num2date(timeCount) & return after field "report"
          put tab & "Start" & tab & "End" & tab & "Event Description" & tab & "Location" & tab & "Purpose" & return after field "report"
        end if
      else -- increment time
        if item 5 of startTime is 0 then
          put 30 into item 5 of startTime
        else
          add 1 to  item 4 of startTime
          put 0 into item 5 of startTime
        end if
        put convertTime(gCurrentDate,startTime) into timeCount
      end if
      
      set the itemdelimiter to tab
      repeat while item 2 of line zsorterLine of zsorter < convertTime(gCurrentDate,startTime)
        if item 2 of line zsorterLine of zsorter is empty then exit repeat
        addLine2report (item 4 of line zsorterLine of zsorter),(item 1 of line zsorterLine of zsorter)
        add 1 to zsorterLine
      end repeat
      
    end repeat
  else -- don't show all times, just events
    repeat with i = zsorterLine to the number of lines of zsorter
      if line i of zsorter is empty then exit repeat
      addLine2report (item 4 of line i of zsorter),(item 1 of line i of zsorter)
    end repeat
  end if
  unlock screen with visual wipe down
end mouseUp

on addLine2report cardNum,zDate
  global gCurrentDate,gChars,gTemp,gTemp2,gTemp3
  
  if cardNum is not a number then exit addLine2report
  set the itemdelimiter to tab
  set cursor to busy
  if zDate <> gCurrentDate then
    put addSeparator(75,"= ") & return after field "report"
    put num2date(zDate) & return after field "report"
    put tab & "Start" & tab & "End" & tab & "Event Description" & tab & "Location" & tab \
        & "Purpose" & return after field "report"
    put zDate into gCurrentDate
  end if
  
  put empty into gTemp2
  put empty into gTemp3
  put field "start time" of card cardnum of stack "scheduler" into item 2 of gTemp
  put field "end time" of card cardnum of stack "scheduler" into item 3 of gTemp
  if the hilite of button "Show purpose" then
    put trunc(gChars * .60) into zChars
  else put gChars into zChars
  put field "event" of card cardnum of stack "scheduler" into temp --item 4 of temp
  if length(temp) > zChars then
    handleLongEvents temp,4,zChars
  else put temp into item 4 of gTemp
  put field "location" of card cardnum of stack "scheduler" into temp --item 5 of temp
  if length(temp) > zChars then
    handleLongEvents temp,5,zChars
  else put temp into item 5 of gTemp
  if the hilite of button "Show purpose" then
    put field "purpose" of card cardnum of stack "scheduler" into temp --item 6 of temp
    if length(temp) > zChars then
      handleLongEvents temp,6,zChars
    else put temp into item 6 of gTemp
  end if
  put cardnum into item 7 of gTemp
  put gTemp & return after field "report"
  if gTemp2 <> empty then
    put gTemp2 & return after field "report"
  end if
  if gTemp3 <> empty then
    put gTemp3 & return after field "report"
  end if
  if the hilite of button "Show Notes" AND (field "notes" of card cardnum of stack "scheduler" <> empty) then
    put field "notes" of card cardnum of stack "scheduler" & return & return after field "report"
  end if
end addLine2report

on handleLongEvents temp,itemNum,zChars
  global gTemp,gTemp2,gTemp3
  set the itemdelimiter to tab
  put false into repeatFlag
  repeat with repeatCounter = 1 to 4
    if length(temp) > zChars then
      put char 1 to zChars of temp into temp2
      put 0 into charCounter
      repeat while last char of temp2 <> space
        delete last char of temp2
        add 1 to charCounter
      end repeat
    else
      put true into repeatFlag
      put temp into temp2
    end if
    if repeatCounter is 1 then  put temp2 into item itemNum of gTemp
    if repeatCounter is 2 then  put temp2 into item itemNum of gTemp2
    if repeatCounter is 3 then  put temp2 into item itemNum of gTemp3
    if repeatCounter is 4 then
      put "..." after item itemNum of gTemp3
      exit repeat
    end if
    delete char 1 to (zChars - charCounter) of temp
    if repeatFlag then exit repeat
  end repeat
end handleLongEvents

function addzSorterLine zdate,cardnum
  set the itemdelimiter to tab
  put zdate into item 1 of temp
  put convertTime(zdate,field "start time" of card cardnum of stack "scheduler") into item 2 of temp
  put convertTime(zdate,field "end time" of card cardnum of stack "scheduler") into item 3 of temp
  put cardnum into item 4 of temp
  return temp
end addzSorterLine

function convertDate zdate -- converts dateitems to number
  put item 1 of zdate into temp
  repeat with n = 2 to 3
    if item n of zdate < 10 then
      put "0" & item n of zdate after temp
    else
      put item n of zdate after temp
    end if
  end repeat
  return temp & "0000"
end convertDate

function convertTime zdate,ztime -- converts dateitems & field time to number
  convert ztime to dateitems
  put char 1 to 8 of zdate into temp
  repeat with n = 4 to 5
    if item n of ztime < 10 then
      put "0" & item n of ztime after temp
    else
      put item n of ztime after temp
    end if
  end repeat
  return temp
end convertTime

function num2date zdate
  put the date into longDate
  convert longDate to dateitems
  put char 1 to 4 of zdate into item 1 of longDate
  put char 5 to 6 of zdate into item 2 of longDate
  put char 7 to 8 of zdate into item 3 of longDate
  convert longDate to long date
  return longDate
end num2date

function num2time ztime
  put the date into temp
  convert temp to dateitems
  put char 1 to 4 of ztime into item 1 of temp
  put char 5 to 6 of ztime into item 2 of temp
  put char 7 to 8 of ztime into item 3 of temp
  put char 9 to 10 of ztime into item 4 of temp
  put char 11 to 12 of ztime into item 5 of temp
  convert temp to time
  return temp
end num2time

function addSeparator howmany,which
  repeat with i = 1 to howmany
    put which after temp
  end repeat
  return temp
end addSeparator
    
LightPink     t             	        bg  @h     
LightPink    	 + E            	   	        font   a         4   font bg E`   
LightPink     ,             	        bgrect   K@              v    
   fonts  )x   won mouseUp
  put the hilitedlines of me into temp
  set the textfont of field "report" to line temp of me
end mouseUp
                      
.Keyboard  
AGaramond  AGaramond Italic  AGaramond Semibold  AGaramond SemiboldItalic  Andale Mono  Arial  Arial Black  B Friz Quadrata Bold  C Helvetica Condensed  	Capitals  CB Helvetica Condensed Bold  	Charcoal  Chicago  Comic Sans MS  Courier  Courier New  
FrenchScript  Friz Quadrata  Gadget  
GarthGraphic  GarthGraphic Black  GarthGraphic Bold  GarthGraphic BoldCondensed  GarthGraphic BoldItalic  GarthGraphic Condensed  GarthGraphic ExtraBold  GarthGraphic Italic  Geneva  Georgia  
Helvetica  Impact  	Kidprint  L Helvetica Light  LB Helvetica Black  
Lydian MT  Minion Web  Monaco  Monotype Sorts  
Monotype.com  	MT Extra  	New York  	Palatino  Sand  Swing  Swis721 BdCn BT  Swis721 BdCnOul BT  Swis721 BdOul BT  Swis721 BdRnd BT  Swis721 BlkCn BT  Swis721 BlkOul BT  Swis721 BlkRnd BT  Swis721 BT  Swis721 Hv BT  Swis721 It BT  Swis721 LtCn BT  Swis721 Th BT  Symbol  Techno  Tekton  Tekton Bold  Textile  Times  Times New Roman  
Trebuchet MS  Verdana  	Webdings  
Wingdings  Zapf Dingbats       	`    @        Close Ex   `on mouseUp
  lock screen
  hide group "font"
  unlock screen with visual wipe left
end mouseUp
    
LightPink     L              	     
   inst 	                      +Pick a font face and size for your report.    sizes   i   on mouseUp
  set the textSize of field "report" to word 1 of the hilitedButtonName of me
  put the textHeight of field "report" into field "lheight"
end mouseUp
         z K   9 pt @D   
LightPink     8              	      10 pt @D   
LightPink     8              	     11 pt @D   
LightPink     8              	      12 pt @D   
LightPink     8              	      14 pt @D   
LightPink     8              	      16 pt @D   
LightPink     8              	   
   label3 	         ]N ,           jAfter making changes to the font or size, you may need to adjust the tabs and other numbers to the right. 
   label2 
          T             Line Height 
   lheight  7)x  on mouseUp
  put field "lheight" into temp
  put the hilitedButtonName of group "sizes" into tsize
  ask "Enter a new line height > " & tsize &"." with temp
  if it is empty  then exit mouseUp
  if  it is not a number or it < tsize then
    answer information "You must enter a number larger than the font size."
    exit mouseUp
  end if
  put it into field "lheight"
  set the textHeight of field "report" to it
end mouseUp
         '            13    Tabs Ex  on mouseUp
  global gSchedTabs
  answer question "Set the tab stops to" with "Default" or "Custom"
  switch it
  case "Default"
    if the hilite of button "Show purpose" then
      set the tabstops of field "report" to "15,75,135,275,425,600"
    else
      set the tabstops of field "report" to "15,75,135,330,600"
    end if
    put the tabstops of field "report" into gSchedTabs
    break
    
  case "Custom"
    if gSchedTabs is empty then put the tabstops of field "report" into gSchedTabs
    ask "Set the tab stops of the report field to" with gSchedTabs
    if it is empty then exit mouseUp
    put true into flag
    repeat with i = 1 to 3
      if item i of it is a number then
        put true into flag
      else
        put false into flag
      end if
    end repeat
    if flag then
      set the tabstops of field "report" to it
      put it into gSchedTabs
    end if
  end switch
end mouseUp
    
LightPink    4              	     
   label5 
         T ,           Characters  per column 
   chars  7)x  |on mouseUp
  global gChars
  put field "chars" into temp
  ask "How many characters per column would you like to display?" with temp
  
  if it is empty then exit mouseUp
  if it is not a number then
    answer information "You must enter a number ."
    exit mouseUp
  end if
  put it into field "chars"
  put it into gChars
  send mouseUp to button "create report"
end mouseUp
        '            40   
 
Default Font Ex   on mouseUp
  set the hilitedButtonName of group "sizes" to "10 pt"
  send mouseUp to group "sizes"
  set the textfont of field "report" to  "Arial"
  send mouseUp to button "font"
end mouseUp
    
LightPink    `              	     
   report 	x 	 
 )on mouseUp
  goReportLine 7
end mouseUp
        	 X+< 
 
 
 
     K X                	`    @ # Y :    Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "sHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  goHelp "view schedule", helpStack, zStack
end mouseUp
    
LightPink    0 H             	        
Close Window Ex   [on mouseUp
  lock screen
  close this stack
  unlock screen with visual plain
end mouseUp
    
LightPink                  	        Save as... Ux  :on mouseUp
  
  put the date into whichDate
  put whichDate into temp
  repeat while offset("/",temp) > 0
    put "_" into char offset("/",temp) of temp
  end repeat
  ask file "Save schedule as... " with "schedule_" & temp & ".txt"
  if the result is "Cancel" then exit mouseUp
  put checkExt(it) into fileName
  
  -- save data from all cards to txt file
  open file fileName for write
  if the result is empty then
    lock messages
    lock screen
    set itemdelimiter to tab
    repeat with i = 1 to the number of lines of field "report"
      put line i of field "report" into temp
      delete item 7 of of temp
      write temp & return to file filename
    end repeat
    close file fileName
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
    
LightPink    X             	        Font Ux  on mouseUp
  global gChars
  lock screen
  put the fontNames into field "fonts"
  sort field "fonts"
  repeat with i = 1 to the number of lines of field "fonts"
    if the textfont of field "report" is line i of field "fonts" then
      set the hilitedlines of field "fonts" to i
      exit repeat
    end if
  end repeat
  if gChars is empty then put 20 into gChars
  put gChars into field "chars"
  put the textHeight of field "report" into field "lheight"
  show group "font"
  unlock screen with visual wipe right
end mouseUp
    
LightPink   p H             	        Print Ux   &on mouseUp
  printReport
end mouseUp
    
LightPink    H             	        size   a         ` Z
   short  )h 	 
       d  <           button "Help"	48,410,120,431  &button "Close Window"	129,410,261,431  $button "Save as..."	270,410,358,431  button "Font"	368,410,440,431  button "Print"	449,410,521,431  field "report"	9,88,564,404       	`    @ s e  : 
   long  )h 	 
       d  <           button "Help"	48,520,120,541  &button "Close Window"	129,520,261,541  $button "Save as..."	270,520,358,541  button "Font"	368,520,440,541  button "Print"	449,520,521,541  field "report"	9,88,564,512       	`    @  e  :    putLong Ex  
;on mouseUp
  put "long" into whichField
  put empty into field whichField
  repeat with i = 1 to 5
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of field "report" & tab & the rect of field "report" after field whichField
end mouseUp
    
LightPink     :              	        setLong Ex  
kon mouseUp
  set itemdelimiter to tab
  put "long" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
    
LightPink     :              	        	putShort Ex  
<on mouseUp
  put "short" into whichField
  put empty into field whichField
  repeat with i = 1 to 5
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of field "report" & tab & the rect of field "report" after field whichField
end mouseUp
    
LightPink     :              	       	 	setShort Ex  
lon mouseUp
  set itemdelimiter to tab
  put "short" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
    
LightPink   G  :              	        Show All Times @E   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
    
LightPink     % x              	        
Show Purpose @E   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
    
LightPink     % t              	       Show Notes @E   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
    
LightPink     % h              	     
   date label         d  g            Start Date 
   date  	x  Lon mouseUp
  global gStartDate
  
  if field "date" is empty then
    put the long date into temp
  else
    put field "date" into temp
  end if
  put temp into gStartDate
  
  convert temp to short date
  ask "Enter a Start Date" with temp
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid Start Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Start Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    end if
  end if
  put it into temp
  convert temp to long date
  put temp into field "date"
  send mouseUp to button "create report"
end mouseUp
       d *               Edit Ex  
 7on mouseUp
  send mouseUp to field "date"
end mouseUp
    
LightPink     (              	        Choose Ex  
ton mouseUp
  global gDateField,gStack,gStartDate
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "date" into gStartDate
  put "date" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Select a Start Date"
  go stack "dates"
end mouseUp
    
LightPink     2              	     
   instruction 	  
        8            NClick any options to get an updated list. Click an event to go to its record.    sHelp   on closeStack
  set the locktext of field "main" to true
  set the traversalOn of  field "main"  to false
  hide group "devtools"
end closeStack

on closeCard
  -- trap
end closeCard
  w        Black    Cyan ffffff      white       	darkgray    !w             Help      U Arial  
 U 
Helvetica   U 
Helvetica   U 
Helvetica   W 
Helvetica  @W 
Helvetica  PW 
Helvetica  U 
Helvetica  @U 
Helvetica  W 
Helvetica   U 
Helvetica   W 
Helvetica   W 
Helvetica   W 
helvetica  @U 
helvetica  @W 
helvetica  PW 
helvetica  U 
Helvetica  W 
Helvetica    About Help   	@          w       	Tutorial   	@          w       Schedule Tracker   	@          w       View Schedule   	@          w       Preferences   	@          w       Keyboard Shortcuts   	@          w      / Adding a New Event Record   	@          w    1 Adjusting the Date   	@          w    2 Adjusting the Time   	@          w    3 Background Color   	@          w     Button Colors   	@          w    : Choose Date   	@          w    D Default Settings   	@          w    I 
Edit Date   	@          w    K Deleting Records   	@          w    L 
Edit Time   	@          w    M Exporting Records   	@          w     
First Record   	@          w     Font   	@          w    R 
Go to Record   	@          w    U Help   	@          w    V Highlight Color   	@          w    W Importing Records   	@          w     Last Record   	@          w    Z Look and Feel   	@          w     Next Record   	@          w     Prev Record   	@          w     	Printing   	@          w    g Quit   	@          w    h 	Record #   	@          w    i 
Registration   	@          w    j Schedule Options   	@          w     
Repeating   	@          w     Save As...   	@          w    n Save Record   	@          w    o Searching Records   	@          w    v Sorting Records   	@          w     Tabs   	@          w    y Time Format   	@          w    { Visual Effects   	@          w     Help Index   	@          w    !               help   i          t
   main  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the traversalOn of me to true
    exit mouseUp
  end if
  if the textstyle of the clickChunk contains "group" then
    put the clickText into temp
    if last char of temp is "." then delete last char of temp
    if there is a card temp then
      push card
      go card temp
    end if
  end if
end mouseUp
         Xl(         
Repeating 
  @        	   jIf the event will be repeated at the same time each day, week, month or year, use the Repeating feature.  
       V
 @        Black  V 	
     _ 
  
         You can choose to have the event repeat Daily, Weekly, Week Days, Monthly, Yearly or for a particular Day of the Month, such as the third Thursday. Just click the Click to repeat button and choose one of these options.  
       (
     ( 
     - 
     / 
     5 
     7 	
     @ 
     B 
     Q 
     f 
     w ,
      
      )  
         A dialog will ask you for a date to stop repeating the event. You may change this date later, but you must enter a date that is later than the one in the Date field.  
       b
 @      Blue  b 8
 @      Blue   
 @      Blue   
        
         If you choose Daily, another field will appear where you can specify how often you want the event to repeat. For example if the event repeats every third day, click on this field and enter 3. 
       
      
        
         If you choose Weekly, another field will appear where you can specify how often you want the event to repeat. For example if the event repeats every other week, click on this field and enter 2. 
       
      
        
         {You can view and edit the list of repeating dates by clicking the word Until that appears after selecting a repeat option. 
       G
     G 
     L . If you edit this list, be sure you don't put two dates on the same line, have any blank lines or use date formats different than what you see. To hide this field, click the word Until again or go to another record. 
         
           Schedule Tracker 
  @          
  @          NThe Schedule Tracker window is where you will add all your event information. 
 @        Black    M  fEach "record" in Schedule Tracker consists of the date of the event, the event description, the start and stop times, the location, the purpose, repeating information, plus any notes.  You can add new records or edit the information for any record at any time. You must specify a date and event description in order for the event to appear in your schedule. 
       
 @        Black   
     " 
 @      Blue  `   Dates and Times 
  @          CThe Date field is automatically filled in. If it is incorrect, you can click on the field, or the Edit button, to enter another date. You can also use the date chooser by clicking Choose. See Choose Date for more information. You can go directly to the first record with a particular date by clicking the Start Date label. 
       
      
      Z
     b 
     f N
      
      
  @       
      
      O
    1 

    ;    The Start Time, and End Time fields are optional. If left blank the event will be listed first in the schedule for that day. For more information see Adjusting the Time .  
       
      

      
      
      z
  @       
        
         *The Event Description field is required.  
       
      
        If the event will be repeated at the same time each day, week, month or year, use the Repeating feature. You can choose to have the event repeat Daily, Weekly, Week Days, Monthly, Yearly or for a particular Day of the Month, such as the third Thursday. Just click the Click to repeat button and choose one of these options. A dialog will ask you for a date to stop repeating the event. You may change this date later, but you must enter a date that is later than the one in the Date field. If you choose Daily or Weekly, another field will appear where you can specify how often you want the event to repeat. For example if the event repeats every other day (or week), click on this field and enter 2. 
       V
 @      blue  V 	
     _ 2
      
      
      
      
      	
      
      
      
      
      ,
     
     
 @      Blue  8
 @      Blue  
 @      Blue  
     
     
     
     
       
         0Adding, Deleting, Searching and Sorting Records 
  @        /   To add a new event (or record) click the New button. The current date will be automatically filled in. Enter the Event Date, Start Time, End Time, Event Description, Location, Purpose, any Repeating  information, and any  notes about the event. 
       )
     ) 
     , D
     p 
     { 
     } 

      
      
      
      %
      
 @      blue   	
      .  <You may delete one or all of the records by clicking the Delete button. You will be asked if you want to delete just the record you are on, all records, or just those older than a certain date. If you choose the last option you will be asked for a date. You may want to export the records, before deleting them all. 
       9
     9 
     ?    Search for text in any record by clicking Find. You can search for the first few characters of a word or complete words. You may also limit your search to words with the exact capitalization as the word you enter, by clicking "case sensitive". 
       *
     * 
     .   
         You can sort records by clicking the Sort button. All records will be sorted by the Event Date. All records are renumbered after sorting. 
       %
     % 
     ) +
     T 
     _ *  
         Import and Exporting Records 
  @           You can import or export the records to a tab delimited text file by clicking the Import or Export button. There are several reasons you might want to do this: 
       R
     R 
     X 
     \ 
     b =  
        1) If you work in a small office or workgroup, each person can keep track of their own schedule, then export their records and send the file to an administrator. They will then be able to import the data and generate daily, weekly and monthly schedules for the whole group.    2) Rather than archiving the whole program, you might want to export all the records and just archive the much smaller text file.    3) When updating to a newer version of the program, you should export all your records and then import them into the new version.    V4) If you wanted to export the records to a spreadsheet or a word processing program.    a5) If you use the Palm Desktop program, you can import or export your schedule and appointments.    The exported file is called schedule_records.txt with contains the data for all the records. You can change this name if you wish. Be sure to make a note of its location.  
       
 @      Red   
     0 S
 @      Blue   (   You can export one or all records, or records that are newer or older than a certain date. See Exporting Records for more information. 
       _
  @      _ 
     p   
         Other Buttons 
  @        
   The Prefs button brings up the Preferences window, where you can change Background colors and Button colors as well as the Time Format. For more information see Preferences. 
       
      
     	 
  @       
     1 p
  @       
         /The Help button brings you to the Help window. 
       
      
      
  @      " 
     -   
         To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _    @The View Schedule button takes you to the View Schedule window. 
       
      
 @      blue   

      
 @      red  * 
     >    mThe Save button saves your data. All records are saved automatically when going to another record or window. 
       
      
      d   6The Quit button saves the data and quits the program. 
       
      
      -         	Tutorial 
  @          
  @          RHere's a quick tutorial for those just getting started with the Schedule Tracker. 
 @        Black    Q  Each "record" in Schedule Tracker consists of the date of the event, the event description, the start and stop times, the location, the purpose, repeating information, plus any notes.  You can add new records or edit the information for any record at any time. 
       
 @      blue   
     !    To add a new event (or record) click the New button. Enter the Event Date, Start Time, End Time, Event Description, Location, Purpose, any Repeating  information, and any notes about the event. 
       )
     ) 
     , 
     > 
     I 
     K 

     U 
     W 
     _ 
     a %
      
 @      blue   	
      -   The Start Time, and End Time fields are optional. If left blank the event will be listed first in the schedule for that day. For more information see Adjusting the Time .  
       
      

      
      
      z
  @       
        
         The Event Date field is required. You may use the Edit button to edit the date directly or the Choose button to pick a date.  For more information see Adjusting the Date. 
       
      

      $
     2 
     6 )
     _ 
     e 2
  @       
        yIf the event will be repeated at the same time each day, week, month or year, use the Repeating feature. You can choose to have the event repeat Daily, Weekly, Week Days, Monthly, Yearly or for a particular Day of the Month. Just click the Click to repeat button and choose one of these options. A dialog will ask you for a date to stop repeating the event. You may change this date later, but you must enter a date that is later than the one in the Date field. If you choose Daily or Weekly, another field will appear where you can specify if you want the event to repeat every other day (or week), click on this field and enter 2. 
       V
 @      blue  V 	
     _ 2
      
      
      
      
      	
      
      
      
      
      
      
      
 @      Blue  8
 @      Blue  
 @      Blue  
     
     
     
     
       
         Other features: 
  @          vYou can use the arrow buttons to go to the first, previous, next or last record. (These buttons are hidden when you first open Schedule Tracker because there are no other records available to go to.) The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. The number of the current record appears in the Record # field. You can also go directly to any record by clicking on the record # field. A dialog will ask you what record number you want to go to. 
       Q
     Q {
      
      
      
      4
     
     
    % 
    ) /
 @      Blue X X
     0
     
        Search for text in any record by clicking the Find button. You can search for the first part of a word (partial words) or one or more whole words. If capitalization matters, click the "case sensitive" button. 
       .
     . 
     2   
         ;Sort all the records by date by clicking the Sort button.  
       -
     - 
     1 	   Delete one or all of the records by clicking the Delete button. You will be asked which records you want to delete. For more information see Deleting Records. 
       1
     1 
     7 V
  @         You may want to export the records by clicking Export. You can then import the data into a spreadsheet or word processing program. You can export the data for archiving purposes too. You can Import the saved data back into Schedule Tracker at any time. You will want to export your data when updating to a newer version of Schedule Tracker. For more information see Exporting Records and Importing Records. 
       /
     / 
     5 
      
      
  @     n 
     
  @      
       
         To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _   
         To access the Preferences window, click the Prefs button. You can change the highlight, button and background colors, time format, etc. For more information see Preferences. 
       ,
     , 
     1 p
  @          You can view, save or print out Daily, Weekly or Monthly schedules by clicking the View Schedule button. See View Schedule for more information. 
       R
     R 
 @        Black  S 

     ` 

 @      blue  m 

     z    The Save button saves your data. All records are saved automatically when going to another record or when you quit the program. 
       
      
      w  
        You can close the current window by using the Control + w (or command + w on the Mac) key combination. It is usually better to use the Close Window button, if there is one, or choose another tool from the Small Business Tracker Menu instead of using this shortcut though. 
       
      
      :
      
      '  
         The Quit button saves the data and quits the program. You can quit the program from any window by using the Control + Q (or Command + q on the MAC) key combination. 
       
      
      .
     6 n  
         5To access the help system, click on the Help button. 
       (
     ( 
     ,    \For more information, check the Help Index or any of the buttons at the top of this window. 
        
 @        Black    

     * 1  
         You can use the Save As... button below, to save any or all of the text in the help system, as either a .txt or .html file, for reading or printing. Saving the text in .html format allows you to view the formatted help text in your web browser. 
       
      
      z
 @      Blue   _  
               View Schedule 
 @      Red    
  
  @          ]You can generate Daily Weekly and Monthly schedules for viewing, printing or saving as text. 
 @        Black    \   Options 
  @          
  @          iYou can choose from several Options. Click the Day, Week or Month radio button to switch between views.  
       
      
     # 
  @      $ 
  @      / 
  @      2 
  @      4 
  @      8 
  @      < 
  @      A &
     g   
         The current date is automatically entered into the Start Date field. You can change this date by clicking the field itself, the Edit button or by clicking the Choose button. For more information see Adjusting the Date. 
       3
     3 

     = C
      
      
      
      "
  @       
        
        2The Show All Times option will display all the hours for each day in addition to events for that day. You can change the range of hours displayed from the Preferences window. Show Purpose displays all Purpose notes. Show Notes displays all event notes. Click the checkbox next to the option to enable it.  
       
      
      
      
      
      

      
  @       3
    0   
         [You can go directly to any event record by clicking the event description in the schedule. 
 @      Blue    Z   &Invoice or Report output modification 
  @        %  
You can Print any schedule by clicking the Print button, or save it to a text file by clicking the Save as... button. You can then open this text file in your word processor or import it into another program. You may also want to save schedules for archiving purposes. 
       
      
     
 V
     c 

     m d
  @       ;  
  @         Before printing you may want to adjust the font, size or line height of the report or invoice text by clicking the Font... button. Choose a new font by clicking its name in the font list. Change the font size by clicking one of the pt size radio buttons. Not all fonts are available in all sizes, so you may not notice a change. Click the line height field to enter a new number. The minimum line height is equal to the text size plus one (i.e., if the text size = 14 then the minimum line height = 15). 
       s
     s 
     z
    | {  
        You can also set the tab stops of the report or invoice text by clicking the Font... button and then the Tab button. You will be given the choices of Default and Custom. The custom option allows you to specify exact numbers for the tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the numbers to see what the effects are. Tabs may need to be readjusted after each report or invoice has been generated. 
       
      .
     M 
     T 
     i 
     l *
      
      
      
      
 @      Blue u O  
 @      Blue     You may also want to adjust the Characters per column setting. If the Show Purpose option is enabled, each of the three right columns are limited to the number of characters specified here.  If the Show Purpose option is NOT enabled, the Event Description column width is equal to twice the number of characters specified here. After adjusting the font, size or line height, you may need to also adjust the Characters per column. 
 @        Black     
 @        Black    
 @        Black  5 
 @        Black  F 
 @        Black  R t
 @        Black   
 @        Black   v
  @     H e   3Close the Font dialog by clicking on Close button. 
       %
     % 
     *    ZClose the View Schedules window by clicking on Close Window button when you are finished. 
       /
     / 
     ;    Other Buttons 
  @        
   /The Help button brings you to the Help window. 
       
      
      
  @      " 
     -    mThe Save button saves your schedule. All data is saved automatically when going to another record or window. 
       
      
      d  
            W Importing Records 
  @           You can import previously exported records by clicking the Import button in the Schedule Tracker window. First you will be asked if you want to Delete all existing records before importing or Add the imported records to the existing ones.  
       ;
     ; 
     A 
 @      red  P 
     g )
      
      *
      
      ,  
         You then will be asked if you want to import a Schedule Tracker or a Palm export file. Next you will be asked to locate the text file to import.  
         
         To export records from the Palm Desktop program, choose Export from the File menu, select Calendar from the Which Module menu, choose Tab & return from the Delimiters menu and then click OK. 
         
         @There are a couple of reasons you might want to import records: 
  @        ? 1) If you work in a small office or workgroup, each person can keep track of their own schedule, then export their records and send the file to an administrator. They will then be able to import the data and generate schedules for the group.    2) When updating to a newer version of the program, you should export all your records and then import them into the new version.    ,See Exporting Records for more information. 
       
  @       
           xx   M Exporting Records 
  @          You can export the records to a text file by clicking the Export button. First you will be asked if you want to export to a Schedule Tracker file or a Palm file. If you want to import your tasks into the Palm Desktop program then choose Palm. Otherwise choose Schedule Tracker. 
       :
     : 
     @   
         (To import records into the Palm Desktop program, choose Import from the File menu, open the file exported from Schedule Tracker, select Calendar from the Fields menu, choose Tab & Return from the Delimiters menu and click OK.) 
         
 @      Blue      Next you will be asked if you want export All event records or just the current event. If you choose All then all records will be exported. Records are exported in a tab delimited format, so they can be easily imported into many other applications. 
       *
     * 
     ; *
     e 
     h $
 @      Blue   l  
         If there are no records found to be exported, you will see a message to that effect, but a file will still be written to disk. To avoid confusion, you may want to delete that file. 
          <There are several reasons you might want to export records: 
  @        ; 1) If you work in a small office or workgroup, each person can keep track of their own schedule, then export their records and send the file to an administrator. They will then be able to import the data and generate schedules for the group.     2) Rather than archiving the whole program, you might want to export all (or some of) the records and just archive the much smaller text file.    3) When updating to a newer version of the program, you should export all your records and then import them into the new version.   94) If you wanted to export the records to a spreadsheet or a word processing program. When Schedule Notes are exported, all line endings are converted to " | " characters, so that importing into spreadsheets and databases is possible. If you import into a word processor, you may want to remove these characters. 
       V
 @      Blue  V 
      N  
         a5) If you use the Palm Desktop program, you can import or export your schedule and appointments.    Exported Records files: 
  @         The exported file is called schedule_records.txt which contains the data for all the records in a tab delimited format. You can change this name if you wish. Be sure to make a note of its location. 
       
 @      Red   
  @      , 
     0 n
  @       '       About Help 
  @        
  
  @          "Welcome to Schedule Tracker Help. 
 @        Black    !   Listed in this Help system are all the features, fields and buttons of Schedule Tracker. (Buttons are things you click on and fields contain text.) 
         You can click the Save as... button at the bottom of this Help window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. 
       
      

      
 @      Blue   Y
    < W   The Search Help button at the bottom of this Help window will search for occurrences of a particular word or phrase in any of the help topics. 
       
      
        
         [Click blue underlined text to go directly to that Help topic (except for this example ;-). 
       
  @       
      @  
         Bolded words (like this) in this Help system indicate buttons or fields. (Again, buttons are things you click on and fields are where text is entered or displayed.) Blue text (like this) highlights important information. 
       
      	
      
  @       7   [You can easily return to the previous topic by clicking the Back to Previous Topic button. 
       <
     < 
     R   
        Each "record" in Schedule Tracker consists of the date of the event, the event description, the start and stop times, the location, the purpose, repeating information, plus any notes.  You can add new records or edit the information for any record at any time. 
       
 @      blue   
     !    \Use the buttons at the top of this Help window to learn more about the following subjects:  
       #
     # 
     ' 4   @The Schedule Tracker window is where you add Event information. 
       
 @      blue   
      +   The View Schedule window is where you can generate Daily, Weekly or Monthly schedules. You can print these out or save them to a text file for importing into a word processor or other programs. 
       
 @      Blue   

         The Preferences window is where you can change background and button colors, time formats, and the general "look and feel" of the program. You can also change the beginning and ending times for the View Schedule window. 
       
  @       
      
 @      Red      jAlmost every button in this program has a keyboard shortcut. For more information see Keyboard Shortcuts. 
       V
  @      V 
     h    IThere's an extensive tutorial available by clicking the Tutorial button. 
       8
  @      8 
     @    iThe newest version of this software is available at http://productivity-software/sbtracker/download.html 
 @      Blue    h  
 @      Blue      ~Your comments, suggestions and bug reports are always welcome. Please send your email to: comments@productivity-software.com. 
       Z
 @      Red  Z "
     |    #Thank you for using this software,    Garth Catterall-Heart  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470     1 Adjusting the Date 
  @           The Event Date can be adjusted several ways. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       ,
     , 2
     ^ 
     b F  
Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the current record. 
       
      
     %   
         If you use the Repeating feature a new field will appear which allows you to specify the date the repeating will end. You can use the Edit or Choose button as above. 
       
 @      blue   	
      n
      
      
      
         If you enter an end repeat date that is before the event date, you will be warned about the error and the repeat feature will revert back to its no repeat state. You can choose not to be warned about this in the Preferences window. 
       
  @       
             Keyboard Shortcuts 
  @          
  @          )Many buttons have a keyboard equivalent. 
 @        Black    (  
  @          Shortcuts are indicated by the letter of the button that is underlined. Just press the letter on your keyboard to activate the button.    cIf a keyboard shortcut does not work, try pressing the tab key and then the shortcut letter again. 
  @        b   If you are typing notes, many of the following shortcuts will not work unless you also hold down the Alt key (or Command key on the Macintosh).   CYou can also use the Tab key to move between most of the buttons and editable fields of each window. (Buttons are things you click on, fields are places where text is entered or displayed.) Buttons will appear with a dotted rectangle when they are active. Then you can press the return or enter key to activate the button.    In any field that you can type in, you can also use the standard Cut (Ctrl - x), Copy (Ctrl - c) and Paste (Ctrl - v) keyboard shortcuts.    #Schedule Tracker window shortcuts: 
 @        Black    
      
 New - n  Delete - d  View Schedule - v  Save -s  	Quit - q     View Schedule window shortcuts: 
 @        Black    
       	Help - h  Close Window - c  	Save - s  	Font - f  
Print - p  	Quit - q    Help window shortcuts: 
        About Help - a  View Schedule - v  Keyboard Shortcuts- k  
Tutorial - t  Schedule Tracker - d  Preferences - p  Help Index - h  Back to Previous Topic - b  Search Help - s  Close Window - c         g Quit 
  @           uYou can quit (or exit) the program at any time by clicking the Quit button. All data will be saved before quitting.  
       ?
     ? 
     C 1  
         IYou may also type Control + Q (or Command + Q on the Macintosh) to quit. 
       H         Font 
  @          
         You may want to adjust the font, size or line height of the schedule text by clicking the Font button. Choose a new font by clicking its name in the font list. 
       Z
     Z 
     ^ A  
         Change the font size by clicking one of the point size radio buttons (9 pt, 10 pt, etc.). Not all fonts are available in all sizes, so you may not notice a change.  
         
         Click the Line Height field to enter a new number. The minimum line height is equal to the text size plus one (i.e., if the text size = 14 then the minimum line height = 15). 
       

     
 
      
     3 {  
        You can also set the tab stops of the schedule text by clicking the Font... button and then the Tab button. You will be given the choices of Default and Custom. The custom option allows you to specify exact numbers for the tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the three numbers to see what the effects are. Tabs may need to be readjusted after each report or invoice has been generated. 
       
      %
     D 
     K 
     ` 
     c *
      
      
      
      
 @      Blue r O  
 @      Blue      QReset the font face and size to 10 pt Arial by clicking the Default Font button. 
 @        Black    <
 @        Black  < 
 @        Black  H         j Schedule Options 
  @           rYou can generate a Schedule with any of the Options provided. Click the checkbox next to the option to enable it. 
       ,
     , 
     3 >   The Show All Times option will display all times between the start time and end time specified in the Preferences window. Show Purpose displays all Purpose notes. Show Notes displays all event Notes.  
       
      
      h
     z 
      
      

         `Click one of the radio buttons to switch between the Day, Week or Month views of your schedule. 
       5
     5 
     G    (For more information see View Schedule. 
       
 @      blue   

  @      &   / Adding a New Event Record 
  @           To add a new event record, click the New button. Enter the Event Date, Start Time, End Time, Event Description, Location, Purpose, any Repeating  information, and any notes about the event. 
       %
     % 
     ( 
     : 
     E 
     G 

     Q 
     S 
     [ 
     ] %
      
 @      blue   	
      -   The Start Time, and End Time fields are optional. If left blank the event will be listed first in the schedule for that day. For more information see Adjusting the Time .  
       
      

      
      
      z
  @       
        
         The Event Date field is required. You may use the Edit button to edit the date directly or the Choose button to pick a date.  For more information see Adjusting the Date. 
       
      

      $
     2 
     6 )
     _ 
     e 2
  @       
        nIf the event will be repeated at the same time each day, week, month or year, use the Repeating feature. You can choose to have the event repeat Daily, Weekly, Monthly, Yearly or for a particular Day of the Month. Just click the Click to repeat button and choose one of these options. A dialog will ask you for a date to stop repeating the event. You may change this date later, but you must enter a date that is later than the one in the Date field. If you choose Daily or Weekly, another field will appear where you can specify if you want the event to repeat every other day (or week), click on this field and enter 2. 
       V
 @      blue  V 	
     _ 2
      
      
      
      
      
      
      
      
      
      
 @      Blue  8
 @      Blue  
 @      Blue  
     
     
     
     
           i 
Registration 
  @          'To register Small Business Tracker, click the Small Business Tracker Menu button and choose Small Business Tracker Welcome. Then click the Register button. Read the instructions for getting a registration number. Once you receive your number, fill in your full name and the registration number. 
       .
     . 
     I 
     [ 
     \ 
     { 
      

      
         HYou can also review the License Agreement from the Registration window. 
       
      
     )          Preferences 
  @          
  @          @There are several preferences you can set for Schedule Tracker. 
 @        Black    ?   YTo access the Preferences window, click the Prefs button in the Schedule Tracker window. 
       ,
     , 
     1 
 @      red  @ 
     W   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
      
      e
     v 

      a
      	
      H
  @     2 
    D    jThe Time Format defaults to AM/PM, but if you would want times displayed in 24 hour format, click 24 Hrs. 
       
      
      Z  
        .There is a visual effect that helps to indicate the movement from one record to another in the Schedule Tracker window when using the arrow buttons or keys. Some people find this effect annoying or slow. Other people think it is great. So you can choose to turn it On or Off in the Preferences window. 
       _
  @      _ 
     v 
    	 
     
     
     
  @      
    ,   You can change the Background color from the Preferences window. Choose a color from the Background Color list. The background color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     # 

  @      - 
     ?   You can change the Button colors from the Preferences window. Choose a color from the Button Colors list. The button colors will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      

       

  @      * 
     <    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.   You can also change the Highlight color from the Preferences window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     ' 

  @      1 
     C    You specify whether you want to be reminded when end times are before start times by clicking On or Off in the Time Error Reminder section. 
       ^
     ^ 
     ` 
     d 
     g 
     o 
      	   The hours displayed when Show All Times is enabled in the View Schedules window, are effected by setting the beginning and ending times in the List times between section. For more information see View Schedule. 
       
      
     ' 
 @      Red  : 
     P ?
      
      #
  @       

        The Open new tools in a different window? button allows you to choose if you want each tool to open in a new, separate window or if you want each new tool to open in the same window as the current tool. Opening new tools in new windows sometimes creates too many open windows on the screen for some people. Some tools, such as the Universal Calculator,  always open in a new window. 
       
      %
     )U   WClick the Default Settings button to return all settings back to their default values. 
       

     
 
      <        v Sorting Records 
  @           You can sort records by by date by clicking the Sort button in the Schedule Tracker window.  All records are renumbered after sorting. 
       0
     0 
     4 
 @      red  C 
     Z ,        o Searching Records 
  @          You can search records for particular text by clicking the Find button. A dialog will ask for a partial or whole word to search for. You can find the beginning of a word or phrase by using the partial words option. To find an exact word or phrase, use the whole words option. 
       :
     : 
     ? 
      

      2
      
        You can also specify that you want your search to be case sensitive (i.e., a search for "UNIX" will not find "unix"). Click the checkbox next to this option to enable it. 
       5
     5 
     C g   aYou can go directly to the first record with a particular date by clicking the Event Date label. 
       O
     O 

     Y     R 
Go to Record 
  @           LYou can go directly to any record by clicking the Record # field or label.  
       2
     2 
     :    fYou can also go directly to the first record with a particular date by clicking the Event Date label. 
       T
     T 

     ^        Button Colors 
  @        
   You can change the button colors from the Preferences window. Click the Prefs button, then choose a color from the Button Colors list. The button colors will automatically change to the new color. 
       *
  @      * 
     < 
     H 
     M &
     s 

      D        3 Background Color 
  @           You can change the background color from the Preferences window. Click the Prefs button, then choose a color from the Background Color list. The background color will automatically change to the new color. 
       -
  @      - 
     ? 
     K 
     P &
     v 
      G        2 Adjusting the Time 
  @           The Start and End Times can be adjusted several ways. If you want to edit the time field, click on the Edit button or the field itself. A dialog box will ask you for a new time. 
       6
     6 1
     g 
     k F  2Another method is to click the small up or down arrows next to the time field. You can increase or decrease the hours with the first set of buttons, and increase or decrease the minutes with the second set of buttons. You can hold down the mouse button on any of these arrows to get continuous adjustment.     { Visual Effects 
  @          .There is a visual effect that helps to indicate the movement from one record to another in the Schedule Tracker window when using the arrow buttons or keys. Some people find this effect annoying or slow. Other people think it is great. So you can choose to turn it On or Off in the Preferences window. 
       _
  @      _ 
     v 
    	 
     
     
     
  @      
    ,    See also Record #. 
       	
 @      Blue  	 	  y Time Format 
  @           In the Preferences window, you can set the Time Format to either 24 Hr or AM/PM. Times previously entered will not be modified, but all new times entered will be in the new format. 
       
  @       
      
     + 
     7 }         Tabs 
 @      Red      mYou can also set the tab stops of the schedule text by clicking the Font... button and then the Tab button. You will be given the choices of Default and Custom. The custom option allows you to specify exact numbers for the tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the numbers to see what the effects are.  
       
      %
     D 
     K 
     ` 
     c )
      
      
      
        
 @      Blue      See also Printing. 
 @        Black    	
 @      Blue  	 
        n Save Record 
  @           You can save all the data in the record window by clicking the Save button. All data is saved automatically when going to another record or when quitting the program. 
       ?
     ? 
     C c         Save As... 
  @        
  You can use the Save as... button at the bottom of this window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. See About Help for more information about printable versions of this Help system. 
       
      

      
 @      Blue   Y
    5 \
  @      

     C   cIn the View Schedule window, the Save as... button saves the text of the schedule to a text file.  
       
 @      Red   
      
     ! 

     + 7    h 	Record # 
  @          Each Record in Schedule Tracker has a number. This number may change when you add or delete records. You can go directly to a particular record by clicking the Record # field or label. Or you can use the arrow buttons to go the First Record, Prev Record, Next Record or Last Record. 
       .
  @      . 6
     d <
      
      <
  @       
      
  @       
      
  @       
    
 
  @      
        The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
          See also Visual Effects. 
       	
 @      Blue  	    	Printing 
  @           UYou can print schedules by clicking on the Print button in the View Schedule window. 
       +
     + 
     0 
  @      ? 
     S    You can modify the font face, size, line height and the number of lines printed per page, by clicking the Font... button in the View Schedule window. 
       j
     j 
     q 
  @         To change the font face of the schedule, just click on the name of the new font. The schedule will be updated automatically. To change the font size of the schedule, just click on the new size. (Some fonts may not be available in all sizes.) The schedule will be updated automatically. To change the line height, just click on the field and enter a new number. The minimum line height is equal to the text size plus one (i.e., if the text size = 14 then the minimum line height = 15). 
       
      .
        Changing the font face, size or line height may require you to change the number of lines printed on each page. Before submitting schedules to others, you will want to make sure that all the lines of the schedule are being printed. If they are not all being printed, or there is extra space at the bottom of the page, you will want to experiment with the lines per page setting. To change the lines per page settings, just click on the field and enter a new number. 
       p
 @      Blue  p w
        mYou can also set the tab stops of the schedule text by clicking the Font... button and then the Tab button. You will be given the choices of Default and Custom. The custom option allows you to specify exact numbers for the tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the numbers to see what the effects are.  
       
      %
     D 
     K 
     ` 
     c *
      
      
      
             Prev Record 
  @           {Go the previous record (the record with the next lowest number) by clicking the Prev button (the one with the left arrow). 
       P
     P 
     T &   The First Record and Prev Record buttons are hidden on the first record. You can also use the arrow keys to move from one record to the next or previous record.  
            Next Record 
  @           yGo the next record (the record with the next highest number) by clicking the Next button (the one with the right arrow). 
       M
     M 
     Q '   The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
           Z Look and Feel 
  @        
  aIn the Preferences window, the Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
  @       
      
      

     , e
      

      a
      	
     H
  @     M 
    _          Last Record 
  @           |Go the last record (the record with the highest number) by clicking the Last button (the one with the right arrow and bar). 
       H
     H 
     L /   GThe Last Record and Next Record buttons are hidden on the last record. 
       F    V Highlight Color 
  @           You can change the highlight color from the Preferences window. Click the Prefs button in the Schedule Tracker window, then choose a color from the Highlight Color list. The highlight color will automatically change to the new color. 
       ,
  @      , 
     > 
     J 
     O 
 @      red  ^ 
     u 
      
      F        U Help 
  @           oClicking the Help button at the bottom of the View Schedule window takes you to the View Schedule help topic.  
       

     
 
      
 @      red  . 
     B 
 @      blue  T 

     a 
  
         tClicking the Help button at the bottom of the Schedule Tracker window takes you to the Schedule Tracker help topic. 
       

     
 
      
 @      red  . 
     E 
 @      Blue  W 	
  @      ` 
     g   
         jClicking the Help button at the bottom of the Preferences window takes you to the Preferences help topic. 
       

     
 
      
  @      . 
     @ 
 @      Blue  R 
     ]    There are Help button in a few other places which give you a quick hint about the functionality or limitations of that feature.    
First Record 
  @           |Go the first record (the record with the lowest number) by clicking the First button (the one with the left arrow and bar). 
       H
     H 
     M .  
         IThe First Record and Prev Record buttons are hidden on the first record. 
       H        L 
Edit Time 
  @        	  The Start and End Times can be adjusted several ways. If you want to enter the current time, click the Now button above the start or end field. If you want to edit the time field, click on the Edit button or the field itself. A dialog box will ask you for a new time. 
       g
     g 
     j W
      
      F  2Another method is to click the small up or down arrows next to the time field. You can increase or decrease the hours with the first set of buttons, and increase or decrease the minutes with the second set of buttons. You can hold down the mouse button on any of these arrows to get continuous adjustment.       K Deleting Records 
  @          You can delete some or all records by clicking the Delete button. You will be asked if you want to delete Just this one record, Older records or All records. If you choose Older then you will be asked for a date. This feature is useful when you have many old records that you do not need to keep. You will probably want to export the old records first. See Exporting Records for more information. 
       3
     3 
     9 1
     j 

     w 	
      
      
      
      
  @     e 
    v       I 
Edit Date 
  @        	  
The Start and End Dates can be adjusted several ways. If you want to enter today's date, click the Today button above the start or end field. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       c
     c 
     h W
      
      F  Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date, closes the window and enters that date into the current record. 
       
      
     %       D Default Settings 
  @           }If you want to return the settings in the Preferences window to their default state, just click the Default Settings button. 
       *
  @      * 
     < (
     d 
     t    See also Preferences. 
       	
  @      	     : Choose Date 
  @          3One method for changing a date, is to click the Choose button above the date field. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the appropriate field. 
       0
     0 
     6          Preferences 
          There are several preferences you can set for Activity & Expense Tracker. Start by clicking the Prefs button in the record window.   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts.    iThe Time Format defaults to AM/PM but if you would want times displayed in 24 hour format, click 24 Hrs.    You can change the background color from the Preferences Window. Choose a color from the Background Color list. The background color will automatically change to the new color.    You can change the button colors from the Preferences Window. Choose a color from the Button Colors list. The button colors will automatically change to the new color.    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.    You can also change the highlight color from the Preferences Window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color.   =You can set the Monetary Symbol to something other than the dollar sign ($), if you use a different one, by clicking the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed on the records screen and in all reports.    WClick the Default Settings button to return all settings back to their default values.             	`    @ _ Y &    About Help Ux   Ion mouseUp
  lock screen
  push card
  go card "About Help"
end mouseUp
    
LightPink      a             	        View Schedule Ex   Qon mouseUp
  lock screen
  push card
  go card the short name of me
end mouseUp
    
LightPink    p  l             	        Keyboard Shortcuts Ex   Oon mouseUp
  lock screen
push card
  go card "Keyboard Shortcuts"
end mouseUp
    
LightPink      ~             	        	Tutorial Ex   Eon mouseUp
  lock screen
push card
  go card "Tutorial"
end mouseUp
    
LightPink     " P             	        Schedule Tracker Ex   Qon mouseUp
  lock screen
  push card
  go card the short name of me
end mouseUp
    
LightPink    ` "              	        Preferences Ex   Oon mouseUp
  lock screen
push card
  go card the short name of me
end mouseUp
    
LightPink     " f             	        Help Index Ex   Gon mouseUp
  lock screen
push card
  go card "Help Index"
end mouseUp
    
LightPink     <              	        Back to Previous Topic Ex   on mouseUp
  pop card into temp
  if temp is empty or NOT (temp contains "help") then
    go card "Help Index"
  else
    go temp
  end if
end mouseUp
    
LightPink     <              	        Search Help Ex  ]on mouseUp
  global gFindStack,gFoundOne
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 320 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack "atFind" to it
  go card 1 of stack "atFind"
  show stack "atFind"
  select text of field "find" of stack "atFind"
end mouseUp
            
LightPink     l             	        Save as... Ex   on mouseUp
  global gStackName
  
  insert the script of button "SaveHelp" of stack "Launcher" into back
  put "Schedule Tracker Help" into gStackName
  exportHelp
  remove the script of button "SaveHelp" of stack "Launcher" from back
end mouseUp
    
LightPink     Q              	        
Close Window Ex   [on mouseUp
  lock screen
  close this stack
  unlock screen with visual plain
end mouseUp
    
LightPink     y             	        	devtools   a         tH    Save Ex   *on mouseUp
  save this stack
end mouseUp
    
LightPink    x Q              	        go next Ex   'on mouseUp
  go next card
end mouseUp
    
LightPink    \x Q              	        delete Ex   +on mouseUp
  delete this card
end mouseUp
    
LightPink   x 2             	        go prev Ex   'on mouseUp
  go prev card
end mouseUp
    
LightPink    x Q              	           K        	  g          K           j          K                    K        
   T    
  ! index  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the listbehavior of me to false
    set the traversalOn of me to true
  else
    put line (the hilitedLine of me) of field "index" into temp
    push card
    go card temp
  end if
end mouseUp
         Xl(           About Help  Adding a New Event Record  Adjusting the Date  Adjusting the Time  Background Color  Button Colors  Choose Date  Default Settings  Deleting Records  
Edit Date  
Edit Time  Exporting Records  
First Record  Font  
Go to Record  Help  Highlight Color  Importing Records  Keyboard Shortcuts  Last Record  Look and Feel  Next Record  Preferences  Prev Record  	Printing  Quit  	Record #  
Registration  
Repeating  Save As...  Save Record  Schedule Options  Schedule Tracker  Searching Records  Sorting Records  Tabs  Time Format  	Tutorial  View Schedule  Visual Effects         	`    @ ` Y & 
   title 	H          ;h            Help Index 
   instruction 
         h @            *Click a topic below for more information.    New Button EpGon mouseUp
sort this stack by field "main"
  beep
end mouseUp


  repeat with i = 1 to the number of cards
    put empty into field "main" of card i
  end repeat

repeat with i = 1 to the number of lines of field index
  if there is a card line i of field index then next repeat
  else answer line i of field index
end repeat
          `              	        Export EpJon mouseUp
global gHelpText
  open file "helptext.html" for write
  repeat with i = 1 to the number of cards --lines of zlist
    put the htmltext of field "main" of card i into gHelpText
    exportHTML 
    write gHelpText & "<p>&nbsp;<p>"  & return to file "helptext.html"
  end repeat
  close file "helptext.html"
end mouseUp
        D ` ,             	        Import Ep	on mouseUp
  
  answer file "Select a  helptext.html file to import." with "helptext.html"
  if the result is "Cancel" then exit to metacard
  put it into fileName
  open file fileName for read
  --  lock screen
  read from file fileName until eof
  put it into allText
  close file fileName
  
  put "adding group close tags"
  put "</B></U></FONT>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "</B></U></GROUP></FONT>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  put "adding group open tags"
  put "<FONT color="& quote&"#0000FF"&quote&"><U><B>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "<FONT color="& quote&"#0000FF"&quote&"><GROUP><U><B>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  repeat with i = 1 to the number of cards
    put empty into cardText
    put "working on card" && i && "of" && the number of cards
    set cursor to busy
    put offset("<p>&nbsp;",allText) +2 into lastChar
    put char 1 to lastChar of allText into cardText
    delete char 1 to (lastChar+length("<p>&nbsp;")-1) of allText
    
    repeat while offset(return,cardText) > 0
      put offset(return,cardText) into firstchar
      delete char firstchar of cardText
    end repeat
    
    repeat while offset("  ",cardText) > 0
      delete char offset("  ",cardText) of cardText
    end repeat
    
    repeat while char 1 to 3 of cardText is "<p>"
      delete char 1 to 3 of cardText
    end repeat
    
    if char 1 of cardText is ">" then delete char 1 of cardText
    if char 1 of cardText <> "<" then put "<" before cardText
  --  answer cardText with "OK" or "Cancel" --**
 --   if it is "cancel" then exit mouseUp --**
    set the htmltext of  field "main" of card i to cardText
  end repeat
  
end mouseUp

put "<p>" & return & "<p>" & return & "<p>" & return into cardEnd
put "<p><p><p><p>" & return into cardEnd2

repeat while offset(cardEnd,allText) > 0
  set cursor to busy
  put offset(cardEnd,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd)) of allText
end repeat

repeat while offset(cardEnd2,allText) > 0
  set cursor to busy
  put offset(cardEnd2,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd2)) of allText
end repeat
put "<p>&nbsp;"  after allText
         ` 8             	        reindex and sort EpMon mouseUp
  put empty into field "index"
  repeat with i = 1 to the number of cards
    if char 1 of field "main" of card i <> "x" then
      set the name of card i to line 1 of field "main" of card i
      put line 1 of field "main" of card i  & return after field "index"
    end if
  end repeat
  sort field "index"
end mouseUp
        T               	           K        ^             K        o  m      a Ask Dialog   ron openCard
end openCard

on preOpenCard
end preOpenCard

on closeCard
end closeCard

on openStack
end openStack
      Cyan    2 @                     U 
Helvetica       	Pon doresize
  local twidth, iwidth
  put the width of this stack into twidth
  set the width of field 1 to twidth - 64
  set the left of field 1 to 48
  set the width of field 2 to twidth - 64
  set the left of field 2 to 48
  set the top of field 2 to the bottom of field 1
  set the top of button 1 to the height of field 1 div 2 - 8
  put (twidth - 120 ) div 3 into iwidth
  put iwidth into twidth
  set the default of button 2 to false
  repeat with i = 2 to the number of buttons
    set the left of button i to twidth
    set the bottom of button i to the height of this stack - 12
    add the width of button i + iwidth to twidth
  end repeat
  set the default of button 2 to true
end doresize

on star
  local tstring
  put empty into tstring
  repeat with i = 1 to the number of characters in field 3
    put "*" after tstring
  end repeat
  put tstring into field 2
end star

on preOpenStack
  local twidth
  set the itemDelimiter to numToChar(0)
  set the fieldmode of me to word 2 of item 1 of the dialogData
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of the dialogData into field 1
  put max(the formattedWidth of field 1 + 64,\
      the formattedWidth of field 2 + 64, 320) into twidth
  set the width of this stack to twidth
  set the height of field 1 to the formattedHeight of field 1
  set the top of field 1 to 8
  set the height of this stack to (the height of field 1) + 100
  doresize
  if the fieldmode of me is not "plain" then
    put item 4 of the dialogData into field 3
    star
  else put item 4 of the dialogData into field 2
  set the dialogData to numToChar(0)
  set the itemDelimiter to comma
  set the icon of button 1 to item itemOffset(the lookAndFeel,"Motif,Macintosh,Windows 95") of "330,994,998"
end preOpenStack

on keyDown which
  local tpos
  if the name of the target contains "field" and the fieldmode of me is not "plain" then
    put the selectedChunk into tpos
    put which into character (word 2 of tpos) to (word 4 of tpos) of field 3
    star
    select after character (word 2 of tpos) of field 2
  else pass keyDown
end keyDown

on deleteKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass deleteKey
end deleteKey

on backspaceKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass backspaceKey
end backspaceKey

on deleteone
  local tpos
  put word 2 of the selectedChunk into tpos
  put empty into character (tpos - 1) of field 3
  star
  select before character (tpos - 1) of field 2
end deleteone

on commandKeyDown which
  if the fieldmode of me is not "plain"
  then
    local tpos
    switch which
    case "D"
      put word 2 of the selectedChunk into tpos
      put empty into character tpos of field 3
      star
      select before character tpos of field 1
      break
    case "H"
      deleteone
      break
    default
      pass commandKeyDown
    end switch
  else pass commandKeyDown
end commandKeyDown

on openField
  select the text of the target
end openField

on resizeStack
  doresize
end resizeStack

on returnInField
  click at the loc of button "OK"
end returnInField

on closeStack
  put empty into field 1
  put empty into field 2
  put empty into field 3
end closeStack
          @    
fieldmode  plain  a    _  \  ]  `
             0                  \ OK Lp on mouseUp
  switch the fieldmode of this card
  case "plain"
    get field 2
    break
  case "clear"
    get field 3
    break
  case "password"
    get mcencrypt(field 3)
    break
  end switch
  set the dialogData to it
  close this stack
end mouseUp
    
LightPink    B \ 4             	     ] Cancel Dp +on mouseUp
  close this stack
end mouseUp
    
LightPink     \ <             	   
  _   `       0 (              
  `   
!`       b 8 |             a New Button B@   
LightPink      $ (          	      Answer Dialog   on resizeStack
end resizeStack

on openStack
end openStack

on preOpenCard
end preOpenCard

on openCard
end openCard

on closeCard
end closeCard
      Cyan   G  d   macintoshIcons  992,993,994,995motifIcons  328,329,330,331windows95Icons  996,997,998,999                U 
Helvetica       	P(on preOpenStack
  local dtype, foffset, oldwidth, bwidth, twidth, iwidth, theight, curx, nchoices
  set the itemDelimiter to numToChar(0)
  if word 2 of item 1 of the dialogData is "plain" then
    hide button 1
    put 0 into foffset
  else
    show button 1
    switch the lookAndFeel
    case "Motif"
      get the motifIcons of this stack
      break
    case "Macintosh"
      get the macintoshIcons of this stack
      break
    default
      get the windows95Icons of this stack
    end switch
    put word 2 of item 1 of the dialogData into dtype
    set the itemDelimiter to comma
    set the icon of button "icon" to item itemOffset(dtype, "error,information,question,warning") of it
    set the itemDelimiter to numToChar(0)
    put 40 into foffset
  end if
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of dialogData into field 1
  get item 4 of dialogData
  if it is empty then get "OK"
  put the number of lines in it into nchoices
  put 32 into bwidth
  if nchoices > the number of buttons - 1
  then put the number of buttons - 1 into nchoices
  repeat with i = 2 to nchoices + 1
    show button i
    set the name of button i to line nchoices + 2 - i of it
    set the width of button i to the formattedWidth of button i + 24
    add the width of button i + 32 to bwidth
  end repeat
  set the dontWrap of field 1 to true
  put max(the formattedWidth of field 1 + foffset + 16, bwidth) into twidth
  if twidth > 600 then
    put 600 into twidth
    set the dontWrap of field 1 to false
  end if
  put the width of this stack into oldwidth
  set the width of this stack to twidth
  set the width of field 1 to twidth - foffset - 16
  put the formattedHeight of field 1 + 68 into theight
  if theight > 400 then
    set the vScrollbar of field 1 to true
    put 400 into theight
  else set the vScrollbar of field 1 to false
  set the height of this stack to theight
  set the height of field 1 to theight - 68
  set the top of button 1 to the height of field 1 div 2 - 12
  set the topLeft of field 1 to foffset + 8, 8
  put (twidth - bwidth) div (nchoices + 1) + 32 into iwidth
  put iwidth into curx
  if the lookAndFeel is "Macintosh" then
    repeat with i = nchoices + 1 down to 2
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  else
    repeat with i = 2 to nchoices + 1
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  end if
  set the default of button 2 to true
  set the dialogData to empty
end preOpenStack

on closeStack
  repeat with i = 3 to the number of buttons
    hide button i
  end repeat
  set the default of button 2 to false
end closeStack

on mouseUp
  if the name of the target contains "button" then
    set the dialogData to the short name of the target
    close this stack
  end if
end mouseUp
            d  z                
     @       0              2Delete all records, old records or just this one?   z icon BP on mouseUp
end mouseUp
    
LightPink      , (         	      Cancel D`   
LightPink      6 L            	      Just this one D`   
LightPink     6 m            	      Older D`   
LightPink    6 C            	      All D`   
LightPink   | 6 /            	      y D`   
LightPink     4 '            	      x D`   
LightPink    i 4 '            	      w D`   
LightPink      4 )            	    